/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui;

import com.deltawalker.App;
import com.deltawalker.Doc;
import com.deltawalker.Relation;
import com.deltawalker.UriInfo;
import com.deltawalker.interfaces.IDoc;
import com.deltawalker.interfaces.IDocBoss;
import com.deltawalker.internal.ui.ContentProposalTable;
import com.deltawalker.script.Role;
import com.deltawalker.ui.ControlUtil;
import com.deltawalker.ui.DiffView;
import com.deltawalker.ui.FileDnDProcessor;
import com.deltawalker.ui.IMenuComboCallback;
import com.deltawalker.ui.MenuCombo;
import com.deltawalker.ui.UIMsg;
import com.deltawalker.ui.UriChooserBoss;
import com.deltawalker.ui.fieldassist.ContentAssistField;
import com.deltawalker.ui.fieldassist.ContentProposal;
import com.deltawalker.ui.fieldassist.ContentProposalAdapter;
import com.deltawalker.ui.fieldassist.MenuComboContentAdapter;
import com.deltopia.StringUtil;
import com.deltopia.io.ContentType;
import com.deltopia.io.FileInfo;
import com.deltopia.io.FileType;
import com.deltopia.io.FileUtil;
import com.deltopia.io.IFile;
import com.deltopia.io.StructFileInfo;
import com.deltopia.io.VfsUtil;
import com.deltopia.ui.dnd.IFileDropTarget;
import com.deltopia.ui.swt.KeyUtil;
import java.io.File;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlCreator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public abstract class UriChooser
extends Composite
implements IFileDropTarget {
    private static boolean SHOW_RAW_URI_ON_FOCUS = false;
    protected IAction actOpen;
    protected IAction actSave;
    private ContentAssistField caField;
    private MenuCombo combo;
    private ContentProposalAdapter cpAdapter;
    protected FileDnDProcessor dndProcessor;
    private int lastSelIx = -1;
    private final ListenerList listeners = new ListenerList();
    private boolean preview;
    private Role role;
    protected UriInfo uriInfo;
    private DiffView view;

    public UriChooser(Composite composite, int n, Role role, boolean bl, DiffView diffView) {
        super(composite, n | 0x40000000 | 0x40000);
        this.role = role;
        this.preview = bl;
        this.view = diffView;
        this.createContents();
        if (bl) {
            this.setEnabled(false);
        }
        this.dndProcessor = new FileDnDProcessor(this);
    }

    public boolean accepts(FileInfo fileInfo) {
        return true;
    }

    protected abstract List<IAction> actions();

    public void addFocusListener(FocusListener focusListener) {
        this.combo.addFocusListener(focusListener);
    }

    public void addModifyListener(ModifyListener modifyListener) {
        if (modifyListener != null) {
            this.listeners.add((Object)modifyListener);
        }
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        TypedListener typedListener = selectionListener == null ? null : new TypedListener((SWTEventListener)selectionListener);
        this.addListener(14, (Listener)typedListener);
        this.addListener(13, (Listener)typedListener);
    }

    public void addTraverseListener(TraverseListener traverseListener) {
        this.combo.addTraverseListener(traverseListener);
    }

    public void addVerifyListener(VerifyListener verifyListener) {
        if (verifyListener != null) {
            this.listeners.add((Object)verifyListener);
        }
    }

    public void clearHistory() {
        this.combo.removeAll();
        this.lastSelIx = 0;
    }

    private int computeLeftSlashPosition() {
        return FileUtil.defaultSlashes((String)this.combo.getText()).lastIndexOf(File.separator, this.combo.getTextControl().getCaretOffset() - 2);
    }

    private int computeRightSlashPosition() {
        return FileUtil.defaultSlashes((String)this.combo.getText()).indexOf(File.separator, this.combo.getTextControl().getCaretOffset());
    }

    public String constructHint(String string) {
        boolean bl = this.view.isThreeWay();
        if (string.equals(FileType.FILE.toString())) {
            string = String.valueOf(this.role.getDisplayName(bl)) + ' ' + FileType.FILE.displayName();
        } else if (string.equals(FileType.FOLDER.toString())) {
            string = String.valueOf(this.role.getDisplayName(bl)) + ' ' + FileType.FOLDER.displayName();
        }
        return string;
    }

    public Control control() {
        return this;
    }

    private void createCombo(Composite composite) {
        final int n = App.instance().docBoss().maxUriCount();
        this.caField = new ContentAssistField(composite, 2048, new IControlCreator(){

            public Control createControl(Composite composite, int n2) {
                UriChooser.this.combo = new MenuCombo(composite, 0x40040000){

                    @Override
                    public List<String> getItems() {
                        return App.instance().docBoss().recentUris(UriChooser.this.type(), UriChooser.this.role);
                    }
                };
                if (!UriChooser.this.preview) {
                    for (IAction iAction : UriChooser.this.actions()) {
                        UriChooser.this.combo.addMenuButton(iAction, UriChooser.this.role);
                    }
                }
                UriChooser.this.combo.setMaxDropdownItemCount(n);
                UriChooser.this.installComboListeners();
                if (SHOW_RAW_URI_ON_FOCUS) {
                    UriChooser.this.combo.setCallback(new IMenuComboCallback(){

                        @Override
                        public String getFocusInText() {
                            return UriChooser.this.uriInfo().uri();
                        }

                        @Override
                        public String getFocusOutText() {
                            return UriChooser.this.uriInfo().uri();
                        }
                    });
                }
                return UriChooser.this.combo;
            }
        }, new MenuComboContentAdapter(), this.getContentProposalProvider(), null, null);
        this.caField.getLayoutControl().setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.combo = (MenuCombo)this.caField.getControl();
        this.combo.setMaxDropdownItemCount(n);
        StyledText styledText = this.combo.getTextControl();
        styledText.setKeyBinding(0x1040004, 0);
        styledText.setKeyBinding(17039363, 0);
        styledText.setKeyBinding(17170436, 0);
        styledText.setKeyBinding(17170435, 0);
        this.cpAdapter = this.caField.getContentAssistCommandAdapter();
        this.cpAdapter.setLabelProvider((ILabelProvider)new LabelProvider(){

            public Image getImage(Object object) {
                return ((ContentProposal)object).getImage();
            }

            public String getText(Object object) {
                IContentProposal iContentProposal = (IContentProposal)object;
                String string = iContentProposal.getLabel();
                return StringUtil.isEmpty((String)string) ? iContentProposal.getContent() : string;
            }
        });
        this.cpAdapter.setProposalAcceptanceStyle(2);
        this.cpAdapter.setPropagateKeys(true);
        this.cpAdapter.proposalTableCreator = new IControlCreator(){

            public Control createControl(Composite composite, int n) {
                return new ContentProposalTable(UriChooser.this.cpAdapter, composite, n);
            }
        };
    }

    protected void createContents() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        this.setLayout((Layout)gridLayout);
        this.createCombo(this);
    }

    public DiffView deltaView() {
        return this.view;
    }

    public void dropped(DropTargetEvent dropTargetEvent) {
        List<IFile> list = this.dndProcessor.getDroppedFiles(dropTargetEvent);
        if (!list.isEmpty()) {
            boolean bl;
            boolean bl2;
            if (list.size() == 1) {
                boolean bl3 = dropTargetEvent.widget != this.dndProcessor.dropTarget();
                UriInfo uriInfo = new UriInfo(list.get(0).getUri(), false);
                this.updateUriInfo(uriInfo, false, bl3, false);
                return;
            }
            boolean bl4 = bl2 = list.size() > 2;
            if (bl2 != this.view.isThreeWay()) {
                this.view.getInput().setThreeWay(bl2);
            }
            Set<Role> set = Relation.roles(bl2);
            UriChooserBoss uriChooserBoss = this.view.uriChooserBoss();
            Map<Role, UriInfo> map = FileDnDProcessor.uriInfosFromFiles(list);
            for (Role role : set) {
                UriInfo uriInfo = map.get((Object)role);
                if (uriInfo == null) continue;
                uriChooserBoss.uriChooser(role).updateUriInfo(uriInfo, false, false, false);
            }
            boolean bl5 = bl = dropTargetEvent.widget != this.dndProcessor.dropTarget();
            if (bl) {
                App.instance().viewBoss().viewDoc(this.view, false, null, null, false, true);
            }
        }
    }

    public DropTargetListener dropTargetListener() {
        return this.dndProcessor.dropTargetListener();
    }

    public Color getBackground() {
        return this.combo.getBackground();
    }

    protected IContentProposalProvider getContentProposalProvider() {
        return null;
    }

    protected Image getDefaultImage() {
        return null;
    }

    public UriInfo getHistoryItem(int n) {
        IDocBoss iDocBoss = App.instance().docBoss();
        if (n >= 0 && n < iDocBoss.uriCount(this.type())) {
            return iDocBoss.get(this.type(), n).uriInfo(this.role);
        }
        return new UriInfo();
    }

    public int getSelectionIndex() {
        return this.lastSelIx;
    }

    private int getSelectionPassiveEnd() {
        Point point = this.combo.getSelection();
        return this.combo.getTextControl().getCaretOffset() == point.y ? point.x : point.y;
    }

    public String getText() {
        if (this.uriInfo.title().isEmpty()) {
            return this.combo.getText();
        }
        return this.uriInfo.uri();
    }

    public boolean hasEntryMask(int n, boolean bl) {
        return KeyUtil.hasMask((Widget)this.combo, (int)n, (boolean)bl);
    }

    private void installComboListeners() {
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 14: {
                        UriChooser.this.updateUriInfo(UriChooser.this.uriInfo(), UriChooser.this.combo.getText(), true, true, false);
                        break;
                    }
                    case 1: {
                        UriChooser.this.onComboKeyDown(event);
                        break;
                    }
                    case 2: {
                        UriChooser.this.onComboKeyUp(event);
                        break;
                    }
                    case 13: {
                        UriChooser.this.onDropdownListSelection(event);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
        };
        this.combo.addListener(14, listener);
        this.combo.addListener(1, listener);
        this.combo.addListener(2, listener);
        this.combo.addListener(13, listener);
        this.combo.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                UriChooser.this.updateForegroundColor(true);
            }

            public void focusLost(FocusEvent focusEvent) {
                UriChooser.this.updateForegroundColor(false);
            }
        });
    }

    public boolean isFocusControl() {
        return this.combo.isFocusControl();
    }

    private void modifyText(ModifyEvent modifyEvent) {
        Object[] objectArray;
        Object[] objectArray2 = objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray2[n2];
            if (object instanceof ModifyListener) {
                ((ModifyListener)object).modifyText(modifyEvent);
            }
            ++n2;
        }
    }

    private void onComboKeyDown(Event event) {
        if (event.character == '\t') {
            Display display = this.getDisplay();
            display.post(ControlUtil.translateEvent(event, display.getFocusControl()));
            event.character = (char)27;
            event.doit = false;
        }
        if (!event.doit) {
            return;
        }
        if (KeyUtil.hasKey((Event)event, (int)0x1000003, (int)262144) || KeyUtil.hasKey((Event)event, (int)0x1000004, (int)262144)) {
            int n;
            if (KeyUtil.hasKey((Event)event, (int)0x1000003, (int)262144)) {
                n = this.computeLeftSlashPosition() + 1;
            } else {
                n = this.computeRightSlashPosition() + 1;
                if (n == 0) {
                    n = this.combo.getText().length();
                }
            }
            int n2 = KeyUtil.hasMask((Event)event, (int)SWT.MOD2) ? this.getSelectionPassiveEnd() : n;
            this.combo.getTextControl().setSelection(n2, n);
            event.doit = false;
        } else if ((KeyUtil.hasKey((Event)event, (int)0x1000007) || KeyUtil.hasKey((Event)event, (int)0x1000008)) && !KeyUtil.hasMask((Event)event, (int)SWT.MOD2)) {
            switch (event.keyCode) {
                case 0x1000007: {
                    this.combo.setSelection(new Point(0, 0));
                    break;
                }
                case 0x1000008: {
                    int n = this.combo.getText().length();
                    this.combo.setSelection(new Point(n, n));
                }
            }
            event.doit = false;
        }
    }

    private void onComboKeyUp(Event event) {
        if (!event.doit) {
            return;
        }
        if (KeyUtil.hasKey((Event)event, (int)0x1000002) || KeyUtil.hasKey((Event)event, (int)0x1000001) || KeyUtil.hasKey((Event)event, (int)0x1000003) || KeyUtil.hasKey((Event)event, (int)0x1000004) || KeyUtil.hasKey((Event)event, (int)0x1000008) || KeyUtil.hasKey((Event)event, (int)0x1000007) || KeyUtil.hasKey((Event)event, (int)0x1000050) || KeyUtil.hasKey((Event)event, (int)40) || KeyUtil.hasKey((Event)event, (int)13) || KeyUtil.hasKey((Event)event, (int)SWT.MOD1) || KeyUtil.hasKey((Event)event, (int)SWT.MOD2) || KeyUtil.hasKey((Event)event, (int)SWT.MOD3) || KeyUtil.hasKey((Event)event, (int)SWT.MOD4) || KeyUtil.hasKey((Event)event, (int)0x100000A) || KeyUtil.hasKey((Event)event, (int)0x100000B) || KeyUtil.hasKey((Event)event, (int)0x100000C) || KeyUtil.hasKey((Event)event, (int)0x100000D) || KeyUtil.hasKey((Event)event, (int)0x100000E) || KeyUtil.hasKey((Event)event, (int)0x100000F) || KeyUtil.hasKey((Event)event, (int)0x1000010) || KeyUtil.hasKey((Event)event, (int)0x1000011) || KeyUtil.hasKey((Event)event, (int)0x1000012) || KeyUtil.hasKey((Event)event, (int)0x1000013) || KeyUtil.hasKey((Event)event, (int)0x1000014) || KeyUtil.hasKey((Event)event, (int)0x1000015) || KeyUtil.hasKey((Event)event, (int)0x1000016) || KeyUtil.hasKey((Event)event, (int)0x1000017) || KeyUtil.hasKey((Event)event, (int)0x1000018) || KeyUtil.hasKey((Event)event, (int)27) || KeyUtil.hasKey((Event)event, (int)16777300) || KeyUtil.hasMask((Event)event, (int)SWT.MOD1) || KeyUtil.hasMask((Event)event, (int)SWT.MOD2) || KeyUtil.hasMask((Event)event, (int)SWT.MOD3) || SWT.MOD4 != 0 && KeyUtil.hasMask((Event)event, (int)SWT.MOD4) || event.character == '\t') {
            return;
        }
        if (this.cpAdapter != null && !VfsUtil.hasRemoteScheme((String)this.getText())) {
            this.cpAdapter.openProposalPopup(true);
        }
    }

    protected void onDropdownListSelection(Event event) {
        this.lastSelIx = this.combo.getSelectionIndex();
        if (this.lastSelIx < this.combo.getItemCount()) {
            this.uriInfo = this.getHistoryItem(this.lastSelIx);
        }
        this.notifyListeners(13, ControlUtil.translateEvent(event, (Control)this.combo));
    }

    public void removeFocusListener(FocusListener focusListener) {
        this.combo.removeFocusListener(focusListener);
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        if (modifyListener != null) {
            this.listeners.remove((Object)modifyListener);
        }
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.removeListener(14, (SWTEventListener)selectionListener);
        this.removeListener(13, (SWTEventListener)selectionListener);
    }

    public void removeVerifyListener(VerifyListener verifyListener) {
        if (verifyListener != null) {
            this.listeners.remove((Object)verifyListener);
        }
    }

    public Role role() {
        return this.role;
    }

    public void setBackground(Color color) {
        this.combo.setBackground(color);
    }

    private void setComboText(String string, boolean bl) {
        FileType fileType = FileType.fromString((String)string);
        boolean bl2 = this.view.isThreeWay();
        if (fileType != FileType.UNKNOWN) {
            string = Doc.constructHint(this.role, fileType, bl2);
        }
        this.combo.setText(string);
        this.setToolTipText(NLS.bind((String)UIMsg.UriChooser_name, (Object)this.role.getDisplayName(bl2), (Object)this.type()));
        this.updateForegroundColor(this.isFocusControl());
        this.combo.setEditable(bl);
    }

    public void setImage(Image image) {
        if (!this.preview) {
            this.combo.setImage(image != null ? image : this.getDefaultImage());
        }
    }

    public void setToolTipText(String string) {
        this.combo.setToolTipText(string);
    }

    public String toString() {
        return this.role().toString();
    }

    public FileType type() {
        return FileType.FILE;
    }

    private void updateForegroundColor(boolean bl) {
        boolean bl2 = UriInfo.isHintUri(this.combo.getText());
        int n = 2;
        String string = NLS.bind((String)UIMsg.UriChooser_name, (Object)this.role.getDisplayName(this.view.isThreeWay()), (Object)this.type());
        if (this.view.getInputs().get((Object)this.role).isSnapshot()) {
            n = 9;
            string = String.valueOf(string) + " Snapshot";
        } else if (!bl && bl2) {
            n = 16;
        }
        this.setToolTipText(string);
        this.combo.getTextControl().setForeground(this.combo.getDisplay().getSystemColor(n));
    }

    protected void updateTabList() {
        this.setTabList(new Control[]{this.caField.getLayoutControl()});
    }

    public void updateUriInfo(IDoc iDoc) {
        String string = iDoc.uriInfo().uri();
        if (string.isEmpty()) {
            string = iDoc.getName();
        }
        this.updateUriInfo(iDoc.uriInfo(), string, false, false, false);
    }

    public void updateUriInfo(UriInfo uriInfo, boolean bl, boolean bl2, boolean bl3) {
        this.updateUriInfo(uriInfo, uriInfo.uri(), bl, bl2, bl3);
    }

    private void updateUriInfo(UriInfo uriInfo, String string, boolean bl, boolean bl2, boolean bl3) {
        this.uriInfo = uriInfo;
        if (!(string = StringUtil.makeSafe((String)string)).equals(this.combo.getText()) || bl) {
            String string2;
            String string3;
            if (bl2) {
                string3 = new Event();
                ((Event)string3).widget = this;
                string2 = new VerifyEvent((Event)string3);
                ((VerifyEvent)string2).doit = true;
                ((VerifyEvent)string2).text = string;
                this.verifyText((VerifyEvent)string2);
                if (!((VerifyEvent)string2).doit) {
                    return;
                }
            }
            string3 = uriInfo.title();
            string2 = uriInfo.displayUri();
            if (!string2.isEmpty() && !string.equals(string2)) {
                string = string2;
            }
            this.setComboText(string3.isEmpty() ? string : string3, string3.isEmpty());
            if (bl2) {
                Event event = new Event();
                event.widget = this;
                event.data = bl3;
                this.modifyText(new ModifyEvent(event));
            }
        }
    }

    public UriInfo uriInfo() {
        String string;
        String string2 = this.getText();
        String string3 = string = UriInfo.isHintUri(string2) ? "" : FileUtil.resolvePath((String)string2, null);
        if (this.uriInfo == null) {
            this.uriInfo = new UriInfo(string);
        } else {
            boolean bl;
            String string4 = this.uriInfo.displayUri();
            boolean bl2 = bl = !string.equals(string4);
            if (bl && this.view.getInputs().get((Object)this.role).isSnapshot()) {
                this.uriInfo = this.uriInfo.cloneUpdateSnapshotPath("");
                EnumMap<Role, StructFileInfo> enumMap = new EnumMap<Role, StructFileInfo>(Role.class);
                enumMap.putAll(this.uriInfo.snapshotTrees());
                enumMap.remove((Object)this.role);
                this.uriInfo = this.uriInfo.cloneUpdateSnapshotTrees(enumMap);
            }
            this.uriInfo = !bl ? this.uriInfo.cloneUpdateError(null) : this.uriInfo.cloneUpdateUri(string, true);
            if (!this.uriInfo.contentType().isUnknown()) {
                this.uriInfo = this.uriInfo.cloneUpdateContentType(ContentType.UNKNOWN);
            }
        }
        return this.uriInfo;
    }

    private void verifyText(VerifyEvent verifyEvent) {
        Object[] objectArray = this.listeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            if (object instanceof VerifyListener) {
                ((VerifyListener)object).verifyText(verifyEvent);
            }
            ++n;
        }
    }
}

