/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui;

import com.deltawalker.ImageCache;
import com.deltawalker.ImageConst;
import com.deltawalker.Msg;
import com.deltawalker.interfaces.IDiffDoc;
import com.deltawalker.internal.DeltaWalkerPlugin;
import com.deltawalker.internal.script.doc.ScriptDoc;
import com.deltawalker.internal.script.ui.ScriptEditor;
import com.deltawalker.internal.ui.WorkbenchPartAdapter;
import com.deltawalker.ui.CompareEditor;
import com.deltawalker.ui.CompareView;
import com.deltawalker.ui.DiffView;
import com.deltawalker.ui.UIMsg;
import com.deltawalker.ui.actions.SearchContributionItem;
import com.deltopia.jface.util.IViewHolder;
import com.deltopia.jface.util.Spacer;
import com.deltopia.ui.concurrency.GuiExecutor;
import com.deltopia.util.Const;
import com.deltopia.util.OS;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.intro.IIntroManager;
import org.eclipse.ui.intro.IIntroPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public final class UIUtil {
    public static final String CHECK_FOR_UPDATES_IS_RUN_KEY = String.valueOf(UIUtil.class.getName()) + ".checkForUpdatesIsRun";
    public static final String COMPARE_VIEW_ID = CompareView.ID;
    public static final String DIFF_FONT_KEY = "com.deltawalker.ui.editorFont";
    public static final String DW_URL = "http://www.deltawalker.com";
    public static final IEditorReference[] EMPTY_EDITOR_ARRAY = new IEditorReference[0];
    public static final IViewReference[] EMPTY_VIEW_ARRAY = new IViewReference[0];
    public static final boolean OATI = false;

    public static ActionBarAdvisor actionAdvisor() {
        WorkbenchWindow workbenchWindow = (WorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        ActionBarAdvisor actionBarAdvisor = workbenchWindow.getActionBarAdvisor();
        return actionBarAdvisor;
    }

    public static DiffView activeDiffView(boolean bl, IWorkbenchWindow iWorkbenchWindow) {
        IWorkbenchPage iWorkbenchPage;
        if (iWorkbenchWindow == null) {
            iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        }
        if ((iWorkbenchPage = iWorkbenchWindow.getActivePage()) != null) {
            List<IViewPart> list;
            DiffView diffView = null;
            List<Object> list2 = list = bl ? UIUtil.getCompareViews(iWorkbenchWindow) : UIUtil.getCompareEditors(iWorkbenchWindow);
            if (!list.isEmpty()) {
                IWorkbenchPart iWorkbenchPart = (IWorkbenchPart)list.get(list.size() - 1);
                WorkbenchPartAdapter workbenchPartAdapter = (WorkbenchPartAdapter)iWorkbenchPart.getAdapter(WorkbenchPartAdapter.class);
                diffView = (DiffView)workbenchPartAdapter.viewHolder().view(0, false);
                return diffView;
            }
        }
        return null;
    }

    public static void centerToAppShell(Shell shell) {
        Rectangle rectangle = shell.getBounds();
        Shell shell2 = UIUtil.getActiveWindowShell();
        Rectangle rectangle2 = shell2.getBounds();
        int n = rectangle2.x + (rectangle2.width - rectangle.width) / 2;
        int n2 = rectangle2.y + (rectangle2.height - rectangle.height) / 2;
        shell.setLocation(n, n2);
    }

    public static void closeIntro(IWorkbenchWindow iWorkbenchWindow) {
        IIntroManager iIntroManager;
        IIntroPart iIntroPart;
        if (iWorkbenchWindow == null) {
            iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        }
        if ((iIntroPart = (iIntroManager = iWorkbenchWindow.getWorkbench().getIntroManager()).getIntro()) != null) {
            iIntroManager.closeIntro(iIntroPart);
        }
        iWorkbenchWindow.getShell().setActive();
    }

    public static void copyTextToClipboard(String string) {
        Clipboard clipboard = new Clipboard(UIUtil.display());
        try {
            clipboard.setContents(new Object[]{string}, new Transfer[]{TextTransfer.getInstance()});
        }
        finally {
            clipboard.dispose();
        }
    }

    public static Display display() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static void enableDialogHelp() {
        TrayDialog.setDialogHelpAvailable((boolean)true);
        ImageRegistry imageRegistry = JFaceResources.getImageRegistry();
        imageRegistry.put("dialog_help_image", AbstractUIPlugin.imageDescriptorFromPlugin((String)DeltaWalkerPlugin.getPluginId(), (String)ImageConst.DIALOG_HELP));
    }

    public static void enforceMinDialogSize(Shell shell) {
        shell.pack();
        Rectangle rectangle = shell.getBounds();
        shell.setMinimumSize(rectangle.width * 3 / 4, rectangle.height);
        UIUtil.centerToAppShell(shell);
    }

    public static IWorkbenchWindow getActiveWindow() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    }

    public static Shell getActiveWindowShell() {
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        if (iWorkbench == null) {
            return null;
        }
        IWorkbenchWindow iWorkbenchWindow = iWorkbench.getActiveWorkbenchWindow();
        if (iWorkbenchWindow == null) {
            Display display = UIUtil.display();
            return display.getActiveShell();
        }
        return iWorkbenchWindow.getShell();
    }

    public static List<IEditorPart> getAllCompareEditors() {
        IWorkbenchWindow[] iWorkbenchWindowArray;
        ArrayList<IEditorPart> arrayList = new ArrayList<IEditorPart>();
        IWorkbenchWindow[] iWorkbenchWindowArray2 = iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow iWorkbenchWindow = iWorkbenchWindowArray2[n2];
            arrayList.addAll(UIUtil.getCompareEditors(iWorkbenchWindow));
            ++n2;
        }
        return arrayList;
    }

    public static List<IViewPart> getAllCompareViews() {
        IWorkbenchWindow[] iWorkbenchWindowArray;
        ArrayList<IViewPart> arrayList = new ArrayList<IViewPart>();
        IWorkbenchWindow[] iWorkbenchWindowArray2 = iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow iWorkbenchWindow = iWorkbenchWindowArray2[n2];
            arrayList.addAll(UIUtil.getCompareViews(iWorkbenchWindow));
            ++n2;
        }
        return arrayList;
    }

    public static int getAverageCharWidth(Drawable drawable) {
        GC gC = new GC(drawable);
        try {
            int n;
            int n2 = n = gC.getFontMetrics().getAverageCharWidth();
            return n2;
        }
        finally {
            if (gC != null) {
                gC.dispose();
            }
        }
    }

    public static List<IEditorPart> getCompareEditors(IWorkbenchWindow iWorkbenchWindow) {
        IWorkbenchPage[] iWorkbenchPageArray;
        if (iWorkbenchWindow == null) {
            iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        }
        LinkedList<IEditorPart> linkedList = new LinkedList<IEditorPart>();
        IWorkbenchPage[] iWorkbenchPageArray2 = iWorkbenchPageArray = iWorkbenchWindow.getPages();
        int n = iWorkbenchPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference[] iEditorReferenceArray;
            IWorkbenchPage iWorkbenchPage = iWorkbenchPageArray2[n2];
            IEditorReference[] iEditorReferenceArray2 = iEditorReferenceArray = iWorkbenchPage.getEditorReferences();
            int n3 = iEditorReferenceArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IEditorReference iEditorReference = iEditorReferenceArray2[n4];
                IEditorPart iEditorPart = iEditorReference.getEditor(false);
                if (iEditorPart instanceof CompareEditor) {
                    linkedList.add(iEditorPart);
                }
                ++n4;
            }
            ++n2;
        }
        return linkedList;
    }

    public static List<IViewReference> getCompareViewRefs(IWorkbenchWindow iWorkbenchWindow) {
        IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
        LinkedList<IViewReference> linkedList = new LinkedList<IViewReference>();
        if (iWorkbenchPage != null) {
            IViewReference[] iViewReferenceArray;
            IViewReference[] iViewReferenceArray2 = iViewReferenceArray = iWorkbenchPage.getViewReferences();
            int n = iViewReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IViewReference iViewReference = iViewReferenceArray2[n2];
                if (iViewReference.getId().equals(CompareView.ID)) {
                    linkedList.add(iViewReference);
                }
                ++n2;
            }
        }
        return linkedList;
    }

    public static List<IViewPart> getCompareViews(IWorkbenchWindow iWorkbenchWindow) {
        ArrayList<IViewPart> arrayList = new ArrayList<IViewPart>();
        List<IViewReference> list = UIUtil.getCompareViewRefs(iWorkbenchWindow);
        for (IViewReference iViewReference : list) {
            IViewPart iViewPart = iViewReference.getView(false);
            if (iViewPart == null) continue;
            arrayList.add(iViewPart);
        }
        return arrayList;
    }

    public static List<IEditorPart> getScriptEditors(IWorkbenchWindow iWorkbenchWindow) {
        IWorkbenchPage[] iWorkbenchPageArray;
        if (iWorkbenchWindow == null) {
            iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        }
        LinkedList<IEditorPart> linkedList = new LinkedList<IEditorPart>();
        IWorkbenchPage[] iWorkbenchPageArray2 = iWorkbenchPageArray = iWorkbenchWindow.getPages();
        int n = iWorkbenchPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference[] iEditorReferenceArray;
            IWorkbenchPage iWorkbenchPage = iWorkbenchPageArray2[n2];
            IEditorReference[] iEditorReferenceArray2 = iEditorReferenceArray = iWorkbenchPage.getEditorReferences();
            int n3 = iEditorReferenceArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IEditorReference iEditorReference = iEditorReferenceArray2[n4];
                IEditorPart iEditorPart = iEditorReference.getEditor(false);
                if (iEditorPart instanceof ScriptEditor) {
                    linkedList.add(iEditorPart);
                }
                ++n4;
            }
            ++n2;
        }
        return linkedList;
    }

    public static IToolBarManager getSearchToolBarManager(IWorkbenchWindow iWorkbenchWindow) {
        IContributionItem iContributionItem;
        ToolBarManager toolBarManager;
        boolean bl = OS.COCOA;
        Object object = toolBarManager = bl ? ((WorkbenchWindow)iWorkbenchWindow).getToolBarManager() : ((WorkbenchWindow)iWorkbenchWindow).getPerspectiveBar();
        if (toolBarManager != null && (iContributionItem = toolBarManager.find("searchContributionItem")) == null) {
            Listener[] listenerArray;
            IContributionItem[] iContributionItemArray = toolBarManager.getItems();
            if (bl) {
                toolBarManager.add((IContributionItem)new Spacer(true));
            }
            toolBarManager.add((IContributionItem)new SearchContributionItem());
            if (bl) {
                return toolBarManager;
            }
            toolBarManager.update(true);
            toolBarManager.remove(iContributionItemArray[0]);
            toolBarManager.update(true);
            ToolBar toolBar = toolBarManager.getControl();
            Listener[] listenerArray2 = listenerArray = toolBar.getListeners(35);
            int n = listenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Listener listener = listenerArray2[n2];
                toolBar.removeListener(35, listener);
                ++n2;
            }
        }
        return toolBarManager;
    }

    public static boolean hasSingleEmptyDeltaEditor(IWorkbenchWindow iWorkbenchWindow) {
        List<IEditorPart> list = UIUtil.getCompareEditors(iWorkbenchWindow);
        for (IEditorPart iEditorPart : list) {
            IDiffDoc iDiffDoc;
            if (!(iEditorPart instanceof CompareEditor) || !(iDiffDoc = ((CompareEditor)iEditorPart).diffDoc()).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasSingleEmptyDeltaView(IWorkbenchWindow iWorkbenchWindow) {
        List<IViewPart> list = UIUtil.getCompareViews(iWorkbenchWindow);
        for (IViewPart iViewPart : list) {
            if (!(iViewPart instanceof CompareView) || !((CompareView)iViewPart).diffDoc().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasSingleEmptyScriptEditor(IWorkbenchWindow iWorkbenchWindow) {
        List<IEditorPart> list = UIUtil.getScriptEditors(iWorkbenchWindow);
        for (IEditorPart iEditorPart : list) {
            ScriptDoc scriptDoc;
            if (!(iEditorPart instanceof ScriptEditor) || !(scriptDoc = ((ScriptEditor)iEditorPart).getEditorInput()).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static boolean isRetina() {
        final Point[] pointArray = new Point[1];
        final Display display = UIUtil.display();
        GuiExecutor.instance().execute(new Runnable(){

            @Override
            public void run() {
                pointArray[0] = display.getDPI();
            }
        });
        return pointArray[0].x >= 144 && pointArray[0].y >= 144;
    }

    public static void setBackground(Control control, int n) {
        control.setBackground(control.getDisplay().getSystemColor(n));
    }

    public static void setHelpContextId(Control control, String string) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp(control, string);
    }

    public static int showConfirmActionPrompt(Shell shell, String string, String[] stringArray) {
        if (shell == null) {
            shell = UIUtil.getActiveWindowShell();
        }
        MessageDialog messageDialog = new MessageDialog(shell, UIMsg.UIUtil_confirmTitle, null, string, 0, stringArray, 0){

            public Image getImage() {
                return ImageCache.getImage("icons/DeltaWalker48x48.png");
            }
        };
        return messageDialog.open();
    }

    public static void showError(final String string) {
        GuiExecutor.instance().execute(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)UIUtil.getActiveWindowShell(), (String)Msg.Common_deltaWalker, (String)string);
            }
        });
    }

    public static void showError(String string, Throwable throwable) {
        HashSet<String> hashSet = new HashSet<String>();
        Throwable throwable2 = throwable.getCause();
        int n = 0;
        Serializable serializable = throwable2;
        while (serializable != null) {
            hashSet.add(((Throwable)serializable).getLocalizedMessage());
            if (++n > 10) break;
            serializable = ((Throwable)serializable).getCause();
        }
        serializable = new StringBuilder();
        ((StringBuilder)serializable).append(string);
        if (!hashSet.isEmpty()) {
            for (String string2 : hashSet) {
                ((StringBuilder)serializable).append(string2);
                ((StringBuilder)serializable).append(Const.LINE_ENDING);
                ((StringBuilder)serializable).append(Const.LINE_ENDING);
            }
        }
        GuiExecutor.instance().execute(new Runnable((StringBuilder)serializable){
            private final /* synthetic */ StringBuilder val$sb;
            {
                this.val$sb = stringBuilder;
            }

            @Override
            public void run() {
                MessageDialog.openError((Shell)UIUtil.getActiveWindowShell(), (String)Msg.Common_deltaWalker, (String)this.val$sb.toString());
            }
        });
    }

    public static void showHelp(String string, HelpContext helpContext) {
        String string2 = helpContext != null ? NLS.bind((String)"{0}/{1}/{2}.jsp", (Object[])new String[]{DW_URL, helpContext.toString(), string}) : NLS.bind((String)"{0}/{1}.jsp", (Object)DW_URL, (Object)string);
        Program.launch((String)string2);
    }

    public static void showOutOfMemoryError() {
        GuiExecutor.instance().execute(new Runnable(){

            @Override
            public void run() {
                Shell shell = UIUtil.getActiveWindowShell();
                MessageDialog messageDialog = new MessageDialog(shell, Msg.Common_err_OomTitle, null, Msg.Common_err_Oom, 0, new String[]{IDialogConstants.OK_LABEL}, 0){

                    public Image getImage() {
                        return ImageCache.getImage("icons/DeltaWalker48x48.png");
                    }
                };
                messageDialog.open();
            }
        });
    }

    public static int showRestartPrompt(Shell shell, String string, String[] stringArray) {
        if (shell == null) {
            shell = UIUtil.getActiveWindowShell();
        }
        MessageDialog messageDialog = new MessageDialog(shell, UIMsg.UIUtil_restartTitle, null, string, 0, stringArray, 0){

            public Image getImage() {
                return ImageCache.getImage("icons/DeltaWalker48x48.png");
            }
        };
        return messageDialog.open();
    }

    public static int stringExtent(String string, Control control) {
        GC gC = new GC((Drawable)control);
        try {
            int n = (int)((double)gC.stringExtent((String)string).x * 1.1);
            return n;
        }
        finally {
            gC.dispose();
        }
    }

    public static IWorkbenchPart workbenchPartFromDiffView(DiffView diffView) {
        IWorkbenchPart iWorkbenchPart = diffView.getPart();
        if (iWorkbenchPart != null) {
            return iWorkbenchPart;
        }
        IEditorSite iEditorSite = diffView.getEditorSite();
        if (iEditorSite != null && (iWorkbenchPart = iEditorSite.getPart()) != null) {
            return iWorkbenchPart;
        }
        IViewHolder iViewHolder = diffView.viewHolder();
        if (iViewHolder != null) {
            Control control = iViewHolder.getControl();
            while (control != null && !control.isDisposed()) {
                Object object = control.getData();
                if (object instanceof IWorkbenchPart) {
                    return (IWorkbenchPart)object;
                }
                control = control.getParent();
            }
        }
        return null;
    }

    public static IWorkbenchPart workbenchPartFromDiffView(DiffView diffView, boolean bl, IWorkbenchWindow iWorkbenchWindow) {
        if (iWorkbenchWindow == null) {
            iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        }
        List<IViewPart> list = bl ? UIUtil.getCompareViews(iWorkbenchWindow) : UIUtil.getCompareEditors(iWorkbenchWindow);
        for (IWorkbenchPart iWorkbenchPart : list) {
            WorkbenchPartAdapter workbenchPartAdapter = (WorkbenchPartAdapter)iWorkbenchPart.getAdapter(WorkbenchPartAdapter.class);
            IViewHolder iViewHolder = workbenchPartAdapter.viewHolder();
            int n = iViewHolder.viewCount(false);
            int n2 = 0;
            while (n2 < n) {
                if (diffView == iViewHolder.view(n2, false)) {
                    return iWorkbenchPart;
                }
                ++n2;
            }
        }
        return null;
    }

    public static final Point getPrefPreviewSize(Display display) {
        if (display == null) {
            throw new NullPointerException("display");
        }
        Rectangle rectangle = display.getBounds();
        Rectangle rectangle2 = display.getClientArea();
        int n = Math.min(rectangle2.width, rectangle.width);
        int n2 = Math.min(rectangle2.height, rectangle.height);
        n = Math.max(256, n / 2);
        n2 = Math.max(256, n2 / 2);
        return new Point(n, n2);
    }

    private UIUtil() {
    }

    public static enum HelpContext {
        DIALOG("dialogs"),
        PREF_PAGE("preferences");

        private final String context;

        private HelpContext(String string2) {
            this.context = string2;
        }

        public String toString() {
            return this.context;
        }
    }
}

