/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui;

import com.deltawalker.ImageConst;
import com.deltawalker.internal.DeltaWalkerPlugin;
import com.deltawalker.ui.IThrobber;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class ThrobberService {
    private static final String DEFAULT_THROBBER_SERVICE = String.valueOf(ThrobberService.class.getName()) + ".defaultThrobberService";
    private boolean animating;
    private Runnable animator;
    private int[] busyDelays;
    private int currentFrameIx;
    private final Display display;
    private Image idleFrame;
    private Image[] imgFrames;
    private final IPropertyChangeListener onPop = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("BUSY".equals(propertyChangeEvent.getProperty())) {
                ThrobberService.this.busyChanged((IThrobber)propertyChangeEvent.getSource());
            }
        }
    };
    private final List<IThrobber> spinners = new LinkedList<IThrobber>();

    public static ThrobberService getDefault(Display display) {
        String string = DEFAULT_THROBBER_SERVICE;
        ThrobberService throbberService = (ThrobberService)display.getData(string);
        if (throbberService == null) {
            throbberService = new ThrobberService(display, new Point(16, 16));
            display.setData(string, (Object)throbberService);
        }
        return throbberService;
    }

    private ThrobberService(Display display, Point point) {
        this.display = display;
        try (InputStream inputStream = DeltaWalkerPlugin.getDefault().getBundle().getResource(ImageConst.SPINNER).openStream();){
            ImageLoader imageLoader = new ImageLoader();
            this.setBusyFrames(imageLoader.load(inputStream));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void addThrobber(IThrobber iThrobber) {
        if (iThrobber == null) {
            throw new NullPointerException("throbber");
        }
        if (!this.spinners.contains(iThrobber) && this.spinners.add(iThrobber)) {
            iThrobber.addPropertyListener(this.onPop);
        }
    }

    private void busyChanged(IThrobber iThrobber) {
        iThrobber.currentFrameChanged(this.getCurrentFrame(iThrobber));
        if (this.isBusy()) {
            this.startAnimation();
        } else {
            this.stopAnimation(false);
        }
    }

    public Point computeSize(int n, int n2, boolean bl) {
        int n3;
        int n4;
        if (this.idleFrame != null) {
            Rectangle rectangle = this.idleFrame.getBounds();
            n4 = rectangle.width;
            n3 = rectangle.height;
        } else {
            n4 = 0;
            n3 = 0;
        }
        if (this.imgFrames != null) {
            int n5 = this.imgFrames.length;
            int n6 = 0;
            while (n6 < n5) {
                Rectangle rectangle = this.imgFrames[n6].getBounds();
                if (n4 < rectangle.width) {
                    n4 = rectangle.width;
                }
                if (n3 < rectangle.height) {
                    n4 = rectangle.height;
                }
                ++n6;
            }
        }
        return new Point(n4, n3);
    }

    private void disposeBusyFrames() {
        if (this.imgFrames != null) {
            int n = this.imgFrames.length;
            int n2 = 0;
            while (n2 < n) {
                this.imgFrames[n2].dispose();
                ++n2;
            }
            this.imgFrames = null;
        }
    }

    private int getCurrentDelay() {
        int n = this.busyDelays == null || this.currentFrameIx < 0 || this.currentFrameIx >= this.busyDelays.length ? 0 : this.busyDelays[this.currentFrameIx];
        return n * 10;
    }

    public Image getCurrentFrame(IThrobber iThrobber) {
        Object object = iThrobber.isBusy() ? (this.imgFrames == null || this.currentFrameIx < 0 || this.imgFrames.length <= this.currentFrameIx ? null : this.imgFrames[this.currentFrameIx]) : this.idleFrame;
        return object;
    }

    private Display getDisplay() {
        return this.display;
    }

    private boolean isBusy() {
        boolean bl = false;
        Iterator<IThrobber> iterator = this.spinners.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().isBusy()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private boolean isDisposed() {
        return false;
    }

    private void redraw() {
        for (IThrobber iThrobber : this.spinners) {
            iThrobber.currentFrameChanged(this.getCurrentFrame(iThrobber));
        }
    }

    public void removeThrobber(IThrobber iThrobber) {
        if (this.spinners.remove(iThrobber)) {
            iThrobber.removePropertyListener(this.onPop);
        }
    }

    public void setBusyFrames(ImageData[] imageDataArray) {
        int n = imageDataArray.length;
        Image[] imageArray = new Image[n];
        int[] nArray = new int[n];
        Display display = this.getDisplay();
        int n2 = 0;
        while (n2 < n) {
            Image image;
            ImageData imageData = imageDataArray[n2];
            imageArray[n2] = image = new Image((Device)display, imageData);
            nArray[n2] = imageData.delayTime;
            ++n2;
        }
        this.disposeBusyFrames();
        this.imgFrames = imageArray;
        this.busyDelays = nArray;
        this.currentFrameIx = 0;
        if (this.isBusy()) {
            this.redraw();
            if (imageDataArray == null || n < 2) {
                this.stopAnimation(false);
            } else {
                this.startAnimation();
            }
        }
    }

    private void startAnimation() {
        boolean bl = this.animating = this.isBusy() && this.imgFrames != null && this.imgFrames.length > 1;
        if (this.animating && this.animator == null) {
            final Display display = this.getDisplay();
            this.animator = new Runnable(){

                @Override
                public void run() {
                    if (!ThrobberService.this.isDisposed() && ThrobberService.this.isBusy() && ThrobberService.this.imgFrames != null && ThrobberService.this.imgFrames.length > 1 && ThrobberService.this.animating) {
                        ThrobberService.this.currentFrameIx = (ThrobberService.this.currentFrameIx + 1) % ThrobberService.this.imgFrames.length;
                        ThrobberService.this.redraw();
                        display.timerExec(ThrobberService.this.getCurrentDelay(), (Runnable)this);
                    } else {
                        ThrobberService.this.animator = null;
                    }
                }
            };
            display.timerExec(this.getCurrentDelay(), this.animator);
        }
    }

    private void stopAnimation(boolean bl) {
        this.animating = false;
        if (!bl && !this.isDisposed()) {
            this.redraw();
        }
    }
}

