/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui;

import com.deltawalker.NotifyUtil;
import com.deltawalker.ui.IThrobber;
import com.deltawalker.ui.ThrobberService;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class Throbber
extends Canvas
implements IThrobber {
    private boolean busy;
    private final ListenerList listeners = new ListenerList();
    private ThrobberService service = ThrobberService.getDefault(this.getDisplay());

    public Throbber(Composite composite, int n) {
        super(composite, n);
        this.service.addThrobber(this);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 9: {
                        Throbber.this.paintControl(event);
                        break;
                    }
                    case 12: {
                        Throbber.this.widgetDisposed(event);
                    }
                }
            }
        };
        this.addListener(12, listener);
        this.addListener(9, listener);
    }

    @Override
    public void addPropertyListener(IPropertyChangeListener iPropertyChangeListener) {
        this.listeners.add((Object)iPropertyChangeListener);
    }

    public Point computeSize(int n, int n2, boolean bl) {
        if (n == -1 && n2 == -1 && this.service != null) {
            Point point = this.service.computeSize(n, n2, bl);
            if (point.x != 0 && point.y != 0) {
                int n3 = 2 * this.getBorderWidth();
                return new Point(point.x + n3, point.y + n3);
            }
        }
        return super.computeSize(n, n2, bl);
    }

    @Override
    public void currentFrameChanged(Image image) {
        if (this.service != null) {
            this.redraw();
            this.update();
        }
    }

    @Override
    public boolean isBusy() {
        return this.busy;
    }

    protected void paintControl(Event event) {
        Image image = this.service == null ? null : this.service.getCurrentFrame(this);
        GC gC = event.gc;
        Rectangle rectangle = this.getClientArea();
        if (image == null) {
            gC.setBackground(this.getBackground());
            gC.fillRectangle(rectangle);
        } else {
            Rectangle rectangle2 = image.getBounds();
            int n = rectangle2.width;
            int n2 = rectangle2.height;
            gC.drawImage(image, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, rectangle.x + (rectangle.width - n) / 2, rectangle.y + (rectangle.height - n2) / 2, n, n2);
        }
    }

    @Override
    public void removePropertyListener(IPropertyChangeListener iPropertyChangeListener) {
        this.listeners.remove((Object)iPropertyChangeListener);
    }

    @Override
    public void setBusy(boolean bl) {
        if (this.busy != bl) {
            boolean bl2 = this.busy;
            this.busy = bl;
            NotifyUtil.firePropertyChange(this.listeners, this, "BUSY", bl2, this.busy);
        }
    }

    protected void widgetDisposed(Event event) {
        if (this.service != null) {
            this.service.removeThrobber(this);
            this.service = null;
        }
    }
}

