/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui;

import com.deltawalker.Delta;
import com.deltawalker.DeltaUtil;
import com.deltawalker.Msg;
import com.deltawalker.Relation;
import com.deltawalker.script.Delta;
import com.deltawalker.ui.DeltaColor;
import com.deltawalker.ui.DeltaPart;
import com.deltawalker.ui.IDiffSummary;
import com.deltawalker.ui.IDiffSummaryItem;
import com.deltawalker.ui.IDiffSummaryProvider;
import com.deltawalker.ui.StatusLineCLabelContribution;
import com.deltawalker.ui.UIMsg;
import com.deltopia.ObjectUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.internal.ViewActionBars;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SummaryStatusLineGroup
extends ActionGroup {
    private static final int ADORNMENT_INSET = 3;
    private static final int IMAGE_HEIGHT = 12;
    private static final int IMAGE_WIDTH = 16;
    private static final Map<ImageKey, ImageValue> imageCache = new HashMap<ImageKey, ImageValue>(4);
    private static final Logger LOG = LoggerFactory.getLogger(SummaryStatusLineGroup.class);
    private static final int PANEL_WIDTH_IN_CHARS = 14;
    private IActionBars actionBars;
    private StatusLineCLabelContribution ciAdded;
    private StatusLineCLabelContribution ciChanged;
    private StatusLineCLabelContribution ciConflict;
    private StatusLineCLabelContribution ciDeleted;
    private final DeltaColor color;
    protected Map<Delta, String> delta2id = new HashMap<Delta, String>(4);
    private final IPropertyChangeListener onProp = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getSource();
            if (!$assertionsDisabled && object == null) {
                throw new AssertionError();
            }
            if (object == SummaryStatusLineGroup.this.color) {
                SummaryStatusLineGroup.this.updateColors();
            }
        }
    };

    public SummaryStatusLineGroup(Shell shell, IActionBars iActionBars) {
        this.actionBars = iActionBars;
        this.color = DeltaColor.forDevice((Device)shell.getDisplay());
        this.color.addListener(this.onProp);
        this.addSummaryPanels();
    }

    protected IActionBars actionBars() {
        return this.actionBars;
    }

    protected StatusLineCLabelContribution addedItem() {
        return this.ciAdded;
    }

    protected void addSummaryPanels() {
        IStatusLineManager iStatusLineManager = this.actionBars.getStatusLineManager();
        String string = this.actionBars.getClass().getSimpleName();
        this.delta2id.put(DeltaUtil.DELETED, String.valueOf(string) + DeltaUtil.DELETED.toString());
        this.delta2id.put(DeltaUtil.ADDED, String.valueOf(string) + DeltaUtil.ADDED.toString());
        this.delta2id.put(DeltaUtil.CHANGED, String.valueOf(string) + DeltaUtil.CHANGED.toString());
        this.delta2id.put(DeltaUtil.CONFLICT, String.valueOf(string) + DeltaUtil.CONFLICT.toString());
        this.ciDeleted = this.getItem(DeltaUtil.DELETED, true);
        this.ciAdded = this.getItem(DeltaUtil.ADDED, true);
        this.ciChanged = this.getItem(DeltaUtil.CHANGED, true);
        this.ciConflict = this.getItem(DeltaUtil.CONFLICT, true);
        iStatusLineManager.update(true);
        if (LOG.isDebugEnabled()) {
            LOG.debug("addSummaryPanels():" + this.toString());
        }
    }

    protected StatusLineCLabelContribution changedItem() {
        return this.ciChanged;
    }

    protected StatusLineCLabelContribution conflictItem() {
        return this.ciConflict;
    }

    private Image createImage(Delta delta) {
        Color color = this.color.colorFromRgb(DeltaColor.getColor(delta, DeltaPart.BG, false));
        Color color2 = this.color.colorFromRgb(DeltaColor.getColor(delta, DeltaPart.BORDER, false));
        ImageKey imageKey = new ImageKey(ImageKey.SimpleKind.fromKind(delta), this.color, color, color2);
        ImageValue imageValue = imageCache.get(imageKey);
        if (imageValue != null) {
            return imageValue.retain();
        }
        Device device = this.color.device();
        Image image = new Image(device, 16, 12);
        Rectangle rectangle = image.getBounds();
        Color color3 = device.getSystemColor(1);
        Color color4 = this.color.borderColorFromBgColor(color);
        GC gC = new GC((Drawable)image);
        try {
            gC.setBackground(color);
            gC.fillRectangle(rectangle);
            int n = Math.min(rectangle.width, rectangle.height) - 6;
            if (delta.isAdded()) {
                gC.setForeground(color3);
                int n2 = (rectangle.width - n) / 2 - 1;
                int n3 = rectangle.height / 2 - 1;
                gC.drawLine(n2, n3, n2 + n, n3);
                int n4 = rectangle.width / 2 - 1;
                int n5 = (rectangle.height - n) / 2 - 1;
                gC.drawLine(n4, n5, n4, n5 + n);
                gC.setForeground(color4);
                gC.drawLine(++n2, ++n3, n2 + n, n3);
                gC.drawLine(++n4, ++n5, n4, n5 + n);
            } else if (delta.isDeleted()) {
                gC.setForeground(color3);
                int n6 = (rectangle.width - n) / 2 - 1;
                int n7 = rectangle.height / 2 - 1;
                gC.drawLine(n6, n7, n6 + n, n7);
                gC.setForeground(color4);
                gC.drawLine(++n6, ++n7, n6 + n, n7);
            }
            gC.setForeground(color2);
            gC.drawRectangle(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
        }
        finally {
            gC.dispose();
        }
        imageCache.put(imageKey, new ImageValue(image));
        return image;
    }

    private StatusLineCLabelContribution createLabel(IStatusLineManager iStatusLineManager, Delta delta) {
        final Image image = this.createImage(delta);
        String string = this.actionBars.getClass().getSimpleName();
        StatusLineCLabelContribution statusLineCLabelContribution = new StatusLineCLabelContribution(String.valueOf(string) + delta.toString(), true, this.widthInChars()){

            public void dispose() {
                try {
                    super.dispose();
                }
                finally {
                    SummaryStatusLineGroup.this.disposeImage(image);
                }
            }
        };
        statusLineCLabelContribution.setText("0");
        statusLineCLabelContribution.setImage(image);
        iStatusLineManager.add((IContributionItem)statusLineCLabelContribution);
        return statusLineCLabelContribution;
    }

    protected StatusLineCLabelContribution deletedItem() {
        return this.ciDeleted;
    }

    public void dispose() {
        try {
            this.removeSummaryPanels(true);
            if (this.ciAdded != null) {
                this.ciAdded.dispose();
            }
            if (this.ciDeleted != null) {
                this.ciDeleted.dispose();
            }
            if (this.ciChanged != null) {
                this.ciChanged.dispose();
            }
            if (this.ciConflict != null) {
                this.ciConflict.dispose();
            }
            this.color.removeListener(this.onProp);
            this.color.dispose();
            this.delta2id.clear();
            this.actionBars = null;
        }
        finally {
            super.dispose();
        }
    }

    private void disposeImage(Image image) {
        Iterator<Map.Entry<ImageKey, ImageValue>> iterator = imageCache.entrySet().iterator();
        while (iterator.hasNext()) {
            ImageValue imageValue = iterator.next().getValue();
            if (!ObjectUtil.areEqual((Object)imageValue.image, (Object)image) || imageValue.release() != null) continue;
            iterator.remove();
            break;
        }
    }

    protected IContributionItem findItem(Delta delta) {
        IStatusLineManager iStatusLineManager = this.actionBars.getStatusLineManager();
        return iStatusLineManager.find(this.delta2id.get(delta));
    }

    protected StatusLineCLabelContribution getItem(Delta delta, boolean bl) {
        StatusLineCLabelContribution statusLineCLabelContribution;
        boolean bl2 = bl ? this.actionBars instanceof ViewActionBars : false;
        IStatusLineManager iStatusLineManager = this.actionBars.getStatusLineManager();
        if (bl2) {
            statusLineCLabelContribution = this.createLabel(iStatusLineManager, delta);
        } else {
            statusLineCLabelContribution = (StatusLineCLabelContribution)iStatusLineManager.find(this.delta2id.get(delta));
            if (statusLineCLabelContribution == null) {
                statusLineCLabelContribution = this.createLabel(iStatusLineManager, delta);
            }
        }
        assert (statusLineCLabelContribution != null);
        return statusLineCLabelContribution;
    }

    private void removeSummaryPanels(boolean bl) {
        IStatusLineManager iStatusLineManager = this.actionBars.getStatusLineManager();
        iStatusLineManager.remove((IContributionItem)this.ciDeleted);
        iStatusLineManager.remove((IContributionItem)this.ciAdded);
        iStatusLineManager.remove((IContributionItem)this.ciChanged);
        iStatusLineManager.remove((IContributionItem)this.ciConflict);
        iStatusLineManager.update(true);
    }

    private void setActionHandlers(IAction iAction) {
        this.ciAdded.setActionHandler(iAction);
        this.ciDeleted.setActionHandler(iAction);
        this.ciConflict.setActionHandler(iAction);
        this.ciChanged.setActionHandler(iAction);
    }

    protected void setItemWidth(IContributionItem iContributionItem, int n) {
        ((StatusLineCLabelContribution)iContributionItem).setWidthInChars(this.widthInChars());
    }

    protected void showStatusLineText(IStatusLineManager iStatusLineManager) {
        iStatusLineManager.setMessage("");
    }

    public String toString() {
        String string = this.actionBars.getClass().getSimpleName();
        return String.valueOf(string) + " (" + this.actionBars.hashCode() + " )" + " DELETED: " + this.ciDeleted.isVisible() + ", ADDED: " + this.ciAdded.isVisible() + ", CHANGED: " + this.ciChanged.isVisible() + ", CONFLICTS: " + this.ciConflict.isVisible();
    }

    private void updateColors() {
        StatusLineCLabelContribution[] statusLineCLabelContributionArray = new StatusLineCLabelContribution[]{this.ciChanged, this.ciAdded, this.ciDeleted, this.ciConflict};
        Delta[] deltaArray = new Delta[]{new Delta(Delta.Kind.CHANGED), new Delta(Delta.Kind.ADDED), new Delta(Delta.Kind.DELETED), new Delta(Relation.ONE_TWO, Delta.Kind.CHANGED)};
        int n = 0;
        while (n < statusLineCLabelContributionArray.length) {
            StatusLineCLabelContribution statusLineCLabelContribution = statusLineCLabelContributionArray[n];
            Image image = statusLineCLabelContribution.getImage();
            statusLineCLabelContribution.setImage(this.createImage(deltaArray[n]));
            this.disposeImage(image);
            ++n;
        }
    }

    protected void updatePanelTooltips(IDiffSummaryProvider iDiffSummaryProvider, String string, String string2, String string3, String string4) {
        String string5 = String.valueOf(1);
        String string6 = string.equals(string5) ? UIMsg.SummaryPanel_deletion : UIMsg.SummaryPanel_deletions;
        this.ciDeleted.setTooltip(NLS.bind((String)string6, (Object)string));
        string6 = string2.equals(string5) ? UIMsg.SummaryPanel_addition : UIMsg.SummaryPanel_additions;
        this.ciAdded.setTooltip(NLS.bind((String)string6, (Object)string2));
        string6 = string3.equals(string5) ? UIMsg.SummaryPanel_diff : UIMsg.SummaryPanel_diffs;
        this.ciChanged.setTooltip(NLS.bind((String)string6, (Object)string3));
        string6 = string4.equals(string5) ? UIMsg.SummaryPanel_conflict : UIMsg.SummaryPanel_conflicts;
        this.ciConflict.setTooltip(NLS.bind((String)string6, (Object)string4));
    }

    public void updateSummary(IDiffSummaryProvider iDiffSummaryProvider, IAction iAction, boolean bl) {
        String string;
        String string2;
        String string3;
        String string4;
        List<IDiffSummaryItem> list;
        IDiffSummary iDiffSummary = iDiffSummaryProvider.summary();
        this.setActionHandlers(iAction);
        List<IDiffSummaryItem> list2 = list = iDiffSummary != null ? iDiffSummary.getItems() : null;
        if (list != null && !list.isEmpty()) {
            IDiffSummaryItem iDiffSummaryItem = list.get(0);
            string4 = iDiffSummaryItem.getValue(Msg.DeltaKind_deleted).toString();
            string3 = iDiffSummaryItem.getValue(Msg.DeltaKind_added).toString();
            string2 = iDiffSummaryItem.getValue(Msg.DeltaKind_changed).toString();
            Object object = iDiffSummaryItem.getValue(Msg.DeltaKind_conflicting);
            string = object == null ? "0" : object.toString();
        } else {
            string = "0";
            string2 = "0";
            string3 = "0";
            string4 = "0";
        }
        this.updateSummaryPanels(iDiffSummaryProvider, string4, string3, string2, string, iAction, bl);
    }

    protected void updateSummaryPanels(IDiffSummaryProvider iDiffSummaryProvider, String string, String string2, String string3, String string4, IAction iAction, boolean bl) {
        IContributionItem[] iContributionItemArray;
        IStatusLineManager iStatusLineManager = this.actionBars.getStatusLineManager();
        StatusLineCLabelContribution statusLineCLabelContribution = this.getItem(DeltaUtil.DELETED, false);
        statusLineCLabelContribution = this.getItem(DeltaUtil.ADDED, false);
        statusLineCLabelContribution.setVisible(true);
        statusLineCLabelContribution.setText(string2);
        statusLineCLabelContribution = this.getItem(DeltaUtil.CHANGED, false);
        statusLineCLabelContribution.setVisible(true);
        statusLineCLabelContribution.setText(string3);
        statusLineCLabelContribution = this.getItem(DeltaUtil.CONFLICT, false);
        if (statusLineCLabelContribution.isVisible() != bl) {
            statusLineCLabelContribution.setVisible(bl);
        }
        if (bl) {
            statusLineCLabelContribution.setText(string4);
            statusLineCLabelContribution.setWidthInChars(this.widthInChars());
        }
        int n = this.widthInChars();
        IContributionItem[] iContributionItemArray2 = iContributionItemArray = iStatusLineManager.getItems();
        int n2 = iContributionItemArray.length;
        int n3 = 0;
        while (n3 < n2) {
            IContributionItem iContributionItem = iContributionItemArray2[n3];
            for (Map.Entry<Delta, String> entry : this.delta2id.entrySet()) {
                if (!entry.getValue().equals(iContributionItem.getId())) continue;
                this.setItemWidth(iContributionItem, n);
                if (entry.getKey().equals(DeltaUtil.DELETED)) {
                    statusLineCLabelContribution = (StatusLineCLabelContribution)iContributionItem;
                    statusLineCLabelContribution.setText(string);
                }
                if (entry.getKey().equals(DeltaUtil.ADDED)) {
                    statusLineCLabelContribution = (StatusLineCLabelContribution)iContributionItem;
                    statusLineCLabelContribution.setText(string2);
                }
                if (entry.getKey().equals(DeltaUtil.CHANGED)) {
                    statusLineCLabelContribution = (StatusLineCLabelContribution)iContributionItem;
                    statusLineCLabelContribution.setText(string3);
                }
                if (!entry.getKey().equals(DeltaUtil.CONFLICT)) continue;
                statusLineCLabelContribution = (StatusLineCLabelContribution)iContributionItem;
                statusLineCLabelContribution.setText(string4);
                iContributionItem.setVisible(bl);
            }
            ++n3;
        }
        this.updatePanelTooltips(iDiffSummaryProvider, string, string2, string3, string4);
        iStatusLineManager.update(true);
        if (LOG.isDebugEnabled()) {
            LOG.debug("updateSummaryPanels():    widthInChars=" + n + "   " + this.toString());
        }
    }

    protected int widthInChars() {
        return 14;
    }

    private static class ImageKey {
        private final Color bg;
        private final DeltaColor color;
        private final Color fg;
        private final SimpleKind kind;

        public ImageKey(SimpleKind simpleKind, DeltaColor deltaColor, Color color, Color color2) {
            this.kind = simpleKind;
            this.color = deltaColor;
            this.bg = color;
            this.fg = color2;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null || !this.getClass().equals(object.getClass())) {
                return false;
            }
            ImageKey imageKey = (ImageKey)object;
            return this.kind == imageKey.kind || this.color.equals(imageKey.color) || this.bg.equals((Object)imageKey.bg) || this.fg.equals((Object)imageKey.fg);
        }

        public int hashCode() {
            return this.kind.hashCode() + (this.color.hashCode() << 8) + (this.bg.hashCode() << 16) + (this.fg.hashCode() << 24);
        }

        public static enum SimpleKind {
            ADDED,
            CHANGED,
            CONFLICT,
            DELETED;


            public static SimpleKind fromKind(Delta delta) {
                if (delta.isAdded()) {
                    return ADDED;
                }
                if (delta.isDeleted()) {
                    return DELETED;
                }
                if (delta.isChanged()) {
                    return CHANGED;
                }
                if (delta.isConflict()) {
                    return CONFLICT;
                }
                throw new IllegalArgumentException("delta");
            }
        }
    }

    private static class ImageValue {
        private Image image;
        private int retainCount;

        public ImageValue(Image image) {
            this.image = image;
            this.retainCount = 1;
        }

        public Image release() {
            --this.retainCount;
            if (this.retainCount < 1) {
                try {
                    this.image.dispose();
                }
                finally {
                    this.image = null;
                }
            }
            return this.image;
        }

        public Image retain() {
            if (this.image != null) {
                ++this.retainCount;
            }
            return this.image;
        }
    }
}

