/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui;

import com.deltawalker.ui.DiffView;
import com.deltopia.ui.swt.ProgressMonitorProxy;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

public class StatusLineProgressMonitor
implements IProgressMonitor {
    private static final Map<IWorkbenchPart, StatusLineProgressMonitor> part2monitor = new HashMap<IWorkbenchPart, StatusLineProgressMonitor>();
    private static final String STATUS_LINE = String.valueOf(StatusLineProgressMonitor.class.getName()) + ".statusLine";
    private boolean canceled;
    private boolean done;
    private boolean messageOnly;
    private final IWorkbenchPart part;
    private final StatusLineManager statusLine;
    private String taskName;
    private int totalWork;
    private int worked;

    public static IProgressMonitor createInstance(DiffView diffView) {
        return StatusLineProgressMonitor.createInstance(diffView, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IProgressMonitor createInstance(DiffView diffView, boolean bl) {
        IWorkbenchPart iWorkbenchPart = diffView.getPart();
        IWorkbenchWindow iWorkbenchWindow = iWorkbenchPart.getSite().getWorkbenchWindow();
        Shell shell = iWorkbenchWindow.getShell();
        StatusLineManager statusLineManager = (StatusLineManager)shell.getData(STATUS_LINE);
        if (statusLineManager == null) {
            statusLineManager = new StatusLineManager(iWorkbenchWindow, diffView.controller().getActionBars().getStatusLineManager());
            shell.setData(STATUS_LINE, (Object)statusLineManager);
        }
        StatusLineProgressMonitor statusLineProgressMonitor = new StatusLineProgressMonitor(iWorkbenchPart, statusLineManager, bl);
        StatusLineManager statusLineManager2 = statusLineManager;
        synchronized (statusLineManager2) {
            part2monitor.put(iWorkbenchPart, statusLineProgressMonitor);
        }
        return new ProgressMonitorProxy((Control)diffView.getControl(), (IProgressMonitor)statusLineProgressMonitor);
    }

    private StatusLineProgressMonitor(IWorkbenchPart iWorkbenchPart, StatusLineManager statusLineManager, boolean bl) {
        this.part = iWorkbenchPart;
        this.statusLine = statusLineManager;
        this.messageOnly = bl;
    }

    public void beginTask(String string, int n) {
        this.taskName = string;
        this.totalWork = n;
        this.statusLine.beginTask(this, string, n);
    }

    public void done() {
        this.done = true;
        this.statusLine.done(this);
    }

    public IWorkbenchPart getPart() {
        return this.part;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public int getTotalWork() {
        return this.totalWork;
    }

    public int getWorked() {
        return this.worked;
    }

    public void internalWorked(double d) {
    }

    public boolean isCanceled() {
        return this.canceled || this.statusLine.isCanceled(this);
    }

    public boolean isDone() {
        return this.done;
    }

    public boolean isMessageOnly() {
        return this.messageOnly;
    }

    public void setCanceled(boolean bl) {
        this.canceled = bl;
        this.statusLine.setCanceled(this, bl);
    }

    public void setTaskName(String string) {
        this.taskName = string;
        this.statusLine.setTaskName(this, string);
    }

    public void subTask(String string) {
    }

    public void worked(int n) {
        this.worked += n;
        this.statusLine.worked(this, n);
    }

    private static class StatusLineManager {
        private IWorkbenchPart activePart;
        private IProgressMonitor pm;
        private final IStatusLineManager statusLine;

        public StatusLineManager(IWorkbenchWindow iWorkbenchWindow, IStatusLineManager iStatusLineManager) {
            this.statusLine = iStatusLineManager;
            final IPartService iPartService = iWorkbenchWindow.getPartService();
            this.updateActivePart(iPartService);
            iPartService.addPartListener(new IPartListener(){

                public void partActivated(IWorkbenchPart iWorkbenchPart) {
                    StatusLineManager.this.updateActivePart(iPartService);
                }

                public void partBroughtToTop(IWorkbenchPart iWorkbenchPart) {
                    StatusLineManager.this.updateActivePart(iPartService);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void partClosed(IWorkbenchPart iWorkbenchPart) {
                    StatusLineManager.this.updateActivePart(iPartService);
                    StatusLineManager statusLineManager = StatusLineManager.this;
                    synchronized (statusLineManager) {
                        part2monitor.remove(iWorkbenchPart);
                    }
                }

                public void partDeactivated(IWorkbenchPart iWorkbenchPart) {
                    StatusLineManager.this.updateActivePart(iPartService);
                }

                public void partOpened(IWorkbenchPart iWorkbenchPart) {
                    StatusLineManager.this.updateActivePart(iPartService);
                }
            });
        }

        public synchronized void beginTask(StatusLineProgressMonitor statusLineProgressMonitor, String string, int n) {
            if (statusLineProgressMonitor.getPart() == this.getActivePart()) {
                if (statusLineProgressMonitor.isMessageOnly()) {
                    this.statusLine.setMessage(string == null ? "" : string);
                } else {
                    this.pm = this.statusLine.getProgressMonitor();
                    this.pm.beginTask(string, n);
                    this.statusLine.setCancelEnabled(true);
                }
            }
        }

        public synchronized void done(StatusLineProgressMonitor statusLineProgressMonitor) {
            IWorkbenchPart iWorkbenchPart = statusLineProgressMonitor.getPart();
            if (iWorkbenchPart == this.getActivePart() && this.pm != null) {
                this.pm.done();
                this.pm = null;
            }
            part2monitor.remove(iWorkbenchPart);
        }

        private synchronized IWorkbenchPart getActivePart() {
            return this.activePart;
        }

        private synchronized boolean isCanceled(StatusLineProgressMonitor statusLineProgressMonitor) {
            return statusLineProgressMonitor.getPart() == this.getActivePart() && this.pm != null ? this.pm.isCanceled() : false;
        }

        private synchronized void setActivePart(IWorkbenchPart iWorkbenchPart) {
            if (this.activePart != iWorkbenchPart) {
                StatusLineProgressMonitor statusLineProgressMonitor;
                IWorkbenchPart iWorkbenchPart2 = this.activePart;
                this.activePart = iWorkbenchPart;
                if (iWorkbenchPart2 != null && (statusLineProgressMonitor = (StatusLineProgressMonitor)part2monitor.get(iWorkbenchPart2)) != null && this.pm != null) {
                    statusLineProgressMonitor.setCanceled(this.pm.isCanceled());
                }
                if (this.pm != null) {
                    this.pm.done();
                    this.pm = null;
                    this.statusLine.setCancelEnabled(false);
                }
                StatusLineProgressMonitor statusLineProgressMonitor2 = statusLineProgressMonitor = iWorkbenchPart == null ? null : (StatusLineProgressMonitor)part2monitor.get(iWorkbenchPart);
                if (statusLineProgressMonitor != null && !statusLineProgressMonitor.isDone()) {
                    if (statusLineProgressMonitor.isMessageOnly()) {
                        String string = statusLineProgressMonitor.getTaskName();
                        this.statusLine.setMessage(string == null ? "" : string);
                    } else {
                        this.pm = this.statusLine.getProgressMonitor();
                        this.pm.beginTask(statusLineProgressMonitor.getTaskName(), statusLineProgressMonitor.getTotalWork());
                        this.pm.worked(statusLineProgressMonitor.getWorked());
                        this.pm.setCanceled(statusLineProgressMonitor.isCanceled());
                        this.statusLine.setCancelEnabled(true);
                    }
                }
            }
        }

        public synchronized void setCanceled(StatusLineProgressMonitor statusLineProgressMonitor, boolean bl) {
            if (statusLineProgressMonitor.getPart() == this.getActivePart() && this.pm != null) {
                this.pm.setCanceled(bl);
            }
        }

        public synchronized void setTaskName(StatusLineProgressMonitor statusLineProgressMonitor, String string) {
            if (statusLineProgressMonitor.getPart() == this.getActivePart()) {
                if (statusLineProgressMonitor.isMessageOnly()) {
                    this.statusLine.setMessage(string == null ? "" : string);
                } else if (this.pm != null) {
                    this.pm.setTaskName(string);
                }
            }
        }

        private void updateActivePart(IPartService iPartService) {
            this.setActivePart(iPartService.getActivePart());
        }

        public synchronized void worked(StatusLineProgressMonitor statusLineProgressMonitor, int n) {
            if (statusLineProgressMonitor.getPart() == this.getActivePart() && this.pm != null) {
                this.pm.worked(n);
            }
        }
    }
}

