/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui;

import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.StatusLineLayoutData;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.texteditor.IStatusField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusLineCLabelContribution
extends ContributionItem
implements IStatusField {
    private static final Logger LOG = LoggerFactory.getLogger(StatusLineCLabelContribution.class);
    private IAction action;
    private Image image;
    private CLabel label;
    private MouseListener onMouse;
    private String text = "";
    private String tooltip;
    private int widthInChars;

    public StatusLineCLabelContribution(String string, boolean bl, int n) {
        super(string);
        this.setVisible(bl);
        this.widthInChars = n;
    }

    public void fill(Composite composite) {
        if (this.image != null && this.image.isDisposed()) {
            return;
        }
        if (this.label == null || this.label.isDisposed()) {
            this.label = new CLabel(composite, 32);
        }
        this.label.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                StatusLineCLabelContribution.this.label.setImage(null);
                StatusLineCLabelContribution.this.installMouseListener(false);
            }
        });
        if (this.action != null) {
            this.installMouseListener(true);
        }
        this.setWidthInChars(this.widthInChars);
        if (LOG.isDebugEnabled()) {
            LOG.debug("widthInChars=" + this.widthInChars + "   " + this.toString());
        }
        this.label.setText(this.text);
        this.label.setImage(this.image);
        if (this.tooltip != null) {
            this.label.setToolTipText(this.tooltip);
        }
    }

    public Image getImage() {
        return this.image;
    }

    private void installMouseListener(boolean bl) {
        if (bl) {
            if (this.label != null && !this.label.isDisposed()) {
                if (this.onMouse == null) {
                    this.onMouse = new MouseAdapter(){

                        public void mouseDoubleClick(MouseEvent mouseEvent) {
                            if (StatusLineCLabelContribution.this.action != null && StatusLineCLabelContribution.this.action.isEnabled()) {
                                StatusLineCLabelContribution.this.action.run();
                            }
                        }
                    };
                }
                this.label.addMouseListener(this.onMouse);
            }
        } else if (this.onMouse != null && this.label != null && !this.label.isDisposed()) {
            this.label.removeMouseListener(this.onMouse);
            this.onMouse = null;
        }
    }

    public void setActionHandler(IAction iAction) {
        if (this.action != iAction) {
            if (this.action != null) {
                this.installMouseListener(false);
            }
            this.action = iAction;
            if (iAction != null) {
                this.installMouseListener(true);
            }
        }
    }

    public void setImage(Image image) {
        if (image == null) {
            throw new NullPointerException("image");
        }
        this.image = image;
        if (this.label != null && !this.label.isDisposed()) {
            this.label.setImage(this.image);
        }
        if (!this.isVisible()) {
            this.setVisible(true);
            IContributionManager iContributionManager = this.getParent();
            if (iContributionManager != null) {
                iContributionManager.update(true);
            }
        }
    }

    public void setText(String string) {
        if (string == null) {
            throw new NullPointerException("text");
        }
        if (string.equals("?")) {
            string = "";
        }
        this.text = string;
        if (this.label != null && !this.label.isDisposed()) {
            this.label.setText(this.text);
        }
        Boolean bl = null;
        if (this.text.isEmpty()) {
            if (this.isVisible()) {
                bl = false;
            }
        } else if (!this.isVisible()) {
            bl = true;
        }
        if (bl != null) {
            this.setVisible(bl);
            IContributionManager iContributionManager = this.getParent();
            if (iContributionManager != null) {
                this.getParent().update(true);
            }
        }
    }

    public void setTooltip(String string) {
        if (string == null) {
            throw new NullPointerException("tooltip");
        }
        this.tooltip = string;
        if (this.label != null && !this.label.isDisposed()) {
            this.label.setToolTipText(this.tooltip);
        }
    }

    public void setWidthInChars(int n) {
        if (this.label != null && !this.label.isDisposed()) {
            this.widthInChars = n;
            StatusLineLayoutData statusLineLayoutData = new StatusLineLayoutData();
            GC gC = new GC((Drawable)this.label);
            gC.setFont(this.label.getParent().getFont());
            FontMetrics fontMetrics = gC.getFontMetrics();
            int n2 = fontMetrics.getAverageCharWidth() * n;
            gC.dispose();
            statusLineLayoutData.widthHint = n2;
            this.label.setLayoutData((Object)statusLineLayoutData);
            this.label.getParent().layout();
        }
    }

    public String toString() {
        return this.getId();
    }
}

