/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui;

import com.deltawalker.internal.DeltaWalkerPlugin;
import com.deltawalker.ui.DiffView;
import com.deltopia.ui.Direction;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class Sash
extends Canvas
implements MouseListener,
MouseMoveListener {
    private static final String _PREFIX = Sash.class.getName();
    public static final double DEF_SPLIT_RATIO_2_WAY = 0.5;
    public static final double DEF_SPLIT_RATIO_3_WAY = 0.333;
    public static final String H_SPLIT_RATIO = String.valueOf(_PREFIX) + ".hSplitRatio";
    public static final int MIN_WIDTH = 5;
    public static final int V_CENTER_WIDTH = 50;
    public static final String V_SPLIT_RATIO = String.valueOf(_PREFIX) + ".vSplitRatio";
    private final Sash buddy;
    private final EnumSet<Direction> direction;
    private final DiffView dView;
    private final boolean first;
    private int height1;
    private int height2;
    private boolean mouseDown;
    private int oldX;
    private int oldY;
    private Map<Direction, Double> ratios = new EnumMap<Direction, Double>(Direction.class);
    private int width1;
    private int width2;

    public Sash(Composite composite, int n, DiffView diffView, EnumSet<Direction> enumSet, boolean bl, Sash sash) {
        super(composite, n | 0x80000);
        if ((n & 0x20000000) == 0x20000000) {
            this.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent paintEvent) {
                    Sash.this.paint(paintEvent);
                }
            });
            this.setBackground(this.getDisplay().getSystemColor(25));
        }
        this.dView = diffView;
        this.direction = enumSet.clone();
        this.first = bl;
        this.buddy = sash;
        this.addMouseListener(this);
        this.addMouseMoveListener(this);
    }

    public void clearSplitRatios() {
        this.ratios.clear();
    }

    private double defaultSplitRatio() {
        boolean bl;
        boolean bl2 = this.dView.isOrientation(768);
        boolean bl3 = bl = bl2 || !this.dView.isThreeWay();
        if (bl) {
            return 0.5;
        }
        return this.first ? 0.333 : 0.667;
    }

    public double getSplitRatio(Direction direction) {
        return this.ratios.get(direction);
    }

    public boolean isMoving() {
        return this.mouseDown;
    }

    public void mouseDoubleClick(MouseEvent mouseEvent) {
        if (this.direction.contains(Direction.HORIZONTAL)) {
            double d = this.defaultSplitRatio();
            if (d < 0.01) {
                d = this.dView.isThreeWay() ? 0.333 : 0.5;
            }
            this.setSplitRatio(Direction.HORIZONTAL, d);
        }
        if (this.direction.contains(Direction.VERTICAL)) {
            this.setSplitRatio(Direction.HORIZONTAL, this.defaultSplitRatio());
        }
        this.dView.rootComposite().layout(true);
    }

    public void mouseDown(MouseEvent mouseEvent) {
        this.oldX = mouseEvent.x;
        this.oldY = mouseEvent.y;
        Composite composite = this.getParent();
        Point point = composite.toDisplay(this.getLocation());
        Point point2 = composite.getParent().toDisplay(composite.getLocation());
        this.width1 = point.x - point2.x;
        this.width2 = composite.getSize().x - this.getSize().x - this.width1;
        this.height1 = point.y - point2.y;
        this.height2 = composite.getSize().y - this.getSize().y - this.height1;
        this.mouseDown = true;
    }

    public void mouseMove(MouseEvent mouseEvent) {
        this.setCursor();
        if (this.mouseDown) {
            this.resize(mouseEvent);
        }
    }

    public void mouseUp(MouseEvent mouseEvent) {
        this.mouseDown = false;
    }

    protected void paint(PaintEvent paintEvent) {
        GC gC = paintEvent.gc;
        gC.setForeground(gC.getDevice().getSystemColor(15));
        gC.drawLine(paintEvent.x, paintEvent.y, paintEvent.x, paintEvent.y + paintEvent.height);
        gC.drawLine(paintEvent.x + paintEvent.width - 1, paintEvent.y, paintEvent.x + paintEvent.width - 1, paintEvent.y + paintEvent.height);
    }

    private void resize(MouseEvent mouseEvent) {
        int n = mouseEvent.x - this.oldX;
        int n2 = mouseEvent.y - this.oldY;
        boolean bl = false;
        if (this.width1 + n > 1 && this.width2 - n > 1) {
            this.width1 += n;
            this.width2 -= n;
            if (this.direction.contains(Direction.HORIZONTAL)) {
                this.setSplitRatio(Direction.HORIZONTAL, (double)this.width1 / (double)(this.width1 + this.width2));
                bl = true;
            }
        }
        if (this.height1 + n2 > 1 && this.height2 - n2 > 1) {
            this.height1 += n2;
            this.height2 -= n2;
            if (this.direction.contains(Direction.VERTICAL)) {
                this.setSplitRatio(Direction.VERTICAL, (double)this.height1 / (double)(this.height1 + this.height2));
                bl = true;
            }
        }
        if (bl) {
            this.dView.rootComposite().layout(true);
            this.getDisplay().update();
        }
    }

    private void setCursor() {
        int n = this.dView.getOrientation();
        if (n == 256) {
            n = 512;
        } else if (n == 512) {
            n = 256;
        }
        int n2 = 0;
        switch (n) {
            case 512: {
                n2 = 7;
                break;
            }
            case 256: {
                n2 = 9;
                break;
            }
            case 768: {
                break;
            }
            default: {
                throw new IllegalArgumentException("orientation");
            }
        }
        this.setCursor(DeltaWalkerPlugin.getDefault().getCursorRegistry().getCursor(n2));
    }

    public void setSplitRatio(Direction direction, double d) {
        this.ratios.put(direction, d);
        if (this.buddy != null) {
            this.buddy.setSplitRatio(direction, d);
        }
    }

    public int width() {
        return 50;
    }
}

