/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui;

import com.deltawalker.script.Role;
import com.deltawalker.ui.ControlUtil;
import com.deltawalker.ui.DropDownMenuAction;
import com.deltawalker.ui.IMenuComboCallback;
import com.deltawalker.ui.MenuButton;
import com.deltawalker.ui.UIMsg;
import com.deltawalker.ui.actions.ClearHistoryAction;
import com.deltopia.ui.swt.ImageCanvas;
import com.deltopia.ui.swt.StyledTextUndo;
import com.deltopia.util.Const;
import com.deltopia.util.OS;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.accessibility.AccessibleTextAdapter;
import org.eclipse.swt.accessibility.AccessibleTextEvent;
import org.eclipse.swt.accessibility.AccessibleTextListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.TypedListener;

public class MenuCombo
extends Composite {
    private static final int IMAGE_INDENT = 2;
    public MenuButton btnArrow;
    private IMenuComboCallback callback;
    private final Composite contents;
    private VerifyEvent eVerify;
    private boolean hasSelection;
    private ImageCanvas image;
    List<String> items = new ArrayList<String>();
    private int maxItemCount = 16;
    private final DropDownMenuAction menuAction = new DropDownMenuAction(){

        @Override
        protected List<IAction> getMenuActions() {
            return MenuCombo.this.getMenuActions();
        }
    };
    private Listener onText;
    private int selIx;
    private StyledText stText;
    private StyledTextUndo stTextUndo;

    public MenuCombo(Composite composite, int n) {
        super(composite, n);
        this.contents = this.createContents();
        this.initAccessible();
        this.contents.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                GC gC = paintEvent.gc;
                Rectangle rectangle = MenuCombo.this.contents.getBounds();
                boolean bl = false;
                if (OS.OSX && MenuCombo.this.isFocusControl()) {
                    gC.drawFocus(-1, -1, paintEvent.width + 2, paintEvent.height + 2);
                    bl = true;
                } else {
                    gC.setForeground(MenuCombo.this.getDisplay().getSystemColor(15));
                    gC.drawRoundRectangle(0, 0, rectangle.width - 1, rectangle.height - 1, Const.ARC.x, Const.ARC.y);
                }
                Color color = gC.getBackground();
                gC.setBackground(MenuCombo.this.stText.getBackground());
                int n = bl ? 3 : 1;
                gC.fillRoundRectangle(n, n, rectangle.width - 2 * n, rectangle.height - 2 * n, Const.ARC.x, Const.ARC.y);
                gC.setBackground(color);
            }
        });
    }

    char _findMnemonic(String string) {
        if (string == null) {
            return '\u0000';
        }
        int n = 0;
        int n2 = string.length();
        while (true) {
            if (n < n2 && string.charAt(n) != '&') {
                ++n;
                continue;
            }
            if (++n >= n2) {
                return '\u0000';
            }
            if (string.charAt(n) != '&') {
                return Character.toLowerCase(string.charAt(n));
            }
            if (++n >= n2) break;
        }
        return '\u0000';
    }

    public void add(String string) {
        int n;
        this.checkWidget();
        if (string == null) {
            SWT.error((int)4);
        }
        if ((n = this.items.size()) >= this.maxItemCount && n > 1) {
            this.items.remove(n - 1);
        }
        this.items.add(string);
    }

    public void add(String string, int n) {
        int n2;
        this.checkWidget();
        if (string == null) {
            SWT.error((int)4);
        }
        if ((n2 = this.items.size()) >= this.maxItemCount && n2 > 1) {
            this.items.remove(n2 - 1);
        }
        this.items.add(n, string);
    }

    private MenuButton addMenuButton(Composite composite, IAction iAction, Role role) {
        ++((GridLayout)composite.getLayout()).numColumns;
        return new MenuButton(composite, iAction, (Control)this.stText, role);
    }

    public MenuButton addMenuButton(IAction iAction, Role role) {
        return this.addMenuButton(this.contents, iAction, role);
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            SWT.error((int)4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)modifyListener);
        this.addListener(24, (Listener)typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error((int)4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)selectionListener);
        this.addListener(13, (Listener)typedListener);
        this.addListener(14, (Listener)typedListener);
    }

    public void addTraverseListener(TraverseListener traverseListener) {
        super.addTraverseListener(traverseListener);
        if (OS.GTK) {
            this.btnArrow.addTraverseListener(traverseListener);
        }
    }

    void arrowEvent(Event event) {
        switch (event.type) {
            case 15: {
                this.onTextFocus(15);
                break;
            }
            case 16: {
                this.onTextFocus(16);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void clearSelection() {
        this.checkWidget();
        this.stText.setSelection(0, 0);
    }

    void comboEvent(Event event) {
        switch (event.type) {
            case 12: {
                this.btnArrow.dispose();
                this.image.dispose();
                break;
            }
            case 11: {
                this.internalLayout(false);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public Point computeSize(int n, int n2, boolean bl) {
        if (this.contents != null && !this.contents.isDisposed()) {
            Point point = this.contents.computeSize(n, n2, bl);
            Rectangle rectangle = this.contents.computeTrim(0, 0, point.x, point.y);
            return new Point(rectangle.width, rectangle.height);
        }
        return super.computeSize(n, n2, bl);
    }

    private Composite createContents() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = 3;
        gridLayout.numColumns = 2;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 4;
        gridLayout.marginLeft = 5;
        gridLayout.marginRight = 3;
        Composite composite = new Composite((Composite)this, 0x40040000);
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)gridData);
        this.image = new ImageCanvas(composite, 0);
        this.image.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        int n = 4;
        int n2 = this.getStyle();
        if ((n2 & 8) != 0) {
            n |= 8;
        }
        if ((n2 & 0x800000) != 0) {
            n |= 0x800000;
        }
        this.stText = new StyledText(composite, n);
        this.stText.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.stTextUndo = new StyledTextUndo(this.stText);
        this.btnArrow = this.addMenuButton(composite, (IAction)this.menuAction, null);
        composite.setBackground(this.stText.getBackground());
        this.installListeners();
        composite.setTabList(new Control[]{this.stText});
        return composite;
    }

    private Menu createContextMenu(final StyledText styledText) {
        final Menu menu = new Menu((Control)styledText);
        MenuItem menuItem = new MenuItem(menu, 8);
        final String string = UIMsg.constructedKeyBundle().getString("ActionUndo.label");
        menuItem.setText(string);
        menuItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                MenuCombo.this.stTextUndo.undo();
            }
        });
        MenuItem menuItem2 = new MenuItem(menu, 8);
        final String string2 = UIMsg.constructedKeyBundle().getString("ActionRedo.label");
        menuItem2.setText(string2);
        menuItem2.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                MenuCombo.this.stTextUndo.redo();
            }
        });
        new MenuItem(menu, 2);
        MenuItem menuItem3 = new MenuItem(menu, 8);
        menuItem3.setText(UIMsg.constructedKeyBundle().getString("ActionCut.label"));
        styledText.setKeyBinding(SWT.MOD1 | 0x58, 131199);
        menuItem3.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                styledText.cut();
            }
        });
        MenuItem menuItem4 = new MenuItem(menu, 8);
        menuItem4.setText(UIMsg.constructedKeyBundle().getString("ActionCopy.label"));
        styledText.setKeyBinding(SWT.MOD1 | 0x43, 17039369);
        menuItem4.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                styledText.copy();
            }
        });
        MenuItem menuItem5 = new MenuItem(menu, 8);
        menuItem5.setText(UIMsg.constructedKeyBundle().getString("ActionPaste.label"));
        styledText.setKeyBinding(SWT.MOD1 | 0x56, 16908297);
        menuItem5.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                styledText.paste();
            }
        });
        new MenuItem(menu, 2);
        MenuItem menuItem6 = new MenuItem(menu, 8);
        menuItem6.setText(UIMsg.constructedKeyBundle().getString("ActionSelectAll.label"));
        styledText.setKeyBinding(SWT.MOD1 | 0x41, 262209);
        menuItem6.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                styledText.selectAll();
            }
        });
        menu.addListener(22, new Listener(){

            public void handleEvent(Event event) {
                MenuItem[] menuItemArray;
                MenuItem[] menuItemArray2 = menuItemArray = menu.getItems();
                int n = menuItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MenuItem menuItem = menuItemArray2[n2];
                    String string3 = menuItem.getText();
                    if (string3.equals(string)) {
                        menuItem.setEnabled(MenuCombo.this.stTextUndo.hasUndo());
                    }
                    if (string3.equals(string2)) {
                        menuItem.setEnabled(MenuCombo.this.stTextUndo.hasRedo());
                    }
                    ++n2;
                }
            }
        });
        return menu;
    }

    private IAction createMenuAction(final String string) {
        Action action = new Action(){

            public String getText() {
                return string;
            }

            public void run() {
            }

            public void runWithEvent(Event event) {
                String string2 = this.getText();
                if (string2.equals(UIMsg.MenuCombo_clearHistory)) {
                    ClearHistoryAction.clear(null);
                } else {
                    string2 = string2.substring(string2.indexOf(" "), string2.length());
                    string2 = string2.trim();
                    MenuCombo.this.stText.setText(string2.trim());
                    List<String> list = MenuCombo.this.getItems();
                    MenuCombo.this.selIx = list.indexOf(string2);
                    MenuCombo.this.stText.selectAll();
                    Event event2 = new Event();
                    event2.time = event.time;
                    event2.stateMask = event.stateMask;
                    event2.doit = event.doit;
                    MenuCombo.this.notifyListeners(13, event2);
                }
                MenuCombo.this.stText.setFocus();
            }
        };
        return action;
    }

    public void dispose() {
    }

    Label getAssociatedLabel() {
        Control[] controlArray = this.getParent().getChildren();
        int n = 0;
        while (n < controlArray.length) {
            if (controlArray[n] == this && n > 0 && controlArray[n - 1] instanceof Label) {
                return (Label)controlArray[n - 1];
            }
            ++n;
        }
        return null;
    }

    public Color getBackground() {
        Color color;
        if (this.stText != null && (color = this.stText.getBackground()) != null) {
            return color;
        }
        return super.getBackground();
    }

    public Control[] getChildren() {
        this.checkWidget();
        return new Control[0];
    }

    public boolean getEditable() {
        this.checkWidget();
        return this.stText.getEditable();
    }

    public Image getImage() throws SWTException {
        this.checkWidget();
        return this.image.getImage();
    }

    public String getItem(int n) {
        this.checkWidget();
        return this.getItems().get(n);
    }

    public int getItemCount() {
        this.checkWidget();
        return this.getItems().size();
    }

    public List<String> getItems() {
        this.checkWidget();
        return Collections.unmodifiableList(this.items);
    }

    private List<IAction> getMenuActions() {
        int n;
        List<String> list = this.getItems();
        ArrayList<IAction> arrayList = new ArrayList<IAction>(list.size());
        int n2 = n = list.size() <= this.maxItemCount ? list.size() : this.maxItemCount;
        if (n > 0) {
            String string = UIMsg.MenuCombo_menuItem;
            int n3 = 0;
            while (n3 < n) {
                arrayList.add(this.createMenuAction(NLS.bind((String)string, (Object)(n3 + 1), (Object)list.get(n3))));
                ++n3;
            }
            arrayList.add(null);
            arrayList.add(this.createMenuAction(UIMsg.MenuCombo_clearHistory));
        } else {
            arrayList.add(this.createMenuAction(UIMsg.MenuCombo_historyEmpty));
        }
        return arrayList;
    }

    public Point getSelection() {
        this.checkWidget();
        return this.stText.getSelection();
    }

    public int getSelectionIndex() {
        this.checkWidget();
        return this.selIx;
    }

    public int getStyle() {
        int n = super.getStyle();
        n &= 0xFFFFFFF7;
        if (this.stText != null && !this.stText.getEditable()) {
            n |= 8;
        }
        return n;
    }

    public String getText() {
        this.checkWidget();
        return this.stText.getText();
    }

    public StyledText getTextControl() {
        this.checkWidget();
        return this.stText;
    }

    public int getTextHeight() {
        this.checkWidget();
        return this.stText.getLineHeight();
    }

    public int getTextLimit() {
        this.checkWidget();
        return this.stText.getTextLimit();
    }

    private void imageEvent(Event event) {
        switch (event.type) {
            case 35: {
                this.stText.notifyListeners(35, null);
                this.image.setMenu(this.stText.getMenu());
                break;
            }
            case 3: {
                this.setFocus();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public int indexOf(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error((int)4);
        }
        return this.getItems().indexOf(string);
    }

    void initAccessible() {
        AccessibleAdapter accessibleAdapter = new AccessibleAdapter(){

            public void getHelp(AccessibleEvent accessibleEvent) {
                accessibleEvent.result = MenuCombo.this.getToolTipText();
            }

            public void getKeyboardShortcut(AccessibleEvent accessibleEvent) {
                char c;
                String string;
                String string2 = null;
                Label label = MenuCombo.this.getAssociatedLabel();
                if (label != null && (string = label.getText()) != null && (c = MenuCombo.this._findMnemonic(string)) != '\u0000') {
                    string2 = "Alt+" + c;
                }
                accessibleEvent.result = string2;
            }

            public void getName(AccessibleEvent accessibleEvent) {
                String string = null;
                Label label = MenuCombo.this.getAssociatedLabel();
                if (label != null) {
                    string = MenuCombo.this.stripMnemonic(label.getText());
                }
                accessibleEvent.result = string;
            }
        };
        this.getAccessible().addAccessibleListener((AccessibleListener)accessibleAdapter);
        this.stText.getAccessible().addAccessibleListener((AccessibleListener)accessibleAdapter);
        this.btnArrow.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getHelp(AccessibleEvent accessibleEvent) {
                accessibleEvent.result = MenuCombo.this.getToolTipText();
            }

            public void getKeyboardShortcut(AccessibleEvent accessibleEvent) {
                accessibleEvent.result = "Alt+Down Arrow";
            }

            public void getName(AccessibleEvent accessibleEvent) {
                accessibleEvent.result = MenuCombo.this.btnArrow.isMenuVisible() ? SWT.getMessage((String)"SWT_Close") : SWT.getMessage((String)"SWT_Open");
            }
        });
        this.getAccessible().addAccessibleTextListener((AccessibleTextListener)new AccessibleTextAdapter(){

            public void getCaretOffset(AccessibleTextEvent accessibleTextEvent) {
                accessibleTextEvent.offset = MenuCombo.this.stText.getCaretOffset();
            }
        });
        this.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent accessibleControlEvent) {
                Point point = MenuCombo.this.toControl(accessibleControlEvent.x, accessibleControlEvent.y);
                if (MenuCombo.this.getBounds().contains(point)) {
                    accessibleControlEvent.childID = -1;
                }
            }

            public void getChildCount(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = 0;
            }

            public void getLocation(AccessibleControlEvent accessibleControlEvent) {
                Rectangle rectangle = MenuCombo.this.getBounds();
                Point point = MenuCombo.this.toDisplay(rectangle.x, rectangle.y);
                accessibleControlEvent.x = point.x;
                accessibleControlEvent.y = point.y;
                accessibleControlEvent.width = rectangle.width;
                accessibleControlEvent.height = rectangle.height;
            }

            public void getRole(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = 46;
            }

            public void getState(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = 0;
            }

            public void getValue(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.result = MenuCombo.this.getText();
            }
        });
        this.stText.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getRole(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = MenuCombo.this.stText.getEditable() ? 42 : 41;
            }
        });
        this.btnArrow.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getDefaultAction(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.result = MenuCombo.this.btnArrow.isMenuVisible() ? SWT.getMessage((String)"SWT_Close") : SWT.getMessage((String)"SWT_Open");
            }
        });
    }

    private void installListeners() {
        int[] nArray;
        int[] nArray2;
        int[] nArray3;
        this.onText = new Listener(){

            public void handleEvent(Event event) {
                if (MenuCombo.this.stText == event.widget) {
                    MenuCombo.this.textEvent(event);
                } else if (MenuCombo.this.btnArrow == event.widget) {
                    MenuCombo.this.arrowEvent(event);
                } else if (MenuCombo.this == event.widget) {
                    MenuCombo.this.comboEvent(event);
                } else if (MenuCombo.this.image == event.widget) {
                    MenuCombo.this.imageEvent(event);
                }
            }
        };
        int[] nArray4 = nArray3 = new int[]{12, 11};
        int n = nArray3.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray4[n2];
            this.addListener(n3, this.onText);
            ++n2;
        }
        int[] nArray5 = nArray2 = new int[]{15, 16, 1, 2, 35, 24, 8, 3, 31};
        int n4 = nArray2.length;
        n = 0;
        while (n < n4) {
            n2 = nArray5[n];
            this.stText.addListener(n2, this.onText);
            ++n;
        }
        this.stText.addVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent verifyEvent) {
                Event event = new Event();
                event.time = verifyEvent.time;
                event.character = verifyEvent.character;
                event.keyCode = verifyEvent.keyCode;
                event.stateMask = verifyEvent.stateMask;
                if (verifyEvent.keyCode == 127) {
                    MenuCombo.this.onTextKeyDown(event);
                    MenuCombo.this.eVerify = verifyEvent;
                    return;
                }
                MenuCombo.this.notifyListeners(1, event);
                verifyEvent.doit = event.doit;
                MenuCombo.this.eVerify = verifyEvent.doit ? null : verifyEvent;
            }
        });
        this.btnArrow.addListener(15, this.onText);
        this.btnArrow.addListener(16, this.onText);
        int[] nArray6 = nArray = new int[]{35, 3};
        int n5 = nArray.length;
        n4 = 0;
        while (n4 < n5) {
            n = nArray6[n4];
            this.image.addListener(n, this.onText);
            ++n4;
        }
    }

    void internalLayout(boolean bl) {
        this.contents.setBounds(this.getClientArea());
        this.contents.layout(bl);
    }

    public boolean isFocusControl() {
        if (this.isDisposed()) {
            return false;
        }
        return this.stText.isFocusControl() || this.btnArrow.isFocusControl();
    }

    public int lastIndexOf(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error((int)4);
        }
        return this.getItems().lastIndexOf(string);
    }

    private void onTextFocus(int n) {
        if (this.isDisposed()) {
            return;
        }
        switch (n) {
            case 15: {
                if (this.getEditable()) {
                    if (this.callback != null) {
                        this.stText.setText(this.callback.getFocusInText());
                    }
                    this.stText.selectAll();
                    boolean bl = this.hasSelection = this.stText.getSelectionText().trim().length() != 0;
                }
                if (OS.OSX) {
                    this.contents.redraw();
                }
                this.notifyListeners(15, new Event());
                break;
            }
            case 16: {
                if (this.callback != null) {
                    this.stText.setText(this.callback.getFocusOutText());
                }
                this.notifyListeners(16, new Event());
                this.stText.setSelection(0, 0);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private void onTextKeyDown(Event event) {
        if (this.eVerify != null && !this.eVerify.doit && event.character == this.eVerify.character && event.keyCode == this.eVerify.keyCode && event.stateMask == this.eVerify.stateMask) {
            event.doit = false;
            this.eVerify = null;
            return;
        }
        if (event.character == '\r') {
            Event event2 = new Event();
            event2.time = event.time;
            event2.stateMask = event.stateMask;
            this.notifyListeners(14, event2);
        }
    }

    public void redraw() {
        super.redraw();
        this.stText.redraw();
        this.btnArrow.redraw();
    }

    public void redraw(int n, int n2, int n3, int n4, boolean bl) {
        super.redraw(n, n2, n3, n4, true);
    }

    public void remove(int n) {
        this.checkWidget();
        this.items.remove(n);
    }

    public void remove(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error((int)4);
        }
        this.items.remove(string);
    }

    public void removeAll() {
        this.checkWidget();
        this.stText.setText("");
        this.items.clear();
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            SWT.error((int)4);
        }
        this.removeListener(24, (SWTEventListener)modifyListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error((int)4);
        }
        this.removeListener(13, (SWTEventListener)selectionListener);
        this.removeListener(14, (SWTEventListener)selectionListener);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.stText != null) {
            Composite composite = this.stText.getParent();
            while (composite != this) {
                composite.setBackground(color);
                composite = composite.getParent();
            }
            this.stText.setBackground(color);
        }
    }

    public void setCallback(IMenuComboCallback iMenuComboCallback) {
        this.callback = iMenuComboCallback;
    }

    public void setData(String string, Object object) {
        super.setData(string, object);
        if (this.contents != null) {
            Control[] controlArray = ControlUtil.getChildren((Control)this.contents, Control.class);
            int n = 0;
            while (n < controlArray.length) {
                controlArray[n].setData(string, object);
                ++n;
            }
        }
    }

    public void setEditable(boolean bl) {
        this.checkWidget();
        this.stText.setEditable(bl);
        this.btnArrow.setEnabled(bl);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.stText != null) {
            this.stText.setEnabled(bl);
        }
        if (this.btnArrow != null) {
            this.btnArrow.setEnabled(bl);
        }
    }

    public boolean setFocus() {
        this.checkWidget();
        return this.stText.setFocus();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.stText.setFont(font);
        this.internalLayout(true);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.stText != null) {
            this.stText.setForeground(color);
        }
    }

    public void setImage(Image image) throws IllegalArgumentException, SWTException {
        this.checkWidget();
        this.image.setImage(image);
    }

    public void setItem(int n, String string) {
        this.checkWidget();
        this.items.remove(n);
        this.items.add(n, string);
    }

    public void setItems(String[] stringArray) {
        this.checkWidget();
        int n = 0;
        while (n < stringArray.length) {
            this.items.add(stringArray[n]);
            ++n;
        }
        if (!this.stText.getEditable()) {
            this.stText.setText("");
        }
    }

    public void setMaxDropdownItemCount(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        this.maxItemCount = n;
    }

    public void setSelection(Point point) {
        this.checkWidget();
        if (point == null) {
            SWT.error((int)4);
        }
        this.stText.setSelection(point.x, point.y);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error((int)4);
        }
        this.stText.setText(string);
    }

    public void setTextLimit(int n) {
        this.checkWidget();
        this.stText.setTextLimit(n);
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        super.setToolTipText(string);
        this.btnArrow.setToolTipText(string);
        this.stText.setToolTipText(string);
    }

    private String stripMnemonic(String string) {
        int n = 0;
        int n2 = string.length();
        while (true) {
            if (n < n2 && string.charAt(n) != '&') {
                ++n;
                continue;
            }
            if (++n >= n2) {
                return string;
            }
            if (string.charAt(n) != '&') {
                return String.valueOf(string.substring(0, n - 1)) + string.substring(n, n2);
            }
            if (++n >= n2) break;
        }
        return string;
    }

    private void textEvent(Event event) {
        switch (event.type) {
            case 15: {
                this.onTextFocus(15);
                break;
            }
            case 16: {
                this.onTextFocus(16);
                break;
            }
            case 1: {
                this.onTextKeyDown(event);
                break;
            }
            case 2: {
                Event event2 = new Event();
                event2.time = event.time;
                event2.character = event.character;
                event2.keyCode = event.keyCode;
                event2.stateMask = event.stateMask;
                this.notifyListeners(2, event2);
                break;
            }
            case 35: {
                Event event3 = new Event();
                event3.time = event.time;
                this.notifyListeners(35, event3);
                if (this.getMenu() != null || this.stText.getMenu() != null) break;
                this.stText.setMenu(this.createContextMenu(this.stText));
                break;
            }
            case 24: {
                Event event4 = new Event();
                event4.time = event.time;
                this.notifyListeners(24, event4);
                break;
            }
            case 3: {
                if (event.button == 3) {
                    this.setFocus();
                }
                if (event.button != 1) {
                    return;
                }
                if (this.hasSelection) {
                    this.stText.selectAll();
                    this.hasSelection = false;
                }
                if (this.stText.getEditable()) {
                    this.notifyListeners(3, new Event());
                    return;
                }
                this.notifyListeners(3, new Event());
                break;
            }
            case 8: {
                this.stText.selectAll();
                event.doit = false;
                break;
            }
            case 31: {
                switch (event.detail) {
                    case 4: 
                    case 32: 
                    case 64: {
                        event.doit = false;
                    }
                }
                Event event5 = new Event();
                event5.time = event.time;
                event5.detail = event.detail;
                event5.doit = event.doit;
                event5.character = event.character;
                event5.keyCode = event.keyCode;
                event5.data = MenuCombo.class;
                this.notifyListeners(31, event5);
                event.doit = event5.doit;
                event.detail = event5.detail;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }
}

