/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui;

import com.deltawalker.ImageCache;
import com.deltawalker.ImageConst;
import com.deltawalker.interfaces.IRoleAccessor;
import com.deltawalker.script.Role;
import com.deltawalker.ui.IActionMB;
import com.deltopia.StringUtil;
import com.deltopia.ui.swt.ImageButton;
import com.deltopia.ui.swt.KeyUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.actions.RetargetAction;

public class MenuButton
extends Composite {
    private LocalResourceManager imageCache = new LocalResourceManager(JFaceResources.getResources());
    private ImageButton imgAction;
    private ImageButton imgArrow;
    private boolean menuVisible = false;
    private IPropertyChangeListener onAction;

    public MenuButton(Composite composite, final IAction iAction, final Control control, final Role role) {
        super(composite, 0);
        int n;
        boolean bl = iAction.getMenuCreator() != null;
        GridLayout gridLayout = new GridLayout();
        boolean bl2 = StringUtil.isEmpty((String)iAction.getText());
        boolean bl3 = !bl2 && bl;
        gridLayout.numColumns = bl3 ? 2 : 1;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 1;
        this.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(0x1000008, 0x1000000, false, false);
        gridData.widthHint = n = bl3 ? 40 : 20;
        gridData.heightHint = 16;
        this.setLayoutData(gridData);
        if (!bl2) {
            this.imgAction = new ImageButton((Composite)this, 0);
            if (iAction instanceof IActionMB) {
                IActionMB iActionMB = (IActionMB)iAction;
                this.imgAction.setDefaultImage((Image)this.imageCache.get((DeviceResourceDescriptor)iActionMB.getImageDescriptorMB()));
                this.imgAction.setDisabledImage((Image)this.imageCache.get((DeviceResourceDescriptor)iActionMB.getDisabledImageDescriptorMB()));
                this.imgAction.setDownImage((Image)this.imageCache.get((DeviceResourceDescriptor)iActionMB.getImageDescriptorMB()));
                this.imgAction.setHoverImage((Image)this.imageCache.get((DeviceResourceDescriptor)iActionMB.getHoverImageDescriptorMB()));
            }
            this.imgAction.setImage(this.imgAction.getDefaultImage());
            this.imgAction.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent mouseEvent) {
                    control.setFocus();
                    iAction.run();
                }
            });
            this.onAction = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    String string = propertyChangeEvent.getProperty();
                    if (string.equals("enabled")) {
                        IAction iAction = (IAction)propertyChangeEvent.getSource();
                        if (iAction instanceof IActionMB) {
                            IAction iAction2 = ((RetargetAction)iAction).getActionHandler();
                            if (iAction2 instanceof IRoleAccessor) {
                                if (role == ((IRoleAccessor)iAction2).role()) {
                                    MenuButton.this.imgAction.setEnabled(iAction.isEnabled());
                                }
                            } else {
                                MenuButton.this.imgAction.setEnabled(iAction.isEnabled());
                            }
                        } else {
                            MenuButton.this.imgAction.setEnabled(iAction.isEnabled());
                        }
                    }
                }
            };
            iAction.addPropertyChangeListener(this.onAction);
            this.imgAction.setEnabled(iAction.isEnabled());
            this.imgAction.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent disposeEvent) {
                    iAction.removePropertyChangeListener(MenuButton.this.onAction);
                }
            });
        }
        if (bl) {
            this.imgArrow = new ImageButton((Composite)this, 0);
            this.setArrowImages();
            this.imgArrow.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent mouseEvent) {
                    control.setFocus();
                    MenuButton.this.showMenu((Control)MenuButton.this, iAction);
                }
            });
            if (bl2) {
                control.addKeyListener((KeyListener)new KeyAdapter(){

                    public void keyPressed(KeyEvent keyEvent) {
                        if (KeyUtil.hasKey((KeyEvent)keyEvent, (int)0x1000001) || KeyUtil.hasKey((KeyEvent)keyEvent, (int)0x1000002)) {
                            keyEvent.doit = false;
                            if (KeyUtil.hasMask((KeyEvent)keyEvent, (int)SWT.MOD3)) {
                                MenuButton.this.showMenu((Control)MenuButton.this, iAction);
                            }
                        }
                    }
                });
            }
        }
    }

    public void dispose() {
        this.disposeImages();
    }

    private void disposeImages() {
        if (this.imageCache != null) {
            this.imageCache.dispose();
            this.imageCache = null;
        }
    }

    public boolean isMenuVisible() {
        return this.menuVisible;
    }

    private void setArrowImages() {
        this.imgArrow.setDefaultImage(ImageCache.getImage(ImageConst.ARROW_DROP_DOWN));
        this.imgArrow.setDisabledImage(ImageCache.getImage(ImageConst.ARROW_DROP_DOWN_DL));
        this.imgArrow.setDownImage(ImageCache.getImage(ImageConst.ARROW_DROP_DOWN_HOT));
        this.imgArrow.setHoverImage(ImageCache.getImage(ImageConst.ARROW_DROP_DOWN_HOT));
        this.imgArrow.setImage(this.imgArrow.getDefaultImage());
    }

    private void showMenu(Control control, IAction iAction) {
        Point point;
        IMenuCreator iMenuCreator;
        if (iAction instanceof RetargetAction) {
            iMenuCreator = ((RetargetAction)iAction).getActionHandler().getMenuCreator();
            point = control.toDisplay(5, control.getSize().y + 5);
        } else {
            iMenuCreator = iAction.getMenuCreator();
            point = control.getParent().toDisplay(0, control.getParent().getSize().y);
        }
        Menu menu = iMenuCreator.getMenu(control);
        menu.setLocation(point.x, point.y + 3);
        menu.addMenuListener(new MenuListener(){

            public void menuHidden(MenuEvent menuEvent) {
                MenuButton.this.menuVisible = false;
            }

            public void menuShown(MenuEvent menuEvent) {
                MenuButton.this.menuVisible = true;
            }
        });
        menu.setVisible(true);
    }
}

