/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui;

import com.deltawalker.LineEndingUtil;
import com.deltawalker.PrefKey;
import com.deltawalker.ui.UIMsg;
import com.deltopia.StringUtil;
import com.deltopia.util.ArrayUtil;
import com.deltopia.util.OS;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class LineEndingChooser
extends Composite {
    private final boolean canEditPrefs;
    private Combo combo;
    private String endingName;
    private final String[] endingNames;
    private boolean leaveAsIs;
    private final IPreferenceStore prefs;

    public LineEndingChooser(Composite composite, int n, boolean bl, boolean bl2, IPreferenceStore iPreferenceStore) {
        super(composite, n);
        this.canEditPrefs = bl;
        this.leaveAsIs = bl2;
        this.endingNames = bl2 ? (String[])ArrayUtil.join(String.class, (Object)new String[]{UIMsg.FileDlg_leaveAsIs}, (Object)LineEndingUtil.endingNames()) : LineEndingUtil.endingNames();
        this.prefs = iPreferenceStore;
        this.createControls(this);
        this.loadFromPreferences(bl2);
        this.initializeControlState();
        this.installListeners(true);
    }

    private void createControls(Composite composite) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        this.combo = new Combo(composite, this.getStyle());
        this.combo.setLayoutData((Object)new GridData(4, 4, true, true));
    }

    public String getSelectedLineEnding() {
        return this.endingName;
    }

    private void handleEvent(Event event) {
        switch (event.type) {
            case 13: {
                String string = StringUtil.replace((String)this.combo.getText(), (String)"* ", (String)"");
                this.endingName = string.equals(UIMsg.FileDlg_leaveAsIs) ? "" : string;
                this.initializeControlState();
                this.notifyListeners(event.type, event);
                break;
            }
            default: {
                throw new IllegalArgumentException("event.type");
            }
        }
    }

    private void initializeControlState() {
        int n;
        this.combo.setItems(this.endingNames);
        String string = this.endingName;
        if (StringUtil.isEmpty((String)string)) {
            String string2 = string = this.leaveAsIs ? UIMsg.FileDlg_leaveAsIs : LineEndingUtil.OS_ENDING_NAME;
        }
        if ((n = this.combo.indexOf(string)) != -1 && (OS.WIN || n != this.combo.getSelectionIndex())) {
            this.combo.setItem(n, "* " + string);
            this.combo.select(n);
        }
    }

    private void installListeners(boolean bl) {
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                LineEndingChooser.this.handleEvent(event);
            }
        };
        if (bl) {
            this.combo.addListener(13, listener);
        }
    }

    private void loadFromPreferences(boolean bl) {
        this.endingName = bl && !this.canEditPrefs ? "" : this.prefs.getString(PrefKey.T_LINE_ENDING.toString());
    }

    public void performDefaults() {
        this.endingName = this.prefs.getDefaultString(PrefKey.T_LINE_ENDING.toString());
        this.initializeControlState();
    }

    public void saveToPreferences() {
        if (this.canEditPrefs) {
            this.prefs.setValue(PrefKey.T_LINE_ENDING.toString(), this.endingName);
        }
    }

    public void setSelectedDelimiter(String string) {
        this.endingName = string;
        this.initializeControlState();
    }
}

