/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui;

import java.util.Random;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class GradientComposite
extends Composite {
    static Random rand = new Random();
    private Color[] clrFrom;
    private Color[] clrTo;
    private final Color[] colors;
    private final int DELTA = 2;
    private final int FROM = 240;
    private Image imgBg;
    final int[] percents;
    private final int TO = 220;

    public static int randInt(int n, int n2) {
        int n3 = rand.nextInt(n2 - n + 1) + n;
        return n3;
    }

    public GradientComposite(Composite composite, int n, int n2) {
        super(composite, n);
        Display display = this.getDisplay();
        this.colors = new Color[]{new Color((Device)display, 241, 241, 241), new Color((Device)display, 229, 229, 229)};
        this.percents = new int[]{100};
        this.setBackgroundMode(n2);
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                GradientComposite.this.createAndSetBackgroundImage();
            }
        });
    }

    private void createAndSetBackgroundImage() {
        Image image = this.imgBg;
        Display display = this.getDisplay();
        Rectangle rectangle = this.getClientArea();
        if (rectangle.isEmpty()) {
            return;
        }
        this.imgBg = new Image((Device)display, rectangle.width, rectangle.height);
        GC gC = new GC((Drawable)this.imgBg);
        this.paintGradient(gC, rectangle);
        this.setBackgroundImage(this.imgBg);
        if (image != null) {
            image.dispose();
        }
    }

    private void initializePseudoRandomColors() {
        Display display = this.getDisplay();
        this.clrFrom = new Color[5];
        this.clrTo = new Color[5];
        int n = 0;
        while (n < 5) {
            int n2 = GradientComposite.randInt(238, 242);
            this.clrFrom[n] = new Color((Device)display, n2, n2, n2);
            n2 = GradientComposite.randInt(218, 222);
            this.clrTo[n] = new Color((Device)display, n2, n2, n2);
            ++n;
        }
    }

    private void paintGradient(GC gC, Rectangle rectangle) {
        Color color = this.colors[0];
        Color color2 = this.colors[1];
        if (color == null) {
            color = color2;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.percents.length) {
            gC.setForeground(color);
            color = this.colors[n2 + 1];
            if (color == null) {
                color = color2;
            }
            gC.setBackground(color);
            int n3 = n2 > 0 ? this.percents[n2] - this.percents[n2 - 1] : this.percents[n2];
            int n4 = n3 * rectangle.height / 100;
            gC.fillGradientRectangle(rectangle.x, rectangle.y + n, rectangle.width, n4, true);
            n += n4;
            ++n2;
        }
        if (n < rectangle.height) {
            gC.setBackground(color2);
            gC.fillRectangle(rectangle.x, n, rectangle.width, rectangle.height - n + 1);
        }
    }

    private void paintGradientSimple(GC gC, Rectangle rectangle) {
        Color color = this.colors[0];
        Color color2 = this.colors[1];
        if (color == null) {
            color = color2;
        }
        gC.setForeground(color);
        gC.setBackground(color2);
        gC.fillGradientRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
    }
}

