/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui;

import com.deltawalker.Relation;
import com.deltawalker.UriInfo;
import com.deltawalker.internal.resources.local.LocalFileFactory;
import com.deltawalker.script.Role;
import com.deltopia.io.IFile;
import com.deltopia.ui.dnd.IFileDropTarget;
import java.io.File;
import java.io.IOException;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.util.DelegatingDropAdapter;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileDnDProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(FileDnDProcessor.class);
    final IFileDropTarget dndTarget;
    private DropTarget dropTarget;
    private DropTargetListener onDropTarget;

    public static Map<Role, UriInfo> uriInfosFromFiles(List<IFile> list) {
        EnumMap<Role, UriInfo> enumMap = new EnumMap<Role, UriInfo>(Role.class);
        int n = list.size() - 1;
        int n2 = 0;
        while (n2 < Role.count()) {
            int n3 = n - n2;
            if (n3 >= 0) {
                Role role = Relation.argToRole(n2, list.size());
                enumMap.put(role, new UriInfo(list.get(n3).getUri()));
            }
            ++n2;
        }
        return enumMap;
    }

    public FileDnDProcessor(IFileDropTarget iFileDropTarget) {
        this.dndTarget = iFileDropTarget;
        this.setupDropTarget();
    }

    private DropTarget createDropTarget() {
        if (this.dropTarget == null) {
            this.dropTarget = new DropTarget(this.dndTarget.control(), 23);
        }
        return this.dropTarget;
    }

    public DropTarget dropTarget() {
        return this.dropTarget;
    }

    public DropTargetListener dropTargetListener() {
        if (this.onDropTarget == null) {
            return new TransferDropTargetListener(){

                public void dragEnter(DropTargetEvent dropTargetEvent) {
                    this.dragOperationChanged(dropTargetEvent);
                }

                public void dragLeave(DropTargetEvent dropTargetEvent) {
                }

                public void dragOperationChanged(DropTargetEvent dropTargetEvent) {
                    dropTargetEvent.detail = !this.isEnabled(dropTargetEvent) ? 0 : 16;
                }

                public void dragOver(DropTargetEvent dropTargetEvent) {
                }

                public void drop(DropTargetEvent dropTargetEvent) {
                    FileDnDProcessor.this.dndTarget.dropped(dropTargetEvent);
                }

                public void dropAccept(DropTargetEvent dropTargetEvent) {
                }

                public Transfer getTransfer() {
                    return FileTransfer.getInstance();
                }

                public boolean isEnabled(DropTargetEvent dropTargetEvent) {
                    TransferData[] transferDataArray = dropTargetEvent.dataTypes;
                    if (transferDataArray != null) {
                        Transfer transfer = this.getTransfer();
                        TransferData[] transferDataArray2 = transferDataArray;
                        int n = transferDataArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TransferData transferData = transferDataArray2[n2];
                            if (transfer.isSupportedType(transferData)) {
                                return true;
                            }
                            ++n2;
                        }
                    }
                    return false;
                }
            };
        }
        return this.onDropTarget;
    }

    public List<IFile> getDroppedFiles(DropTargetEvent dropTargetEvent) {
        String[] stringArray = (String[])FileTransfer.getInstance().nativeToJava(dropTargetEvent.currentDataType);
        LinkedList<IFile> linkedList = new LinkedList<IFile>();
        if (stringArray == null) {
            return linkedList;
        }
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            try {
                IFile iFile = LocalFileFactory.createFile(new File(string));
                linkedList.add(iFile);
            }
            catch (IOException iOException) {
                LOG.warn("Couldn't create local file: ", (Throwable)iOException);
            }
            ++n2;
        }
        return linkedList;
    }

    private void setupDropTarget() {
        DropTargetListener dropTargetListener;
        final DropTarget dropTarget = this.createDropTarget();
        if (dropTarget != null && (dropTargetListener = this.dropTargetListener()) != null) {
            dropTarget.addDropListener(dropTargetListener);
            dropTarget.addListener(12, new Listener(){

                public void handleEvent(Event event) {
                    dropTarget.removeDropListener(dropTargetListener);
                }
            });
            if (dropTargetListener instanceof TransferDropTargetListener) {
                dropTarget.setTransfer(new Transfer[]{((TransferDropTargetListener)dropTargetListener).getTransfer()});
            } else if (dropTargetListener instanceof DelegatingDropAdapter) {
                dropTarget.setTransfer(((DelegatingDropAdapter)dropTargetListener).getTransfers());
            }
        }
    }
}

