/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui;

import com.deltawalker.PrefKey;
import com.deltawalker.ui.EncodingChooser;
import com.deltawalker.ui.LineEndingChooser;
import com.deltawalker.ui.UIMsg;
import com.deltawalker.ui.dialogs.AlertComposite;
import com.deltopia.io.TextEncoding;
import java.util.Locale;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class FileDialogExtensionComposite
extends AlertComposite {
    private Button chbOpenInBrowser;
    private EncodingChooser encodingChooser;
    private LineEndingChooser endingChooser;
    private Label labelAfter;
    private Label lblEncoding;
    private Label lblEnding;
    private final int nativeComboX;
    private IPreferenceStore prefs;
    private final int vComboSpacing;

    public FileDialogExtensionComposite(Composite composite, int n, Object object, IPreferenceStore iPreferenceStore) {
        super(composite, n);
        this.prefs = iPreferenceStore;
        if (object != null) {
            int[] nArray = (int[])object;
            this.vComboSpacing = nArray[0];
            this.nativeComboX = nArray[1];
        } else {
            this.vComboSpacing = -1;
            this.nativeComboX = -1;
        }
        this.createControls(this);
    }

    private void createControls(Composite composite) {
        assert (this.lblEncoding == null) : String.valueOf(FileDialogExtensionComposite.class.getName()) + ": are you calling initialize twice?";
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        if (this.vComboSpacing != -1) {
            gridLayout.verticalSpacing = this.vComboSpacing;
        }
        composite.setLayout((Layout)gridLayout);
        int n = this.nativeComboX - gridLayout.horizontalSpacing;
        this.createEncodingControls(composite, n);
        this.createDelimiterControls(composite, n);
        this.createOpenInBrowserControls(composite, n);
    }

    private void createDelimiterControls(Composite composite, int n) {
        GridData gridData = new GridData();
        gridData.verticalAlignment = 128;
        if (n > 0) {
            gridData.widthHint = n;
        }
        this.lblEnding = new Label(composite, 0);
        this.lblEnding.setLayoutData((Object)gridData);
        this.lblEnding.setText(UIMsg.FileDlg_lineEnding);
        this.endingChooser = new LineEndingChooser(composite, 12, false, true, this.prefs);
        this.endingChooser.setLayoutData(new GridData(4, 128, true, false));
    }

    private void createEncodingControls(Composite composite, int n) {
        GridData gridData = new GridData();
        gridData.verticalAlignment = 128;
        if (n > 0) {
            gridData.widthHint = n;
        }
        this.lblEncoding = new Label(composite, 0);
        this.lblEncoding.setLayoutData((Object)gridData);
        this.lblEncoding.setText(UIMsg.FileDlg_encoding);
        this.encodingChooser = new EncodingChooser(composite, 12, false, (this.getStyle() & 0x1000) == 4096, this.prefs);
        this.encodingChooser.setLayoutData(new GridData(16384, 128, false, false));
    }

    private void createOpenInBrowserControls(Composite composite, int n) {
        GridData gridData = new GridData();
        gridData.verticalAlignment = 128;
        if (n > 0) {
            gridData.widthHint = n;
        }
        this.labelAfter = new Label(composite, 0);
        this.labelAfter.setLayoutData((Object)gridData);
        this.labelAfter.setText(UIMsg.FileDlg_after);
        this.chbOpenInBrowser = new Button(composite, 32);
        this.chbOpenInBrowser.setText(UIMsg.FileDlg_openInBrowser);
        this.chbOpenInBrowser.setSelection(this.prefs.getBoolean(PrefKey.C_OPEN_REPORT_IN_BROWSER.toString()));
        this.chbOpenInBrowser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileDialogExtensionComposite.this.prefs.setValue(PrefKey.C_OPEN_REPORT_IN_BROWSER.toString(), FileDialogExtensionComposite.this.chbOpenInBrowser.getSelection());
            }
        });
        this.chbOpenInBrowser.setLayoutData((Object)new GridData(4, 128, true, false));
    }

    public TextEncoding getSelectedEncoding(boolean bl) {
        return this.encodingChooser.getSelectedEncoding(bl);
    }

    public String getSelectedLineEnding() {
        return this.endingChooser.getSelectedLineEnding();
    }

    public Locale getSelectedLocale() {
        return this.encodingChooser.getSelectedLocale();
    }

    public boolean isCharsetSelected() {
        return this.encodingChooser.isCharsetSelected();
    }

    public void setSelectedEncoding(TextEncoding textEncoding) {
        this.encodingChooser.setSelectedEncoding(textEncoding);
    }

    public void setSelectedLineEnding(String string) {
        this.endingChooser.setSelectedDelimiter(string);
    }

    public void setSelectedLocale(Locale locale) {
        this.encodingChooser.setSelectedLocale(locale);
    }

    public void setShowLineEnding(boolean bl) {
        boolean bl2;
        ((GridData)this.lblEnding.getLayoutData()).exclude = bl2 = !bl;
        ((GridData)this.endingChooser.getLayoutData()).exclude = bl2;
    }

    public void setShowOpenInBrowser(boolean bl) {
        boolean bl2;
        ((GridData)this.labelAfter.getLayoutData()).exclude = bl2 = !bl;
        ((GridData)this.chbOpenInBrowser.getLayoutData()).exclude = bl2;
    }
}

