/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui;

import com.deltawalker.EncodingUtil;
import com.deltawalker.LocaleUtil;
import com.deltawalker.PrefKey;
import com.deltawalker.interfaces.IPrefSerializer;
import com.deltawalker.ui.UIMsg;
import com.deltopia.StringUtil;
import com.deltopia.io.TextEncoding;
import com.deltopia.util.ArrayUtil;
import com.deltopia.util.Checker;
import com.deltopia.util.OS;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;

public class EncodingChooser
extends Composite
implements IPrefSerializer {
    private static final int COMBO_VISIBLE_ITEM_COUNT = 30;
    private static final String ITEMS = "items";
    private static final Map<String, Locale> langToLocale = new HashMap<String, Locale>();
    private static final int LIST_HEIGHT = 200;
    private final boolean autoDetect;
    private final boolean canEditPrefs;
    private String charset;
    private Control ctlCustom;
    private String dispLocale;
    private final IPreferenceStore prefs;
    private Button rdbCharset;
    private Button rdbLocale;
    private boolean useLocale;

    private static Locale getLocale(String string) {
        if (StringUtil.isEmpty((String)string)) {
            return null;
        }
        Locale locale = langToLocale.get(string);
        if (locale != null) {
            return locale;
        }
        Locale locale2 = Locale.getDefault();
        if (!string.equals(locale2.getDisplayName())) {
            Locale[] localeArray;
            locale2 = null;
            Locale[] localeArray2 = localeArray = Locale.getAvailableLocales();
            int n = localeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Locale locale3 = localeArray2[n2];
                if (string.equals(locale3.getDisplayName())) {
                    locale2 = locale3;
                    break;
                }
                ++n2;
            }
        }
        if (locale2 != null) {
            langToLocale.put(string, locale2);
        }
        return locale2;
    }

    public EncodingChooser(Composite composite, int n, boolean bl, boolean bl2, IPreferenceStore iPreferenceStore) {
        super(composite, n);
        this.canEditPrefs = bl;
        this.autoDetect = bl2;
        this.prefs = iPreferenceStore;
        this.createControls(this);
        if (!this.autoDetect) {
            this.fromPrefs();
        }
        this.initializeControls(true);
        this.installListeners(true);
    }

    private void cacheSelection() {
        if (this.ctlCustom instanceof List) {
            String string = this.getSelection();
            if (this.useLocale) {
                this.dispLocale = string;
            } else {
                this.charset = string;
            }
        }
    }

    private void createControls(Composite composite) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        Control control = this.createRadioBar(composite);
        control.setLayoutData((Object)new GridData(4, 128, true, false));
        Control control2 = this.createCustomControl(composite);
        control2.setLayoutData((Object)new GridData(4, 4, true, true));
    }

    private Control createCustomControl(Composite composite) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)gridLayout);
        if ((this.getStyle() & 4) == 4) {
            Combo combo = new Combo(composite2, this.getStyle());
            combo.setLayoutData((Object)new GridData(4, 128, true, false));
            combo.setVisibleItemCount(30);
            this.ctlCustom = combo;
        } else {
            GridData gridData = new GridData(4, 4, true, true);
            gridData.heightHint = 200;
            List list = new List(composite2, 2560);
            list.setLayoutData((Object)gridData);
            this.ctlCustom = list;
        }
        return composite2;
    }

    private Control createRadioBar(Composite composite) {
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)gridLayout);
        this.rdbCharset = new Button(composite2, 16);
        this.rdbCharset.setLayoutData((Object)new GridData(1, 128, false, false));
        this.rdbCharset.setText(UIMsg.SelectEncodingDlg_encodings);
        this.rdbLocale = new Button(composite2, 16);
        this.rdbLocale.setLayoutData((Object)new GridData(1, 128, false, false));
        this.rdbLocale.setText(UIMsg.SelectEncodingDlg_languages);
        return composite2;
    }

    @Override
    public void fromPrefs() {
        this.useLocale = this.prefs.getBoolean(PrefKey.T_USE_LOCALE.toString());
        this.charset = this.prefs.getString(PrefKey.T_ENCODING_CHARSET.toString());
        Locale locale = LocaleUtil.getLocale(this.prefs);
        if (locale == null) {
            this.useLocale = false;
            this.dispLocale = "";
        } else {
            this.dispLocale = locale.getDisplayName();
        }
    }

    private String[] getItems() {
        return this.useLocale ? LocaleUtil.getDisplayLocaleNames() : EncodingUtil.getCharsets();
    }

    public TextEncoding getSelectedEncoding(boolean bl) {
        String string = null;
        if (bl && this.useLocale) {
            string = StringUtil.isEmpty((String)this.dispLocale) ? this.dispLocale : EncodingUtil.getEncoding(EncodingChooser.getLocale(this.dispLocale));
        }
        TextEncoding textEncoding = TextEncoding.fromUiCharset((String)(string != null ? string : this.charset));
        return textEncoding;
    }

    private String getSelectedItem() {
        String string = null;
        if (this.useLocale) {
            string = this.dispLocale;
            if (StringUtil.isEmpty((String)string)) {
                string = Locale.getDefault().getDisplayName();
            }
        } else {
            if (!StringUtil.isEmpty((String)this.dispLocale)) {
                string = EncodingUtil.getEncoding(EncodingChooser.getLocale(this.dispLocale));
            }
            if (StringUtil.isEmpty((String)string)) {
                string = this.charset;
            }
        }
        return string;
    }

    public Locale getSelectedLocale() {
        return this.useLocale ? EncodingChooser.getLocale(this.dispLocale) : null;
    }

    private String getSelection() {
        String string;
        if (this.ctlCustom instanceof List) {
            string = ((List)this.ctlCustom).getSelection()[0];
        } else {
            Combo combo = (Combo)this.ctlCustom;
            string = combo.getItem(combo.getSelectionIndex());
        }
        string = StringUtil.replace((String)string, (String)"* ", (String)"");
        return this.autoDetect && string.equals(UIMsg.EncodingChooser_autoDetect) ? "" : string;
    }

    public int getSelectionIndex() {
        if (this.ctlCustom instanceof List) {
            return ((List)this.ctlCustom).getSelectionIndex();
        }
        return ((Combo)this.ctlCustom).getSelectionIndex();
    }

    private void handleCombo(Event event) {
        Combo combo = (Combo)this.ctlCustom;
        String string = StringUtil.replace((String)combo.getText(), (String)"* ", (String)"");
        if (this.autoDetect && string.equals(UIMsg.EncodingChooser_autoDetect)) {
            string = "";
        }
        if (this.useLocale) {
            this.dispLocale = string;
            this.populateEncodingControl(this.dispLocale, LocaleUtil.getDisplayLocaleNames());
        } else {
            this.charset = string;
            this.populateEncodingControl(this.charset, EncodingUtil.getCharsets());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleEvent(Event event) {
        switch (event.type) {
            case 13: 
            case 14: {
                if (event.widget == this.ctlCustom) {
                    if (this.ctlCustom instanceof List) {
                        this.handleList(event);
                    } else {
                        if (!(this.ctlCustom instanceof Combo)) throw new IllegalArgumentException();
                        this.handleCombo(event);
                    }
                } else if (event.widget == this.rdbCharset || event.widget == this.rdbLocale) {
                    this.handleRadio(event);
                }
                this.notifyListeners(event.type, event);
                return;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private void handleList(Event event) {
        List list = (List)this.ctlCustom;
        int n = list.getSelectionIndex();
        if (this.useLocale) {
            this.dispLocale = list.getItem(n);
        } else {
            this.charset = list.getItem(n);
        }
    }

    private void handleRadio(Event event) {
        this.useLocale = this.rdbLocale.getSelection();
        this.populateEncodingControl(this.getSelectedItem(), this.getItems());
    }

    public int indexOf(String string) {
        if (this.autoDetect) {
            if (StringUtil.isEmpty((String)string)) {
                string = UIMsg.EncodingChooser_autoDetect;
            } else if ("* ".equals(string)) {
                string = "* " + UIMsg.EncodingChooser_autoDetect;
            }
        }
        if (this.ctlCustom instanceof List) {
            return ((List)this.ctlCustom).indexOf(string);
        }
        return ((Combo)this.ctlCustom).indexOf(string);
    }

    private void initializeControls(boolean bl) {
        List list;
        int n;
        this.rdbCharset.setSelection(!this.useLocale);
        this.rdbLocale.setSelection(this.useLocale);
        this.rdbCharset.notifyListeners(13, null);
        this.rdbLocale.notifyListeners(13, null);
        String string = bl ? (this.useLocale ? this.dispLocale : this.charset) : this.getSelectedItem();
        this.populateEncodingControl(string, this.getItems());
        if (this.ctlCustom instanceof List && (n = (list = (List)this.ctlCustom).getSelectionIndex()) != -1) {
            list.setTopIndex(n);
        }
    }

    private void installListeners(boolean bl) {
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                EncodingChooser.this.handleEvent(event);
            }
        };
        if (bl) {
            this.ctlCustom.addListener(14, listener);
            this.ctlCustom.addListener(13, listener);
            this.rdbCharset.addListener(13, listener);
        }
    }

    public boolean isCharsetSelected() {
        return !this.useLocale;
    }

    public boolean isValidSelection(int n) {
        String string;
        if (n == -1) {
            return false;
        }
        String string2 = this.getSelection();
        if (this.autoDetect && StringUtil.isEmpty((String)string2)) {
            string2 = UIMsg.EncodingChooser_autoDetect;
        }
        return this.indexOf(string = "* " + string2) != n;
    }

    public void performDefaults() {
        this.useLocale = this.prefs.getDefaultBoolean(PrefKey.T_USE_LOCALE.toString());
        this.charset = EncodingUtil.DEFAULT_ENCODING.name();
        this.dispLocale = this.prefs.getDefaultString(PrefKey.T_ENCODING_LOCALE.toString());
        this.initializeControls(true);
    }

    private void populateEncodingControl(String string, String[] stringArray) {
        if (this.autoDetect) {
            stringArray = (String[])ArrayUtil.join(String.class, (Object)new String[]{UIMsg.EncodingChooser_autoDetect}, (Object)stringArray);
            if (StringUtil.isEmpty((String)string)) {
                string = UIMsg.EncodingChooser_autoDetect;
            }
        }
        if (this.ctlCustom instanceof Combo) {
            int n;
            Combo combo = (Combo)this.ctlCustom;
            Object object = combo.getData(ITEMS);
            if (object == null || !object.equals(stringArray)) {
                combo.setItems(stringArray);
                combo.setData(ITEMS, (Object)stringArray);
            }
            if (!combo.getText().equals(string)) {
                combo.setText(string);
            }
            if ((n = this.indexOf(string)) != -1 && (OS.WIN || n != combo.getSelectionIndex())) {
                combo.setItem(n, "* " + string);
                combo.select(n);
            }
        } else {
            List list = (List)this.ctlCustom;
            list.setItems(stringArray);
            int n = this.indexOf(string);
            if (n != -1) {
                list.setSelection(n);
                if (OS.WIN) {
                    list.setTopIndex(n);
                }
                list.setItem(n, "* " + string);
            }
        }
    }

    public void reload() {
        String string = this.useLocale ? this.dispLocale : this.charset;
        this.populateEncodingControl(string, this.useLocale ? LocaleUtil.getDisplayLocaleNames() : EncodingUtil.getCharsets());
    }

    public boolean setFocus() {
        return this.ctlCustom.setFocus();
    }

    public void setSelectedEncoding(TextEncoding textEncoding) {
        Checker.notNull((Object)textEncoding, (String)"encoding");
        this.useLocale = false;
        this.charset = textEncoding.uiCharset();
        this.dispLocale = "";
        this.initializeControls(false);
    }

    public void setSelectedLocale(Locale locale) {
        this.useLocale = true;
        if (locale != null) {
            this.dispLocale = locale.getDisplayName();
            this.charset = "";
        } else {
            this.dispLocale = "";
        }
        this.initializeControls(false);
    }

    @Override
    public void toPrefs() {
        this.cacheSelection();
        if (this.canEditPrefs) {
            this.prefs.setValue(PrefKey.T_USE_LOCALE.toString(), this.useLocale);
            this.prefs.setValue(PrefKey.T_ENCODING_CHARSET.toString(), this.charset);
            Locale locale = LocaleUtil.getLocaleFromDisplayName(this.dispLocale);
            this.prefs.setValue(PrefKey.T_ENCODING_LOCALE.toString(), locale != null ? locale.toString() : "");
        }
    }
}

