/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui;

import com.deltawalker.Relation;
import com.deltawalker.script.Role;
import com.deltawalker.ui.BirdsEye;
import com.deltawalker.ui.ContentArea;
import com.deltawalker.ui.Dashboard;
import com.deltawalker.ui.DiffView;
import com.deltawalker.ui.Margin;
import com.deltawalker.ui.Sash;
import com.deltawalker.ui.UriChooserBoss;
import com.deltopia.ui.Direction;
import com.deltopia.util.OS;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiffViewLayout
extends Layout {
    public static final int H_SPACE = 0;
    private static final Logger LOG = LoggerFactory.getLogger(DiffViewLayout.class);
    public static final int OFFSET_X = 4;
    private static final int V_SPACE = 0;
    protected final DiffView dView;

    public DiffViewLayout(DiffView diffView) {
        this.dView = diffView;
    }

    public Point computeSize(Composite composite, int n, int n2, boolean bl) {
        return new Point(100, 100);
    }

    private int getMarginAlignment(Role role) {
        boolean bl = this.dView.isThreeWay();
        int n = this.dView.getOrientation();
        if (n == 256) {
            return 147456;
        }
        if (role == Role.ONE) {
            return bl ? 16384 : 131072;
        }
        if (role == Role.REF) {
            return bl ? 0 : 16384;
        }
        return bl ? 131072 : 0;
    }

    private double getSplitRatio(Relation relation) {
        Sash sash = this.dView.verticalSash(relation);
        if (sash.isMoving()) {
            return sash.getSplitRatio(Direction.HORIZONTAL);
        }
        Sash sash2 = this.dView.verticalSashTop(relation);
        if (sash2 != null && sash2.isMoving()) {
            return sash2.getSplitRatio(Direction.HORIZONTAL);
        }
        return sash.getSplitRatio(Direction.HORIZONTAL);
    }

    private void initializeHorizontalSplitRatios(boolean bl, double d) {
        Sash sash = this.dView.horizontalSash(Relation.REF_ONE);
        sash.setSplitRatio(Direction.VERTICAL, d);
        double d2 = bl ? 0.5 : 0.333;
        sash = this.dView.horizontalSash(Relation.ONE_REF);
        sash.setSplitRatio(Direction.VERTICAL, d2);
        d2 = bl ? 0.5 : 0.6665;
        sash = this.dView.horizontalSash(Relation.REF_TWO);
        sash.setSplitRatio(Direction.VERTICAL, d2);
    }

    public void initializeSplitRatios() {
        boolean bl = this.dView.isOrientation(768);
        double d = bl ? 0.5 : 0.333;
        this.initializeVerticalSplitRatios(bl, d);
    }

    private void initializeVerticalSplitRatios(boolean bl, double d) {
        Sash sash = this.dView.verticalSashTop(Relation.ONE_REF);
        sash.setSplitRatio(Direction.HORIZONTAL, d);
        sash = this.dView.verticalSash(Relation.ONE_REF);
        sash.setSplitRatio(Direction.HORIZONTAL, d);
        d = bl ? 0.5 : 0.6665;
        sash = this.dView.verticalSashTop(Relation.REF_TWO);
        sash.setSplitRatio(Direction.HORIZONTAL, d);
        this.dView.verticalSash(Relation.REF_TWO).setSplitRatio(Direction.HORIZONTAL, d);
        d = 0.5;
        this.dView.verticalSashTop(Relation.REF_ONE).setSplitRatio(Direction.HORIZONTAL, d);
        this.dView.verticalSash(Relation.REF_ONE).setSplitRatio(Direction.HORIZONTAL, d);
    }

    public void layout(Composite composite, boolean bl) {
        int n;
        Rectangle rectangle = composite.getClientArea();
        Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (rectangle.isEmpty()) {
            return;
        }
        Dashboard dashboard = this.dView.dashboard();
        Rectangle rectangle3 = new Rectangle(0, 0, 0, 0);
        if (dashboard != null && !dashboard.isDisposed()) {
            n = dashboard.getPanel((Dashboard.Panel)Dashboard.Panel.HEADER).computeSize((int)rectangle.width, (int)-1).y;
            if (dashboard.hasPanel(Dashboard.Panel.CENTER)) {
                n += dashboard.getPanel((Dashboard.Panel)Dashboard.Panel.CENTER).computeSize((int)rectangle.width, (int)-1).y;
            }
            rectangle3 = new Rectangle(rectangle.x, rectangle.y, rectangle.width, n += this.dView.computeUriChooserHeight());
            dashboard.setBounds(rectangle3);
            dashboard.setVisible(true);
            rectangle2.y += n + 0;
            rectangle2.height -= n + 0;
        }
        if ((n = this.dView.contentArea(Role.REF).marginTop()) != 0) {
            rectangle2.y += n;
            rectangle2.height -= n;
        }
        Rectangle rectangle4 = this.dView.getControlPadding();
        rectangle2.x += rectangle4.x;
        rectangle2.y += rectangle4.y;
        rectangle2.width -= rectangle4.x + rectangle4.width;
        rectangle2.height -= rectangle4.y + rectangle4.height;
        boolean bl2 = this.dView.isThreeWay();
        switch (this.dView.getOrientation()) {
            case 256: {
                if (bl2) {
                    this.layoutHorizontal3Way(rectangle2);
                    break;
                }
                this.layoutHorizontal2Way(rectangle2);
                break;
            }
            case 768: {
                this.layoutMixed(rectangle2);
                break;
            }
            case 512: {
                if (bl2) {
                    this.layoutVertical3Way(rectangle2);
                    break;
                }
                this.layoutVertical2Way(rectangle2);
                break;
            }
            default: {
                throw new IllegalArgumentException("owner.orientation");
            }
        }
    }

    protected void layoutAll(Rectangle rectangle, Map<Role, Rectangle> map) {
        Rectangle rectangle2 = this.layoutScrollBars(rectangle, map);
        this.layoutContentAreas(map);
        this.layoutBirdsEye(rectangle, map, rectangle2);
        this.dView.layoutDashboard();
        this.dView.updateCommonScrollBar();
    }

    private void layoutBirdsEye(Rectangle rectangle, Map<Role, Rectangle> map, Rectangle rectangle2) {
        if (rectangle.isEmpty()) {
            return;
        }
        ContentArea contentArea = this.dView.contentArea(Role.ONE);
        int n = contentArea.isHScrollBarVisible() ? this.dView.scrollable((Role)Role.ONE).getHorizontalBar().getSize().y : 0;
        boolean bl = this.dView.isCommonScrollBarVisible();
        Rectangle rectangle3 = map.get((Object)Role.ONE);
        Scrollable scrollable = this.dView.commonScrollable();
        BirdsEye birdsEye = this.dView.birdsEye();
        if (birdsEye != null) {
            Rectangle rectangle4 = this.dView.getControlPadding();
            if (rectangle4 != null) {
                Rectangle rectangle5 = new Rectangle(rectangle.x + rectangle.width + rectangle4.width - BirdsEye.WIDTH, rectangle.y, BirdsEye.WIDTH, rectangle.height);
                Rectangle rectangle6 = bl ? rectangle2 : rectangle3;
                rectangle5.y = rectangle6.y + this.dView.commonScrollBarVerticalOffset();
                if (scrollable instanceof Composite) {
                    ((Composite)scrollable).layout();
                }
                int n2 = this.dView.getGotoButtonsSize().y;
                rectangle5.height = rectangle6.height - (bl ? n2 + 4 : n);
                if (OS.LINUX) {
                    rectangle5.x = Math.max(rectangle5.x, rectangle6.x + rectangle6.width);
                }
                birdsEye.setBounds(rectangle5);
                birdsEye.setVisible(true);
            } else {
                birdsEye.setVisible(false);
            }
        }
    }

    protected void layoutCenter(Control control, Rectangle rectangle) {
        control.setBounds(rectangle);
        control.setVisible(true);
    }

    protected void layoutContentArea(Role role, Rectangle rectangle) {
        Margin margin = this.dView.getMargin(role);
        ContentArea contentArea = this.dView.contentArea(role);
        if (rectangle.width <= 0 || rectangle.height <= 0) {
            if (margin != null) {
                margin.setVisible(false);
            }
            contentArea.setVisible(false);
            return;
        }
        Scrollable scrollable = this.dView.scrollable(role);
        boolean bl = false;
        int n = 0;
        int n2 = this.getMarginAlignment(role);
        if (margin != null) {
            n = 3;
            bl = (n2 == 16384 || n2 == 131072) && n > 0;
            margin.setVisible(bl);
        }
        if (bl) {
            int n3;
            int n4 = 0;
            if (scrollable != null) {
                n4 = scrollable.computeTrim((int)0, (int)0, (int)0, (int)0).height;
            }
            rectangle.width -= n;
            if (n2 == 16384) {
                n3 = rectangle.x;
                rectangle.x += n;
            } else {
                n3 = rectangle.x + rectangle.width;
            }
            margin.setBounds(n3, rectangle.y, n, rectangle.height - n4);
        }
        if (contentArea != null) {
            contentArea.setBounds(rectangle);
            if (OS.WIN) {
                contentArea.layout();
            }
            contentArea.setVisible(true);
        }
    }

    protected void layoutContentAreas(Map<Role, Rectangle> map) {
        Set<Role> set = Relation.roles(this.dView.isThreeWay());
        for (Role role : set) {
            this.layoutContentArea(role, map.get((Object)role));
        }
    }

    private void layoutHorizontal2Way(Rectangle rectangle) {
    }

    private void layoutHorizontal3Way(Rectangle rectangle) {
        this.setControlVisibility(true, true);
        if (LOG.isInfoEnabled()) {
            LOG.info("layoutHorizontal3Way() rcClient=" + rectangle);
        }
        int n = this.dView.computeUriChooserHeight();
        int n2 = rectangle.height - 2 * n - 0;
        Map<Relation, Sash> map = this.dView.horizontalSashes();
        double d = map.get((Object)Relation.ONE_REF).getSplitRatio(Direction.VERTICAL);
        double d2 = map.get((Object)Relation.REF_TWO).getSplitRatio(Direction.VERTICAL);
        int n3 = (int)Math.round((double)(n2 -= n + 0) * d);
        int n4 = (int)Math.round((double)n2 * d2) - n3;
        if (LOG.isInfoEnabled()) {
            LOG.info("hNonHeader=" + n2 + "   splitRatio10=" + d + "   splitRatio02=" + d2);
            LOG.info("hOne=" + n3 + "   hRef=" + n4);
        }
        int n5 = rectangle.y;
        UriChooserBoss uriChooserBoss = this.dView.uriChooserBoss();
        EnumMap<Role, Rectangle> enumMap = new EnumMap<Role, Rectangle>(Role.class);
        uriChooserBoss.uriChooser(Role.ONE).setBounds(rectangle.x - 4, n5, rectangle.width + 4, n);
        enumMap.put(Role.ONE, new Rectangle(rectangle.x, n5 += n + 0, rectangle.width, n3));
        map.get((Object)Relation.REF_ONE).setVisible(false);
        map.get((Object)Relation.ONE_REF).setBounds(rectangle.x, (n5 += n3 + 0) - 0, rectangle.width, 0);
        map.get((Object)Relation.ONE_REF).setVisible(true);
        uriChooserBoss.uriChooser(Role.REF).setBounds(rectangle.x - 4, n5, rectangle.width + 4, n);
        uriChooserBoss.uriChooser(Role.REF).setVisible(true);
        enumMap.put(Role.REF, new Rectangle(rectangle.x, n5 += n + 0, rectangle.width, n4));
        map.get((Object)Relation.REF_TWO).setBounds(rectangle.x, n5 += n4, rectangle.width, 0);
        map.get((Object)Relation.REF_TWO).setVisible(true);
        uriChooserBoss.uriChooser(Role.TWO).setBounds(rectangle.x - 4, n5 += 0, rectangle.width + 4, n);
        int n6 = rectangle.height - ((n5 += n + 0) - rectangle.y);
        enumMap.put(Role.TWO, new Rectangle(rectangle.x, n5, rectangle.width, n6));
        this.layoutAll(rectangle, enumMap);
    }

    private void layoutMixed(Rectangle rectangle) {
        Map<Relation, Sash> map = this.dView.horizontalSashes();
        map.get((Object)Relation.REF_TWO).setVisible(false);
        map.get((Object)Relation.REF_ONE).setVisible(false);
        int n = this.dView.computeUriChooserHeight();
        int n2 = this.dView.getSashWidth();
        Map<Relation, Sash> map2 = this.dView.verticalSashes();
        double d = map2.get((Object)Relation.REF_TWO).getSplitRatio(Direction.HORIZONTAL);
        int n3 = (int)Math.round((double)(rectangle.width - n2) * d);
        int n4 = rectangle.width - n3 - n2;
        int n5 = 0;
        int n6 = 0;
        double d2 = 1.0 - map.get((Object)Relation.ONE_REF).getSplitRatio(Direction.VERTICAL);
        n5 = (int)Math.round((double)(rectangle.height - 2 * n) * d2);
        n6 = rectangle.height - 2 * n - n5 - 0;
        int n7 = rectangle.y;
        UriChooserBoss uriChooserBoss = this.dView.uriChooserBoss();
        EnumMap<Role, Rectangle> enumMap = new EnumMap<Role, Rectangle>(Role.class);
        Map<Relation, Sash> map3 = this.dView.verticalSashTops();
        for (Map.Entry<Relation, Sash> entry : map3.entrySet()) {
            Control control = (Control)entry.getValue();
            if (entry.getKey() == Relation.REF_TWO) {
                int control2 = control.computeSize((int)-1, (int)n).x;
                int n8 = 0;
                if (control2 <= n2) {
                    control2 = n2;
                } else {
                    n8 = (control2 - n2) / 2;
                }
                uriChooserBoss.uriChooser(Role.ONE).setBounds(rectangle.x - 4, n7, n3 - n8 + 4, n);
                control.setVisible(true);
                control.setBounds(rectangle.x + n3 - n8, n7, control2, n);
                uriChooserBoss.uriChooser(Role.TWO).setBounds(rectangle.x - 4 + n3 + n2 + (control2 - n2 - n8), n7, n4 - (control2 - n2 - n8) + 4, n);
                continue;
            }
            control.setVisible(false);
        }
        n7 += n;
        int n9 = rectangle.x;
        enumMap.put(Role.ONE, new Rectangle(n9, n7 += 0, n3, n6 += 0));
        n9 += n3;
        for (Map.Entry entry : map2.entrySet()) {
            Control control = (Control)entry.getValue();
            if (control == null || control.isDisposed()) continue;
            if (entry.getKey() == Relation.REF_TWO) {
                this.layoutCenter(control, new Rectangle(n9, n7, n2, n6));
                n9 += n2;
                continue;
            }
            control.setVisible(false);
        }
        enumMap.put(Role.TWO, new Rectangle(n9, n7, n4, n6));
        map.get((Object)Relation.ONE_REF).setBounds(rectangle.x, n7 += n6, rectangle.width, 0);
        map.get((Object)Relation.ONE_REF).setVisible(true);
        uriChooserBoss.uriChooser(Role.REF).setBounds(rectangle.x - 4, n7 += 0, rectangle.width + 4, n);
        uriChooserBoss.uriChooser(Role.REF).setVisible(true);
        n7 += n;
        enumMap.put(Role.REF, new Rectangle(rectangle.x, n7 += 0, rectangle.width, n5 += 0));
        n7 += n5;
        this.layoutAll(rectangle, enumMap);
    }

    private Rectangle layoutScrollBars(Rectangle rectangle, Map<Role, Rectangle> map) {
        Rectangle rectangle2;
        int n = this.dView.getOrientation();
        ContentArea contentArea = this.dView.contentArea(Role.ONE);
        int n2 = contentArea.isHScrollBarVisible() ? this.dView.scrollable((Role)Role.ONE).getHorizontalBar().getSize().y : 0;
        boolean bl2 = this.dView.isCommonScrollBarVisible();
        Rectangle rectangle3 = map.get((Object)Role.ONE);
        Scrollable scrollable = this.dView.commonScrollable();
        if (bl2) {
            int bl = this.dView.commonScrollBarWidth();
            rectangle2 = new Rectangle(0, rectangle3.y, bl, 0);
            if (n == 768) {
                rectangle2.x = rectangle.x + rectangle.width - rectangle2.width;
                rectangle2.height = rectangle3.height;
                rectangle3.width -= rectangle2.width;
            } else if (n == 512) {
                rectangle2.x = rectangle.x + rectangle.width;
                rectangle2.height = rectangle3.height - n2;
            } else {
                rectangle2.x = rectangle.x + rectangle.width;
                rectangle2.y = rectangle.y;
                rectangle2.height = rectangle.height;
            }
            rectangle2.width = OS.GTK ? Math.max(12, rectangle2.width) : rectangle2.width;
            scrollable.setBounds(rectangle2);
        } else {
            rectangle2 = null;
        }
        scrollable.setVisible(bl2);
        boolean bl = this.dView.isThreeWay();
        boolean bl3 = !this.dView.isCommonScrollBarVisible();
        for (Role role : Relation.roles(bl)) {
            ScrollBar scrollBar = this.dView.scrollable(role).getVerticalBar();
            if (scrollBar == null) continue;
            scrollBar.setVisible(bl3);
        }
        return rectangle2;
    }

    private void layoutVertical2Way(Rectangle rectangle) {
        this.setControlVisibility(false, false);
        Map<Relation, Sash> map = this.dView.verticalSashes();
        int n = this.dView.getSashWidth();
        int n2 = rectangle.width - n;
        double d = this.getSplitRatio(Relation.REF_ONE);
        int n3 = (int)Math.round((double)n2 * d);
        int n4 = rectangle.x;
        int n5 = rectangle.y;
        int n6 = rectangle.height;
        Map<Relation, Sash> map2 = this.dView.verticalSashTops();
        UriChooserBoss uriChooserBoss = this.dView.uriChooserBoss();
        EnumMap<Role, Rectangle> enumMap = new EnumMap<Role, Rectangle>(Role.class);
        int n7 = this.dView.computeUriChooserHeight();
        int n8 = n < 10 ? 5 : 0;
        uriChooserBoss.uriChooser(Role.REF).setBounds(new Rectangle(n4, 0, n3 - n8, n7));
        enumMap.put(Role.REF, new Rectangle(n4, n5, n3, n6));
        this.layoutCenter((Control)map2.get((Object)Relation.REF_ONE), new Rectangle((n4 += n3) + 2, 0, n, n7));
        this.layoutCenter((Control)map.get((Object)Relation.REF_ONE), new Rectangle(n4, n5, n, n6));
        int n9 = rectangle.width - (n4 += n);
        int n10 = 8 - n8;
        uriChooserBoss.uriChooser(Role.ONE).setBounds(new Rectangle(n4 - n10, 0, n9 + n10, n7));
        enumMap.put(Role.ONE, new Rectangle(n4, n5, n9, n6));
        enumMap.put(Role.TWO, new Rectangle(0, 0, 0, 0));
        this.layoutAll(rectangle, enumMap);
    }

    private void layoutVertical3Way(Rectangle rectangle) {
        this.setControlVisibility(false, true);
        Map<Relation, Sash> map = this.dView.verticalSashes();
        int n = this.dView.getSashWidth();
        int n2 = rectangle.width - 2 * n;
        double d = this.getSplitRatio(Relation.ONE_REF);
        double d2 = this.getSplitRatio(Relation.REF_TWO);
        int n3 = (int)Math.round((double)n2 * d);
        int n4 = (int)Math.round((double)n2 * d2) - n3;
        int n5 = rectangle.x;
        int n6 = this.dView.computeUriChooserHeight();
        int n7 = rectangle.y;
        int n8 = rectangle.height;
        Map<Relation, Sash> map2 = this.dView.verticalSashTops();
        UriChooserBoss uriChooserBoss = this.dView.uriChooserBoss();
        EnumMap<Role, Rectangle> enumMap = new EnumMap<Role, Rectangle>(Role.class);
        uriChooserBoss.uriChooser(Role.ONE).setBounds(new Rectangle(n5, 0, n3, n6));
        enumMap.put(Role.ONE, new Rectangle(n5, n7, n3, n8));
        this.layoutCenter((Control)map2.get((Object)Relation.ONE_REF), new Rectangle(n5 += n3, 0, n, n6));
        this.layoutCenter((Control)map.get((Object)Relation.ONE_REF), new Rectangle(n5, n7, n, n8));
        uriChooserBoss.uriChooser(Role.REF).setBounds(new Rectangle((n5 += n) - 8, 0, n4 + 8, n6));
        enumMap.put(Role.REF, new Rectangle(n5, n7, n4, n8));
        map2.get((Object)Relation.REF_TWO).setBounds(n5 += n4, 0, n, n6);
        map2.get((Object)Relation.REF_TWO).setVisible(true);
        this.layoutCenter((Control)map.get((Object)Relation.REF_TWO), new Rectangle(n5, n7, n, n8));
        int n9 = rectangle.width - ((n5 += n) - rectangle.x);
        int n10 = 8;
        uriChooserBoss.uriChooser(Role.TWO).setBounds(new Rectangle(n5 - n10, 0, n9 + n10, n6));
        enumMap.put(Role.TWO, new Rectangle(n5, n7, n9, n8));
        this.layoutAll(rectangle, enumMap);
    }

    private void setControlVisibility(boolean bl, boolean bl2) {
        UriChooserBoss uriChooserBoss = this.dView.uriChooserBoss();
        uriChooserBoss.uriChooser(Role.TWO).setVisible(bl2);
        if (bl) {
            Object object22;
            Map<Relation, Sash> map = this.dView.verticalSashTops();
            for (Control control2 : map.values()) {
                control2.setVisible(false);
            }
            Map<Relation, Sash> control3 = this.dView.verticalSashes();
            for (Object object22 : control3.values()) {
                object22.setVisible(false);
            }
            object22 = this.dView.horizontalSashes();
            ((Sash)((Object)object22.get((Object)Relation.ONE_REF))).setVisible(bl2);
            ((Sash)((Object)object22.get((Object)Relation.REF_TWO))).setVisible(bl2);
        } else {
            Map<Relation, Sash> map = this.dView.horizontalSashes();
            for (Control control : map.values()) {
                control.setVisible(false);
            }
            Map<Relation, Sash> map2 = this.dView.verticalSashes();
            map2.get((Object)Relation.REF_ONE).setVisible(!bl2);
            map2.get((Object)Relation.ONE_REF).setVisible(bl2);
            map2.get((Object)Relation.REF_TWO).setVisible(bl2);
        }
    }
}

