/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui;

import com.deltawalker.App;
import com.deltawalker.Delta;
import com.deltawalker.DiffDoc;
import com.deltawalker.DiffDocAdapter;
import com.deltawalker.DocType;
import com.deltawalker.NotifyUtil;
import com.deltawalker.PrefKey;
import com.deltawalker.PrefUtil;
import com.deltawalker.Relation;
import com.deltawalker.ScriptBoss;
import com.deltawalker.interfaces.IDiffDoc;
import com.deltawalker.interfaces.IDiffDocListener;
import com.deltawalker.interfaces.IDiffModel;
import com.deltawalker.interfaces.IDiffView;
import com.deltawalker.interfaces.IDoc;
import com.deltawalker.interfaces.IElement;
import com.deltawalker.interfaces.IFilter;
import com.deltawalker.interfaces.IFilterBoss;
import com.deltawalker.interfaces.IFilters;
import com.deltawalker.internal.DeltaWalkerPlugin;
import com.deltawalker.internal.SessionPrefStore;
import com.deltawalker.internal.ui.DiffViewTraverseListener;
import com.deltawalker.internal.ui.RefreshFromStorageRunnable;
import com.deltawalker.internal.ui.WorkbenchPartAdapter;
import com.deltawalker.internal.ui.printing.dialogs.PageSetupDialog;
import com.deltawalker.resources.IResource;
import com.deltawalker.script.Role;
import com.deltawalker.text.Filters;
import com.deltawalker.ui.Alerts;
import com.deltawalker.ui.BirdsEye;
import com.deltawalker.ui.ContentArea;
import com.deltawalker.ui.Dashboard;
import com.deltawalker.ui.DeltaColor;
import com.deltawalker.ui.DiffController;
import com.deltawalker.ui.DiffModelListener;
import com.deltawalker.ui.DiffViewContentProvider;
import com.deltawalker.ui.DiffViewLayout;
import com.deltawalker.ui.FileSystemUriChooser;
import com.deltawalker.ui.FileUriChooser;
import com.deltawalker.ui.GotoDiffButton;
import com.deltawalker.ui.IAlertService;
import com.deltawalker.ui.IDeltaIterator;
import com.deltawalker.ui.IDeltaListener;
import com.deltawalker.ui.IDeltaNotifier;
import com.deltawalker.ui.IDiffSummaryProvider;
import com.deltawalker.ui.IDiffViewContentProvider;
import com.deltawalker.ui.IThrobber;
import com.deltawalker.ui.Margin;
import com.deltawalker.ui.Sash;
import com.deltawalker.ui.UIMsg;
import com.deltawalker.ui.UIUtil;
import com.deltawalker.ui.UriChooser;
import com.deltawalker.ui.UriChooserBoss;
import com.deltawalker.ui.actions.GotoDiffAction;
import com.deltawalker.ui.printing.HeaderFooterPrintOp;
import com.deltawalker.ui.printing.PrintPreviewWindow;
import com.deltopia.ClassUtil;
import com.deltopia.eclipse.util.Goto;
import com.deltopia.eclipse.util.IPropertyChangeNotifier;
import com.deltopia.interfaces.IMvcController;
import com.deltopia.interfaces.IMvcModel;
import com.deltopia.io.FileUtil;
import com.deltopia.io.StorageEvent;
import com.deltopia.jface.util.IViewHolder;
import com.deltopia.ui.Direction;
import com.deltopia.ui.swt.IFocusNotifier;
import com.deltopia.ui.swt.IVerticalScrollBarOwner;
import com.deltopia.ui.swt.KeyUtil;
import com.deltopia.util.OS;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DiffView
extends ContentViewer
implements IDiffView,
IDeltaIterator,
IDeltaNotifier,
IElement,
IFocusNotifier,
IPropertyChangeNotifier,
IVerticalScrollBarOwner {
    private static final String _PREFIX = DiffView.class.getName();
    public static final String CANCELABLE_JOB = String.valueOf(_PREFIX) + ".cancelableJob";
    public static final String INPUT = "INPUT";
    public static final int LINE_WIDTH = 1;
    private static final Logger LOG = LoggerFactory.getLogger(DiffView.class);
    private static final boolean MEASURE_PAINT = false;
    public static final String ORIENTATION = "ORIENTATION";
    private final Map<Role, ContentArea> areas = new EnumMap<Role, ContentArea>(Role.class);
    protected BirdsEye birdsEye;
    private GotoDiffButton btnNext;
    private GotoDiffButton btnPrev;
    private Dashboard cmpDashboard;
    private Composite cmpRoot;
    private final DeltaColor dColor;
    protected final DiffController dCtlr;
    private boolean disposed = false;
    private IEditorSite editorSite;
    private final Map<Relation, Sash> hSashes = new EnumMap<Relation, Sash>(Relation.class);
    protected boolean inScrolling;
    private Job job;
    private final ListenerList listeners = new ListenerList();
    private Map<Role, Margin> margins = new EnumMap<Role, Margin>(Role.class);
    private final IDiffDocListener onDeltaDoc = new DiffDocAdapter(){

        @Override
        public void threeWayChanged(boolean bl) {
            DiffView.this.threeWayChanged(bl);
        }
    };
    private DiffModelListener onDeltaModel;
    private final IPropertyChangeListener onProp = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Composite composite = DiffView.this.getControl();
            if (composite == null || composite.isDisposed()) {
                return;
            }
            App.instance().scriptBoss().fireEvent(ScriptBoss.Event.SETTING_CHANGED, propertyChangeEvent, DiffView.this.getInput());
            boolean bl = DiffView.this.propertyChange(propertyChangeEvent);
            String string = propertyChangeEvent.getProperty();
            PrefKey prefKey = PrefKey.fromString(string);
            if (!bl && prefKey != null && prefKey.isSession() && propertyChangeEvent.getSource() instanceof SessionPrefStore) {
                IPreferenceStore iPreferenceStore = DiffView.this.getInput().preferences();
                Recompare recompare = DiffView.this.shouldRecompare(iPreferenceStore, prefKey, true);
                if (recompare == Recompare.FULL) {
                    LOG.info("Full-Recompare-worthy session pref changed");
                    DiffView.this.compare();
                } else if (recompare == Recompare.PARTIAL) {
                    LOG.info("Partial-Recompare-worthy session pref changed");
                    DiffView.this.compare();
                }
            }
        }
    };
    protected TraverseListener onTraverse = new DiffViewTraverseListener(this);
    protected int orientation;
    protected Composite parent;
    private int rootStyle;
    protected ScrollBar sbCommon;
    private Scrollable scrCommon;
    protected boolean syncVScroll;
    protected UriChooserBoss uriBoss;
    private boolean useCommonSB;
    private final int viewIx;
    private final Map<Relation, Sash> vSashes = new EnumMap<Relation, Sash>(Relation.class);
    private final Map<Relation, Sash> vSashTops = new EnumMap<Relation, Sash>(Relation.class);

    protected DiffView(Composite composite, int n, int n2) {
        this.parent = composite;
        this.rootStyle = n | 0x80000;
        this.dColor = DeltaColor.forDevice((Device)this.parent.getDisplay());
        this.dColor.addListener(this.onProp);
        this.viewIx = n2;
        this.initializeControlLayout();
        this.setContentProvider(new DiffViewContentProvider());
        IPreferenceStore iPreferenceStore = PrefUtil.getGlobalPrefs();
        this.setSyncedVScroll(iPreferenceStore.getBoolean(PrefKey.C_SYNC_V_SCROLL.toString()));
        this.setUseCommonScrollBar(iPreferenceStore.getBoolean(PrefKey.C_USE_COMMON_SCROLLBAR.toString()));
        iPreferenceStore.addPropertyChangeListener(this.onProp);
        JFaceResources.getFontRegistry().addListener(this.onProp);
        this.dCtlr = this.createController();
    }

    @Override
    public void addDeltaListener(IDeltaListener iDeltaListener) {
        if (iDeltaListener == null) {
            throw new NullPointerException("listener");
        }
        this.listeners.add((Object)iDeltaListener);
    }

    public void addFocusListener(FocusListener focusListener) {
    }

    @Override
    public void addPropertyListener(IPropertyChangeListener iPropertyChangeListener) {
        this.listeners.add((Object)iPropertyChangeListener);
    }

    public Composite alertComposite() {
        return this.cmpDashboard.getPanel(Dashboard.Panel.HEADER);
    }

    public BirdsEye birdsEye() {
        return this.birdsEye;
    }

    public boolean canCopyFrom(boolean bl, Role role, Role role2) {
        return true;
    }

    public Scrollable commonScrollable() {
        return this.scrCommon;
    }

    public int commonScrollableWidth() {
        return 0;
    }

    public ScrollBar commonScrollBar() {
        return this.sbCommon;
    }

    public int commonScrollBarVerticalOffset() {
        return 0;
    }

    public int commonScrollBarWidth() {
        Rectangle rectangle = this.sbCommon.getParent().computeTrim(0, 0, 0, 0);
        return rectangle.width == 0 ? (OS.OSX ? 15 : 16) : rectangle.width;
    }

    public void compare() {
        if (this.getInput().isWorking()) {
            return;
        }
        App.instance().viewBoss().viewDoc(this, true, null, null, false, true);
    }

    public int computeUriChooserHeight() {
        return this.uriChooserBoss().uriChooser((Role)Role.REF).computeSize((int)-1, (int)-1, (boolean)true).y;
    }

    public void connect(IMvcModel iMvcModel, IMvcController iMvcController) {
        ((IDiffDoc)iMvcModel).setHasOpenView(true);
    }

    public ContentArea contentArea(Role role) {
        return this.areas.get((Object)role);
    }

    public Map<Role, ContentArea> contentAreas() {
        return this.areas;
    }

    public Composite control() {
        return this.getControl();
    }

    public DiffController controller() {
        return this.dCtlr;
    }

    protected abstract void createBirdsEye(Composite var1);

    private Scrollable createCommonScrollable(Composite composite) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginTop = this.commonScrollBarVerticalOffset();
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)gridLayout);
        if (OS.OSX) {
            composite2.setBackground(this.scrollableBackgroundColor());
            composite2.setBackgroundMode(2);
        }
        Composite composite3 = new Composite(composite2, 512);
        composite3.setLayoutData((Object)new GridData(4, 4, true, true));
        this.sbCommon = composite3.getVerticalBar();
        this.sbCommon.setIncrement(1);
        this.sbCommon.setVisible(true);
        this.sbCommon.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (!$assertionsDisabled && DiffView.this.sbCommon != event.widget) {
                    throw new AssertionError();
                }
                int n = DiffView.this.sbCommon.getSelection();
                DiffView.this.doVerticalScroll(n, n, n, null);
            }
        });
        gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginTop = 1;
        gridLayout.marginBottom = 5;
        gridLayout.marginLeft = OS.GTK ? 0 : 2;
        GridData gridData = new GridData(4, 0x1000008, true, false);
        Composite composite4 = new Composite(composite2, 0);
        composite4.setLayout((Layout)gridLayout);
        composite4.setLayoutData((Object)gridData);
        this.createGotoButtons(composite4);
        if (composite4.getChildren().length == 0) {
            gridData.exclude = true;
        }
        composite2.layout();
        return composite2;
    }

    protected abstract ContentArea createContentArea(Composite var1, Role var2);

    protected void createContentAreas(Composite composite) {
        for (Role role : Relation.roles(true)) {
            ContentArea contentArea = this.createContentArea(composite, role);
            contentArea.addTraverseListener(this.onTraverse);
            this.areas.put(role, contentArea);
        }
    }

    protected void createControl() {
        this.createRootComposite();
        this.createVerticalSashes(this.cmpRoot);
        this.createControls(this.cmpRoot);
        DiffViewLayout diffViewLayout = this.createLayout();
        this.cmpRoot.setLayout((Layout)diffViewLayout);
        diffViewLayout.initializeSplitRatios();
        this.hookControl((Control)this.cmpRoot);
    }

    protected DiffController createController() {
        return new DiffController();
    }

    protected void createControls(Composite composite) {
        this.scrCommon = this.createCommonScrollable(composite);
        this.createContentAreas(composite);
        this.createMargins(composite);
        this.createBirdsEye(composite);
    }

    protected void createDashboard(int n) {
        this.cmpDashboard = new Dashboard(this.cmpRoot, 0, n);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        this.cmpDashboard.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1, 128, true, true);
        this.cmpDashboard.setLayoutData(gridData);
        this.cmpDashboard.setPanel(Dashboard.Panel.HEADER, this.createDashboardHeader());
        Composite composite = this.createDashboardCenter();
        if (composite != null) {
            this.cmpDashboard.setPanel(Dashboard.Panel.CENTER, composite);
        }
        this.cmpDashboard.setPanel(Dashboard.Panel.FOOTER, this.createDashboardFooter());
    }

    protected Composite createDashboardCenter() {
        return null;
    }

    private Composite createDashboardFooter() {
        Composite composite = new Composite((Composite)this.cmpDashboard, 0);
        this.uriBoss = new UriChooserBoss(this);
        this.uriBoss.createUriChoosers(composite);
        return composite;
    }

    private Composite createDashboardHeader() {
        IAlertService iAlertService = this.controller().alerts().service();
        return iAlertService.createControl(this.cmpDashboard, 0);
    }

    protected DiffModelListener createDeltaModelListener() {
        return new DiffModelListener(this);
    }

    protected void createGotoButtons(Composite composite) {
        if (this.docType() != DocType.PREVIEW) {
            this.btnPrev = new GotoDiffButton(composite, Goto.PREVIOUS);
            this.btnNext = new GotoDiffButton(composite, Goto.NEXT);
        }
    }

    protected Sash createHorizontalSash(Composite composite, Relation relation, boolean bl) {
        return new Sash(composite, 0x20000000, this, EnumSet.of(Direction.VERTICAL), bl, null);
    }

    protected void createHorizontalSashes(Composite composite) {
        Relation relation = Relation.REF_ONE;
        this.hSashes.put(relation, this.createHorizontalSash(composite, relation, true));
        relation = Relation.ONE_REF;
        this.hSashes.put(relation, this.createHorizontalSash(composite, relation, true));
        relation = Relation.REF_TWO;
        this.hSashes.put(relation, this.createHorizontalSash(composite, relation, false));
    }

    protected DiffViewLayout createLayout() {
        return new DiffViewLayout(this);
    }

    protected Margin createMargin(Composite composite, Role role) {
        return null;
    }

    protected void createMargins(Composite composite) {
        for (Role role : Relation.roles(true)) {
            this.margins.put(role, this.createMargin(composite, role));
        }
    }

    private void createRootComposite() {
        this.cmpRoot = new Composite(this.parent, this.rootStyle){

            public boolean setFocus() {
                return DiffView.this.setFocus();
            }
        };
        if (OS.OSX) {
            this.cmpRoot.setBackground(this.cmpRoot.getDisplay().getSystemColor(25));
        }
        this.createDashboard(2);
    }

    public UriChooser createUriChooser(Composite composite, Role role) {
        return new FileUriChooser(composite, 0, role, this.docType() == DocType.PREVIEW, this);
    }

    protected Sash createVerticalSash(Composite composite, Relation relation, boolean bl) {
        return new Sash(composite, 0x20000000, this, EnumSet.of(Direction.HORIZONTAL), bl, null);
    }

    protected void createVerticalSashes(Composite composite) {
        Sash sash = this.createVerticalSash(composite, Relation.ONE_REF, true);
        this.vSashes.put(Relation.ONE_REF, sash);
        Composite composite2 = this.cmpDashboard.getPanel(Dashboard.Panel.FOOTER);
        this.vSashTops.put(Relation.ONE_REF, this.createVerticalSashTop(composite2, true, sash));
        sash = this.createVerticalSash(composite, Relation.REF_TWO, false);
        this.vSashes.put(Relation.REF_TWO, sash);
        this.vSashTops.put(Relation.REF_TWO, this.createVerticalSashTop(composite2, false, sash));
        sash = this.createVerticalSash(composite, Relation.REF_ONE, true);
        this.vSashes.put(Relation.REF_ONE, sash);
        this.vSashTops.put(Relation.REF_ONE, this.createVerticalSashTop(composite2, true, sash));
    }

    protected Sash createVerticalSashTop(Composite composite, boolean bl, Sash sash) {
        return new Sash(composite, 0, this, EnumSet.of(Direction.HORIZONTAL), bl, sash);
    }

    public Dashboard dashboard() {
        return this.cmpDashboard;
    }

    public DeltaColor deltaColor() {
        return this.dColor;
    }

    public IDiffModel deltaModel() {
        return this.model().diffModel(this.viewIx);
    }

    public DiffModelListener deltaModelListener() {
        return this.onDeltaModel;
    }

    public IDoc[] dirtyDocs() {
        Collection<IDoc> collection = this.getInput().dirtyDocs(0).values();
        return collection.toArray(new IDoc[collection.size()]);
    }

    public void disconnect() {
    }

    public void dispose() {
        try {
            IDiffDoc iDiffDoc = this.getInput();
            this.disposeDeltaModelListener(iDiffDoc);
            NotifyUtil.installPropertyListener(iDiffDoc, this.onProp, false);
            iDiffDoc.removeDiffDocListener(this.onDeltaDoc);
            if (iDiffDoc.preferences() != null) {
                iDiffDoc.preferences().removePropertyChangeListener(this.onProp);
            }
            this.dColor.removeListener(this.onProp);
            this.dColor.dispose();
            JFaceResources.getFontRegistry().removeListener(this.onProp);
            PrefUtil.getGlobalPrefs().removePropertyChangeListener(this.onProp);
            DiffController diffController = this.controller();
            if (diffController != null) {
                diffController.dispose();
            }
            this.disposeUI();
            if (this.btnPrev != null) {
                this.btnPrev.dispose();
            }
            if (this.btnNext != null) {
                this.btnNext.dispose();
            }
            iDiffDoc.dispose();
        }
        catch (Throwable throwable) {
            LOG.error(throwable.getLocalizedMessage());
        }
        this.disposed = true;
    }

    private void disposeDeltaModelListener(IDiffDoc iDiffDoc) {
        if (this.onDeltaModel != null && iDiffDoc != null) {
            IDiffModel iDiffModel = iDiffDoc.diffModel(this.viewIx);
            if (iDiffModel != null) {
                iDiffModel.removeModelListener(this.onDeltaModel);
            }
            this.onDeltaModel.installInputListeners(false);
        }
    }

    protected void disposeUI() {
        if (this.uriBoss != null) {
            this.uriBoss.dispose();
            this.uriBoss = null;
        }
        for (Control control : this.vSashes.values()) {
            control.dispose();
        }
        this.vSashes.clear();
        for (Control control : this.vSashTops.values()) {
            control.dispose();
        }
        this.vSashTops.clear();
        if (this.onTraverse != null) {
            for (Control control : this.areas.values()) {
                control.removeTraverseListener(this.onTraverse);
                control.dispose();
            }
        }
        this.areas.clear();
        for (Control control : this.margins.values()) {
            if (control == null) continue;
            control.dispose();
        }
        this.margins.clear();
        this.cmpDashboard.dispose();
    }

    public IDoc doc(Role role) {
        return this.getInput().doc(this.triadIndex(), role);
    }

    public DocType docType() {
        return this.getInput().docType(this.triadIndex());
    }

    public void doHorizontalScroll(Role role, int n) {
        ScrollBar scrollBar = this.scrollable(role).getHorizontalBar();
        if (scrollBar != null) {
            scrollBar.setSelection(n);
        }
    }

    protected void doVerticalScroll(int n, int n2, int n3, Control control) {
        this.redrawMargins();
        if (this.syncVScroll) {
            this.redrawCenters();
        }
        this.redrawContentAreas();
    }

    public void fireDeltasChanged() {
        NotifyUtil.fireDeltasChanged(this.listeners.getListeners());
    }

    public void fireDeltaSelectionChanged(boolean bl) {
        NotifyUtil.fireDeltaSelectionChanged(this.listeners.getListeners(), bl);
    }

    protected void fireDiffSummaryChanged() {
        this.firePropertyChange(IDiffSummaryProvider.DIFF_SUMMARY, null, null);
    }

    protected void fireInputChanged(DiffDoc diffDoc, DiffDoc diffDoc2) {
        this.firePropertyChange(INPUT, diffDoc, diffDoc2);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        NotifyUtil.firePropertyChange(this.listeners, this, string, object, object2);
    }

    public Job getCancelableJob() {
        return this.job;
    }

    public Composite getControl() {
        if (this.cmpRoot == null) {
            this.createControl();
            this.controller().installListeners();
            this.refresh();
            this.initializeDashboard();
        }
        return this.cmpRoot;
    }

    public Rectangle getControlPadding() {
        int n;
        int n2 = n = this.birdsEye() != null ? BirdsEye.WIDTH : 0;
        if (this.getOrientation() != 768 && this.isCommonScrollBarVisible()) {
            n += this.commonScrollBarWidth();
        }
        return new Rectangle(0, 0, n, 0);
    }

    public Cursor getCursor(int n) {
        return DeltaWalkerPlugin.getDefault().getCursorRegistry().getCursor(n);
    }

    public IEditorSite getEditorSite() {
        return this.editorSite;
    }

    public Role getFocusRole() {
        for (Role role : this.roles()) {
            if (this.contentArea(role).isFocusControl()) {
                return role;
            }
            if (this.uriBoss == null || !this.uriBoss.uriChooser(role).isFocusControl()) continue;
            return role;
        }
        return Relation.firstRole(this.isThreeWay());
    }

    public GotoDiffButton getGotoButton(Goto goto_) {
        return goto_ == Goto.NEXT ? this.btnNext : this.btnPrev;
    }

    public Point getGotoButtonsSize() {
        if (this.btnPrev != null) {
            Rectangle rectangle = this.btnPrev.getBounds();
            return new Point(rectangle.width, 2 * rectangle.height);
        }
        return new Point(0, 0);
    }

    @Override
    public Image getImage() {
        return null;
    }

    public Image getImage(Role role, Object object) {
        return null;
    }

    public IDiffDoc getInput() {
        return (IDiffDoc)super.getInput();
    }

    public Map<Role, IDoc> getInputs() {
        return this.getInput().triad(this.triadIndex());
    }

    public Margin getMargin(Role role) {
        return this.margins.get((Object)role);
    }

    public Map<Role, Margin> getMargins() {
        return this.margins;
    }

    @Override
    public String getName() {
        return this.getInput().docType(0).toString();
    }

    public int getOrientation() {
        boolean bl = this.docType() == DocType.PREVIEW;
        return bl ? 512 : this.orientation;
    }

    public IWorkbenchPart getPart() {
        Composite composite = this.getControl();
        while (composite != null && !composite.isDisposed()) {
            Object object = composite.getData();
            if (object instanceof IWorkbenchPart) {
                return (IWorkbenchPart)object;
            }
            composite = composite.getParent();
        }
        return null;
    }

    private IThrobber getPartThrobber() {
        WorkbenchPartAdapter workbenchPartAdapter;
        IWorkbenchPart iWorkbenchPart = this.getPart();
        IThrobber iThrobber = null;
        if (iWorkbenchPart != null && (workbenchPartAdapter = (WorkbenchPartAdapter)iWorkbenchPart.getAdapter(WorkbenchPartAdapter.class)) != null) {
            iThrobber = workbenchPartAdapter.getThrobber();
        }
        return iThrobber;
    }

    protected ScrollBar getReferenceScrollBar() {
        ScrollBar scrollBar = null;
        int n = 0;
        boolean bl = this.isOrientation(512);
        boolean bl2 = this.isThreeWay();
        for (Role role : this.roles()) {
            Role role2 = bl ? Relation.firstRole(bl2) : role;
            Scrollable scrollable = this.scrollable(role2);
            ScrollBar scrollBar2 = scrollable.getVerticalBar();
            if (scrollBar2 != null) {
                int n2 = scrollBar2.getMaximum() - scrollBar2.getMinimum();
                if (n2 < 0) {
                    n2 = 0;
                }
                if (n < n2 && n2 - scrollBar2.getThumb() > 0) {
                    n = n2;
                    scrollBar = scrollBar2;
                }
            }
            if (bl) break;
        }
        return scrollBar;
    }

    public int getSashWidth() {
        return 50;
    }

    public ISelection getSelection() {
        return null;
    }

    public IWorkbenchPartSite getSite() {
        IWorkbenchPart iWorkbenchPart = this.getPart();
        if (iWorkbenchPart instanceof IViewPart) {
            return ((IViewPart)iWorkbenchPart).getViewSite();
        }
        if (iWorkbenchPart instanceof IEditorPart) {
            return ((IEditorPart)iWorkbenchPart).getEditorSite();
        }
        return null;
    }

    public IStatusLineManager getStatusLineManager() {
        IActionBars iActionBars = this.controller().getActionBars();
        return iActionBars != null ? iActionBars.getStatusLineManager() : null;
    }

    public TraverseListener getTraverseListener() {
        return this.onTraverse;
    }

    public boolean getUseCommonScrollBar() {
        return this.useCommonSB;
    }

    protected void handleDispose(DisposeEvent disposeEvent) {
    }

    @Override
    public boolean hasNextDelta(Set<Delta> set) {
        return this.nextDelta(Goto.NEXT, true, set);
    }

    @Override
    public boolean hasPreviousDelta(Set<Delta> set) {
        return this.nextDelta(Goto.PREVIOUS, true, set);
    }

    protected void hookControl(Control control) {
        this.uriBoss.installListeners(true);
        super.hookControl(control);
        control.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 16) {
                    event.doit = true;
                }
            }
        });
    }

    public Sash horizontalSash(Relation relation) {
        return this.hSashes.get((Object)relation);
    }

    public Map<Relation, Sash> horizontalSashes() {
        return Collections.unmodifiableMap(this.hSashes);
    }

    private void initializeControlLayout() {
        IPreferenceStore iPreferenceStore = PrefUtil.getGlobalPrefs();
        String string = String.valueOf(ClassUtil.getSimpleName(this.getClass())) + PrefKey.C_LAYOUT_ORIENTATION.toString();
        iPreferenceStore.setDefault(string, 512);
        this.orientation = iPreferenceStore.getInt(string);
    }

    protected void initializeDashboard() {
    }

    protected void inputChanged(Object object, Object object2) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("inputChanged()     new: " + (object != null ? Integer.valueOf(object.hashCode()) : "") + "     old: " + (object2 != null ? Integer.valueOf(object2.hashCode()) : ""));
        }
        DiffController diffController = this.controller();
        diffController.connect((IMvcModel)object, this);
        this.connect((IMvcModel)object, diffController);
        if (object2 != object) {
            DiffDoc diffDoc = (DiffDoc)object2;
            IPreferenceStore iPreferenceStore = null;
            if (object2 != null) {
                NotifyUtil.installPropertyListener(diffDoc, this.onProp, false);
                diffDoc.removeDiffDocListener(this.onDeltaDoc);
                this.disposeDeltaModelListener(diffDoc);
                iPreferenceStore = diffDoc.preferences();
            }
            this.onDeltaModel = this.createDeltaModelListener();
            DiffDoc diffDoc2 = (DiffDoc)object;
            IPreferenceStore iPreferenceStore2 = null;
            NotifyUtil.installPropertyListener(diffDoc2, this.onProp, true);
            diffDoc2.addDiffDocListener(this.onDeltaDoc);
            if (this.onDeltaModel != null) {
                this.onDeltaModel.installInputListeners(true);
            }
            if (iPreferenceStore != (iPreferenceStore2 = diffDoc2.preferences())) {
                this.prefsChanged(iPreferenceStore, iPreferenceStore2);
            }
            diffController.alerts().showIntroHint(false, false);
            if (this.cmpRoot != null) {
                this.refresh();
            }
            this.fireInputChanged(diffDoc, diffDoc2);
            if (diffDoc != null) {
                diffDoc.dispose();
            }
        }
    }

    public boolean isAlertServiceReady() {
        return this.alertComposite() != null;
    }

    public boolean isCommonScrollBarVisible() {
        return this.syncVScroll && this.getUseCommonScrollBar() && this.getOrientation() == 512;
    }

    protected boolean isDisplayOnlyPref(PrefKey prefKey) {
        switch (prefKey) {
            case C_SYNC_H_SCROLL: 
            case C_SYNC_V_SCROLL: 
            case C_USE_COMMON_SCROLLBAR: 
            case D_CONFIRM_REPLACE: 
            case D_EXPAND_FOLDERS_ON_END: 
            case D_LIST_FOLDERS_FIRST: 
            case D_MAX_FILE_WND_COUNT: 
            case D_MAX_FILE_WND_COUNT_ON: 
            case D_SHOW_ATTRIBUTES_COLUMN: 
            case D_SHOW_DATE_MODIFIED_COLUMN: 
            case D_SHOW_SIZE_COLUMN: 
            case T_SHOW_PSEUDO_CONFLICTS: 
            case T_USE_SINGLE_LINE: 
            case T_WRAP_LINES: {
                return true;
            }
        }
        return false;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public boolean isOrientation(int n) {
        return this.getOrientation() == n;
    }

    public boolean isSelectionEmpty() {
        ISelection iSelection = this.getSelection();
        return iSelection == null ? true : iSelection.isEmpty();
    }

    public boolean isStructView() {
        return false;
    }

    protected boolean isSyncedHScrolling() {
        return this.preferences().getBoolean(PrefKey.C_SYNC_H_SCROLL.toString());
    }

    public boolean isSyncedVScrolling() {
        return this.syncVScroll;
    }

    public boolean isThreeWay() {
        return this.getInput().isThreeWay();
    }

    public void layoutDashboard() {
        this.cmpDashboard.layout();
    }

    public IDiffDoc model() {
        return this.getInput();
    }

    protected boolean nextDelta(Goto goto_, boolean bl, Set<Delta> set) {
        return false;
    }

    @Override
    public void nextDelta(Set<Delta> set) {
        this.nextDelta(Goto.NEXT, false, set);
    }

    protected void onMouseWheel(Event event) {
        assert (event.type == 37);
        if (event.doit && (KeyUtil.hasKey((Event)event, (int)SWT.MOD1) || KeyUtil.hasMask((Event)event, (int)SWT.MOD1))) {
            int n = SWT.MOD1;
            if (KeyUtil.hasKey((Event)event, (int)SWT.MOD2) || KeyUtil.hasMask((Event)event, (int)SWT.MOD2)) {
                n |= SWT.MOD2;
            }
            Set<Delta> set = GotoDiffAction.delta(n);
            if (event.count <= 0) {
                this.nextDelta(set);
            } else {
                this.previousDelta(set);
            }
            event.doit = false;
        }
    }

    public IPreferenceStore preferences() {
        IDiffDoc iDiffDoc = this.getInput();
        assert (iDiffDoc != null);
        return iDiffDoc != null ? iDiffDoc.preferences() : PrefUtil.getGlobalPrefs();
    }

    private void prefsChanged(IPreferenceStore iPreferenceStore, IPreferenceStore iPreferenceStore2) {
        if (iPreferenceStore != null) {
            iPreferenceStore.removePropertyChangeListener(this.onProp);
        }
        if (iPreferenceStore2 != null) {
            iPreferenceStore2.addPropertyChangeListener(this.onProp);
        }
    }

    @Override
    public void previousDelta(Set<Delta> set) {
        this.nextDelta(Goto.PREVIOUS, false, set);
    }

    protected void print(HeaderFooterPrintOp headerFooterPrintOp) {
        headerFooterPrintOp.setThreeWay(this.isThreeWay());
        this.printFileTagValues(headerFooterPrintOp);
        headerFooterPrintOp.run();
    }

    public void printFileTagValues(HeaderFooterPrintOp headerFooterPrintOp) {
        for (Role role : this.roles()) {
            String string = this.doc(role).uriInfo().uri();
            headerFooterPrintOp.setTagValue(PageSetupDialog.NAME_TAGS.get((Object)role), FileUtil.getFileName((String)string));
            headerFooterPrintOp.setTagValue(PageSetupDialog.PATH_TAGS.get((Object)role), string);
        }
    }

    protected boolean propertyChange(PropertyChangeEvent propertyChangeEvent) {
        IFilterBoss iFilterBoss = App.instance().filterBoss();
        String string = propertyChangeEvent.getProperty();
        IPreferenceStore iPreferenceStore = propertyChangeEvent.getSource() instanceof IPreferenceStore ? (IPreferenceStore)propertyChangeEvent.getSource() : null;
        boolean bl = true;
        if (string.equals("MODIFIED")) {
            IDoc iDoc = (IDoc)propertyChangeEvent.getSource();
            this.updateIndicators(iDoc);
            Alerts alerts = this.controller().alerts();
            alerts.showDocException(false, null);
            alerts.showIntroHint(false, true);
            alerts.showIOError(false, null);
            alerts.showStorageRemoved(false, null);
        } else if (string.equals("READ_ONLY")) {
            this.updateIndicators((IDoc)propertyChangeEvent.getSource());
        } else if (string.equals("NAME") || string.equals("IMAGE") || string.equals("URI_INFO")) {
            this.updateBrowseEntries();
        } else if (string.equals("STORAGE")) {
            this.storageChanged((IDoc)propertyChangeEvent.getSource(), (StorageEvent)propertyChangeEvent.getNewValue());
        } else if (string.equals("ADDITION") || string.equals("CONFLICT") || string.equals("CHANGE") || string.equals("DELETION")) {
            this.updateColors();
        } else if (string.equals(PrefKey.C_SYNC_V_SCROLL.toString())) {
            this.setSyncedVScroll(iPreferenceStore.getBoolean(string));
            if (this.cmpRoot != null) {
                this.redrawControls(true);
            }
        } else if (string.equals(PrefKey.C_USE_COMMON_SCROLLBAR.toString())) {
            this.setUseCommonScrollBar(iPreferenceStore.getBoolean(string));
            if (this.cmpRoot != null) {
                this.redrawControls(true);
            }
        } else if (PrefKey.isPrintPrefKey(string)) {
            Shell shell;
            PrintPreviewWindow printPreviewWindow = App.instance().printBoss().previewWindow();
            if (printPreviewWindow != null && (shell = printPreviewWindow.getShell()) != null && !shell.isDisposed()) {
                printPreviewWindow.beginPreviewPrinting();
            }
        } else if (string.equals(IDiffSummaryProvider.DIFF_SUMMARY)) {
            this.fireDiffSummaryChanged();
        } else if (string.equals(PrefKey.F_ALLOW_READONLY_EDIT.toString())) {
            this.getInput().allowReadOnlyEdit(iPreferenceStore.getBoolean(string));
        } else if (string.equals(PrefKey.C_IGNORE_CHAR_CASE.toString())) {
            IFilters iFilters = iFilterBoss.getSessionFilters(this.model().getFiltersId());
            List<IFilter> list = iFilters.getAllAsList();
            HashSet<IFilter> hashSet = new HashSet<IFilter>(list.size());
            hashSet.addAll(list);
            ((Filters)iFilters).fireChanged(hashSet);
        } else if (string.equals(PrefKey.C_IGNORE_WHITESPACE.toString()) || string.equals(PrefKey.C_IGNORE_LINE_ENDINGS.toString())) {
            IFilters iFilters = iFilterBoss.getSessionFilters(this.model().getFiltersId());
            Filters.updateFilter(iFilters, iPreferenceStore, string, iPreferenceStore.getBoolean(string));
        } else {
            bl = false;
        }
        return bl;
    }

    public void redrawCenters() {
        if (this.syncVScroll) {
            for (Control control : this.vSashes.values()) {
                control.redraw();
            }
        }
    }

    public void redrawContentAreas() {
        for (Role role : this.roles()) {
            ContentArea contentArea = this.contentArea(role);
            if (contentArea.isDisposed()) {
                return;
            }
            Point point = contentArea.getSize();
            contentArea.redraw(0, 0, point.x, point.y, true);
        }
    }

    public void redrawControls(boolean bl) {
        long l = 0L;
        this.updateCommonScrollBar();
        this.redrawCenters();
        this.redrawMargins();
        BirdsEye birdsEye = this.birdsEye();
        if (bl && birdsEye != null) {
            birdsEye.refresh();
        }
    }

    protected void redrawMargins() {
        for (Margin margin : this.margins.values()) {
            margin.redraw();
        }
    }

    public void refresh() {
        this.updateIndicators(null);
        this.updateBrowseEntries();
        this.updateContent();
    }

    @Override
    public void removeDeltaListener(IDeltaListener iDeltaListener) {
        if (iDeltaListener == null) {
            throw new NullPointerException("listener");
        }
        this.listeners.remove((Object)iDeltaListener);
    }

    public void removeFocusListener(FocusListener focusListener) {
    }

    @Override
    public void removePropertyListener(IPropertyChangeListener iPropertyChangeListener) {
        this.listeners.remove((Object)iPropertyChangeListener);
    }

    public Set<Role> roles() {
        return Relation.roles(this.isThreeWay());
    }

    public Composite rootComposite() {
        return this.cmpRoot;
    }

    public Scrollable scrollable(Role role) {
        return this.contentArea(role).scrollable();
    }

    protected Color scrollableBackgroundColor() {
        int n = OS.OSX ? 25 : 22;
        return this.rootComposite().getDisplay().getSystemColor(n);
    }

    protected void scrollOther(Role role, Role role2, ScrollBar scrollBar, int n) {
        scrollBar.setSelection(n);
    }

    public void scrollOthers(Role role, ScrollBar scrollBar, boolean bl) {
        if (bl && !this.isSyncedVScrolling() || !bl && !this.isSyncedHScrolling()) {
            return;
        }
        float f = 0.0f;
        int n = scrollBar.getMaximum() - scrollBar.getThumb();
        if (n > 0) {
            f = (float)scrollBar.getSelection() / (float)n;
        }
        for (Role role2 : this.roles()) {
            if (role2 == role) continue;
            Scrollable scrollable = this.scrollable(role2);
            ScrollBar scrollBar2 = bl ? scrollable.getVerticalBar() : scrollable.getHorizontalBar();
            int n2 = Math.round((float)(scrollBar2.getMaximum() - scrollBar2.getThumb()) * f);
            this.scrollOther(role, role2, scrollBar2, n2);
        }
    }

    public void setCancelableJob(final Job job) {
        Display display = UIUtil.display();
        if (Thread.currentThread().equals(display.getThread())) {
            this.setCancelableJobImpl(job);
        } else {
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    DiffView.this.setCancelableJobImpl(job);
                }
            });
        }
    }

    private void setCancelableJobImpl(Job job) {
        Job job2 = this.job;
        this.job = job;
        try {
            IThrobber iThrobber = this.getPartThrobber();
            if (iThrobber != null) {
                iThrobber.setBusy(this.job != null);
            }
        }
        finally {
            this.firePropertyChange(CANCELABLE_JOB, job2, this.job);
        }
    }

    public void setContentProvider(IContentProvider iContentProvider) {
        assert (iContentProvider instanceof IDiffViewContentProvider);
        super.setContentProvider(iContentProvider);
    }

    public boolean setFocus() {
        ContentArea contentArea = this.contentArea(Relation.firstRole(this.isThreeWay()));
        if (contentArea != null) {
            return contentArea.setFocus();
        }
        return false;
    }

    public boolean setFocus(Role role) {
        if (this.getFocusRole() == role) {
            return true;
        }
        ContentArea contentArea = this.contentArea(role);
        if (contentArea != null) {
            return contentArea.setFocus();
        }
        return false;
    }

    public void setInput(Object object) {
        if (object != this.getInput()) {
            super.setInput(object);
        }
    }

    public void setOrientation(int n) {
        int n2 = this.getOrientation();
        if (n2 == n) {
            return;
        }
        this.orientation = n;
        if (this.cmpRoot != null) {
            this.updateControlLayout();
        }
        IPreferenceStore iPreferenceStore = this.preferences();
        iPreferenceStore.setValue(String.valueOf(ClassUtil.getSimpleName(this.getClass())) + PrefKey.C_LAYOUT_ORIENTATION.toString(), this.orientation);
        this.setSyncedVScroll(this.syncVScroll);
        this.firePropertyChange(ORIENTATION, n2, this.orientation);
    }

    public void setSelection(ISelection iSelection, boolean bl) {
    }

    public void setSite(IEditorSite iEditorSite) {
        this.editorSite = iEditorSite;
    }

    protected void setSyncedVScroll(boolean bl) {
        this.syncVScroll = bl;
        if (this.cmpRoot != null) {
            this.doVerticalScroll(0, 0, 0, null);
            this.getControl().layout(true);
        }
    }

    public void setUseCommonScrollBar(boolean bl) {
        this.useCommonSB = bl;
        this.setSyncedVScroll(this.syncVScroll);
    }

    protected Recompare shouldRecompare(IPreferenceStore iPreferenceStore, PrefKey prefKey, boolean bl) {
        return Recompare.NONE;
    }

    public void showAlerts() {
        this.controller().showAlerts();
    }

    private void showReadOnlyIndicator(Role role, boolean bl) {
        UriChooser uriChooser = this.uriBoss.uriChooser(role);
        if (uriChooser != null) {
            IDoc iDoc = this.getInputs().get((Object)role);
            String string = "";
            if (iDoc.isSnapshot()) {
                string = UIMsg.FileSystemUriChooser_ttSnapshot;
            }
            ((FileSystemUriChooser)uriChooser).showReadOnlyIndicator(bl, string);
        }
    }

    protected void storageChanged(IDoc iDoc, StorageEvent storageEvent) {
        IResource iResource;
        IPreferenceStore iPreferenceStore = iDoc.preferences();
        if (storageEvent.type == 4 && iPreferenceStore.getBoolean(PrefKey.F_ENABLE_DELETE_ALERTS.toString()) && (iResource = iDoc.resource()) != null) {
            Object[] objectArray = storageEvent.getCauses();
            boolean bl = false;
            if (objectArray.length != 0) {
                int n = 0;
                while (n < objectArray.length) {
                    if (objectArray[n].equals(iResource)) {
                        bl = true;
                        break;
                    }
                    ++n;
                }
            } else {
                bl = storageEvent.getSource().equals(iResource);
            }
            if (bl) {
                this.controller().alerts().showStorageRemoved(true, iDoc);
            }
        }
        if (storageEvent.type == 2 && iPreferenceStore.getBoolean(PrefKey.F_ENABLE_CHANGE_ALERTS.toString())) {
            this.controller().alerts().showRefresh(iDoc.resource(), new RefreshFromStorageRunnable(iDoc, storageEvent, this));
        }
    }

    protected void threeWayChanged(boolean bl) {
        if (this.cmpRoot != null) {
            this.updateContent();
            this.updateControlLayout();
            this.setSyncedVScroll(this.syncVScroll);
        }
        this.refresh();
        if (!bl) {
            this.uriBoss.clearUriInfo(Role.REF);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public int triadIndex() {
        return 0;
    }

    protected void updateBrowseEntries() {
        if (this.uriBoss != null) {
            this.uriBoss.update();
        }
    }

    protected void updateColors() {
        this.redrawControls(true);
    }

    public abstract void updateCommonScrollBar();

    protected void updateContent() {
        IDiffModel iDiffModel = this.deltaModel();
        if (iDiffModel != null) {
            iDiffModel.addModelListener(this.deltaModelListener());
        }
        this.dCtlr.alerts().showIOError(false, null);
        this.dCtlr.alerts().showStorageRemoved(false, null);
        this.dCtlr.connectGlobalActions(true);
    }

    public void updateControlLayout() {
        ((DiffViewLayout)this.cmpRoot.getLayout()).initializeSplitRatios();
        this.getControl().layout(true);
    }

    private void updateIndicators(IDoc iDoc) {
        if (iDoc != null) {
            this.showReadOnlyIndicator(iDoc.role(), !iDoc.canEverWrite());
        } else if (this.getInput() != null) {
            Collection<IDoc> collection = this.getInput().triad(0).values();
            for (IDoc iDoc2 : collection) {
                this.showReadOnlyIndicator(iDoc2.role(), !iDoc2.canEverWrite());
            }
        }
    }

    public UriChooserBoss uriChooserBoss() {
        return this.uriBoss;
    }

    public Sash verticalSash(Relation relation) {
        return this.vSashes.get((Object)relation);
    }

    public Map<Relation, Sash> verticalSashes() {
        return Collections.unmodifiableMap(this.vSashes);
    }

    protected Sash verticalSashTop(Relation relation) {
        return this.vSashTops.get((Object)relation);
    }

    public Map<Relation, Sash> verticalSashTops() {
        return Collections.unmodifiableMap(this.vSashTops);
    }

    public ScrollBar verticalScrollBar() {
        return this.isCommonScrollBarVisible() ? this.sbCommon : this.scrollable(Relation.firstRole(this.isThreeWay())).getVerticalBar();
    }

    public ISourceViewer viewer(Role role) {
        return null;
    }

    public IViewHolder viewHolder() {
        Object object = this.getData("VIEW_HOLDER_KEY");
        return object instanceof IViewHolder ? (IViewHolder)object : null;
    }

    public static enum Recompare {
        FULL,
        NONE,
        PARTIAL;

    }
}

