/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui;

import com.deltawalker.Msg;
import com.deltawalker.ui.IDiffSummary;
import com.deltawalker.ui.IDiffSummaryItem;
import com.deltawalker.ui.UIMsg;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DiffSummary
implements IDiffSummary {
    private static final String[] PROPS = new String[]{Msg.DeltaKind_same, Msg.DeltaKind_changed, Msg.DeltaKind_added, Msg.DeltaKind_deleted};
    private String description;
    private final List<IDiffSummaryItem> items = new ArrayList<IDiffSummaryItem>(2);
    private String name;
    private IDiffSummary nextSummary;
    private final String[] props;
    protected final boolean threeWay;
    private String title;
    private final List<IDiffSummaryItem> umItems = Collections.unmodifiableList(this.items);

    public DiffSummary(boolean bl) {
        this(null, bl);
    }

    public DiffSummary(String[] stringArray, boolean bl) {
        if (stringArray == null) {
            this.props = null;
        } else {
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray2[n2];
                if (string == null) {
                    throw new IllegalArgumentException("props contains one or more null values");
                }
                ++n2;
            }
            this.props = (String[])stringArray.clone();
        }
        this.threeWay = bl;
    }

    public void addItem(IDiffSummaryItem iDiffSummaryItem) {
        this.items.add(iDiffSummaryItem);
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public List<IDiffSummaryItem> getItems() {
        return this.umItems;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public final boolean isThreeWay() {
        return this.threeWay;
    }

    @Override
    public IDiffSummary nextSummary() {
        return this.nextSummary;
    }

    @Override
    public String[] properties() {
        if (this.props != null) {
            return this.props;
        }
        int n = PROPS.length;
        if (this.threeWay) {
            ++n;
        }
        String[] stringArray = new String[n];
        System.arraycopy(PROPS, 0, stringArray, 0, PROPS.length);
        if (this.threeWay) {
            stringArray[stringArray.length - 1] = Msg.DeltaKind_conflicting;
        }
        return stringArray;
    }

    public boolean removeItem(IDiffSummaryItem iDiffSummaryItem) {
        return this.items.remove(iDiffSummaryItem);
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setNextSummary(IDiffSummary iDiffSummary) {
        this.nextSummary = iDiffSummary;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    @Override
    public String[][] tableData() {
        String string;
        String[] stringArray = this.properties();
        int n = stringArray == null ? 0 : stringArray.length;
        String[][] stringArray2 = new String[1 + n][];
        int n2 = this.items.size();
        stringArray2[0] = new String[1 + n2];
        stringArray2[0][0] = UIMsg.CompareSummaryDlg_name;
        int n3 = 0;
        while (n3 < n2) {
            string = this.items.get(n3).getName();
            stringArray2[0][1 + n3] = string == null ? "" : string;
            ++n3;
        }
        n3 = 0;
        while (n3 < n) {
            stringArray2[1 + n3] = new String[1 + n2];
            string = stringArray[n3];
            stringArray2[1 + n3][0] = string != null ? string.toString() : "";
            int n4 = 0;
            while (n4 < n2) {
                Object object = this.items.get(n4).getValue(string);
                stringArray2[1 + n3][1 + n4] = object != null ? object.toString() : "";
                ++n4;
            }
            ++n3;
        }
        return stringArray2;
    }

    @Override
    public String title() {
        return this.title;
    }
}

