/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui;

import com.deltawalker.DocType;
import com.deltawalker.Msg;
import com.deltawalker.SaveAs;
import com.deltawalker.interfaces.IDiffDoc;
import com.deltawalker.interfaces.IDiffModel;
import com.deltawalker.interfaces.IDoc;
import com.deltawalker.internal.TagReportConfig;
import com.deltawalker.script.Role;
import com.deltawalker.ui.ActionController;
import com.deltawalker.ui.Alerts;
import com.deltawalker.ui.DiffView;
import com.deltawalker.ui.GotoDiffButton;
import com.deltawalker.ui.MenuCombo;
import com.deltawalker.ui.SummaryStatusLineGroup;
import com.deltawalker.ui.UIUtil;
import com.deltawalker.ui.actions.Compare2WayVerticalAction;
import com.deltawalker.ui.actions.Compare3WayVerticalAction;
import com.deltawalker.ui.actions.CompareSummaryAction;
import com.deltawalker.ui.actions.CopyLeftAction;
import com.deltawalker.ui.actions.CopyLeftMenuAction;
import com.deltawalker.ui.actions.CopyRightAction;
import com.deltawalker.ui.actions.CopyRightMenuAction;
import com.deltawalker.ui.actions.CreatePatchAction;
import com.deltawalker.ui.actions.OpenFileAction;
import com.deltawalker.ui.actions.OpenLocalFileAction;
import com.deltawalker.ui.actions.OpenRemoteFileAction;
import com.deltawalker.ui.actions.ReportAction;
import com.deltawalker.ui.actions.SaveAction;
import com.deltawalker.ui.actions.SaveAsAction;
import com.deltawalker.ui.actions.SwapMenuAction;
import com.deltopia.ObjectUtil;
import com.deltopia.eclipse.util.Goto;
import com.deltopia.interfaces.IMvcModel;
import com.deltopia.interfaces.IMvcView;
import com.deltopia.ui.swt.IFocusNotifier;
import com.deltopia.util.OS;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

public class DiffController
extends ActionController {
    protected Alerts alerts;
    private SummaryStatusLineGroup panels;
    private IWorkbenchWindow window;

    public Alerts alerts() {
        if (this.alerts == null) {
            this.alerts = new Alerts(this);
        }
        return this.alerts;
    }

    @Override
    public void connect(IMvcModel iMvcModel, IMvcView iMvcView) {
        super.connect(iMvcModel, iMvcView);
        if (!ObjectUtil.areEqual((Object)iMvcModel, (Object)this.model())) {
            this.alerts().inputChanged();
        }
    }

    @Override
    public void connectGlobalActions(boolean bl) {
        int n;
        DiffView diffView = this.view();
        IDiffDoc iDiffDoc = diffView.getInput();
        if (iDiffDoc.docType(n = this.triadIndex()) == DocType.PREVIEW) {
            return;
        }
        Collection<IAction> collection = this.actions();
        if (collection.isEmpty()) {
            return;
        }
        IActionBars iActionBars = this.getActionBars();
        for (IAction iAction : collection) {
            String string = iAction.getId();
            if (bl) {
                iActionBars.setGlobalActionHandler(string, iAction);
                continue;
            }
            if (iActionBars.getGlobalActionHandler(string) != iAction) continue;
            iActionBars.setGlobalActionHandler(string, null);
        }
        iActionBars.updateActionBars();
        if (bl) {
            this.updateActions();
        }
        this.updateComparisonSummary();
    }

    public void connectSearchField(boolean bl, boolean bl2) {
    }

    protected IDiffModel createDiffModel() {
        return null;
    }

    protected SummaryStatusLineGroup createSummaryPanels() {
        return new SummaryStatusLineGroup(this.window().getShell(), this.getActionBars());
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.panels != null) {
            this.panels.dispose();
            this.panels = null;
        }
        this.window = null;
    }

    protected void focusGained(FocusEvent focusEvent) {
        Shell shell = this.window().getShell();
        if (shell != null && !shell.isDisposed()) {
            if (focusEvent.widget instanceof MenuCombo) {
                this.getActionBars().updateActionBars();
            } else {
                this.connectGlobalActions(true);
            }
        }
    }

    protected void focusLost(FocusEvent focusEvent) {
        Shell shell = this.window().getShell();
        if (shell != null && !shell.isDisposed()) {
            this.disconnectIndividualGlobalActions(this.getActionBars());
            this.getActionBars().updateActionBars();
        }
    }

    public IDoc getSubInput(Role role) {
        return this.model().doc(0, role);
    }

    protected void initializeGotoDiffButtons() {
        GotoDiffButton gotoDiffButton = this.view().getGotoButton(Goto.NEXT);
        if (gotoDiffButton != null) {
            gotoDiffButton.initialize(this.getAction("nextDelta"));
        }
        if ((gotoDiffButton = this.view().getGotoButton(Goto.PREVIOUS)) != null) {
            gotoDiffButton.initialize(this.getAction("previousDelta"));
        }
    }

    public void installListeners() {
        DiffView diffView = this.view();
        IWorkbenchPart iWorkbenchPart = diffView.getPart();
        if (iWorkbenchPart instanceof IViewPart) {
            this.setActionBars(((IViewPart)iWorkbenchPart).getViewSite().getActionBars());
        } else if (iWorkbenchPart instanceof IEditorPart) {
            this.setActionBars(((IEditorPart)iWorkbenchPart).getEditorSite().getActionBars());
        } else {
            return;
        }
        this.window = diffView.getSite().getWorkbenchWindow();
        this.makeActions();
        this.fillActionBars(this.getActionBars());
        this.installContextMenu();
        FocusListener focusListener = new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                DiffController.this.focusGained(focusEvent);
            }

            public void focusLost(FocusEvent focusEvent) {
                DiffController.this.focusLost(focusEvent);
            }
        };
        if (diffView instanceof IFocusNotifier) {
            diffView.addFocusListener(focusListener);
        }
    }

    public boolean isThreeWay() {
        return this.view().isThreeWay();
    }

    @Override
    protected void makeActions() {
        ResourceBundle resourceBundle = Msg.constructedKeyBundle();
        IWorkbenchWindow iWorkbenchWindow = this.window();
        DiffView diffView = this.view();
        this.addAction((IAction)new SwapMenuAction(resourceBundle, 0, diffView));
        this.addAction((IAction)new SwapMenuAction(resourceBundle, 1, diffView));
        this.addAction((IAction)new CompareSummaryAction(resourceBundle, diffView));
        this.addAction((IAction)new CreatePatchAction(resourceBundle, diffView));
        Set<TagReportConfig.Format> set = TagReportConfig.getSupportedFormats();
        for (TagReportConfig.Format format : set) {
            this.addAction((IAction)new ReportAction(resourceBundle, format, diffView));
        }
        boolean bl = false;
        this.addAction((IAction)new CopyRightAction(resourceBundle, iWorkbenchWindow, bl));
        this.addAction((IAction)new CopyLeftAction(resourceBundle, iWorkbenchWindow, bl));
        this.addAction((IAction)new CopyRightMenuAction(resourceBundle, 0, diffView, false));
        this.addAction((IAction)new CopyRightMenuAction(resourceBundle, 1, diffView, false));
        this.addAction((IAction)new CopyLeftMenuAction(resourceBundle, 0, diffView, false));
        this.addAction((IAction)new CopyLeftMenuAction(resourceBundle, 1, diffView, false));
        this.addAction((IAction)new CopyRightMenuAction(resourceBundle, 0, diffView, true));
        this.addAction((IAction)new CopyRightMenuAction(resourceBundle, 1, diffView, true));
        this.addAction((IAction)new CopyLeftMenuAction(resourceBundle, 0, diffView, true));
        this.addAction((IAction)new CopyLeftMenuAction(resourceBundle, 1, diffView, true));
        if (OS.COCOA) {
            bl = true;
            this.addAction((IAction)new CopyRightAction(resourceBundle, iWorkbenchWindow, bl));
            this.addAction((IAction)new CopyLeftAction(resourceBundle, iWorkbenchWindow, bl));
        }
        this.addAction((IAction)new Compare2WayVerticalAction(resourceBundle, diffView));
        this.addAction((IAction)new Compare3WayVerticalAction(resourceBundle, diffView));
        this.makeOpenSaveActions();
    }

    protected void makeOpenSaveActions() {
        DiffView diffView = this.view();
        this.addAction((IAction)new SaveAction());
        this.addAction((IAction)new OpenFileAction(diffView));
        this.addAction((IAction)new OpenLocalFileAction(diffView));
        this.addAction((IAction)new OpenRemoteFileAction(diffView));
        this.addAction((IAction)new SaveAsAction(SaveAs.LOCAL));
        this.addAction((IAction)new SaveAsAction(SaveAs.REMOTE));
    }

    @Override
    public IDiffDoc model() {
        return (IDiffDoc)super.model();
    }

    public void showAlerts() {
        if (this.model().docType(0) != DocType.PREVIEW) {
            this.alerts().showIntroHint(true, false);
        }
    }

    protected int triadIndex() {
        DiffView diffView = this.view();
        IDiffDoc iDiffDoc = diffView.getInput();
        return Math.min(diffView.triadIndex(), iDiffDoc.triadCount());
    }

    public void updateComparisonSummary() {
        if (this.view().getInput().docType(0) == DocType.PREVIEW) {
            return;
        }
        if (this.panels == null) {
            this.panels = this.createSummaryPanels();
        }
        if (this.panels != null) {
            IAction iAction = this.getAction("compareSummary");
            this.panels.updateSummary(this.view().deltaModel(), iAction, this.isThreeWay());
        }
    }

    @Override
    public DiffView view() {
        return (DiffView)super.view();
    }

    protected IWorkbenchWindow window() {
        if (this.window == null) {
            this.window = UIUtil.getActiveWindow();
        }
        return this.window;
    }
}

