/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui;

import com.deltawalker.NotifyUtil;
import com.deltawalker.interfaces.IDiffNode;
import com.deltawalker.script.Delta;
import com.deltawalker.script.Role;
import com.deltawalker.ui.DeltaPart;
import com.deltawalker.ui.UIUtil;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.AnnotationPreferenceLookup;

public class DeltaColor {
    private static Color clrFocusBg;
    private static Color clrSysBg;
    private static Color clrSysFg;
    private static final Map<Device, DeltaColor> dcRegistry;
    public static final String KEY_ADDITION = "ADDITION";
    public static final String KEY_CHANGE = "CHANGE";
    public static final String KEY_CONFLICT = "CONFLICT";
    public static final String KEY_DELETION = "DELETION";
    public static final String KEY_QUICKDIFF_ADDITION = "org.eclipse.ui.workbench.texteditor.quickdiffAddition";
    public static final String KEY_QUICKDIFF_CHANGE = "org.eclipse.ui.workbench.texteditor.quickdiffChange";
    public static final String KEY_QUICKDIFF_DELETION = "org.eclipse.ui.workbench.texteditor.quickdiffDeletion";
    private static final Map<DeltaPart, RGB> part2rgbAddition;
    private static final Map<DeltaPart, RGB> part2rgbChange;
    private static final Map<DeltaPart, RGB> part2rgbConflict;
    private static final Map<DeltaPart, RGB> part2rgbDeletion;
    private static final RGB RGB_WHITE;
    private static RGB rgbAddition;
    private static RGB rgbChange;
    private static RGB rgbConflict;
    private static RGB rgbDeletion;
    private static final Map<DeltaPart, Double> transparencies;
    private final Device device;
    private final ListenerList listeners = new ListenerList();
    private int retainCount = 1;
    private final Map<RGB, Color> rgb2clr = new HashMap<RGB, Color>();

    static {
        dcRegistry = new HashMap<Device, DeltaColor>();
        part2rgbAddition = new EnumMap<DeltaPart, RGB>(DeltaPart.class);
        part2rgbChange = new EnumMap<DeltaPart, RGB>(DeltaPart.class);
        part2rgbConflict = new EnumMap<DeltaPart, RGB>(DeltaPart.class);
        part2rgbDeletion = new EnumMap<DeltaPart, RGB>(DeltaPart.class);
        RGB_WHITE = new RGB(255, 255, 255);
        transparencies = new EnumMap<DeltaPart, Double>(DeltaPart.class);
        transparencies.put(DeltaPart.BG, 0.8);
        transparencies.put(DeltaPart.BG_SELECT, 0.94);
        transparencies.put(DeltaPart.BORDER, 0.3);
        transparencies.put(DeltaPart.FG, 0.5);
        JFaceResources.getColorRegistry().addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getProperty();
                if (DeltaColor.KEY_ADDITION.equals(string) || DeltaColor.KEY_CONFLICT.equals(string) || DeltaColor.KEY_DELETION.equals(string) || DeltaColor.KEY_CHANGE.equals(string)) {
                    DeltaColor.updateColors();
                    DeltaColor.syncQuickdiffColors();
                    for (DeltaColor deltaColor : dcRegistry.values()) {
                        deltaColor.firePropertyChange(string, propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
                    }
                }
            }
        });
        DeltaColor.updateColors();
        DeltaColor.syncQuickdiffColors();
    }

    public static DeltaColor forDevice(Device device) {
        DeltaColor deltaColor = dcRegistry.get(device);
        if (deltaColor == null) {
            deltaColor = new DeltaColor(device);
            dcRegistry.put(device, deltaColor);
        } else {
            ++deltaColor.retainCount;
        }
        return deltaColor;
    }

    public static RGB getColor(Delta delta, DeltaPart deltaPart, boolean bl) {
        if (deltaPart == DeltaPart.BG && bl) {
            deltaPart = DeltaPart.BG_SELECT;
        }
        return DeltaColor.getColor(delta, deltaPart, null, bl);
    }

    public static RGB getColor(Delta delta, DeltaPart deltaPart, Role role, boolean bl) {
        if (delta.isSame()) {
            return RGB_WHITE;
        }
        if (delta.isConflict()) {
            if (deltaPart == DeltaPart.BG_SELECT) {
                return DeltaColor.rgbForConflict(deltaPart);
            }
            return bl ? rgbConflict : DeltaColor.rgbForConflict(deltaPart);
        }
        if (delta.isChanged()) {
            if (deltaPart == DeltaPart.BG_SELECT) {
                return DeltaColor.rgbForChange(deltaPart);
            }
            return bl ? rgbChange : DeltaColor.rgbForChange(deltaPart);
        }
        if (delta.isDeleted()) {
            if (deltaPart == DeltaPart.BG_SELECT) {
                return DeltaColor.rgbForDeletion(deltaPart);
            }
            return bl ? rgbDeletion : DeltaColor.rgbForDeletion(deltaPart);
        }
        if (delta.isAdded()) {
            if (deltaPart == DeltaPart.BG_SELECT) {
                return DeltaColor.rgbForAddition(deltaPart);
            }
            return bl ? rgbAddition : DeltaColor.rgbForAddition(deltaPart);
        }
        return RGB_WHITE;
    }

    public static RGB getColor(Role role, IDiffNode iDiffNode, DeltaPart deltaPart) {
        return DeltaColor.getColor(iDiffNode, deltaPart, role, false);
    }

    public static Color getFocusBackground() {
        if (clrFocusBg == null) {
            clrFocusBg = new Color((Device)UIUtil.display(), DeltaColor.interpolate(clrSysBg.getRGB(), new RGB(70, 150, 255), 0.2));
        }
        return clrFocusBg;
    }

    public static Color getListBackgroundSystemColor() {
        return clrSysBg;
    }

    public static Color getListForegroundSystemColor() {
        return clrSysFg;
    }

    private static double getTransparency(DeltaPart deltaPart) {
        return transparencies.get((Object)deltaPart);
    }

    public static RGB interpolate(RGB rGB, RGB rGB2, double d) {
        if (rGB != null && rGB2 != null) {
            return new RGB((int)((1.0 - d) * (double)rGB.red + d * (double)rGB2.red), (int)((1.0 - d) * (double)rGB.green + d * (double)rGB2.green), (int)((1.0 - d) * (double)rGB.blue + d * (double)rGB2.blue));
        }
        if (rGB != null) {
            return rGB;
        }
        if (rGB2 != null) {
            return rGB2;
        }
        return new RGB(128, 128, 128);
    }

    public static RGB rgbForAddition(DeltaPart deltaPart) {
        return part2rgbAddition.get((Object)deltaPart);
    }

    public static RGB rgbForChange(DeltaPart deltaPart) {
        return part2rgbChange.get((Object)deltaPart);
    }

    public static RGB rgbForConflict(DeltaPart deltaPart) {
        return part2rgbConflict.get((Object)deltaPart);
    }

    public static RGB rgbForDeletion(DeltaPart deltaPart) {
        return part2rgbDeletion.get((Object)deltaPart);
    }

    public static RGB rgbForKind(Delta.Kind kind, DeltaPart deltaPart) {
        switch (kind) {
            case ADDED: {
                return part2rgbAddition.get((Object)deltaPart);
            }
            case DELETED: {
                return part2rgbDeletion.get((Object)deltaPart);
            }
            case CHANGED: {
                return part2rgbChange.get((Object)deltaPart);
            }
        }
        throw new IllegalArgumentException("Unknown kind");
    }

    public static void syncQuickdiffColors() {
        String[] stringArray = new String[]{KEY_CHANGE, KEY_QUICKDIFF_CHANGE, KEY_ADDITION, KEY_QUICKDIFF_ADDITION, KEY_DELETION, KEY_QUICKDIFF_DELETION};
        ColorRegistry colorRegistry = JFaceResources.getColorRegistry();
        AnnotationPreferenceLookup annotationPreferenceLookup = EditorsUI.getAnnotationPreferenceLookup();
        IPreferenceStore iPreferenceStore = EditorsUI.getPreferenceStore();
        int n = 0;
        while (n < stringArray.length) {
            String string;
            AnnotationPreference annotationPreference;
            RGB rGB = colorRegistry.getRGB(stringArray[n]);
            if (rGB != null && (annotationPreference = annotationPreferenceLookup.getAnnotationPreference(stringArray[n + 1])) != null && (string = annotationPreference.getColorPreferenceKey()) != null) {
                PreferenceConverter.setValue((IPreferenceStore)iPreferenceStore, (String)string, (RGB)rGB);
            }
            n += 2;
        }
    }

    private static void updateColors() {
        DeltaPart deltaPart;
        Display display = UIUtil.display();
        ColorRegistry colorRegistry = JFaceResources.getColorRegistry();
        clrSysBg = display.getSystemColor(25);
        clrSysFg = display.getSystemColor(24);
        RGB rGB = clrSysBg.getRGB();
        rgbAddition = colorRegistry.getRGB(KEY_ADDITION);
        assert (rgbAddition != null);
        DeltaPart[] deltaPartArray = DeltaPart.values();
        int n = deltaPartArray.length;
        int n2 = 0;
        while (n2 < n) {
            deltaPart = deltaPartArray[n2];
            part2rgbAddition.put(deltaPart, DeltaColor.interpolate(rgbAddition, rGB, DeltaColor.getTransparency(deltaPart)));
            ++n2;
        }
        rgbChange = colorRegistry.getRGB(KEY_CHANGE);
        assert (rgbChange != null);
        deltaPartArray = DeltaPart.values();
        n = deltaPartArray.length;
        n2 = 0;
        while (n2 < n) {
            deltaPart = deltaPartArray[n2];
            part2rgbChange.put(deltaPart, DeltaColor.interpolate(rgbChange, rGB, DeltaColor.getTransparency(deltaPart)));
            ++n2;
        }
        rgbDeletion = colorRegistry.getRGB(KEY_DELETION);
        assert (rgbDeletion != null);
        deltaPartArray = DeltaPart.values();
        n = deltaPartArray.length;
        n2 = 0;
        while (n2 < n) {
            deltaPart = deltaPartArray[n2];
            part2rgbDeletion.put(deltaPart, DeltaColor.interpolate(rgbDeletion, rGB, DeltaColor.getTransparency(deltaPart)));
            ++n2;
        }
        rgbConflict = colorRegistry.getRGB(KEY_CONFLICT);
        assert (rgbConflict != null);
        deltaPartArray = DeltaPart.values();
        n = deltaPartArray.length;
        n2 = 0;
        while (n2 < n) {
            deltaPart = deltaPartArray[n2];
            part2rgbConflict.put(deltaPart, DeltaColor.interpolate(rgbConflict, rGB, DeltaColor.getTransparency(deltaPart)));
            ++n2;
        }
    }

    private DeltaColor(Device device) {
        this.device = device != null ? device : UIUtil.display();
    }

    public void addListener(IPropertyChangeListener iPropertyChangeListener) {
        this.listeners.add((Object)iPropertyChangeListener);
    }

    public Color borderColorFromBgColor(Color color) {
        DeltaPart deltaPart = DeltaPart.BG;
        RGB rGB = color.getRGB();
        RGB rGB2 = null;
        if (rGB.equals((Object)DeltaColor.rgbForAddition(deltaPart))) {
            rGB2 = rgbAddition;
        } else if (rGB.equals((Object)DeltaColor.rgbForChange(deltaPart))) {
            rGB2 = rgbChange;
        } else if (rGB.equals((Object)DeltaColor.rgbForDeletion(deltaPart))) {
            rGB2 = rgbDeletion;
        } else if (rGB.equals((Object)DeltaColor.rgbForConflict(deltaPart))) {
            rGB2 = rgbConflict;
        } else assert (false);
        return rGB2 != null ? this.colorFromRgb(rGB2) : null;
    }

    public Color colorFor(Delta.Kind kind, DeltaPart deltaPart) {
        RGB rGB = DeltaColor.rgbForKind(kind, deltaPart);
        return this.colorFromRgb(rGB);
    }

    public Color colorFromRgb(RGB rGB) {
        if (rGB == null) {
            return null;
        }
        Color color = this.rgb2clr.get(rGB);
        if (color == null) {
            color = new Color(this.device, rGB);
            this.rgb2clr.put(rGB, color);
        }
        return color;
    }

    public final Device device() {
        return this.device;
    }

    public void dispose() {
        if (this.retainCount > 0) {
            --this.retainCount;
            if (this.retainCount == 0) {
                if (clrFocusBg != null && !clrFocusBg.isDisposed()) {
                    clrFocusBg.dispose();
                    clrFocusBg = null;
                }
                DeltaColor deltaColor = dcRegistry.remove(this.device());
                assert (this.equals(deltaColor));
                try {
                    for (Color color : this.rgb2clr.values()) {
                        color.dispose();
                    }
                }
                finally {
                    this.rgb2clr.clear();
                }
            }
        }
    }

    private void firePropertyChange(String string, Object object, Object object2) {
        NotifyUtil.firePropertyChange(this.listeners, this, string, object, object2);
    }

    public void removeListener(IPropertyChangeListener iPropertyChangeListener) {
        if (iPropertyChangeListener != null) {
            this.listeners.remove((Object)iPropertyChangeListener);
        }
    }
}

