/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui;

import java.util.HashMap;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class CursorRegistry {
    private HashMap<Integer, Cursor> cursors = new HashMap();
    private Display display;

    public CursorRegistry() {
        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        this.display = iWorkbenchWindow.getShell().getDisplay();
    }

    public CursorRegistry(Display display) {
        assert (display != null) : String.valueOf(CursorRegistry.class.getName()) + ": if you don't have a Display instance, call the default constructor instead.";
        this.display = display;
    }

    public void dispose() {
        for (Cursor cursor : this.cursors.values()) {
            cursor.dispose();
        }
        this.display.dispose();
    }

    public Cursor getCursor(int n) {
        Cursor cursor = this.cursors.get(n);
        if (cursor == null) {
            cursor = new Cursor((Device)this.display, n);
            this.cursors.put(new Integer(n), cursor);
        }
        return cursor;
    }
}

