/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui;

import com.deltopia.util.ArrayUtil;
import java.util.LinkedList;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;

public final class ControlUtil {
    private static final int CHECKERED_SQUARE_COUNT = 10;
    private static final int CHECKERED_SQUARE_SIZE = 10;
    private static final int HORIZONTAL_DIALOG_UNIT_PER_CHAR = 4;
    private static final int VERTICAL_DIALOG_UNITS_PER_CHAR = 8;

    public static int convertDLUsToPixels(Control control, int n, boolean bl) {
        GC gC = new GC((Drawable)control);
        gC.setFont(control.getFont());
        FontMetrics fontMetrics = gC.getFontMetrics();
        int n2 = 0;
        n2 = bl ? (fontMetrics.getHeight() * n + 4) / 8 : (fontMetrics.getAverageCharWidth() * n + 2) / 4;
        gC.dispose();
        return n2;
    }

    public static final Image createCheckeredBgImage(Display display, Color color, Color color2) {
        if (display == null) {
            throw new NullPointerException("display");
        }
        Image image = new Image((Device)display, 100, 100);
        GC gC = new GC((Drawable)image);
        ControlUtil.drawCheckeredBg(gC, image.getBounds(), color, color2);
        gC.dispose();
        return image;
    }

    public static void drawCheckeredBg(GC gC, Rectangle rectangle, Color color, Color color2) {
        Color color3 = gC.getBackground();
        Rectangle rectangle2 = new Rectangle(0, 0, 10, 10);
        int n = (int)Math.ceil((double)rectangle.width / 10.0);
        int n2 = (int)Math.ceil((double)rectangle.height / 10.0);
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                rectangle2.x = n3 * 10;
                rectangle2.y = n4 * 10;
                if (n3 % 2 == n4 % 2) {
                    gC.setBackground(color);
                } else {
                    gC.setBackground(color2);
                }
                gC.fillRectangle(rectangle2);
                ++n4;
            }
            ++n3;
        }
        gC.setBackground(color3);
    }

    public static void enableControls(Control[] controlArray, boolean bl) {
        Control[] controlArray2 = controlArray;
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray2[n2];
            control.setEnabled(bl);
            ++n2;
        }
    }

    public static Control[] getChildren(Control control, Class clazz) {
        Control[] controlArray = new Control[]{control};
        LinkedList<Control> linkedList = new LinkedList<Control>();
        int n = 0;
        while (n < controlArray.length) {
            Control control2 = controlArray[n];
            if (control2 instanceof Composite) {
                controlArray = (Control[])ArrayUtil.join(Control.class, (Object)controlArray, (Object)((Composite)control2).getChildren());
            }
            if (clazz.isInstance(control2)) {
                linkedList.add(control2);
            }
            ++n;
        }
        return linkedList.toArray(new Control[linkedList.size()]);
    }

    public static boolean isFocusControl(Control control) {
        Control[] controlArray = new Control[]{control};
        int n = 0;
        while (n < controlArray.length) {
            control = controlArray[n];
            if (control.isFocusControl()) {
                return true;
            }
            if (control instanceof Composite) {
                controlArray = (Control[])ArrayUtil.join(Control.class, (Object)controlArray, (Object)((Composite)control).getChildren());
            }
            ++n;
        }
        return false;
    }

    public static Event translateEvent(Event event, Control control) {
        Control control2 = (Control)event.widget;
        Point point = control.toControl(control2.toDisplay(event.x, event.y));
        Event event2 = new Event();
        event2.button = event.button;
        event2.character = event.character;
        event2.count = event.count;
        event2.detail = event.detail;
        event2.display = event.display;
        event2.doit = event.doit;
        event2.keyCode = event.keyCode;
        event2.stateMask = event.stateMask;
        event2.time = event.time;
        event2.type = event.type;
        event2.widget = control;
        event2.x = point.x;
        event2.y = point.y;
        return event2;
    }

    private ControlUtil() {
    }
}

