/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui;

import com.deltawalker.script.Role;
import com.deltawalker.ui.DiffView;
import com.deltawalker.ui.UIUtil;
import com.deltawalker.ui.UriChooser;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.jface.util.DelegatingDropAdapter;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;

public abstract class ContentArea
extends Composite {
    protected final Role role;
    private DiffView view;

    public ContentArea(Composite composite, int n, DiffView diffView, Role role) {
        super(composite, n);
        this.view = diffView;
        this.role = role;
        this.setLayout((Layout)new FillLayout());
        UIUtil.setHelpContextId((Control)this, this.getHelpContextId());
    }

    protected DropTargetListener configureDropTargetListener(DropTargetListener dropTargetListener, Role role, Control control, DropTarget dropTarget) {
        return dropTargetListener;
    }

    protected DropTarget createDropTarget(Role role, Control control) {
        Transfer[] transferArray;
        UriChooser uriChooser = this.view.uriChooserBoss().uriChooser(role);
        if (uriChooser == null) {
            return null;
        }
        DropTargetListener dropTargetListener = uriChooser.dropTargetListener();
        if (dropTargetListener instanceof DelegatingDropAdapter) {
            transferArray = ((DelegatingDropAdapter)dropTargetListener).getTransfers();
        } else if (dropTargetListener instanceof TransferDropTargetListener) {
            transferArray = new Transfer[]{((TransferDropTargetListener)dropTargetListener).getTransfer()};
        } else {
            return null;
        }
        Object object = control.getData("DropTarget");
        DropTarget dropTarget = object != null ? (DropTarget)object : new DropTarget(control, 23);
        HashSet<Transfer> hashSet = new HashSet<Transfer>();
        hashSet.addAll(Arrays.asList(dropTarget.getTransfer()));
        hashSet.addAll(Arrays.asList(transferArray));
        dropTarget.setTransfer(hashSet.toArray(new Transfer[hashSet.size()]));
        dropTargetListener = this.configureDropTargetListener(dropTargetListener, role, control, dropTarget);
        if (dropTargetListener != null) {
            dropTarget.addDropListener(dropTargetListener);
        }
        return dropTarget;
    }

    protected DiffView deltaView() {
        return this.view;
    }

    public void dispose() {
        this.view = null;
        super.dispose();
    }

    protected abstract String getHelpContextId();

    public boolean isHScrollBarVisible() {
        ScrollBar scrollBar = this.getHorizontalBar();
        return scrollBar != null && scrollBar.isVisible();
    }

    public int marginTop() {
        return 0;
    }

    protected void postPopulate() {
        Scrollable scrollable = this.scrollable();
        ScrollBar scrollBar = scrollable.getVerticalBar();
        if (scrollBar != null) {
            scrollBar.setVisible(!this.view.isCommonScrollBarVisible());
        }
        this.createDropTarget(this.role, (Control)scrollable);
        this.setupSyncedScroll(false);
        this.setupSyncedScroll(true);
    }

    public Role role() {
        return this.role;
    }

    public abstract Scrollable scrollable();

    protected void scrollOther(Scrollable scrollable, ScrollBar scrollBar, int n) {
        scrollBar.setSelection(n);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (!bl && this.isFocusControl()) {
            this.getParent().setFocus();
        }
    }

    protected void setupSyncedScroll(final boolean bl) {
        ScrollBar scrollBar;
        Scrollable scrollable = this.scrollable();
        ScrollBar scrollBar2 = scrollBar = bl ? scrollable.getVerticalBar() : scrollable.getHorizontalBar();
        if (scrollBar != null) {
            scrollBar.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    ContentArea.this.view.scrollOthers(ContentArea.this.role, (ScrollBar)event.widget, bl);
                }
            });
        }
    }

    public void setVisible(boolean bl) {
        boolean bl2 = this.isFocusControl();
        super.setVisible(bl);
        if (!bl && bl2) {
            this.getParent().setFocus();
        }
    }
}

