/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui;

import com.deltawalker.BoldFontCache;
import com.deltawalker.DiffDocAdapter;
import com.deltawalker.Msg;
import com.deltawalker.PrefKey;
import com.deltawalker.interfaces.IDiffDoc;
import com.deltawalker.interfaces.IDiffDocListener;
import com.deltawalker.interfaces.IDiffModel;
import com.deltawalker.interfaces.IFilter;
import com.deltawalker.interfaces.IFilters;
import com.deltawalker.interfaces.IFiltersListener;
import com.deltawalker.interfaces.IFolderFilter;
import com.deltawalker.interfaces.IStructDiffModel;
import com.deltawalker.interfaces.ITextDiffModel;
import com.deltawalker.interfaces.ITextFilter;
import com.deltawalker.structure.FolderFilter;
import com.deltawalker.ui.BaseExpandable;
import com.deltawalker.ui.DiffView;
import com.deltopia.StringUtil;
import com.deltopia.interfaces.IMvcController;
import com.deltopia.interfaces.IMvcModel;
import com.deltopia.jface.util.DialogUtil;
import com.deltopia.ui.concurrency.GuiExecutor;
import com.deltopia.util.OS;
import java.util.List;
import java.util.Set;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class CommonPrefsExpandable
extends BaseExpandable {
    public static final int V_SPACING = 0;
    private Composite cmpFilters;
    private final IDiffDocListener onDeltaInput = new DiffDocAdapter(){

        @Override
        public void comparing() {
            GuiExecutor.instance().execute(new Runnable(){

                @Override
                public void run() {
                    CommonPrefsExpandable.this.client().setEnabled(false);
                }
            });
        }

        @Override
        public void done() {
            GuiExecutor.instance().execute(new Runnable(){

                @Override
                public void run() {
                    CommonPrefsExpandable.this.client().setEnabled(true);
                }
            });
        }
    };
    private final IFiltersListener onFilters = new IFiltersListener(){

        @Override
        public void filtersChanged(Set<? extends IFilter> set) {
            if (CommonPrefsExpandable.this.populate) {
                GuiExecutor.instance().execute(new Runnable(){

                    @Override
                    public void run() {
                        CommonPrefsExpandable.this.populateFiltersSection();
                    }
                });
            }
        }
    };
    private boolean populate = true;

    public CommonPrefsExpandable(Composite composite, int n, DiffView diffView) {
        super(composite, n, diffView);
        this.setMenu(composite.getMenu());
        this.setFont(BoldFontCache.get(this.getFont()));
        this.setText(Msg.Common_settings);
        this.setLayout((Layout)DialogUtil.createGridLayout(1, 5, 0, 0));
        this.setLayoutData(DialogUtil.createFillGridData());
    }

    @Override
    public void connect(IMvcModel iMvcModel, IMvcController iMvcController) {
        super.connect(iMvcModel, iMvcController);
        IDiffDoc iDiffDoc = this.view.model();
        if (iDiffDoc != null) {
            iDiffDoc.filters().addFilterListener(this.onFilters);
            iDiffDoc.addDiffDocListener(this.onDeltaInput);
            this.populateFiltersSection();
        }
    }

    protected void createFiltersSection() {
        Composite composite = DialogUtil.createSectionComposite(this.client());
        DialogUtil.createSectionTitle(composite, "Exclude (-)/Include (+)", false);
        final ScrolledComposite scrolledComposite = new ScrolledComposite(composite, 512);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        this.cmpFilters = new Composite((Composite)scrolledComposite, 0);
        this.cmpFilters.setLayout((Layout)DialogUtil.createGridLayout(1, 0, 0, 0));
        scrolledComposite.setContent((Control)this.cmpFilters);
        this.cmpFilters.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                Point point = CommonPrefsExpandable.this.cmpFilters.computeSize(-1, -1);
                scrolledComposite.setMinSize(point);
            }
        });
        int n = this.populateFiltersSection();
        GridData gridData = new GridData(16384, 4, true, true);
        gridData.heightHint = n * 3;
        scrolledComposite.setLayoutData((Object)gridData);
        if (OS.WIN) {
            scrolledComposite.getVerticalBar().setIncrement(6);
        }
    }

    protected void createIgnoreSection() {
        Composite composite = DialogUtil.createSectionComposite(this.client());
        Composite composite2 = new Composite(composite, 0);
        int n = this.showSeparators() ? 2 : 1;
        composite2.setLayout((Layout)DialogUtil.createGridLayout(n, 0, 0, 0));
        composite2.setLayoutData((Object)DialogUtil.createFillGridData());
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayout((Layout)DialogUtil.createGridLayout(1, 0, 0, 0));
        composite3.setLayoutData((Object)new GridData(1, 4, true, true));
        DialogUtil.createSectionTitle(composite3, "Ignore", false);
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Button button = (Button)selectionEvent.widget;
                Object object = button.getData();
                if (object instanceof String) {
                    boolean bl = button.getSelection();
                    CommonPrefsExpandable.this.prefs.setValue(object.toString(), bl);
                }
            }
        };
        String string = PrefKey.C_IGNORE_WHITESPACE.toString();
        Button button = DialogUtil.addButton(composite3, Msg.TextPrefPage_ignoreWhitespaceShort, string, null, 2, (SelectionListener)selectionAdapter);
        this.buttons.put(string, button);
        string = PrefKey.C_IGNORE_LINE_ENDINGS.toString();
        button = DialogUtil.addButton(composite3, Msg.TextPrefPage_ignoreLineEndingsShort, PrefKey.C_IGNORE_LINE_ENDINGS.toString(), null, 2, (SelectionListener)selectionAdapter);
        this.buttons.put(string, button);
        string = PrefKey.C_IGNORE_CHAR_CASE.toString();
        button = DialogUtil.addButton(composite3, Msg.TextPrefPage_ignoreCharCaseShort, string, null, 2, (SelectionListener)selectionAdapter);
        this.buttons.put(string, button);
        if (this.showSeparators()) {
            BaseExpandable.createCompositeSeparator(composite2, 2);
        }
    }

    @Override
    public void disconnect() {
        super.disconnect();
        IDiffDoc iDiffDoc = this.view.model();
        if (iDiffDoc != null && iDiffDoc.filters() != null) {
            iDiffDoc.filters().removeFilterListener(this.onFilters);
            iDiffDoc.removeDiffDocListener(this.onDeltaInput);
        }
    }

    @Override
    protected String expandPrefKey() {
        return PrefKey.D_EXPAND_SETTINGS.toString();
    }

    private int populateFiltersSection() {
        String string;
        Button button;
        Object object;
        Control[] controlArray;
        Control[] controlArray2 = controlArray = this.cmpFilters.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = controlArray2[n2];
            object.dispose();
            ++n2;
        }
        object = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                block11: {
                    Button button = (Button)selectionEvent.widget;
                    IFilters iFilters = CommonPrefsExpandable.this.view.getInput().filters();
                    IFilter iFilter = (IFilter)button.getData();
                    if (iFilter != null) {
                        CommonPrefsExpandable.this.populate = false;
                        try {
                            boolean bl = button.getSelection();
                            IDiffModel iDiffModel = CommonPrefsExpandable.this.view.deltaModel();
                            if (iDiffModel instanceof IStructDiffModel) {
                                IStructDiffModel iStructDiffModel = (IStructDiffModel)iDiffModel;
                                iStructDiffModel.getRoot().deepEnableUpdate(false);
                                try {
                                    iFilters.updateEnabled(iFilter, bl);
                                    break block11;
                                }
                                finally {
                                    iStructDiffModel.getRoot().deepEnableUpdate(true);
                                }
                            }
                            if (iDiffModel instanceof ITextDiffModel) {
                                iFilters.updateEnabled(iFilter, bl);
                            } else if (!$assertionsDisabled) {
                                throw new AssertionError();
                            }
                        }
                        finally {
                            CommonPrefsExpandable.this.populate = true;
                        }
                    }
                }
            }
        };
        IFilters iFilters = this.view.getInput().filters();
        List<IFilter> list = iFilters.getAllAsList();
        int n3 = 32;
        int n4 = -1;
        boolean bl = false;
        for (IFilter iFilter : list) {
            if (!(iFilter instanceof IFolderFilter)) continue;
            bl = true;
            button = new Button(this.cmpFilters, n3, BaseExpandable.BEZEL_STYLE_EX);
            string = "{0}    ({1})";
            FolderFilter.Action action = ((IFolderFilter)iFilter).action();
            String string2 = "";
            switch (action) {
                case INCLUDE: {
                    string2 = "+";
                    break;
                }
                case EXCLUDE: {
                    string2 = "-";
                    break;
                }
                case ALIGN: {
                    string2 = "A";
                }
            }
            String string3 = StringUtil.ellipsize((String)iFilter.getDisplayExpression(), (Control)this, (int)250);
            String string4 = NLS.bind((String)string, (Object)string3, (Object)string2);
            button.setText(string4);
            button.setSelection(iFilter.isEnabled());
            button.setData((Object)iFilter);
            button.addSelectionListener((SelectionListener)object);
            if (n4 == -1) {
                n4 = button.computeSize((int)-1, (int)-1).y;
            }
            button.setVisible(true);
        }
        if (bl) {
            IFilter iFilter;
            iFilter = new Label(this.cmpFilters, 0);
            iFilter.setLayoutData(new GridData(16384, 128, false, false));
            iFilter.setText("---------------------");
        }
        for (IFilter iFilter : list) {
            if (!(iFilter instanceof ITextFilter) || !((ITextFilter)iFilter).isVisible()) continue;
            button = new Button(this.cmpFilters, n3, BaseExpandable.BEZEL_STYLE_EX);
            string = StringUtil.ellipsize((String)iFilter.getDescription(), (Control)this, (int)150);
            button.setText(string);
            button.setSelection(iFilter.isEnabled());
            button.setData((Object)iFilter);
            button.addSelectionListener((SelectionListener)object);
            if (n4 != -1) continue;
            n4 = button.computeSize((int)-1, (int)-1).y;
        }
        this.cmpFilters.layout();
        return n4;
    }
}

