/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui;

import com.deltawalker.ui.UIMsg;
import com.deltopia.StringUtil;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckboxTable<I extends Item> {
    private static final Logger LOG = LoggerFactory.getLogger(CheckboxTable.class);
    private static final String KEY_TABLE_ITEM = "com.deltawalker.table.item";
    private static final String COL_NAME = "Name";
    private static final String COL_DESC = "Description";
    protected final Composite tblParent;
    protected final Table table;
    private final String prefix;
    private final List<Entry> model = new LinkedList<Entry>();

    public CheckboxTable(Composite composite, int n, String string, int n2) {
        if (StringUtil.isEmpty((String)string)) {
            throw new IllegalArgumentException("prefix");
        }
        this.tblParent = new Composite(composite, n);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        this.tblParent.setLayout((Layout)tableColumnLayout);
        GridData gridData = new GridData(4, 4, true, true);
        this.tblParent.setLayoutData((Object)gridData);
        this.table = new Table(this.tblParent, 68384);
        this.prefix = string;
        this.table.setHeaderVisible(true);
        if (n2 > 0 && n2 < 100) {
            this.addColumn(COL_NAME, n2);
            this.addColumn(COL_DESC, 400);
        }
        Handler handler = new Handler();
        this.table.addListener(13, (Listener)handler);
        this.packTable();
    }

    protected final String getString(String string) {
        ResourceBundle resourceBundle = UIMsg.constructedKeyBundle();
        return resourceBundle.getString(String.valueOf(this.prefix) + string);
    }

    public final void addItem(I i, boolean bl) {
        if (i == null) {
            throw new NullPointerException("item");
        }
        Entry entry = new Entry(this, (Item)i, bl);
        TableItem tableItem = new TableItem(this.table, 0);
        tableItem.setData(KEY_TABLE_ITEM, (Object)entry);
        tableItem.setText(0, ((Item)i).getName());
        tableItem.setText(1, ((Item)i).getDescription());
        tableItem.setChecked(bl);
        this.model.add(entry);
    }

    public final Set<I> getCheckedItems() {
        LinkedHashSet<Item> linkedHashSet = new LinkedHashSet<Item>(this.model.size());
        for (Entry entry : this.model) {
            if (!entry.checked) continue;
            linkedHashSet.add(entry.item);
        }
        return linkedHashSet;
    }

    public final Set<I> getSelectedItems() {
        LinkedHashSet<Item> linkedHashSet = new LinkedHashSet<Item>(this.model.size());
        for (Entry entry : this.model) {
            if (!entry.selected) continue;
            linkedHashSet.add(entry.item);
        }
        return linkedHashSet;
    }

    private final void addColumn(String string, int n) {
        if (StringUtil.isEmpty((String)string)) {
            throw new IllegalArgumentException("columnId");
        }
        TableColumn tableColumn = new TableColumn(this.table, 0);
        String string2 = this.getString(String.valueOf(string) + ".column");
        tableColumn.setText(string2);
        if (n > 0) {
            TableColumnLayout tableColumnLayout = (TableColumnLayout)this.table.getParent().getLayout();
            tableColumnLayout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(n));
        }
    }

    public final void packTable() {
        int n = 0;
        while (n < this.table.getColumnCount()) {
            this.table.getColumn(n).pack();
            ++n;
        }
        this.table.pack();
    }

    private final class Entry {
        private final I item;
        private boolean checked;
        private boolean selected;
        final /* synthetic */ CheckboxTable this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        private Entry(I i, boolean bl) {
            this.this$0 = (CheckboxTable)n;
            this.item = i;
            this.checked = bl;
        }

        public String toString() {
            return this.item + ", checked=" + this.checked;
        }
    }

    private class Handler
    implements Listener {
        private Handler() {
        }

        public void handleEvent(Event event) {
            if (event.detail == 32) {
                this.onCheckItem((TableItem)event.item);
            } else {
                this.onSelect();
            }
        }

        private void onCheckItem(TableItem tableItem) {
            Object object = tableItem.getData(CheckboxTable.KEY_TABLE_ITEM);
            Entry entry = (Entry)object;
            entry.checked = tableItem.getChecked();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Checked: " + entry);
            }
        }

        private void onSelect() {
            int[] nArray = CheckboxTable.this.table.getSelectionIndices();
            Arrays.sort(nArray);
            int n = 0;
            while (n < CheckboxTable.this.model.size()) {
                Entry entry = (Entry)CheckboxTable.this.model.get(n);
                entry.selected = Arrays.binarySearch(nArray, n) >= 0;
                LOG.debug("Select: " + entry);
                ++n;
            }
        }
    }

    public static class Item {
        private final String name;
        private final String description;

        public Item(String string, String string2) {
            if (StringUtil.isEmpty((String)string)) {
                throw new IllegalArgumentException("name");
            }
            this.name = string;
            this.description = string2 != null ? string2 : "-";
        }

        public String toString() {
            return "name='" + this.name + "', description='" + this.description + '\'';
        }

        final String getName() {
            return this.name;
        }

        final String getDescription() {
            return this.description;
        }
    }
}

