/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui;

import com.deltawalker.Delta;
import com.deltawalker.ui.DeltaPart;
import com.deltawalker.ui.DiffView;
import com.deltopia.ui.concurrency.BackgroundTask;
import com.deltopia.util.OS;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public abstract class BirdsEye
extends Canvas {
    public static final int INSET = 2;
    protected static final int LINE_WIDTH = 1;
    public static final int WIDTH = OS.LINUX ? 20 : 12;
    private boolean clearMarkers = false;
    private final DiffView dView;
    private final ExecutorService exec = Executors.newCachedThreadPool();
    protected volatile int height;
    private final Listener listener = new Listener(){

        public void handleEvent(Event event) {
            switch (event.type) {
                case 3: 
                case 5: {
                    BirdsEye.this.handleMouseEvent(event);
                    break;
                }
                case 9: {
                    BirdsEye.this.paint(event.gc);
                    break;
                }
                case 11: {
                    BirdsEye.this.clearMarkers = true;
                    BirdsEye.this.cacheHeight();
                    if (BirdsEye.this.skipEvent[0]) {
                        return;
                    }
                    ((BirdsEye)BirdsEye.this).skipEvent[0] = true;
                    BirdsEye.this.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!BirdsEye.this.exec.isShutdown()) {
                                BirdsEye.this.exec.execute((Runnable)BirdsEye.this.createMarkerTask());
                            }
                            ((BirdsEye)(this).BirdsEye.this).skipEvent[0] = false;
                        }
                    });
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
        }
    };
    protected final List<Marker> markers = new CopyOnWriteArrayList<Marker>();
    private BackgroundTask<?> markerTask;
    private Cursor oldCursor;
    protected float scale = 1.0f;
    private final boolean[] skipEvent = new boolean[1];
    private DefaultToolTip toolTip;

    public BirdsEye(Composite composite, DiffView diffView) {
        super(composite, 0x20080000);
        this.dView = diffView;
        this.addListener(3, this.listener);
        this.addListener(5, this.listener);
        this.addListener(9, this.listener);
        this.addListener(11, this.listener);
        this.toolTip = new DefaultToolTip((Control)this){

            protected String getText(Event event) {
                Color[] colorArray = new Color[1];
                String string = BirdsEye.this.getToolTipText(event, colorArray);
                Color color = colorArray[0] != null ? colorArray[0] : BirdsEye.this.getDisplay().getSystemColor(29);
                BirdsEye.this.toolTip.setBackgroundColor(color);
                return string == null ? super.getText(event) : string;
            }

            protected boolean shouldCreateToolTip(Event event) {
                if (!super.shouldCreateToolTip(event)) {
                    return false;
                }
                return this.getText(event) != null;
            }
        };
        this.toolTip.setShift(new Point(0, 16));
        this.toolTip.setPopupDelay(0);
        this.toolTip.setFont(JFaceResources.getFont((String)"com.deltawalker.ui.editorFont"));
        if (OS.OSX) {
            this.setBackground(this.getDisplay().getSystemColor(25));
        }
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                BirdsEye.this.dispose();
                BirdsEye.this.exec.shutdownNow();
            }
        });
    }

    protected boolean areMarkersUpToDate() {
        for (Marker marker : this.markers) {
            if (marker.isUpToDate()) continue;
            return false;
        }
        return true;
    }

    protected void cacheHeight() {
        this.height = Math.max(1, this.getClientArea().height);
    }

    protected void clearMarkers() {
        for (Marker marker : this.markers) {
            marker.dispose();
        }
        this.markers.clear();
    }

    protected abstract List<Marker> createMarkers();

    private BackgroundTask<?> createMarkerTask() {
        if (this.markerTask != null) {
            this.markerTask.cancel(true);
        }
        this.markerTask = new BackgroundTask<Void>(){

            public Void compute() {
                BirdsEye.this.createMarkers();
                return null;
            }

            protected void onCompletion(Void void_, Throwable throwable, boolean bl) {
                BirdsEye.this.markerTask = null;
                if (!BirdsEye.super.isDisposed()) {
                    BirdsEye.super.redraw();
                    BirdsEye.super.update();
                }
            }
        };
        return this.markerTask;
    }

    protected abstract Color getColor(Marker var1, DeltaPart var2, boolean var3);

    protected abstract String getToolTipText(Event var1, Color[] var2);

    private void handleMouseEvent(Event event) {
        Delta delta;
        Cursor cursor = this.dView.getCursor(21);
        Marker marker = this.hitTest(event.y);
        Delta delta2 = delta = marker != null ? marker.delta() : null;
        if (event.type == 3) {
            if (delta != null) {
                this.select(delta);
            }
        } else if (event.type == 5) {
            Cursor cursor2 = null;
            if (delta != null) {
                cursor2 = cursor;
            }
            if (cursor2 != this.oldCursor) {
                this.setCursor(cursor2);
                this.oldCursor = cursor2;
            }
        }
    }

    protected Marker hitTest(int n) {
        for (Marker marker : this.markers) {
            if (!marker.spans(n)) continue;
            return marker;
        }
        return null;
    }

    protected abstract boolean isMarkerSelected(Marker var1);

    protected void paint(GC gC) {
        if (this.markers.isEmpty()) {
            return;
        }
        int n = this.getClientArea().width - 4;
        Color color = gC.getBackground();
        Color color2 = gC.getForeground();
        for (Marker marker : this.markers) {
            boolean bl = this.isMarkerSelected(marker);
            int n2 = 1 * (bl ? 2 : 1);
            int n3 = 2 + n2;
            int n4 = marker.y + n2;
            int n5 = n - n2 - (OS.LINUX ? 8 : 0);
            int n6 = marker.height - n2;
            Color color3 = this.getColor(marker, DeltaPart.BG, bl);
            if (color3 == null) {
                color3 = color;
            }
            gC.setBackground(color3);
            gC.fillRectangle(n3, n4, n5, n6);
            Color color4 = this.getColor(marker, DeltaPart.BORDER, bl);
            if (color4 == null) {
                color4 = color2;
            }
            gC.setForeground(color4);
            gC.setLineWidth(n2);
            gC.drawRectangle(n3, n4, n5, n6);
        }
    }

    public void refresh() {
        this.clearMarkers = true;
        this.cacheHeight();
        if (!this.exec.isShutdown()) {
            this.exec.execute((Runnable)this.createMarkerTask());
        }
    }

    protected abstract void select(Delta var1);

    protected boolean shouldRecreateMarkers() {
        if (this.clearMarkers) {
            this.clearMarkers = false;
            return true;
        }
        return !this.areMarkersUpToDate();
    }

    protected DiffView view() {
        return this.dView;
    }

    public abstract class Marker {
        public static final int MIN_HEIGHT = 3;
        protected Delta delta;
        public int height;
        private boolean merged = false;
        public int y;

        protected Marker() {
        }

        protected Marker(int n, int n2) {
            this.y = n;
            this.height = Math.max(n2, 3);
        }

        public boolean canMergeWith(Marker marker) {
            return this.spans(marker.y) && this.delta().isOverallKind(marker.delta());
        }

        public abstract boolean containsDelta(Delta var1);

        public Delta delta() {
            return this.delta;
        }

        public abstract void dispose();

        public abstract boolean isUpToDate();

        public void mergeWith(Marker marker) {
            if (marker == null) {
                throw new NullPointerException("marker");
            }
            int n = this.y + this.height;
            int n2 = marker.y + marker.height;
            if (n < n2) {
                this.height += n2 - n;
                this.merged = true;
            }
        }

        public boolean spans(int n) {
            return n >= this.y && n <= this.y + this.height;
        }

        public String toString() {
            return "y=" + this.y + "    h=" + this.height + "    m=" + this.merged;
        }
    }
}

