/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui;

import com.deltawalker.interfaces.IDiffDoc;
import com.deltawalker.ui.DiffController;
import com.deltawalker.ui.DiffView;
import com.deltopia.interfaces.IMvcController;
import com.deltopia.interfaces.IMvcModel;
import com.deltopia.interfaces.IMvcView;
import com.deltopia.jface.util.DialogUtil;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

public abstract class BaseExpandable
extends ExpandableComposite
implements IMvcView {
    protected static int BEZEL_STYLE_EX = DialogUtil.BEZEL_STYLE_EX;
    public static final int V_SPACING = 0;
    protected Map<Object, Button> buttons = new HashMap<Object, Button>();
    private Composite cmpClient;
    private Composite cmpInnerClient;
    protected SelectionListener onBtnSelect = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            this.widgetSelected(selectionEvent);
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            Button button = (Button)selectionEvent.widget;
            String string = (String)button.getData();
            IAction iAction = BaseExpandable.this.view.controller().getAction(string);
            if (iAction != null) {
                if (BaseExpandable.this.shouldRunWithEvent(iAction)) {
                    Event event = new Event();
                    event.stateMask = selectionEvent.stateMask;
                    iAction.runWithEvent(event);
                } else {
                    iAction.run();
                }
                button.setEnabled(iAction.isEnabled());
            }
        }
    };
    protected IPreferenceStore prefs;
    protected DiffView view;

    public static Control createCompositeSeparator(final Composite composite, final int n) {
        final Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)DialogUtil.createGridLayout(1, 0, 0, 2));
        composite2.setLayoutData((Object)new GridData(131072, 4, false, true));
        composite2.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                if (composite2.isDisposed()) {
                    return;
                }
                Rectangle rectangle = composite2.getBounds();
                GC gC = event.gc;
                gC.setBackground(composite.getDisplay().getSystemColor(16));
                gC.setForeground(composite.getDisplay().getSystemColor(15));
                gC.fillGradientRectangle(0, 0 + n, 1, rectangle.height - 2 * n, true);
            }
        });
        return composite2;
    }

    public BaseExpandable(Composite composite, int n, DiffView diffView) {
        super(composite, n, 18);
        this.view = diffView;
        this.prefs = diffView.getInput().preferences();
        this.setLayoutData(DialogUtil.createFillGridData());
        this.cmpClient = new Composite((Composite)this, 0);
        this.setClient((Control)this.cmpClient);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginBottom = gridLayout.marginWidth;
        gridLayout.marginWidth = 0;
        this.cmpClient.setLayout((Layout)gridLayout);
        this.cmpClient.setLayoutData((Object)new GridData(4, 4, true, true));
        if (this.useInnerClient()) {
            this.cmpInnerClient = new Composite(this.cmpClient, 0);
            gridLayout = new GridLayout();
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            gridLayout.horizontalSpacing *= 4;
            gridLayout.verticalSpacing = 0;
            this.cmpInnerClient.setLayout((Layout)gridLayout);
            this.cmpInnerClient.setLayoutData((Object)new GridData(0x1000000, 4, true, true));
        }
        final String string = this.expandPrefKey();
        boolean bl = this.prefs.getBoolean(string);
        this.setExpanded(bl);
        this.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent expansionEvent) {
                BaseExpandable.this.view.getInput().preferences().setValue(string, String.valueOf(expansionEvent.getState()));
            }
        });
    }

    protected Composite client() {
        return this.useInnerClient() ? this.cmpInnerClient : this.cmpClient;
    }

    public void connect(IMvcModel iMvcModel, IMvcController iMvcController) {
        this.prefs = ((IDiffDoc)iMvcModel).preferences();
        this.updateUI();
    }

    public Control control() {
        return this;
    }

    public IMvcController controller() {
        return null;
    }

    public void disconnect() {
        this.prefs = null;
    }

    public void dispose() {
        try {
            this.disconnect();
            this.view = null;
        }
        finally {
            super.dispose();
        }
    }

    protected abstract String expandPrefKey();

    public void layout() {
        super.layout();
        Composite composite = this.view.rootComposite();
        if (composite != null && !composite.isDisposed()) {
            composite.layout();
        }
    }

    public IDiffDoc model() {
        return null;
    }

    public boolean prefChanged(IPreferenceStore iPreferenceStore, String string) {
        Button button = this.buttons.get(string);
        if (button != null && (button.getStyle() & 0x20) != 0) {
            button.setSelection(iPreferenceStore.getBoolean(string));
            return true;
        }
        return false;
    }

    protected boolean shouldRunWithEvent(IAction iAction) {
        return false;
    }

    protected boolean showSeparators() {
        return false;
    }

    protected void updateUI() {
        DiffController diffController = this.view.controller();
        for (Button button : this.buttons.values()) {
            boolean bl;
            String string = (String)button.getData();
            IAction iAction = diffController.getAction(string);
            if (iAction != null) {
                if ((iAction.getStyle() & 2) != 0) {
                    button.setSelection(iAction.isChecked());
                }
                button.setEnabled(iAction.isEnabled());
                continue;
            }
            if (string.equals("showWhitespaceCharacters")) {
                bl = EditorsUI.getPreferenceStore().getBoolean(string);
                button.setSelection(bl);
                continue;
            }
            bl = this.prefs.getBoolean(string);
            button.setSelection(bl);
        }
    }

    protected boolean useInnerClient() {
        return true;
    }
}

