/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui;

import com.deltawalker.App;
import com.deltawalker.DocType;
import com.deltawalker.IPersistable;
import com.deltawalker.PrefKey;
import com.deltawalker.PrefUtil;
import com.deltawalker.Relation;
import com.deltawalker.UriInfo;
import com.deltawalker.interfaces.IDiffDoc;
import com.deltawalker.interfaces.IDoc;
import com.deltawalker.internal.ui.RefreshFromStorageAlert;
import com.deltawalker.resources.IResource;
import com.deltawalker.script.Role;
import com.deltawalker.sound.SoundPlayer;
import com.deltawalker.ui.Alert;
import com.deltawalker.ui.AlertService;
import com.deltawalker.ui.DiffController;
import com.deltawalker.ui.DiffView;
import com.deltawalker.ui.IAlert;
import com.deltawalker.ui.IAlertService;
import com.deltawalker.ui.UIMsg;
import com.deltopia.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Alerts {
    private static String INTRO_MESSAGE_KEY = "INTRO_MESSAGE_KEY";
    private static final Logger LOG = LoggerFactory.getLogger(Alerts.class);
    private DiffController dCtlr;
    private boolean hideStgRemovedAlert = true;
    private String keyDocEx;
    private String keyIOError;
    private String keyMismatch;
    private String keyPropChange;
    private String keyRefresh;
    private String keyStgRemoved;
    private final IAlertService service = new AlertService();

    public static String fetchErrorMessage(Throwable throwable) {
        String string = "";
        Throwable throwable2 = throwable.getCause();
        if (throwable2 != null) {
            string = throwable2.getLocalizedMessage();
        }
        if (StringUtil.isEmpty((String)string)) {
            string = throwable.getLocalizedMessage();
        }
        return StringUtil.makeSafe((String)string);
    }

    public static boolean hasInvalidUri(Map<Role, UriInfo> map, boolean bl) {
        Set<Role> set = Relation.roles(bl);
        for (Role role : set) {
            if (!map.get((Object)role).hasError()) continue;
            return true;
        }
        return false;
    }

    public Alerts(DiffController diffController) {
        this.dCtlr = diffController;
    }

    public void alertForInvalidUris(Map<Role, UriInfo> map, IDiffDoc iDiffDoc) {
        DiffView diffView = this.dCtlr.view();
        if (map == null) {
            map = diffView.uriChooserBoss().uriInfos();
        }
        ArrayList<UriInfo> arrayList = new ArrayList<UriInfo>();
        for (Role role : diffView.roles()) {
            UriInfo uriInfo = map.get((Object)role);
            if (!uriInfo.hasError()) continue;
            arrayList.add(uriInfo);
            Set<Role> set = Relation.others(role, diffView.isThreeWay());
            boolean bl = false;
            for (Role role2 : set) {
                if (map.get((Object)role2).hasError()) continue;
                bl = true;
            }
            if (bl) continue;
            App.instance().docBoss().remove(iDiffDoc);
        }
        boolean bl = this.canShowIOError(arrayList);
        this.showIOError(bl, arrayList);
    }

    protected boolean canShowIOError(List<UriInfo> list) {
        return list.size() > 0 && this.dCtlr.model().docType() != DocType.PREVIEW;
    }

    private String constructIOErrorMessage(List<UriInfo> list, String string) {
        assert (!list.isEmpty());
        assert (list.size() <= Role.count());
        ArrayList<String> arrayList = new ArrayList<String>();
        for (UriInfo uriInfo : list) {
            Throwable throwable = uriInfo.error();
            assert (throwable != null);
            String string2 = Alerts.fetchErrorMessage(throwable);
            if (string2.isEmpty() || arrayList.contains(string2)) continue;
            String string3 = uriInfo.uri();
            arrayList.add(string2);
        }
        assert (!arrayList.isEmpty());
        StringBuilder stringBuilder = new StringBuilder();
        for (String string4 : arrayList) {
            stringBuilder.append(string4);
            stringBuilder.append('\n');
        }
        return stringBuilder.toString().trim();
    }

    protected DiffController controller() {
        return this.dCtlr;
    }

    protected String getIntroText() {
        return UIMsg.Alerts_introTip;
    }

    public void inputChanged() {
        IAlertService iAlertService = this.service();
        if (iAlertService != null) {
            if (this.keyDocEx != null) {
                iAlertService.removeAlert(this.keyDocEx);
            }
            if (this.keyPropChange != null) {
                iAlertService.removeAlert(this.keyPropChange);
            }
            if (this.keyRefresh != null) {
                iAlertService.removeAlert(this.keyRefresh);
            }
        }
    }

    public IAlertService service() {
        return this.service;
    }

    public void showDocException(boolean bl, Map<IDoc, Exception> map) {
        Map.Entry<IDoc, Exception> entry2;
        if (!bl) {
            this.service.removeAlert(this.keyDocEx);
            return;
        }
        if (map == null) {
            throw new NullPointerException("doc2ex");
        }
        ArrayList<UriInfo> arrayList = new ArrayList<UriInfo>();
        for (Map.Entry<IDoc, Exception> entry2 : map.entrySet()) {
            Exception exception = entry2.getValue();
            if (exception == null) continue;
            IDoc iDoc = (IDoc)entry2.getKey();
            arrayList.add(iDoc.uriInfo().cloneUpdateError(exception));
        }
        entry2 = this.service.getAlert(this.keyDocEx);
        String string = this.constructIOErrorMessage(arrayList, "inputException");
        if (entry2 != null) {
            entry2.setText(string);
            LOG.error(string);
        } else {
            entry2 = new Alert(null, string, 1, 64);
            this.keyDocEx = this.service.addAlert((IAlert)((Object)entry2));
        }
    }

    public void showIntroHint(boolean bl, boolean bl2) {
        boolean bl3 = false;
        Set<Role> set = this.dCtlr.view().roles();
        for (Object object : set) {
            IDoc iDoc = this.dCtlr.getSubInput((Role)((Object)object));
            if (iDoc == null) {
                LOG.error("dCtlr.getSubInput(role) returned null for " + (Object)object);
                continue;
            }
            if (iDoc.resource() == null) continue;
            bl3 = true;
            break;
        }
        if (bl && !bl3 && PrefUtil.getGlobalPrefs().getBoolean(PrefKey.C_SHOW_INTRO_ALERT.toString())) {
            Object object;
            object = new Alert(INTRO_MESSAGE_KEY, this.getIntroText(), 2, 64){

                @Override
                public void onClose() {
                    PrefUtil.getGlobalPrefs().setValue(PrefKey.C_SHOW_INTRO_ALERT.toString(), false);
                }
            };
            this.service.addAlert((IAlert)object);
        }
        if (bl3 || bl2) {
            this.service.removeAlert(INTRO_MESSAGE_KEY);
        }
    }

    public void showIOError(boolean bl, List<UriInfo> list) {
        if (!bl) {
            this.service.removeAlert(this.keyIOError);
            return;
        }
        IAlert iAlert = this.service.getAlert(this.keyIOError);
        String string = this.constructIOErrorMessage(list, "ioError");
        if (iAlert != null) {
            iAlert.setText(string);
            LOG.warn(string);
        } else {
            iAlert = new Alert(null, string, 1, 64);
            this.keyIOError = this.service.addAlert(iAlert);
        }
    }

    public void showPropertyChange(boolean bl, PropertyChangeEvent propertyChangeEvent, String string) {
        if (bl) {
            if (string != null) {
                this.service.removeAlert(this.keyPropChange);
                Alert alert = new Alert(null, string, 2, 64);
                this.keyPropChange = this.service.addAlert(alert);
            }
        } else {
            this.service.removeAlert(this.keyPropChange);
        }
    }

    public void showRefresh(IResource iResource, Runnable runnable) {
        IAlert iAlert = this.service.getAlert(this.keyRefresh);
        if (iAlert != null) {
            ((RefreshFromStorageAlert)iAlert).add(iResource, runnable);
        } else {
            iAlert = new RefreshFromStorageAlert(this.dCtlr.view(), iResource, runnable);
            this.keyRefresh = this.service.addAlert(iAlert);
        }
        if (PrefUtil.getGlobalPrefs().getBoolean(PrefKey.C_CHIME_ON_ALERT.toString())) {
            new SoundPlayer(SoundPlayer.Sound.ALERT.toString()).play();
        }
    }

    public void showResourceMismatch(boolean bl, String string) {
        if (!bl) {
            this.service.removeAlert(this.keyMismatch);
            return;
        }
        IAlert iAlert = this.service.getAlert(this.keyMismatch);
        if (iAlert != null) {
            iAlert.setText(string);
            LOG.warn(string);
        } else {
            iAlert = new Alert(null, string, 8, 64);
            this.keyMismatch = this.service.addAlert(iAlert);
        }
    }

    public void showStorageRemoved(boolean bl, IDoc iDoc) {
        if (!bl) {
            if (this.hideStgRemovedAlert) {
                this.service.removeAlert(this.keyStgRemoved);
            }
            return;
        }
        String string = NLS.bind((String)(iDoc.docType() == DocType.FOLDER ? UIMsg.Alerts_folderStgRemoved : UIMsg.Alerts_fileStgRemoved), (Object)iDoc.uriInfo().uri());
        IAlert iAlert = this.service.getAlert(this.keyStgRemoved);
        if (iAlert == null) {
            this.keyStgRemoved = this.service.addAlert(new Alert(null, string, 8, 64));
        } else {
            iAlert.setText(string);
        }
        this.hideStgRemovedAlert = false;
        if (iDoc instanceof IPersistable) {
            ((IPersistable)((Object)iDoc)).setModified(true);
        }
        this.hideStgRemovedAlert = true;
        if (PrefUtil.getGlobalPrefs().getBoolean(PrefKey.C_CHIME_ON_ALERT.toString())) {
            new SoundPlayer(SoundPlayer.Sound.ALERT.toString()).play();
        }
    }
}

