/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui;

import com.deltawalker.internal.ui.AlertPresenter;
import com.deltawalker.ui.IAlert;
import com.deltawalker.ui.IAlertPresenter;
import com.deltawalker.ui.IAlertService;
import com.deltopia.ui.concurrency.GuiExecutor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class AlertService
implements IAlertService {
    private static Point EMPTY_POINT = new Point(0, 0);
    private Composite cmpAlert;
    private boolean disposed;
    private final Map<String, AlertPresentation> presentations = new HashMap<String, AlertPresentation>();
    private final List<IAlertPresenter> presenters = new ArrayList<IAlertPresenter>();

    public AlertService() {
        this.addPresenter(new AlertPresenter());
    }

    @Override
    public String addAlert(IAlert iAlert) {
        String string = iAlert.getKey();
        if (this.hasAlert(string)) {
            return string;
        }
        for (IAlertPresenter iAlertPresenter : this.presenters) {
            if (!iAlertPresenter.canPresent(iAlert)) continue;
            AlertPresentation alertPresentation = new AlertPresentation(iAlert, iAlertPresenter);
            this.presentations.put(string, alertPresentation);
            this.present(alertPresentation);
            return string;
        }
        return null;
    }

    @Override
    public void addPresenter(IAlertPresenter iAlertPresenter) {
        assert (iAlertPresenter != null);
        this.presenters.add(0, iAlertPresenter);
    }

    @Override
    public void clearAlerts() {
        boolean bl = false;
        for (AlertPresentation alertPresentation : this.presentations.values()) {
            if (!this.disposePresentation(alertPresentation)) continue;
            bl = true;
        }
        this.presentations.clear();
        if (bl) {
            this.layout();
        }
    }

    @Override
    public Composite createControl(Composite composite, int n) {
        if (this.cmpAlert != null) {
            if (this.cmpAlert.getParent() != composite) {
                throw new IllegalArgumentException("parent");
            }
            return this.cmpAlert;
        }
        GridLayout gridLayout = new GridLayout();
        int n2 = 1;
        gridLayout.marginWidth += n2;
        gridLayout.marginTop = gridLayout.marginHeight + n2;
        gridLayout.marginHeight = 0;
        this.cmpAlert = new Composite(composite, n | 0x40000000 | 0x40000 | 0x100000){

            public Point computeSize(int n, int n2, boolean bl) {
                if (n == 0) {
                    n = -1;
                }
                if (AlertService.this.presentations.isEmpty()) {
                    return EMPTY_POINT;
                }
                return super.computeSize(n, n2, bl);
            }
        };
        this.cmpAlert.setLayout((Layout)gridLayout);
        this.cmpAlert.setLayoutData((Object)new GridData(4, 4, true, true));
        ((GridData)this.cmpAlert.getLayoutData()).exclude = this.presentations.isEmpty();
        this.cmpAlert.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                AlertService.this.disposed = true;
                AlertService.this.cmpAlert = null;
            }
        });
        for (AlertPresentation alertPresentation : this.presentations.values()) {
            alertPresentation.present();
        }
        return this.cmpAlert;
    }

    private boolean disposePresentation(AlertPresentation alertPresentation) {
        boolean bl = false;
        if (alertPresentation != null) {
            alertPresentation.dispose();
            bl = true;
        }
        return bl;
    }

    @Override
    public IAlert getAlert(String string) {
        AlertPresentation alertPresentation = this.presentations.get(string);
        return alertPresentation != null ? alertPresentation.alert : null;
    }

    @Override
    public Composite getControl() {
        return this.cmpAlert;
    }

    @Override
    public boolean hasAlert(String string) {
        return this.presentations.containsKey(string);
    }

    private void layout() {
        if (!this.disposed) {
            this.cmpAlert.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (AlertService.this.cmpAlert != null && !AlertService.this.cmpAlert.isDisposed()) {
                        Composite composite = AlertService.this.cmpAlert.getParent();
                        while (composite != null && !composite.isDisposed()) {
                            composite.layout(true, true);
                            composite = composite.getParent();
                        }
                    }
                }
            });
        }
    }

    protected void present(final AlertPresentation alertPresentation) {
        if (this.cmpAlert == null || this.cmpAlert.isDisposed()) {
            return;
        }
        GuiExecutor.instance().execute(new Runnable(){

            @Override
            public void run() {
                ((GridData)((AlertService)AlertService.this).cmpAlert.getLayoutData()).exclude = AlertService.this.presentations.isEmpty();
                AlertService.this.presentImpl(alertPresentation);
            }
        });
    }

    private void presentImpl(final AlertPresentation alertPresentation) {
        Control control = alertPresentation.present();
        if (control == null || control.isDisposed()) {
            this.removeAlert(alertPresentation.alert.getKey());
        } else {
            control.setLayoutData((Object)new GridData(4, 4, true, true));
            control.addListener(12, new Listener(){

                public void handleEvent(Event event) {
                    AlertService.this.removeAlert(alertPresentation.alert.getKey());
                }
            });
            this.layout();
        }
    }

    @Override
    public void removeAlert(String string) {
        AlertPresentation alertPresentation = this.presentations.remove(string);
        if (this.disposePresentation(alertPresentation)) {
            this.layout();
        }
    }

    protected class AlertPresentation {
        private IAlert alert;
        private Composite cmpPresentation;
        private Control ctlPresenter;
        public IAlertPresenter presenter;

        public AlertPresentation(IAlert iAlert, IAlertPresenter iAlertPresenter) {
            this.alert = iAlert;
            this.presenter = iAlertPresenter;
        }

        public void dispose() {
            if (this.cmpPresentation != null && !this.cmpPresentation.isDisposed()) {
                this.cmpPresentation.dispose();
                this.cmpPresentation = null;
            }
            if (this.alert != null) {
                this.alert.dispose();
                this.alert = null;
            }
            if (this.presenter != null) {
                this.presenter.dispose();
                this.presenter = null;
            }
        }

        public Control present() {
            if (this.ctlPresenter != null && !this.ctlPresenter.isDisposed()) {
                this.ctlPresenter.update();
                return this.ctlPresenter;
            }
            AlertService alertService = AlertService.this;
            Composite composite = alertService.getControl();
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            this.cmpPresentation = new Composite(composite, 0x40140000);
            this.cmpPresentation.setLayout((Layout)gridLayout);
            this.cmpPresentation.setLayoutData((Object)new GridData(4, 4, true, true));
            this.ctlPresenter = this.presenter.present(this.alert, alertService, this.cmpPresentation);
            if (this.ctlPresenter == null || this.ctlPresenter.isDisposed()) {
                this.dispose();
            } else {
                this.ctlPresenter.addListener(12, new Listener(){

                    public void handleEvent(Event event) {
                        AlertPresentation.this.dispose();
                    }
                });
            }
            return this.cmpPresentation;
        }
    }
}

