/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui;

import com.deltawalker.mvc.MvcController;
import com.deltawalker.ui.actions.IActionAccessor;
import com.deltopia.StringUtil;
import com.deltopia.util.IDisposable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.ExternalActionManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.texteditor.IUpdate;

public abstract class ActionController
extends MvcController
implements IActionAccessor {
    protected static final String MENU_ACTION_KEY = "MENU_ACTION_KEY";
    private IActionBars actionBars;
    protected final Map<String, IAction> actions = new HashMap<String, IAction>();
    private final Map<ImageDescriptor, Image> imgCache = new HashMap<ImageDescriptor, Image>();
    private Listener onMenu = new Listener(){

        public void handleEvent(Event event) {
            if (event.type == 13) {
                MenuItem menuItem = (MenuItem)event.widget;
                String string = (String)menuItem.getData(ActionController.MENU_ACTION_KEY);
                if (!$assertionsDisabled && string == null) {
                    throw new AssertionError();
                }
                ActionController.this.getAction(string).runWithEvent(event);
            } else if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }
    };

    protected Image actionImage(ImageDescriptor imageDescriptor) {
        if (imageDescriptor == null) {
            return null;
        }
        Image image = this.imgCache.get(imageDescriptor);
        if (image != null) {
            return image;
        }
        image = imageDescriptor.createImage();
        assert (image != null);
        this.imgCache.put(imageDescriptor, image);
        return image;
    }

    public Collection<IAction> actions() {
        return this.actions.values();
    }

    public void addAction(IAction iAction) {
        if (iAction == null || StringUtil.isEmpty((String)iAction.getId())) {
            throw new IllegalStateException("A global action must be a valid object with a valid ID: " + iAction);
        }
        this.actions.put(iAction.getId(), iAction);
    }

    protected void addMenu(IMenuManager iMenuManager, String string) {
        IAction iAction = this.getAction(string);
        if (iAction instanceof IUpdate) {
            ((IUpdate)iAction).update();
        }
        iMenuManager.add(iAction);
    }

    protected void addMenuItem(Menu menu, String string) {
        this.addMenuItem(menu, string, false);
    }

    protected void addMenuItem(Menu menu, String string, boolean bl) {
        String string2;
        ExternalActionManager.ICallback iCallback;
        if (StringUtil.isEmpty((String)string)) {
            if (menu.getItemCount() > 0) {
                new MenuItem(menu, 2);
            }
            return;
        }
        IAction iAction = this.getAction(string);
        if (iAction instanceof IUpdate) {
            ((IUpdate)iAction).update();
        }
        if (bl && !iAction.isEnabled()) {
            return;
        }
        int n = iAction.getStyle();
        MenuItem menuItem = new MenuItem(menu, n == 2 ? 32 : 8);
        String string3 = iAction.getText();
        String string4 = iAction.getActionDefinitionId();
        if (string4 != null && (iCallback = ExternalActionManager.getInstance().getCallback()) != null && (string2 = iCallback.getAcceleratorText(string4)) != null) {
            string3 = String.valueOf(string3) + "\t" + string2;
        }
        menuItem.setText(string3);
        iCallback = this.actionImage(iAction.getImageDescriptor());
        if (iCallback != null) {
            menuItem.setImage((Image)iCallback);
        }
        menuItem.setData(MENU_ACTION_KEY, (Object)string);
        menuItem.addListener(13, this.onMenu);
        menuItem.setEnabled(iAction.isEnabled());
        menuItem.setSelection(iAction.isChecked());
    }

    public void connectGlobalActions(boolean bl) {
    }

    protected void disconnectIndividualGlobalActions(IActionBars iActionBars) {
    }

    @Override
    public void dispose() {
        if (this.actionBars != null) {
            this.connectGlobalActions(false);
        }
        for (IAction iAction : this.actions.values()) {
            if (iAction instanceof IDisposable) {
                ((IDisposable)iAction).dispose();
                continue;
            }
            if (!(iAction instanceof ActionFactory.IWorkbenchAction)) continue;
            ((ActionFactory.IWorkbenchAction)iAction).dispose();
        }
        this.actions.clear();
        this.imgCache.clear();
        super.dispose();
    }

    protected void fillActionBars(IActionBars iActionBars) {
        IMenuManager iMenuManager;
        IToolBarManager iToolBarManager = iActionBars.getToolBarManager();
        if (iToolBarManager != null) {
            this.fillToolBar(iActionBars.getToolBarManager());
        }
        if ((iMenuManager = iActionBars.getMenuManager()) != null) {
            this.fillMenuBar(iActionBars.getMenuManager());
        }
    }

    protected void fillContextMenu(IMenuManager iMenuManager) {
    }

    protected void fillContextMenuSwt(Control control, Menu menu) {
    }

    protected void fillMenuBar(IMenuManager iMenuManager) {
    }

    protected void fillToolBar(IToolBarManager iToolBarManager) {
    }

    @Override
    public IAction getAction(String string) {
        return this.actions.get(string);
    }

    public IActionBars getActionBars() {
        return this.actionBars;
    }

    public void installContextMenu() {
    }

    protected abstract void makeActions();

    public void setActionBars(IActionBars iActionBars) {
        this.actionBars = iActionBars;
    }

    public void updateActions() {
        for (IAction iAction : this.actions.values()) {
            if (iAction instanceof IUpdate) {
                ((IUpdate)iAction).update();
                continue;
            }
            iAction.setEnabled(iAction.isEnabled());
            iAction.setChecked(iAction.isChecked());
        }
    }
}

