/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.text.source;

import com.deltawalker.text.source.LineEndingStrategy;
import com.deltawalker.text.source.NonRuleBasedDamagerRepairer;
import com.deltawalker.text.source.SourceConfig;
import java.util.List;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;

public class SourceViewerConfig
extends SourceViewerConfiguration {
    private LineEndingStrategy endingStrategy;
    private String fileExt;

    public SourceViewerConfig(String string) {
        this.fileExt = string;
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer iSourceViewer, String string) {
        if (this.endingStrategy == null) {
            this.endingStrategy = new LineEndingStrategy();
        }
        return new IAutoEditStrategy[]{this.endingStrategy};
    }

    public String[] getConfiguredContentTypes(ISourceViewer iSourceViewer) {
        return SourceConfig.blockIds(this.fileExt);
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer iSourceViewer, String string) {
        return SourceConfig.doubleClickStrategy(this.fileExt);
    }

    public String getFileExtension() {
        return this.fileExt;
    }

    public String[] getIndentPrefixes(ISourceViewer iSourceViewer, String string) {
        return new String[]{"\t", "    "};
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer iSourceViewer) {
        PresentationReconciler presentationReconciler = new PresentationReconciler();
        presentationReconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(iSourceViewer));
        List<IPresentationDamager> list = SourceConfig.getDamagers(this.fileExt);
        for (IPresentationDamager iPresentationDamager : list) {
            Object object;
            if (iPresentationDamager instanceof DefaultDamagerRepairer) {
                object = (DefaultDamagerRepairer)iPresentationDamager;
                presentationReconciler.setDamager((IPresentationDamager)object, object.getContentType());
                presentationReconciler.setRepairer((IPresentationRepairer)object, object.getContentType());
                continue;
            }
            if (!(iPresentationDamager instanceof NonRuleBasedDamagerRepairer)) continue;
            object = (NonRuleBasedDamagerRepairer)iPresentationDamager;
            presentationReconciler.setDamager((IPresentationDamager)object, ((NonRuleBasedDamagerRepairer)object).getContentType());
            presentationReconciler.setRepairer((IPresentationRepairer)object, ((NonRuleBasedDamagerRepairer)object).getContentType());
        }
        return presentationReconciler;
    }

    public int getTabWidth(ISourceViewer iSourceViewer) {
        return 4;
    }

    public void setFileExtension(String string) {
        this.fileExt = string;
    }

    static class SingleTokenScanner
    extends BufferedRuleBasedScanner {
        public SingleTokenScanner(TextAttribute textAttribute) {
            this.setDefaultReturnToken((IToken)new Token((Object)textAttribute));
        }
    }
}

