/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.text.source;

import com.deltawalker.differencer.range.RangeDifferencerJob;
import com.deltawalker.text.source.BlockScanner;
import com.deltawalker.text.source.Comments;
import com.deltawalker.text.source.ConfigEntry;
import com.deltawalker.text.source.DoubleClickStrategyJava;
import com.deltawalker.text.source.Extensions;
import com.deltawalker.text.source.JavaDocScanner;
import com.deltawalker.text.source.Keywords1;
import com.deltawalker.text.source.Keywords2;
import com.deltawalker.text.source.NonRuleBasedDamagerRepairer;
import com.deltawalker.text.source.SourceColor;
import com.deltawalker.text.source.SourceScanner;
import com.deltawalker.text.source.SourceViewerConfig;
import com.deltawalker.text.source.TagScannerXml;
import com.deltopia.StringUtil;
import com.deltopia.ui.swt.ColorCache;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.DefaultTextDoubleClickStrategy;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.swt.graphics.RGB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceConfig {
    private static Map<String, ConfigEntry> _ext2keywords = new LinkedHashMap<String, ConfigEntry>();
    private static Map<String, RuleBasedScanner> _ext2srcScanner = new HashMap<String, RuleBasedScanner>();
    private static SourceConfig _instance;
    private static JavaDocScanner _javaDocScanner;
    private static TagScannerXml _xmlTagScanner;
    public static final String[] DEFAULT_IDS;
    private static boolean DUMP_KEYWORDS;
    private static final Logger LOG;

    static {
        DEFAULT_IDS = new String[]{"__dftl_partition_content_type"};
        DUMP_KEYWORDS = false;
        LOG = LoggerFactory.getLogger(RangeDifferencerJob.class);
        SourceConfig.put(Extensions.AS, new ConfigEntry("ActionScript", Keywords1.AS, Comments.AS, true));
        SourceConfig.put(Extensions.ADA, new ConfigEntry("Ada", Keywords1.ADA, Comments.ADA, false));
        SourceConfig.put(Extensions.ASM, new ConfigEntry("Assembly", Keywords1.ASM, Comments.ASM, false));
        SourceConfig.put(Extensions.ASP, new ConfigEntry("ASP", Keywords1.ASP, Comments.ASP, true));
        SourceConfig.put(Extensions.AUTOIT, new ConfigEntry("AutoIt", Keywords1.AUTOIT, Comments.AUTOIT, true));
        SourceConfig.put(Extensions.BASH, new ConfigEntry("BASH", Keywords1.BASH, Comments.BASH, true));
        SourceConfig.put(Extensions.BATCH, new ConfigEntry("Batch", Keywords1.BATCH, Comments.BATCH, true));
        SourceConfig.put(Extensions.C, new ConfigEntry("C", Keywords1.C, Comments.C, true));
        SourceConfig.put(Extensions.CPP, new ConfigEntry("CPP", Keywords1.CPP, Comments.CPP, true));
        SourceConfig.put(Extensions.CAML, new ConfigEntry("Caml", Keywords1.CAML, Comments.CAML, true));
        SourceConfig.put(Extensions.CMAKE, new ConfigEntry("CMake", Keywords1.CMAKE, Comments.CMAKE, true));
        SourceConfig.put(Extensions.COBOL, new ConfigEntry("COBOL", Keywords1.COBOL, Comments.COBOL, true));
        SourceConfig.put(Extensions.CS, new ConfigEntry("C#", Keywords1.CS, Comments.CS, true));
        SourceConfig.put(Extensions.CSS, new ConfigEntry("CSS", Keywords1.CSS, Comments.CSS, true));
        SourceConfig.put(Extensions.D, new ConfigEntry("D", Keywords1.D, Comments.D, true));
        SourceConfig.put(Extensions.FORTRAN, new ConfigEntry("FORTRAN", Keywords1.FORTRAN, Comments.FORTRAN, false));
        SourceConfig.put(Extensions.HASKELL, new ConfigEntry("Haskell", Keywords1.HASKELL, Comments.HASKELL, true));
        SourceConfig.put(Extensions.HTML, new ConfigEntry("HTML", Keywords1.HTML, Comments.HTML, false));
        SourceConfig.put(Extensions.IDL, new ConfigEntry("IDL", Keywords1.IDL, Comments.IDL, true));
        SourceConfig.put(Extensions.INI, new ConfigEntry("INI", Keywords1.INI, Comments.INI, false));
        SourceConfig.put(Extensions.INNO, new ConfigEntry("InnoScript", Keywords1.INNO, Comments.INNO, true));
        SourceConfig.put(Extensions.JAVA, new ConfigEntry("Java", Keywords1.JAVA, Comments.JAVA, true));
        SourceConfig.put(Extensions.JS, new ConfigEntry("JavaScript", Keywords1.JS, Comments.JS, true));
        SourceConfig.put(Extensions.JSP, new ConfigEntry("JSP", Keywords1.JSP, Comments.JSP, true));
        SourceConfig.put(Extensions.KIX, new ConfigEntry("KiXtart", Keywords1.KIX, Comments.KIX, false));
        SourceConfig.put(Extensions.LISP, new ConfigEntry("Lisp", Keywords1.LISP, Comments.LISP, true));
        SourceConfig.put(Extensions.LUA, new ConfigEntry("Lua", Keywords1.LUA, Comments.LUA, true));
        SourceConfig.put(Extensions.NSIS, new ConfigEntry("NSIS", Keywords2.NSIS, Comments.NSIS, true));
        SourceConfig.put(Extensions.OBJC, new ConfigEntry("Objective-C", Keywords2.OBJC, Comments.OBJC, true));
        SourceConfig.put(Extensions.PASCAL, new ConfigEntry("Pascal", Keywords2.PASCAL, Comments.PASCAL, false));
        SourceConfig.put(Extensions.PERL, new ConfigEntry("Perl", Keywords2.PERL, Comments.PERL, true));
        SourceConfig.put(Extensions.PHP, new ConfigEntry("PHP", Keywords2.PHP, Comments.PHP, true));
        SourceConfig.put(Extensions.POSTSCRIPT, new ConfigEntry("PostScript", Keywords2.POSTSCRIPT, Comments.POSTSCRIPT, true));
        SourceConfig.put(Extensions.POWERSHELL, new ConfigEntry("PowerShell", Keywords2.POWERSHELL, Comments.POWERSHELL, false));
        SourceConfig.put(Extensions.PYTHON, new ConfigEntry("Python", Keywords2.PYTHON, Comments.PYTHON, true));
        SourceConfig.put(Extensions.R, new ConfigEntry("R", Keywords2.R, Comments.R, true));
        SourceConfig.put(Extensions.RC, new ConfigEntry("RC", Keywords2.RC, Comments.RC, true));
        SourceConfig.put(Extensions.RUBY, new ConfigEntry("Ruby", Keywords2.RUBY, Comments.RUBY, true));
        SourceConfig.put(Extensions.SCHEME, new ConfigEntry("Scheme", Keywords2.SCHEME, Comments.SCHEME, false));
        SourceConfig.put(Extensions.SMALLTALK, new ConfigEntry("Smalltalk", Keywords2.SMALLTALK, Comments.SMALLTALK, true));
        SourceConfig.put(Extensions.SQL, new ConfigEntry("SQL", Keywords2.SQL, Comments.SQL, false));
        SourceConfig.put(Extensions.TCL, new ConfigEntry("TCL", Keywords2.TCL, Comments.TCL, true));
        SourceConfig.put(Extensions.VB, new ConfigEntry("VB", Keywords2.VB, Comments.VB, false));
        SourceConfig.put(Extensions.VERILOG, new ConfigEntry("Verilog", Keywords2.VERILOG, Comments.VERILOG, true));
        SourceConfig.put(Extensions.VHDL, new ConfigEntry("VHDL", Keywords2.VHDL, Comments.VHDL, false));
        SourceConfig.put(Extensions.XML, new ConfigEntry("XML", Keywords2.XML, Comments.XML, true));
        SourceConfig.put(Extensions.YAML, new ConfigEntry("YAML", Keywords2.YAML, Comments.YAML, true));
        if (DUMP_KEYWORDS) {
            Collection<ConfigEntry> collection = _ext2keywords.values();
            for (ConfigEntry configEntry : collection) {
                String[] stringArray;
                Arrays.sort(configEntry.keywords());
                LOG.debug("\n\nname=" + configEntry.name());
                String[] stringArray2 = stringArray = configEntry.keywords();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray2[n2];
                    LOG.debug(String.valueOf('\"') + string + '\"' + ", ");
                    ++n2;
                }
            }
        }
    }

    public static String[] blockIds(String string) {
        BlockScanner blockScanner = SourceConfig.blockScanner(string);
        return blockScanner != null ? blockScanner.blockIds() : DEFAULT_IDS;
    }

    public static BlockScanner blockScanner(String string) {
        if (StringUtil.isEmpty((String)string)) {
            return null;
        }
        ConfigEntry configEntry = _ext2keywords.get(string = string.toLowerCase());
        return configEntry != null ? configEntry.blockScanner() : null;
    }

    public static boolean canHaveJavadoc(String string) {
        return string.equals("/*");
    }

    public static ITextDoubleClickStrategy doubleClickStrategy(String string) {
        if (SourceConfig.isJavaLike(string)) {
            return new DoubleClickStrategyJava();
        }
        return new DefaultTextDoubleClickStrategy();
    }

    public static List<IPresentationDamager> getDamagers(String string) {
        String string2;
        string = string.toLowerCase();
        LinkedList<IPresentationDamager> linkedList = new LinkedList<IPresentationDamager>();
        ConfigEntry configEntry = _ext2keywords.get(string);
        if (configEntry == null) {
            return linkedList;
        }
        RuleBasedScanner ruleBasedScanner = _ext2srcScanner.get(string);
        if (ruleBasedScanner == null) {
            string2 = configEntry.comment(Comment.LINE);
            ruleBasedScanner = new SourceScanner(string, string2, configEntry.isCaseSensitive());
            _ext2srcScanner.put(string, ruleBasedScanner);
        }
        string2 = new DefaultDamagerRepairer((ITokenScanner)ruleBasedScanner, "__dftl_partition_content_type");
        linkedList.add((IPresentationDamager)string2);
        String string3 = configEntry.comment(Comment.START);
        if (!string3.isEmpty()) {
            BlockScanner blockScanner = SourceConfig.blockScanner(string);
            if (SourceConfig.isXmlLike(string)) {
                linkedList.add((IPresentationDamager)new DefaultDamagerRepairer((ITokenScanner)SourceConfig.xmlTagScanner(), blockScanner.blockTagId()));
                linkedList.add(new NonRuleBasedDamagerRepairer(new TextAttribute(ColorCache.color((RGB)SourceColor.XML_COMMENT)), blockScanner.blockCommentId()));
            } else {
                SourceViewerConfig.SingleTokenScanner singleTokenScanner = new SourceViewerConfig.SingleTokenScanner(new TextAttribute(ColorCache.color((RGB)SourceColor.BLOCK_COMMENT)));
                linkedList.add((IPresentationDamager)new DefaultDamagerRepairer((ITokenScanner)singleTokenScanner, blockScanner.blockCommentId()));
            }
            if (SourceConfig.canHaveJavadoc(string3)) {
                linkedList.add((IPresentationDamager)new DefaultDamagerRepairer((ITokenScanner)SourceConfig.javaDocScanner(), blockScanner.blockJavadocId()));
            }
        }
        return linkedList;
    }

    public static SourceConfig getInstance() {
        return _instance;
    }

    public static boolean isJavaLike(String string) {
        if (StringUtil.isEmpty((String)string)) {
            return false;
        }
        ConfigEntry configEntry = _ext2keywords.get(string = string.toLowerCase());
        return configEntry != null ? configEntry.isJavaLike() : false;
    }

    public static boolean isKnownFileExtension(String string) {
        string = string.toLowerCase();
        return _ext2keywords.containsKey(string);
    }

    public static boolean isXmlLike(String string) {
        if (StringUtil.isEmpty((String)string)) {
            return false;
        }
        ConfigEntry configEntry = _ext2keywords.get(string = string.toLowerCase());
        return configEntry != null ? configEntry.isXmlLike() : false;
    }

    public static JavaDocScanner javaDocScanner() {
        if (_javaDocScanner == null) {
            _javaDocScanner = new JavaDocScanner();
        }
        return _javaDocScanner;
    }

    public static String[] keywords(String string) {
        string = string.toLowerCase();
        ConfigEntry configEntry = _ext2keywords.get(string);
        return configEntry.keywords();
    }

    public static String partitioningId(String string) {
        if (StringUtil.isEmpty((String)string)) {
            return "";
        }
        BlockScanner blockScanner = SourceConfig.blockScanner(string = string.toLowerCase());
        return blockScanner != null ? blockScanner.partitioningId() : "";
    }

    private static void put(String[] stringArray, ConfigEntry configEntry) {
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            _ext2keywords.put(string, configEntry);
            ++n2;
        }
    }

    public static RuleBasedScanner sourceScanner(String string) {
        string = string.toLowerCase();
        RuleBasedScanner ruleBasedScanner = _ext2srcScanner.get(string);
        return ruleBasedScanner;
    }

    public static TagScannerXml xmlTagScanner() {
        if (_xmlTagScanner == null) {
            _xmlTagScanner = new TagScannerXml();
            _xmlTagScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(ColorCache.color((RGB)SourceColor.BLOCK_TAG))));
        }
        return _xmlTagScanner;
    }

    private SourceConfig() {
        _instance = this;
    }

    public static enum Comment {
        END(2),
        LINE(0),
        START(1);

        private static final Map<Integer, Comment> int2enum;
        private final int intVal;

        static {
            int2enum = new HashMap<Integer, Comment>(3);
            Comment[] commentArray = Comment.values();
            int n = commentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Comment comment = commentArray[n2];
                int2enum.put(comment.intVal, comment);
                ++n2;
            }
        }

        public static Comment fromInt(int n) {
            return int2enum.get(n);
        }

        private Comment(int n2) {
            this.intVal = n2;
        }
    }
}

