/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.text.source;

import com.deltawalker.text.source.HeuristicScannerJava;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.DefaultCharacterPairMatcher;

public final class PairMatcherJava
extends DefaultCharacterPairMatcher {
    private boolean fHighlightAngularBrackets = true;

    public PairMatcherJava(char[] cArray) {
        super(cArray, "__java_partitioning", true);
    }

    private boolean isGreaterThanOperator(IDocument iDocument, int n) throws BadLocationException {
        if (n < 0) {
            return false;
        }
        String string = TextUtilities.getContentType((IDocument)iDocument, (String)"__java_partitioning", (int)n, (boolean)false);
        if (!"__dftl_partition_content_type".equals(string)) {
            return false;
        }
        HeuristicScannerJava heuristicScannerJava = new HeuristicScannerJava(iDocument, "__java_partitioning", string);
        return !this.isTypeParameterClosingBracket(n, iDocument, heuristicScannerJava);
    }

    private boolean isLessThanOperator(IDocument iDocument, int n) throws BadLocationException {
        if (n < 0) {
            return false;
        }
        String string = TextUtilities.getContentType((IDocument)iDocument, (String)"__java_partitioning", (int)n, (boolean)false);
        if (!"__dftl_partition_content_type".equals(string)) {
            return false;
        }
        HeuristicScannerJava heuristicScannerJava = new HeuristicScannerJava(iDocument, "__java_partitioning", string);
        return !this.isTypeParameterOpeningBracket(n, iDocument, heuristicScannerJava);
    }

    public boolean isMatchedChar(char c, IDocument iDocument, int n) {
        block6: {
            block5: {
                try {
                    if (c != '<') break block5;
                    if (this.isLessThanOperator(iDocument, n)) {
                        return false;
                    }
                    break block6;
                }
                catch (BadLocationException badLocationException) {}
            }
            if (c == '>' && this.isGreaterThanOperator(iDocument, n)) {
                return false;
            }
        }
        return super.isMatchedChar(c, iDocument, n);
    }

    private boolean isTypeParameterClosingBracket(int n, IDocument iDocument, HeuristicScannerJava heuristicScannerJava) {
        try {
            String string;
            IRegion iRegion = iDocument.getLineInformationOfOffset(n);
            int n2 = heuristicScannerJava.previousToken(n - 1, iRegion.getOffset());
            int n3 = heuristicScannerJava.getPosition() + 1;
            String string2 = string = n2 == -1 ? null : iDocument.get(n3, n - n3).trim();
            return n2 == 2000 && string.length() > 0 && Character.isUpperCase(string.charAt(0)) || n2 == -1 || n2 == 14 || n2 == 10;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private boolean isTypeParameterIntroducer(String string) {
        return string.length() > 0 && (Character.isUpperCase(string.charAt(0)) || string.startsWith("final") || string.startsWith("public") || string.startsWith("public") || string.startsWith("protected") || string.startsWith("private"));
    }

    private boolean isTypeParameterOpeningBracket(int n, IDocument iDocument, HeuristicScannerJava heuristicScannerJava) {
        try {
            String string;
            IRegion iRegion = iDocument.getLineInformationOfOffset(n);
            int n2 = heuristicScannerJava.previousToken(n - 1, iRegion.getOffset());
            int n3 = heuristicScannerJava.getPosition() + 1;
            String string2 = string = n2 == -1 ? null : iDocument.get(n3, n - n3).trim();
            return n2 == 1 || n2 == 2 || n2 == 7 || n2 == 1022 || n2 == 1019 || n2 == 2000 && this.isTypeParameterIntroducer(string) || n2 == -1;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    public IRegion match(IDocument iDocument, int n) {
        try {
            return this.performMatch(iDocument, n);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private IRegion performMatch(IDocument iDocument, int n) throws BadLocationException {
        int n2;
        char c;
        if (n < 0 || iDocument == null) {
            return null;
        }
        char c2 = iDocument.getChar(Math.max(n - 1, 0));
        char c3 = c = n != iDocument.getLength() ? iDocument.getChar(n) : (char)'\u0000';
        if (c2 == '>' && c != '>') {
            c = c2;
            c2 = iDocument.getChar(Math.max(--n - 1, 0));
        } else if (c == '<' && c2 != '>' && c2 != '<') {
            c2 = c;
            c = iDocument.getChar(++n);
        }
        if (!(c2 != '<' && c != '>' || this.fHighlightAngularBrackets)) {
            return null;
        }
        if (c2 == '<' && this.isLessThanOperator(iDocument, n - 1)) {
            return null;
        }
        IRegion iRegion = super.match(iDocument, n);
        if (iRegion == null) {
            return iRegion;
        }
        if (c == '>' && this.isLessThanOperator(iDocument, n2 = iRegion.getOffset())) {
            return null;
        }
        return iRegion;
    }
}

