/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.text.source;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.swt.custom.StyleRange;

public class NonRuleBasedDamagerRepairer
implements IPresentationDamager,
IPresentationRepairer {
    private String contentType;
    protected TextAttribute defaultTextAttrib;
    protected IDocument document;

    public NonRuleBasedDamagerRepairer(TextAttribute textAttribute, String string) {
        if (textAttribute == null) {
            throw new NullPointerException("defaultTextAttrib");
        }
        this.defaultTextAttrib = textAttribute;
        this.contentType = string;
    }

    protected void addRange(TextPresentation textPresentation, int n, int n2, TextAttribute textAttribute) {
        if (textAttribute != null) {
            textPresentation.addStyleRange(new StyleRange(n, n2, textAttribute.getForeground(), textAttribute.getBackground(), textAttribute.getStyle()));
        }
    }

    public void createPresentation(TextPresentation textPresentation, ITypedRegion iTypedRegion) {
        this.addRange(textPresentation, iTypedRegion.getOffset(), iTypedRegion.getLength(), this.defaultTextAttrib);
    }

    protected int endOfLineOf(int n) throws BadLocationException {
        IRegion iRegion = this.document.getLineInformationOfOffset(n);
        if (n <= iRegion.getOffset() + iRegion.getLength()) {
            return iRegion.getOffset() + iRegion.getLength();
        }
        int n2 = this.document.getLineOfOffset(n);
        try {
            iRegion = this.document.getLineInformation(n2 + 1);
            return iRegion.getOffset() + iRegion.getLength();
        }
        catch (BadLocationException badLocationException) {
            return this.document.getLength();
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public IRegion getDamageRegion(ITypedRegion iTypedRegion, DocumentEvent documentEvent, boolean bl) {
        if (!bl) {
            try {
                IRegion iRegion = this.document.getLineInformationOfOffset(documentEvent.getOffset());
                int n = Math.max(iTypedRegion.getOffset(), iRegion.getOffset());
                int n2 = documentEvent.getOffset() + (documentEvent.getText() == null ? documentEvent.getLength() : documentEvent.getText().length());
                n2 = iRegion.getOffset() <= n2 && n2 <= iRegion.getOffset() + iRegion.getLength() ? iRegion.getOffset() + iRegion.getLength() : this.endOfLineOf(n2);
                n2 = Math.min(iTypedRegion.getOffset() + iTypedRegion.getLength(), n2);
                return new Region(n, n2 - n);
            }
            catch (BadLocationException badLocationException) {}
        }
        return iTypedRegion;
    }

    public void setDocument(IDocument iDocument) {
        this.document = iDocument;
    }
}

