/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.text.source;

import com.deltawalker.LineEndingUtil;
import com.deltawalker.PrefKey;
import com.deltawalker.PrefUtil;
import com.deltopia.StringUtil;
import com.deltopia.util.Const;
import java.util.Arrays;
import java.util.Comparator;
import java.util.regex.Pattern;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class LineEndingStrategy
implements IAutoEditStrategy {
    private static final String[] ENDINGS = (String[])DefaultLineTracker.DELIMITERS.clone();
    private static final Pattern REGEX;
    private boolean enabled = false;
    private String ending;
    private final IPropertyChangeListener onProp = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            LineEndingStrategy.this.propertyChange(propertyChangeEvent);
        }
    };
    private final IPreferenceStore prefs = PrefUtil.getGlobalPrefs();
    private int retainCount;

    static {
        Arrays.sort(ENDINGS, new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                if (string.indexOf(string2) != -1) {
                    return -1;
                }
                if (string2.indexOf(string) != -1) {
                    return 1;
                }
                return string.compareTo(string2);
            }
        });
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = ENDINGS;
        int n = ENDINGS.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            stringBuffer.append('|');
            stringBuffer.append('(');
            stringBuffer.append(string);
            stringBuffer.append(')');
            ++n2;
        }
        if (stringBuffer.length() <= 0) {
            throw new IllegalStateException();
        }
        REGEX = Pattern.compile(stringBuffer.substring(1));
    }

    public static String guessLineDelimiter(String string) {
        int n = 0;
        while (n < ENDINGS.length) {
            String string2 = ENDINGS[n];
            if (string.indexOf(string2) != -1) {
                return string2;
            }
            ++n;
        }
        return Const.LINE_ENDING;
    }

    public static String insertLineDelimiters(String string, int n) {
        if (string == null || string.length() == 0) {
            return string;
        }
        String string2 = Const.LINE_ENDING;
        string = LineEndingStrategy.replaceAll(string, string2);
        int n2 = string2.length();
        int n3 = string.length();
        StringBuilder stringBuilder = new StringBuilder(n3 * 11 / 10);
        int n4 = n;
        boolean bl = false;
        int n5 = 0;
        while (n5 < n3) {
            int n6 = string.indexOf(string2, n5);
            if (n6 > n5 + n4) {
                int n7 = n5 + n4 > n3 - 1 ? n3 - 1 : n5 + n4;
                int n8 = string.lastIndexOf(" ", n7);
                if (n8 == n5) {
                    n8 = n7 - 1;
                }
                stringBuilder.append(string.substring(n5 + (bl ? 1 : 0), n8 + 1));
                stringBuilder.append(string2);
                n5 += n4 - (n7 - n8);
                bl = true;
                continue;
            }
            stringBuilder.append(string.substring(n5 + (bl ? 1 : 0), n6 + n2));
            n5 = n6 + n2;
            bl = false;
        }
        return stringBuilder.toString();
    }

    public static String replaceAll(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("content");
        }
        if (StringUtil.isEmpty((String)string2)) {
            throw new IllegalArgumentException("newEnding");
        }
        return REGEX.matcher(string).replaceAll(string2);
    }

    public static String replaceAllByName(String string, String string2) {
        String string3 = LineEndingUtil.fromName(string2);
        return string3 != null ? LineEndingStrategy.replaceAll(string, string3) : string;
    }

    public LineEndingStrategy() {
        this.ending = this.prefs.getString(PrefKey.T_LINE_ENDING.toString());
        this.prefs.addPropertyChangeListener(this.onProp);
        this.retain();
    }

    public void customizeDocumentCommand(IDocument iDocument, DocumentCommand documentCommand) {
        if (this.enabled) {
            documentCommand.text = LineEndingStrategy.replaceAllByName(documentCommand.text, this.ending);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        LineEndingStrategy lineEndingStrategy = this;
        synchronized (lineEndingStrategy) {
            --this.retainCount;
            if (this.retainCount <= 0) {
                this.prefs.removePropertyChangeListener(this.onProp);
            }
        }
    }

    protected void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getProperty();
        if (PrefKey.T_LINE_ENDING.toString().equals(string)) {
            this.ending = this.prefs.getString(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retain() {
        LineEndingStrategy lineEndingStrategy = this;
        synchronized (lineEndingStrategy) {
            ++this.retainCount;
        }
    }
}

