/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.text.source;

import com.deltawalker.text.source.SymbolsJava;
import java.util.Arrays;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TypedRegion;

public final class HeuristicScannerJava
implements SymbolsJava {
    private static final char AT = '@';
    private static final char COLON = ':';
    private static final char COMMA = ',';
    private static final char EQUAL = '=';
    private static final StopCondition fNonWS = new NonWhitespace();
    private static final char LANGLE = '<';
    private static final char LBRACE = '{';
    private static final char LBRACKET = '[';
    private static final char LPAREN = '(';
    public static final int NOT_FOUND = -1;
    private static final char PLUS = '+';
    private static final char QUESTIONMARK = '?';
    private static final char RANGLE = '>';
    private static final char RBRACE = '}';
    private static final char RBRACKET = ']';
    private static final char RPAREN = ')';
    private static final char SEMICOLON = ';';
    public static final int UNBOUND = -2;
    private ITypedRegion fCachedPartition = new TypedRegion(-1, 0, "__no_partition_at_all");
    private char fChar;
    private final IDocument fDocument;
    private final StopCondition fNonIdent = new NonJavaIdentifierPartDefaultPartition();
    private final StopCondition fNonWSDefaultPart = new NonWhitespaceDefaultPartition();
    private final String fPartition;
    private final String fPartitioning;
    private int fPos;

    public static boolean isGenericStarter(CharSequence charSequence) {
        int n = charSequence.length();
        if (n > 0 && Character.isUpperCase(charSequence.charAt(0))) {
            int n2 = 0;
            while (n2 < n) {
                if (charSequence.charAt(n2) == '_') {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    public HeuristicScannerJava(IDocument iDocument) {
        this(iDocument, "__java_partitioning", "__dftl_partition_content_type");
    }

    public HeuristicScannerJava(IDocument iDocument, String string, String string2) {
        Assert.isLegal((iDocument != null ? 1 : 0) != 0);
        Assert.isLegal((string != null ? 1 : 0) != 0);
        Assert.isLegal((string2 != null ? 1 : 0) != 0);
        this.fDocument = iDocument;
        this.fPartitioning = string;
        this.fPartition = string2;
    }

    private boolean contains(IRegion iRegion, int n) {
        int n2 = iRegion.getOffset();
        return n2 <= n && n < n2 + iRegion.getLength();
    }

    public int findClosingPeer(int n, char c, char c2) {
        return this.findClosingPeer(n, -2, c, c2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int findClosingPeer(int n, int n2, char c, char c2) {
        Assert.isLegal((n >= 0 ? 1 : 0) != 0);
        try {
            CharacterMatch characterMatch = new CharacterMatch(new char[]{c, c2});
            int n3 = 1;
            --n;
            do {
                if ((n = this.scanForward(n + 1, n2, characterMatch)) == -1) {
                    return -1;
                }
                if (this.fDocument.getChar(n) == c) {
                    ++n3;
                    continue;
                }
                --n3;
            } while (n3 != 0);
            return n;
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    public int findNonWhitespaceBackward(int n, int n2) {
        return this.scanBackward(n, n2, this.fNonWSDefaultPart);
    }

    public int findNonWhitespaceBackwardInAnyPartition(int n, int n2) {
        return this.scanBackward(n, n2, fNonWS);
    }

    public int findNonWhitespaceForward(int n, int n2) {
        return this.scanForward(n, n2, this.fNonWSDefaultPart);
    }

    public int findNonWhitespaceForwardInAnyPartition(int n, int n2) {
        return this.scanForward(n, n2, fNonWS);
    }

    public int findOpeningPeer(int n, char c, char c2) {
        return this.findOpeningPeer(n, -2, c, c2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int findOpeningPeer(int n, int n2, char c, char c2) {
        Assert.isLegal((n < this.fDocument.getLength() ? 1 : 0) != 0);
        try {
            CharacterMatch characterMatch = new CharacterMatch(new char[]{c, c2});
            int n3 = 1;
            ++n;
            do {
                if ((n = this.scanBackward(n - 1, n2, characterMatch)) == -1) {
                    return -1;
                }
                if (this.fDocument.getChar(n) == c2) {
                    ++n3;
                    continue;
                }
                --n3;
            } while (n3 != 0);
            return n;
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    public IRegion findSurroundingBlock(int n) {
        if (n < 1 || n >= this.fDocument.getLength()) {
            return null;
        }
        int n2 = this.findOpeningPeer(n - 1, '{', '}');
        int n3 = this.findClosingPeer(n, '{', '}');
        if (n2 == -1 || n3 == -1) {
            return null;
        }
        return new Region(n2, n3 + 1 - n2);
    }

    private ITypedRegion getPartition(int n) {
        if (!this.contains((IRegion)this.fCachedPartition, n)) {
            Assert.isTrue((n >= 0 ? 1 : 0) != 0);
            Assert.isTrue((n <= this.fDocument.getLength() ? 1 : 0) != 0);
            try {
                this.fCachedPartition = TextUtilities.getPartition((IDocument)this.fDocument, (String)this.fPartitioning, (int)n, (boolean)false);
            }
            catch (BadLocationException badLocationException) {
                this.fCachedPartition = new TypedRegion(n, 0, "__no_partition_at_all");
            }
        }
        return this.fCachedPartition;
    }

    public int getPosition() {
        return this.fPos;
    }

    private int getToken(String string) {
        Assert.isNotNull((Object)string);
        switch (string.length()) {
            case 2: {
                if ("if".equals(string)) {
                    return 109;
                }
                if (!"do".equals(string)) break;
                return 1010;
            }
            case 3: {
                if ("for".equals(string)) {
                    return 1011;
                }
                if ("try".equals(string)) {
                    return 1012;
                }
                if (!"new".equals(string)) break;
                return 1025;
            }
            case 4: {
                if ("case".equals(string)) {
                    return 1013;
                }
                if ("else".equals(string)) {
                    return 1014;
                }
                if ("enum".equals(string)) {
                    return 1028;
                }
                if (!"goto".equals(string)) break;
                return 1023;
            }
            case 5: {
                if ("break".equals(string)) {
                    return 1015;
                }
                if ("catch".equals(string)) {
                    return 1016;
                }
                if ("class".equals(string)) {
                    return 1026;
                }
                if (!"while".equals(string)) break;
                return 1017;
            }
            case 6: {
                if ("return".equals(string)) {
                    return 1018;
                }
                if ("static".equals(string)) {
                    return 1019;
                }
                if ("switch".equals(string)) {
                    return 1020;
                }
                if (!"throws".equals(string)) break;
                return 1029;
            }
            case 7: {
                if ("default".equals(string)) {
                    return 1024;
                }
                if (!"finally".equals(string)) break;
                return 1021;
            }
            case 9: {
                if (!"interface".equals(string)) break;
                return 1027;
            }
            case 12: {
                if (!"synchronized".equals(string)) break;
                return 1022;
            }
        }
        return 2000;
    }

    public boolean isBracelessBlockStart(int n, int n2) {
        if (n < 1) {
            return false;
        }
        switch (this.previousToken(n, n2)) {
            case 1010: 
            case 1014: {
                return true;
            }
            case 6: {
                n = this.findOpeningPeer(this.fPos, '(', ')');
                if (n <= 0) break;
                switch (this.previousToken(n - 1, n2)) {
                    case 109: 
                    case 1011: 
                    case 1017: {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public boolean isDefaultPartition(int n) {
        return this.fPartition.equals(this.getPartition(n).getType());
    }

    public boolean looksLikeClassInstanceCreationBackward(int n, int n2) {
        int n3 = this.previousToken(n - 1, n2);
        if (n3 == 2000) {
            n3 = this.previousToken(this.getPosition(), n2);
            while (n3 == 8) {
                n3 = this.previousToken(this.getPosition(), n2);
                if (n3 != 2000) {
                    return false;
                }
                n3 = this.previousToken(this.getPosition(), n2);
            }
            return n3 == 1025;
        }
        return false;
    }

    public int nextToken(int n, int n2) {
        int n3 = this.scanForward(n, n2, this.fNonWSDefaultPart);
        if (n3 == -1) {
            return -1;
        }
        ++this.fPos;
        switch (this.fChar) {
            case '{': {
                return 1;
            }
            case '}': {
                return 2;
            }
            case '[': {
                return 3;
            }
            case ']': {
                return 4;
            }
            case '(': {
                return 5;
            }
            case ')': {
                return 6;
            }
            case ';': {
                return 7;
            }
            case ',': {
                return 11;
            }
            case '?': {
                return 10;
            }
            case '=': {
                return 12;
            }
            case '<': {
                return 13;
            }
            case '>': {
                return 14;
            }
            case '+': {
                return 15;
            }
            case '@': {
                return 16;
            }
        }
        if (Character.isJavaIdentifierPart(this.fChar)) {
            String string;
            int n4 = n3;
            int n5 = (n3 = this.scanForward(n3 + 1, n2, this.fNonIdent)) == -1 ? (n2 == -2 ? this.fDocument.getLength() : n2) : n3;
            try {
                string = this.fDocument.get(n4, n5 - n4);
            }
            catch (BadLocationException badLocationException) {
                return -1;
            }
            return this.getToken(string);
        }
        return 8;
    }

    public int previousToken(int n, int n2) {
        int n3 = this.scanBackward(n, n2, this.fNonWSDefaultPart);
        if (n3 == -1) {
            return -1;
        }
        --this.fPos;
        switch (this.fChar) {
            case '{': {
                return 1;
            }
            case '}': {
                return 2;
            }
            case '[': {
                return 3;
            }
            case ']': {
                return 4;
            }
            case '(': {
                return 5;
            }
            case ')': {
                return 6;
            }
            case ';': {
                return 7;
            }
            case ':': {
                return 9;
            }
            case ',': {
                return 11;
            }
            case '?': {
                return 10;
            }
            case '=': {
                return 12;
            }
            case '<': {
                return 13;
            }
            case '>': {
                return 14;
            }
            case '+': {
                return 15;
            }
            case '@': {
                return 16;
            }
        }
        if (Character.isJavaIdentifierPart(this.fChar)) {
            String string;
            int n4 = n3 + 1;
            int n5 = (n3 = this.scanBackward(n3 - 1, n2, this.fNonIdent)) == -1 ? (n2 == -2 ? 0 : n2 + 1) : n3 + 1;
            try {
                string = this.fDocument.get(n5, n4 - n5);
            }
            catch (BadLocationException badLocationException) {
                return -1;
            }
            return this.getToken(string);
        }
        return 8;
    }

    public int scanBackward(int n, int n2, char c) {
        return this.scanBackward(n, n2, new CharacterMatch(c));
    }

    public int scanBackward(int n, int n2, char[] cArray) {
        return this.scanBackward(n, n2, new CharacterMatch(cArray));
    }

    public int scanBackward(int n, int n2, StopCondition stopCondition) {
        if (n2 == -2) {
            n2 = -1;
        }
        Assert.isLegal((n2 >= -1 ? 1 : 0) != 0);
        Assert.isLegal((n < this.fDocument.getLength() ? 1 : 0) != 0);
        try {
            this.fPos = n;
            while (this.fPos > n2) {
                this.fChar = this.fDocument.getChar(this.fPos);
                if (stopCondition.stop(this.fChar, this.fPos, false)) {
                    return this.fPos;
                }
                this.fPos = stopCondition.nextPosition(this.fPos, false);
            }
        }
        catch (BadLocationException badLocationException) {}
        return -1;
    }

    public int scanForward(int n, int n2, char c) {
        return this.scanForward(n, n2, new CharacterMatch(c));
    }

    public int scanForward(int n, int n2, char[] cArray) {
        return this.scanForward(n, n2, new CharacterMatch(cArray));
    }

    public int scanForward(int n, int n2, StopCondition stopCondition) {
        Assert.isLegal((n >= 0 ? 1 : 0) != 0);
        if (n2 == -2) {
            n2 = this.fDocument.getLength();
        }
        Assert.isLegal((n2 <= this.fDocument.getLength() ? 1 : 0) != 0);
        try {
            this.fPos = n;
            while (this.fPos < n2) {
                this.fChar = this.fDocument.getChar(this.fPos);
                if (stopCondition.stop(this.fChar, this.fPos, true)) {
                    return this.fPos;
                }
                this.fPos = stopCondition.nextPosition(this.fPos, true);
            }
        }
        catch (BadLocationException badLocationException) {}
        return -1;
    }

    private final class CharacterMatch
    extends StopCondition {
        private final char[] fChars;

        public CharacterMatch(char c) {
            this(new char[]{c});
        }

        public CharacterMatch(char[] cArray) {
            Assert.isNotNull((Object)cArray);
            Assert.isTrue((cArray.length > 0 ? 1 : 0) != 0);
            this.fChars = cArray;
            Arrays.sort(cArray);
        }

        @Override
        public int nextPosition(int n, boolean bl) {
            ITypedRegion iTypedRegion = HeuristicScannerJava.this.getPartition(n);
            if (HeuristicScannerJava.this.fPartition.equals(iTypedRegion.getType())) {
                return super.nextPosition(n, bl);
            }
            if (bl) {
                int n2 = iTypedRegion.getOffset() + iTypedRegion.getLength();
                if (n < n2) {
                    return n2;
                }
            } else {
                int n3 = iTypedRegion.getOffset();
                if (n > n3) {
                    return n3 - 1;
                }
            }
            return super.nextPosition(n, bl);
        }

        @Override
        public boolean stop(char c, int n, boolean bl) {
            return Arrays.binarySearch(this.fChars, c) >= 0 && HeuristicScannerJava.this.isDefaultPartition(n);
        }
    }

    private static class NonJavaIdentifierPart
    extends StopCondition {
        private NonJavaIdentifierPart() {
        }

        @Override
        public boolean stop(char c, int n, boolean bl) {
            return !Character.isJavaIdentifierPart(c);
        }
    }

    private final class NonJavaIdentifierPartDefaultPartition
    extends NonJavaIdentifierPart {
        private NonJavaIdentifierPartDefaultPartition() {
        }

        @Override
        public int nextPosition(int n, boolean bl) {
            ITypedRegion iTypedRegion = HeuristicScannerJava.this.getPartition(n);
            if (HeuristicScannerJava.this.fPartition.equals(iTypedRegion.getType())) {
                return super.nextPosition(n, bl);
            }
            if (bl) {
                int n2 = iTypedRegion.getOffset() + iTypedRegion.getLength();
                if (n < n2) {
                    return n2;
                }
            } else {
                int n3 = iTypedRegion.getOffset();
                if (n > n3) {
                    return n3 - 1;
                }
            }
            return super.nextPosition(n, bl);
        }

        @Override
        public boolean stop(char c, int n, boolean bl) {
            return super.stop(c, n, true) || !HeuristicScannerJava.this.isDefaultPartition(n);
        }
    }

    private static class NonWhitespace
    extends StopCondition {
        private NonWhitespace() {
        }

        @Override
        public boolean stop(char c, int n, boolean bl) {
            return !Character.isWhitespace(c);
        }

        /* synthetic */ NonWhitespace(NonWhitespace nonWhitespace, NonWhitespace nonWhitespace2) {
            this();
        }
    }

    private final class NonWhitespaceDefaultPartition
    extends NonWhitespace {
        private NonWhitespaceDefaultPartition() {
            super(null, null);
        }

        @Override
        public int nextPosition(int n, boolean bl) {
            ITypedRegion iTypedRegion = HeuristicScannerJava.this.getPartition(n);
            if (HeuristicScannerJava.this.fPartition.equals(iTypedRegion.getType())) {
                return super.nextPosition(n, bl);
            }
            if (bl) {
                int n2 = iTypedRegion.getOffset() + iTypedRegion.getLength();
                if (n < n2) {
                    return n2;
                }
            } else {
                int n3 = iTypedRegion.getOffset();
                if (n > n3) {
                    return n3 - 1;
                }
            }
            return super.nextPosition(n, bl);
        }

        @Override
        public boolean stop(char c, int n, boolean bl) {
            return super.stop(c, n, true) && HeuristicScannerJava.this.isDefaultPartition(n);
        }
    }

    private static abstract class StopCondition {
        private StopCondition() {
        }

        public int nextPosition(int n, boolean bl) {
            return bl ? n + 1 : n - 1;
        }

        public abstract boolean stop(char var1, int var2, boolean var3);
    }
}

