/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.text.source;

import com.deltawalker.text.source.BlockScanner;
import com.deltawalker.text.source.Comments;
import com.deltawalker.text.source.SourceConfig;
import java.util.EnumMap;
import java.util.Map;

public class ConfigEntry {
    private final boolean caseSensitive;
    private Map<SourceConfig.Comment, String> comments = new EnumMap<SourceConfig.Comment, String>(SourceConfig.Comment.class);
    private final String[] keywords;
    private final String name;

    public ConfigEntry(String string, String[] stringArray, String[] stringArray2, boolean bl) {
        this.name = string;
        this.keywords = stringArray;
        this.caseSensitive = bl;
        int n = 0;
        while (n < stringArray2.length) {
            String string2 = stringArray2[n];
            this.comments.put(SourceConfig.Comment.fromInt(n), string2);
            ++n;
        }
    }

    public BlockScanner blockScanner() {
        String string = this.comment(SourceConfig.Comment.START);
        if (string.equals("/*")) {
            return Comments.blockScannerJava();
        }
        if (string.equals("<!--")) {
            return Comments.blockScannerXml();
        }
        if (string.equals("{")) {
            return Comments.blockScannerPascal();
        }
        if (string.equals("#CS")) {
            return Comments.blockScannerAutoIt();
        }
        return null;
    }

    public String comment(SourceConfig.Comment comment) {
        return this.comments.get((Object)comment);
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean isJavaLike() {
        return this.comment(SourceConfig.Comment.START).equals("/*");
    }

    public boolean isXmlLike() {
        return this.comment(SourceConfig.Comment.START).equals("<!--");
    }

    public String[] keywords() {
        return this.keywords;
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }
}

