/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.text.source;

import com.deltawalker.text.source.BlockScanner;
import java.util.LinkedList;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;

public class BlockScannerJava
extends BlockScanner {
    private static final String _BLOCK_COMMENT_ID = "__java_multiline_comment";
    private static final String _BLOCK_JAVADOC_ID = "__java_javadoc";
    public static final String _PARTITIONING_ID = "__java_partitioning";
    private static final String[] BLOCK_IDS = new String[]{"__dftl_partition_content_type", "__java_multiline_comment", "__java_javadoc"};

    public BlockScannerJava() {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        linkedList.add(new EndOfLineRule("//", Token.UNDEFINED));
        linkedList.add(new SingleLineRule("\"", "\"", Token.UNDEFINED, '\\'));
        linkedList.add(new SingleLineRule("'", "'", Token.UNDEFINED, '\\'));
        Token token = new Token((Object)_BLOCK_COMMENT_ID);
        linkedList.add((Object)new WordPredicateRule((IToken)token));
        Token token2 = new Token((Object)_BLOCK_JAVADOC_ID);
        linkedList.add(new MultiLineRule("/**", "*/", (IToken)token2, '\u0000', true));
        linkedList.add(new MultiLineRule("/*", "*/", (IToken)token, '\u0000', true));
        this.setPredicateRules(linkedList.toArray(new IPredicateRule[linkedList.size()]));
    }

    @Override
    public String blockCommentId() {
        return _BLOCK_COMMENT_ID;
    }

    @Override
    public String partitioningId() {
        return _PARTITIONING_ID;
    }

    @Override
    public String[] blockIds() {
        return BLOCK_IDS;
    }

    @Override
    public String blockJavadocId() {
        return _BLOCK_JAVADOC_ID;
    }

    static class EmptyCommentDetector
    implements IWordDetector {
        EmptyCommentDetector() {
        }

        public boolean isWordPart(char c) {
            return c == '*' || c == '/';
        }

        public boolean isWordStart(char c) {
            return c == '/';
        }
    }

    static class WordPredicateRule
    extends WordRule
    implements IPredicateRule {
        private IToken fSuccessToken;

        public WordPredicateRule(IToken iToken) {
            super((IWordDetector)new EmptyCommentDetector());
            this.fSuccessToken = iToken;
            this.addWord("/**/", this.fSuccessToken);
        }

        public IToken evaluate(ICharacterScanner iCharacterScanner, boolean bl) {
            return super.evaluate(iCharacterScanner);
        }

        public IToken getSuccessToken() {
            return this.fSuccessToken;
        }
    }
}

