/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.text;

import com.deltawalker.differencer.range.IRangeComparator;
import com.deltawalker.interfaces.IFilter;
import com.deltawalker.interfaces.ITextFilter;
import com.deltawalker.text.ITokenComparator;
import com.deltawalker.text.TextFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TokenComparator
implements ITokenComparator {
    private static final Logger LOG = LoggerFactory.getLogger(TokenComparator.class);
    protected List<ITextFilter> charFilters = new ArrayList<ITextFilter>();
    private boolean filterPending = true;
    private boolean ignoreCase;
    protected List<ITextFilter> lineFilters = new ArrayList<ITextFilter>();
    private int rangeCount;
    private int[] realIndices;

    protected TokenComparator() {
    }

    protected TokenComparator(List<? extends IFilter> list, boolean bl) {
        this.setIgnoreCase(bl);
        this.cacheFilters(list);
    }

    protected void cacheFilters(List<? extends IFilter> list) {
        for (IFilter iFilter : list) {
            ITextFilter iTextFilter = (ITextFilter)iFilter;
            if (!iTextFilter.isEnabled()) continue;
            if (iTextFilter.target() == TextFilter.Target.LINES) {
                this.lineFilters.add(iTextFilter);
                continue;
            }
            this.charFilters.add(iTextFilter);
        }
    }

    protected void endFilter(List<Integer> list, int n) {
        if (list != null) {
            if (LOG.isInfoEnabled()) {
                LOG.info("realIndices=" + list);
            }
            int n2 = list.size();
            this.realIndices = new int[n2];
            int n3 = 0;
            while (n3 < n2) {
                this.realIndices[n3] = list.get(n3);
                ++n3;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("End filter realIndices=" + Arrays.toString(this.realIndices));
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("End filter: realIndices=NO");
        }
        this.rangeCount = n;
        this.filterPending = false;
    }

    protected abstract int filter();

    public final boolean getIgnoreCase() {
        return this.ignoreCase;
    }

    protected abstract Object getRange(int var1);

    @Override
    public int getRangeCount() {
        if (this.filterPending) {
            this.filter();
        }
        return this.rangeCount;
    }

    protected int getRealIndex(int n) {
        if (this.filterPending) {
            this.filter();
        }
        int n2 = -1;
        if (this.realIndices != null) {
            if (n >= 0 && n < this.rangeCount) {
                n2 = this.realIndices[n];
            } else {
                if (LOG.isInfoEnabled()) {
                    LOG.info("rangeIx == rangeCount, whereas it should be rangeCount -1");
                }
                n2 = this.realIndices[this.rangeCount - 1] + 1;
            }
        } else {
            n2 = n;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("rangeIx=" + n + "   realIx=" + n2);
        }
        return n2;
    }

    @Override
    public int getTokenLength(int n) {
        return this.getTokenStart(n + 1) - this.getTokenStart(n);
    }

    @Override
    public boolean rangesEqual(int n, IRangeComparator iRangeComparator, int n2) {
        if (iRangeComparator == null || !iRangeComparator.getClass().equals(this.getClass())) {
            return false;
        }
        return this.rangesEqual(this.getRange(n), ((TokenComparator)iRangeComparator).getRange(n2));
    }

    protected abstract boolean rangesEqual(Object var1, Object var2);

    public void setIgnoreCase(boolean bl) {
        this.ignoreCase = bl;
    }

    @Override
    public boolean skipRangeComparison(int n, int n2, IRangeComparator iRangeComparator) {
        return false;
    }

    public String toString() {
        return "rangeCount=" + this.rangeCount + ", realIndices=" + Arrays.toString(this.realIndices);
    }
}

