/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.text;

import com.deltawalker.DocType;
import com.deltawalker.Msg;
import com.deltawalker.interfaces.IFilter;
import com.deltawalker.interfaces.ITextFilter;
import com.deltawalker.script.Filter;
import com.deltopia.StringUtil;
import com.deltopia.interfaces.IJsonState;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TextFilter
implements ITextFilter,
IJsonState {
    private static final Logger LOG = LoggerFactory.getLogger(TextFilter.class);
    public static final String FDITF_ID_01 = "ti1";
    public static final String FDITF_ID_02 = "ti2";
    public static final String FDTF_ID_01 = "t1";
    public static final String FDTF_ID_02 = "t2";
    public static final String FDTF_ID_03 = "t3";
    private static final int IGNORE_DELIMITERS = 1;
    private static final int IGNORE_WHITESPACE = 2;
    private final String description;
    private final boolean enabled;
    private int equivalence;
    private volatile int hashCode;
    private String jsonId;
    private final Pattern pattern;
    private final Target target;

    public static String displayStringToRegex(String string) {
        return StringUtil.replace((String)string, (String)"\\t", (String)"\t");
    }

    public static String filter(String string, List<? extends IFilter> list) {
        char[] cArray = string.toCharArray();
        TextFilter.getMatched(string, cArray, list);
        int n = 0;
        int n2 = 0;
        while (n2 < cArray.length) {
            if (cArray[n2] != '\u0000') {
                cArray[n++] = cArray[n2];
            }
            ++n2;
        }
        return String.valueOf(cArray, 0, n);
    }

    private static char[] getMatched(CharSequence charSequence, char[] cArray, List<? extends IFilter> list) {
        if (cArray == null) {
            cArray = charSequence.toString().toCharArray();
        }
        int n = cArray.length;
        for (IFilter iFilter : list) {
            int n2;
            int n3;
            int n4;
            boolean bl;
            ITextFilter iTextFilter = (ITextFilter)iFilter;
            Pattern pattern = iTextFilter.pattern();
            int n5 = ((TextFilter)iTextFilter).equivalence();
            boolean bl2 = (n5 & 2) != 0;
            boolean bl3 = bl = (n5 & 1) != 0;
            if (bl2 || bl) {
                int n6 = 0;
                n4 = 0;
                n3 = n;
                while (--n3 >= 0) {
                    n2 = cArray[n3];
                    if (bl2 && (n2 == 32 || n2 == 9)) {
                        cArray[n3] = '\u0000';
                        ++n6;
                    }
                    if (!bl || n2 != 10 && n2 != 13 && n2 != 12 && n2 != 11) continue;
                    cArray[n3] = '\u0000';
                    ++n4;
                }
                if (!LOG.isDebugEnabled() || n6 <= 0 && n4 <= 0) continue;
                LOG.debug("Ignore whitespaces=" + n6 + ", delimiters=" + n4);
                continue;
            }
            Matcher matcher = pattern.matcher(charSequence);
            while (matcher.find()) {
                n4 = matcher.start(0);
                n3 = matcher.end(0);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Matched: '" + charSequence.subSequence(n4, n3) + "'");
                }
                n2 = n4;
                while (n2 < n3) {
                    cArray[n2] = '\u0000';
                    ++n2;
                }
            }
        }
        return cArray;
    }

    public static char[] getMatched(CharSequence charSequence, List<? extends IFilter> list) {
        return TextFilter.getMatched(charSequence, null, list);
    }

    public static String regexToDisplayString(String string) {
        return StringUtil.replace((String)string, (String)"\t", (String)"\\t");
    }

    public TextFilter(JsonReader jsonReader) throws IOException {
        boolean bl = false;
        String string = null;
        String string2 = null;
        Target target = Target.CHARS;
        while (jsonReader.hasNext()) {
            String string3 = jsonReader.nextName();
            if (string3.equals("ex")) {
                string = jsonReader.nextString();
                continue;
            }
            if (string3.equals("on")) {
                bl = jsonReader.nextBoolean();
                continue;
            }
            if (string3.equals("tgt")) {
                target = Target.fromJson(jsonReader.nextString());
                continue;
            }
            if (string3.equals("dsc")) {
                string2 = jsonReader.nextString();
                continue;
            }
            assert (false);
            jsonReader.skipValue();
        }
        this.pattern = Pattern.compile(string);
        this.setEquivalence(string);
        this.enabled = bl;
        this.target = target;
        this.description = string2;
    }

    public TextFilter(String string, Target target, String string2) {
        this(string, target, true, string2, null);
    }

    public TextFilter(String string, Target target, boolean bl, String string2, String string3) {
        this.setEquivalence(string);
        this.pattern = Pattern.compile(string);
        this.target = target;
        this.enabled = bl;
        this.description = StringUtil.makeSafe((String)string2);
        this.jsonId = StringUtil.makeSafe((String)string3);
    }

    public TextFilter(TextFilter textFilter, boolean bl) {
        this.description = textFilter.description;
        this.pattern = textFilter.pattern != null ? Pattern.compile(textFilter.pattern.pattern()) : null;
        this.target = textFilter.target;
        this.enabled = bl;
        this.equivalence = textFilter.equivalence;
        this.jsonId = textFilter.jsonId;
    }

    @Override
    public IFilter clone(boolean bl) {
        return new TextFilter(this, bl);
    }

    protected Element createElement(Document document, Element element, String string, String string2, boolean bl) {
        Element element2 = document.createElement(string);
        if (!StringUtil.isEmpty((String)string2)) {
            if (bl) {
                element2.appendChild(document.createCDATASection(string2));
            } else {
                element2.setTextContent(string2);
            }
        }
        element.appendChild(element2);
        return element2;
    }

    @Override
    public DocType docType() {
        return DocType.TEXT;
    }

    @Override
    public boolean equals(Filter filter, boolean bl) {
        if (this == filter) {
            return true;
        }
        if (!(filter instanceof TextFilter)) {
            return false;
        }
        TextFilter textFilter = (TextFilter)filter;
        if (bl && this.isEnabled() != textFilter.isEnabled()) {
            return false;
        }
        return this.description.equals(textFilter.description) && this.target == textFilter.target && this.isRegexType() == textFilter.isRegexType() && this.pattern.pattern().equals(textFilter.pattern.pattern());
    }

    public boolean equals(Object object) {
        if (object instanceof Filter) {
            return this.equals((Filter)object, false);
        }
        return false;
    }

    private final int equivalence() {
        return this.equivalence;
    }

    public void fromJson(JsonReader jsonReader) throws IOException {
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDisplayExpression() {
        return this.getExpression();
    }

    @Override
    public String getExpression() {
        return this.pattern != null ? this.pattern.pattern() : "";
    }

    public int hashCode() {
        int n = this.hashCode;
        if (n == 0) {
            n = 17;
            n = 31 * n + (this.isRegexType() ? 1 : 0);
            n = 31 * n + this.description.hashCode();
            n = 31 * n + this.target.hashCode();
            this.hashCode = n = 31 * n + this.pattern.pattern().hashCode();
        }
        return n;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isForLines() {
        return this.target == Target.LINES;
    }

    @Override
    public boolean isRegexType() {
        return this.equivalence == 0;
    }

    @Override
    public boolean isVisible() {
        return this.equivalence == 0;
    }

    @Override
    public String jsonId() {
        return this.jsonId;
    }

    @Override
    public Pattern pattern() {
        return this.pattern;
    }

    @Override
    public Element report(Element element) {
        if (!this.isEnabled()) {
            return null;
        }
        Document document = element.getOwnerDocument();
        Element element2 = document.createElement("filter");
        element.appendChild(element2);
        this.createElement(document, element2, "expression", this.getExpression(), true);
        this.createElement(document, element2, "target", this.target().toString(), false);
        this.createElement(document, element2, "description", this.getDescription(), true);
        return null;
    }

    private void setEquivalence(String string) {
        if (string.equals("[ \\t]*")) {
            this.equivalence = 2;
        } else if (string.equals("[\\n\\r\\f\\x0B]$")) {
            this.equivalence = 1;
        } else if ("\\s".equals(string)) {
            this.equivalence = 3;
        }
    }

    @Override
    public Target target() {
        return this.target;
    }

    public void toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.name("tp").value(DocType.TEXT.toJson());
        jsonWriter.name("on").value(this.isEnabled());
        jsonWriter.name("tgt").value(this.target().toJson());
        jsonWriter.name("ex").value(this.getExpression());
        jsonWriter.name("dsc").value(this.getDescription());
    }

    public String toString() {
        String string = String.valueOf(this.getDescription()) + "   docType=" + (Object)((Object)this.docType()) + "   regex=" + this.getExpression() + "   enabled=" + this.isEnabled() + "   target=" + (Object)((Object)this.target());
        return string;
    }

    @Override
    public String[] toStringArray(boolean bl) {
        if (bl) {
            return new String[]{"Filter", "Description", "RegEx", "Target"};
        }
        String string = this.isRegexType() ? "Yes" : "No";
        return new String[]{this.getDisplayExpression(), this.getDescription(), string, this.target().toString()};
    }

    public static final class RegEx {
        public static final String BLANK_LINES = "^[ \t\\x0B\f]*$";
        public static final String CPP_COMMENTS = "//.*$";
        public static final String CVS_COMMENTS = "\\$(Author|Date|Header|Id|Locker|Name|RCSfile|Revision|Source|State):[^$]*\\$";
        public static final String IGNORE_LINE_ENDINGS = "[\\n\\r\\f\\x0B]$";
        public static final String IGNORE_WHITESPACE = "[ \\t]*";

        private RegEx() {
        }
    }

    public static final class Tag {
        public static final String DESCRIPTION = "description";
        public static final String EXPRESSION = "expression";
        private static final String FILTER = "filter";
        public static final String TARGET = "target";

        private Tag() {
        }
    }

    public static final class Target
    extends Enum<Target> {
        public static final /* enum */ Target CHARS = new Target(Msg.RegexFilter_Target_chars, "c");
        public static final /* enum */ Target LINES = new Target(Msg.RegexFilter_Target_lines, "l");
        private final String jsonText;
        private final String text;
        private static final /* synthetic */ Target[] ENUM$VALUES;

        static {
            ENUM$VALUES = new Target[]{CHARS, LINES};
        }

        public static Target fromJson(String string) {
            if (string.equals(Target.LINES.jsonText)) {
                return LINES;
            }
            assert (string.equals(Target.CHARS.jsonText));
            return CHARS;
        }

        private Target(String string2, String string3) {
            this.text = string2;
            this.jsonText = string3;
        }

        public String toJson() {
            return this.jsonText;
        }

        public String toString() {
            return this.text;
        }

        public static Target[] values() {
            Target[] targetArray = ENUM$VALUES;
            int n = targetArray.length;
            Target[] targetArray2 = new Target[n];
            System.arraycopy(ENUM$VALUES, 0, targetArray2, 0, n);
            return targetArray2;
        }

        public static Target valueOf(String string) {
            return Enum.valueOf(Target.class, string);
        }
    }
}

