/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.text;

import com.deltawalker.Delta;
import com.deltawalker.DiffModel;
import com.deltawalker.DiffModelEvent;
import com.deltawalker.LineEndingUtil;
import com.deltawalker.MergeException;
import com.deltawalker.NotifyUtil;
import com.deltawalker.PrefKey;
import com.deltawalker.Relation;
import com.deltawalker.differencer.range.DiffRange;
import com.deltawalker.differencer.range.RangeDifferencerJob;
import com.deltawalker.interfaces.IDiffDoc;
import com.deltawalker.interfaces.IFilter;
import com.deltawalker.interfaces.IFilters;
import com.deltawalker.interfaces.IFiltersListener;
import com.deltawalker.interfaces.IReplaceable;
import com.deltawalker.interfaces.ITextDiffDoc;
import com.deltawalker.interfaces.ITextDiffModel;
import com.deltawalker.script.Delta;
import com.deltawalker.script.Role;
import com.deltawalker.text.ITextDoc;
import com.deltawalker.text.MergeOp;
import com.deltawalker.text.TextDiffSummary;
import com.deltawalker.ui.IDeltaListener;
import com.deltawalker.ui.IDeltaNotifier;
import com.deltawalker.ui.IDiffSummary;
import com.deltopia.IAsyncResult;
import com.deltopia.ObjectUtil;
import com.deltopia.eclipse.util.Goto;
import com.deltopia.ui.concurrency.GuiExecutor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextDiffModel
extends DiffModel
implements ITextDiffModel,
IDeltaNotifier {
    private static final Logger LOG = LoggerFactory.getLogger(TextDiffModel.class);
    public static final int UPDATE_DELAY = 500;
    private final List<DiffRange> deltas = new CopyOnWriteArrayList<DiffRange>();
    private Boolean hasTrueDeltas;
    private volatile boolean ignoreDocChanges = false;
    private final IDocumentListener onDocument = new IDocumentListener(){

        public void documentAboutToBeChanged(DocumentEvent documentEvent) {
        }

        public void documentChanged(DocumentEvent documentEvent) {
            if (TextDiffModel.this.ignoreDocChanges) {
                return;
            }
            Timer timer = new Timer(true);
            if (TextDiffModel.this.refreshTask != null) {
                TextDiffModel.this.refreshTask.cancel();
            }
            TextDiffModel.this.refreshTask = new TimerTask(){

                @Override
                public void run() {
                    TextDiffModel.this.computeDeltas();
                }
            };
            timer.schedule(TextDiffModel.this.refreshTask, 500L);
        }
    };
    private final IFiltersListener onFilters = new IFiltersListener(){

        @Override
        public void filtersChanged(Set<? extends IFilter> set) {
            TextDiffModel.this.computeDeltas();
        }
    };
    private final IJobChangeListener onJob = new JobChangeAdapter(){
        long start = 0L;

        public void aboutToRun(IJobChangeEvent iJobChangeEvent) {
            this.start = System.currentTimeMillis();
            TextDiffModel.this.clearSummary();
            TextDiffModel.this.fireEvent(DiffModelEvent.Type.BEGIN_COMPARE, iJobChangeEvent.getJob());
            TextDiffModel.this.selDelta = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void done(IJobChangeEvent iJobChangeEvent) {
            DiffRange[] diffRangeArray = ((RangeDifferencerJob)iJobChangeEvent.getJob()).getDeltas();
            TextDiffModel.this.deltas.addAll(Arrays.asList(diffRangeArray));
            if (LOG.isDebugEnabled()) {
                LOG.debug("### Computing deltas took: " + (System.currentTimeMillis() - this.start));
                this.start = System.currentTimeMillis();
            }
            TextDiffModel.this.setSummary(TextDiffModel.this.createSummary());
            TextDiffModel.this.fireEvent(DiffModelEvent.Type.END_COMPARE, iJobChangeEvent.getJob().getResult());
            TextDiffModel textDiffModel = TextDiffModel.this;
            synchronized (textDiffModel) {
                TextDiffModel.this.hasTrueDeltas = null;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("### Rendering deltas took: " + (System.currentTimeMillis() - this.start));
            }
        }
    };
    private final IPropertyChangeListener onProp = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getProperty();
            IPreferenceStore iPreferenceStore = TextDiffModel.this.dDoc.preferences();
            if (iPreferenceStore == null) {
                LOG.error("'prefs' must be a valid object");
                return;
            }
            if (PrefKey.T_SHOW_PSEUDO_CONFLICTS.toString().equals(string)) {
                TextDiffModel.this.showPseudo = iPreferenceStore.getBoolean(PrefKey.T_SHOW_PSEUDO_CONFLICTS.toString());
                TextDiffModel.this.computeDeltas();
            } else if (PrefKey.T_DO_INLINE_DELTAS.toString().equals(string) && TextDiffModel.this.rdJob != null) {
                boolean bl = iPreferenceStore.getBoolean(PrefKey.T_DO_INLINE_DELTAS.toString());
                if (TextDiffModel.this.rdJob.shouldComputeInlineDeltas() != bl) {
                    TextDiffModel.this.rdJob.setComputeInlineDeltas(bl);
                    for (DiffRange diffRange : TextDiffModel.this.deltas) {
                        diffRange.disposeChildren();
                    }
                }
            }
        }
    };
    private final IPositionUpdater posUpdater = new DefaultPositionUpdater("DocumentRangeCategory");
    private RangeDifferencerJob rdJob;
    private TimerTask refreshTask;
    private DiffRange selDelta;
    private boolean showPseudo;
    private final List<DiffRange> umDeltas = Collections.unmodifiableList(this.deltas);

    private static void deleteText(final List<DiffRange> list, final Set<Role> set, final Map<Role, IDocument> map, final IProgressMonitor iProgressMonitor) throws BadLocationException {
        final BadLocationException[] badLocationExceptionArray = new BadLocationException[1];
        GuiExecutor.instance().execute(new Runnable(){

            @Override
            public void run() {
                ListIterator listIterator = list.listIterator(list.size());
                try {
                    while (listIterator.hasPrevious()) {
                        DiffRange diffRange = (DiffRange)listIterator.previous();
                        if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
                            return;
                        }
                        if (diffRange.isResolved()) continue;
                        for (Role role : set) {
                            IDocument iDocument = (IDocument)map.get((Object)role);
                            Position position = diffRange.position(role);
                            iDocument.replace(position.offset, position.length, "");
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                    LOG.warn("Couldn't delete the specified text", (Throwable)badLocationException);
                    badLocationExceptionArray[0] = badLocationException;
                }
            }
        });
        if (badLocationExceptionArray[0] != null) {
            throw badLocationExceptionArray[0];
        }
    }

    private static void merge(final MergeOp mergeOp, final Map<Role, IDocument> map, final List<DiffRange> list, final Role role, final Role role2, IProgressMonitor iProgressMonitor) throws BadLocationException {
        if (mergeOp == null) {
            throw new NullPointerException("'mergeOp' cannot be null.");
        }
        if (mergeOp != MergeOp.MERGE && role == null) {
            throw new NullPointerException("'src' cannot be null.");
        }
        if (map == null) {
            throw new NullPointerException("'documents' cannot be null.");
        }
        if (map.isEmpty()) {
            throw new IllegalArgumentException("'documents' cannot be empty.");
        }
        if (role2 == null) {
            throw new NullPointerException("'dst' cannot be null.");
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("merge(mergeOp=" + mergeOp + "src=" + (Object)((Object)role) + ", dst=" + (Object)((Object)role2) + ")");
        }
        if (mergeOp == MergeOp.DELETE) {
            EnumMap<Role, IDocument> enumMap = new EnumMap<Role, IDocument>(Role.class);
            enumMap.put(role, map.get((Object)role));
            TextDiffModel.deleteText(list, EnumSet.of(role), enumMap, iProgressMonitor);
            return;
        }
        if (role == role2) {
            throw new IllegalArgumentException("Role." + (Object)((Object)role) + " cannot be both a source and a destination.");
        }
        final Relation relation = mergeOp != MergeOp.MERGE ? Relation.fromRoles(role, role2) : null;
        GuiExecutor.instance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Role role3 = role;
                    IDocument iDocument = (IDocument)map.get((Object)role);
                    IDocument iDocument2 = (IDocument)map.get((Object)role2);
                    String string = LineEndingUtil.fromPreferences();
                    ListIterator listIterator = list.listIterator(list.size());
                    while (listIterator.hasPrevious()) {
                        int n;
                        int n2;
                        DiffRange diffRange = (DiffRange)listIterator.previous();
                        if (diffRange.isSame() || diffRange.isPseudoConflict() || diffRange.isResolved()) continue;
                        if (mergeOp == MergeOp.MERGE) {
                            if (!diffRange.isSame(Relation.REF_ONE)) {
                                role3 = Role.ONE;
                            } else if (!diffRange.isSame(Relation.REF_TWO)) {
                                role3 = Role.TWO;
                            }
                            iDocument = (IDocument)map.get((Object)role3);
                        } else if (diffRange.isSame(relation)) continue;
                        Position position = diffRange.position(role3);
                        Position position2 = diffRange.position(role2);
                        int n3 = position.offset;
                        int n4 = position.length;
                        if (mergeOp == MergeOp.APPEND) {
                            n2 = position2.offset + position2.length;
                            n = 0;
                        } else {
                            n2 = position2.offset;
                            n = position2.length;
                        }
                        String string2 = iDocument.get(n3, n4);
                        if (n2 > 0) {
                            boolean bl;
                            try {
                                int n5 = iDocument2.getLineOfOffset(n2 - 1);
                                bl = iDocument2.getLineDelimiter(n5) == null;
                            }
                            catch (BadLocationException badLocationException) {
                                bl = false;
                            }
                            if (bl) {
                                String[] stringArray;
                                if (string == null && (stringArray = iDocument2.getLegalLineDelimiters()) != null && stringArray.length > 0) {
                                    string = stringArray[0];
                                }
                                if (string != null) {
                                    string2 = String.valueOf(string) + string2;
                                }
                            }
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("replacing: dstOffset=" + n2 + " dstLength=" + n + " dstDocument.getLength()=" + iDocument2.getLength() + " \ncontent=" + string2);
                        }
                        iDocument2.replace(n2, n, string2);
                        position2.setOffset(n2);
                        position2.setLength(string2.length());
                        diffRange.setResolved(true);
                    }
                }
                catch (Throwable throwable) {
                    LOG.warn("Couldn't merge non-conflicting text differences", throwable);
                }
            }
        });
    }

    public static void mergeNonConflicts(Map<Role, IDocument> map, DiffRange[] diffRangeArray) throws BadLocationException {
        TextDiffModel.merge(MergeOp.MERGE, map, Arrays.asList(diffRangeArray), null, Role.REF, null);
    }

    public TextDiffModel(IDiffDoc iDiffDoc) {
        super(iDiffDoc);
        IPreferenceStore iPreferenceStore = iDiffDoc.preferences();
        this.showPseudo = iPreferenceStore.getBoolean(PrefKey.T_SHOW_PSEUDO_CONFLICTS.toString());
        iPreferenceStore.addPropertyChangeListener(this.onProp);
        for (Role role : Relation.roles(true)) {
            this.installDocumentListeners(this.textDoc(role).document(), true);
        }
        this.filters().addFilterListener(this.onFilters);
    }

    @Override
    public void addDeltaListener(IDeltaListener iDeltaListener) {
        if (iDeltaListener == null) {
            throw new NullPointerException("listener");
        }
        this.addListenerObject(iDeltaListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IAsyncResult beginGetDeltas() {
        IAsyncResult iAsyncResult = null;
        if (this.deltas.isEmpty()) {
            TextDiffModel textDiffModel = this;
            synchronized (textDiffModel) {
                if (this.rdJob == null && (this.rdJob = this.createJob()) != null) {
                    this.rdJob.addJobChangeListener(this.onJob);
                    this.rdJob.schedule();
                    iAsyncResult = new IAsyncResult(){

                        public void join() throws InterruptedException {
                            TextDiffModel.this.rdJob.join();
                        }
                    };
                }
            }
        }
        return iAsyncResult;
    }

    @Override
    public IAsyncResult beginGetInlineDeltas(DiffRange diffRange) {
        IAsyncResult iAsyncResult = null;
        if (diffRange.children() == null && this.rdJob != null && this.rdJob.shouldComputeInlineDeltas()) {
            iAsyncResult = this.rdJob.beginInlineDeltaUpdate(new DiffRange[]{diffRange});
        }
        return iAsyncResult;
    }

    @Override
    public boolean canMergeNonConflicts() {
        return this.isThreeWay() && this.hasTrueDiffs();
    }

    @Override
    public void computeDeltas() {
        this.disposeDeltas();
        this.beginGetDeltas();
    }

    @Override
    public Collection<DiffRange> computeInlineDeltas(DiffRange diffRange) {
        IAsyncResult iAsyncResult = this.beginGetInlineDeltas(diffRange);
        if (iAsyncResult != null) {
            try {
                iAsyncResult.join();
            }
            catch (InterruptedException interruptedException) {
                LOG.warn(interruptedException.getLocalizedMessage());
            }
        }
        return diffRange.children();
    }

    @Override
    public void copy(Role role, Role role2, boolean bl, IReplaceable iReplaceable) throws NullPointerException {
        if (role == null) {
            throw new NullPointerException("src");
        }
        if (role2 == null) {
            throw new NullPointerException("dst");
        }
        ITextDiffDoc iTextDiffDoc = this.deltaDoc();
        ITextDoc iTextDoc = (ITextDoc)iTextDiffDoc.doc(0, role);
        ITextDoc iTextDoc2 = (ITextDoc)iTextDiffDoc.doc(0, role2);
        iTextDoc2.document().set(iTextDoc.document().get());
        if (bl) {
            iTextDoc.document().set("");
        }
    }

    private RangeDifferencerJob createJob() {
        ITextDiffDoc iTextDiffDoc = this.deltaDoc();
        if (iTextDiffDoc.triadCount() <= 0) {
            return null;
        }
        return new RangeDifferencerJob(iTextDiffDoc.documents(), null, this.isThreeWay(), iTextDiffDoc.preferences(), iTextDiffDoc.filters()){

            @Override
            protected DiffRange[] createInlineDiffs(RangeDifferencerJob.InlineDiffCreationData[] inlineDiffCreationDataArray) {
                DiffRange[] diffRangeArray = super.createInlineDiffs(inlineDiffCreationDataArray);
                LinkedHashSet<DiffRange> linkedHashSet = new LinkedHashSet<DiffRange>();
                RangeDifferencerJob.InlineDiffCreationData[] inlineDiffCreationDataArray2 = inlineDiffCreationDataArray;
                int n = inlineDiffCreationDataArray.length;
                int n2 = 0;
                while (n2 < n) {
                    RangeDifferencerJob.InlineDiffCreationData inlineDiffCreationData = inlineDiffCreationDataArray2[n2];
                    linkedHashSet.add(inlineDiffCreationData.parent);
                    ++n2;
                }
                if (!linkedHashSet.isEmpty()) {
                    TextDiffModel.this.fireEvent(DiffModelEvent.Type.INLINE_DIFFS_CHANGED, new ArrayList(linkedHashSet));
                }
                return diffRangeArray;
            }
        };
    }

    @Override
    protected IDiffSummary createSummary() {
        return new TextDiffSummary(this);
    }

    @Override
    public void deleteText(List<DiffRange> list, Set<Role> set, IProgressMonitor iProgressMonitor) throws BadLocationException {
        EnumMap<Role, IDocument> enumMap = new EnumMap<Role, IDocument>(Role.class);
        TextDiffModel.deleteText(list, set, enumMap, iProgressMonitor);
    }

    @Override
    public ITextDiffDoc deltaDoc() {
        return (ITextDiffDoc)super.deltaDoc();
    }

    @Override
    public void dispose() {
        this.dDoc.preferences().removePropertyChangeListener(this.onProp);
        for (Role object2 : Relation.roles(true)) {
            this.installDocumentListeners(this.textDoc(object2).document(), false);
        }
        this.disposeDeltas();
        IFilters iFilters = this.deltaDoc().filters();
        if (iFilters != null) {
            iFilters.removeFilterListener(this.onFilters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeDeltas() {
        TextDiffModel object2 = this;
        synchronized (object2) {
            if (this.rdJob != null) {
                this.rdJob.dispose();
                this.rdJob = null;
            }
        }
        for (DiffRange diffRange : this.deltas) {
            diffRange.dispose();
        }
        this.deltas.clear();
    }

    @Override
    public List<DiffRange> getDeltas() {
        return this.getDeltas(false);
    }

    @Override
    public List<DiffRange> getDeltas(boolean bl) {
        if (this.umDeltas.isEmpty()) {
            IAsyncResult iAsyncResult = this.beginGetDeltas();
            if (bl && iAsyncResult != null) {
                try {
                    iAsyncResult.join();
                }
                catch (InterruptedException interruptedException) {
                    LOG.warn(interruptedException.getMessage());
                }
            }
        }
        return this.umDeltas;
    }

    @Override
    public Set<DiffRange> getDeltasOfKind(Delta.Kind kind) {
        List<DiffRange> list = this.getDeltas();
        LinkedHashSet<DiffRange> linkedHashSet = new LinkedHashSet<DiffRange>();
        for (DiffRange diffRange : list) {
            if (diffRange.getKind(Relation.REF_ONE) != kind) continue;
            linkedHashSet.add(diffRange);
        }
        return linkedHashSet;
    }

    public Set<DiffRange> getDeltasOfOverallKind(Delta delta) {
        List<DiffRange> list = this.getDeltas();
        LinkedHashSet<DiffRange> linkedHashSet = new LinkedHashSet<DiffRange>();
        for (DiffRange diffRange : list) {
            if (!diffRange.isOverallKind(delta)) continue;
            linkedHashSet.add(diffRange);
        }
        return linkedHashSet;
    }

    private DiffRange getFirstTrueDiff() {
        List<DiffRange> list = this.getDeltas();
        for (DiffRange diffRange : list) {
            if (diffRange.isSame()) continue;
            return diffRange;
        }
        return null;
    }

    private DiffRange getLastTrueDiff() {
        List<DiffRange> list = this.getDeltas();
        int n = list.size();
        int n2 = n - 1;
        while (n2 >= 0) {
            if (!list.get(n2).isSame()) {
                return list.get(n2);
            }
            --n2;
        }
        return null;
    }

    @Override
    public DiffRange getSelected() {
        return this.selDelta;
    }

    @Override
    public List<DiffRange> getTrueDiffs() {
        List<DiffRange> list = this.getDeltas();
        ArrayList<DiffRange> arrayList = new ArrayList<DiffRange>(list.size());
        for (DiffRange diffRange : list) {
            if (diffRange.isSame()) continue;
            arrayList.add(diffRange);
        }
        return arrayList;
    }

    @Override
    public boolean gotoDelta(Goto goto_, boolean bl, Set<Delta> set, DiffRange diffRange) {
        boolean bl2;
        if (!this.hasTrueDiffs()) {
            return false;
        }
        DiffRange diffRange2 = this.selDelta != null ? this.selDelta : diffRange;
        if (diffRange2 == null) {
            diffRange2 = goto_ == Goto.NEXT ? this.getFirstTrueDiff() : this.getLastTrueDiff();
            bl2 = true;
        } else {
            bl2 = false;
        }
        List<DiffRange> list = this.getDeltas();
        int n = list.indexOf(diffRange2);
        if (n == -1) {
            return false;
        }
        int n2 = goto_ == Goto.NEXT ? list.size() - 1 : 0;
        int n3 = n + (bl2 ? 0 : goto_.toInt());
        while (!(goto_ == Goto.NEXT ? n3 > n2 : n3 < n2)) {
            DiffRange diffRange3 = list.get(n3);
            if (!diffRange3.isSame()) {
                Delta.Kind kind = null;
                if (set.size() == 1) {
                    kind = set.iterator().next().getKind(Relation.REF_ONE);
                }
                if (set.isEmpty() || set.size() > 1 || diffRange3.isOverallKind(kind)) {
                    if (!bl) {
                        this.selectDelta(diffRange3, true, true);
                    }
                    return true;
                }
            }
            n3 += goto_.toInt();
        }
        return false;
    }

    @Override
    public synchronized boolean hasTrueDiffs() {
        if (this.hasTrueDeltas == null || !this.hasTrueDeltas.booleanValue()) {
            this.hasTrueDeltas = false;
            List<DiffRange> list = this.getDeltas();
            for (DiffRange diffRange : list) {
                if (diffRange.isSame()) continue;
                this.hasTrueDeltas = true;
            }
        }
        return this.hasTrueDeltas;
    }

    private void installDocumentListeners(IDocument iDocument, boolean bl) {
        assert (iDocument != null);
        if (!iDocument.containsPositionCategory("DocumentRangeCategory")) {
            iDocument.addPositionCategory("DocumentRangeCategory");
        } else {
            try {
                iDocument.removePositionCategory("DocumentRangeCategory");
            }
            catch (BadPositionCategoryException badPositionCategoryException) {
                badPositionCategoryException.printStackTrace();
            }
        }
        if (bl) {
            iDocument.addDocumentListener(this.onDocument);
            iDocument.addPositionUpdater(this.posUpdater);
        } else {
            iDocument.removeDocumentListener(this.onDocument);
            iDocument.removePositionUpdater(this.posUpdater);
        }
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public void merge(MergeOp mergeOp, List<DiffRange> list, Role role, Role role2, IProgressMonitor iProgressMonitor) throws BadLocationException {
        this.ignoreDocChanges = true;
        try {
            TextDiffModel.merge(mergeOp, this.deltaDoc().documents(), list, role, role2, iProgressMonitor);
        }
        finally {
            this.ignoreDocChanges = false;
        }
        this.computeDeltas();
    }

    @Override
    protected void mergeNonConflicts(IProgressMonitor iProgressMonitor) throws MergeException {
        this.ignoreDocChanges = true;
        try {
            try {
                TextDiffModel.merge(MergeOp.MERGE, this.deltaDoc().documents(), this.getDeltas(), null, Role.REF, iProgressMonitor);
            }
            catch (Throwable throwable) {
                throw new MergeException(throwable);
            }
        }
        finally {
            this.ignoreDocChanges = false;
        }
        this.computeDeltas();
    }

    @Override
    public void removeDeltaListener(IDeltaListener iDeltaListener) {
        if (iDeltaListener == null) {
            throw new NullPointerException("listener");
        }
        this.removeListenerObject(iDeltaListener);
    }

    @Override
    public void selectDelta(DiffRange diffRange, boolean bl, boolean bl2) {
        if (!ObjectUtil.areEqual((Object)this.selDelta, (Object)diffRange)) {
            this.selDelta = diffRange;
            if (bl2) {
                NotifyUtil.fireDeltaSelectionChanged(this.getListeners(), bl);
            }
        }
    }

    @Override
    public boolean shouldShowPseudoConflicts() {
        return this.showPseudo && this.isThreeWay();
    }

    private ITextDoc textDoc(Role role) {
        return (ITextDoc)this.deltaDoc().doc(0, role);
    }
}

