/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.text;

import com.deltawalker.DiffDoc;
import com.deltawalker.DocType;
import com.deltawalker.Relation;
import com.deltawalker.interfaces.ITextDiffDoc;
import com.deltawalker.interfaces.ITextDiffModel;
import com.deltawalker.script.Role;
import com.deltawalker.text.ITextDoc;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.swt.graphics.Point;

public class TextDiffDoc
extends DiffDoc
implements ITextDiffDoc {
    private final Map<Role, IDocument> documents = new EnumMap<Role, IDocument>(Role.class);

    public TextDiffDoc(DiffDoc.Builder builder) {
        super(builder);
    }

    public TextDiffDoc(JsonReader jsonReader) throws IOException {
        super(jsonReader, "");
    }

    @Override
    public void dispose() {
        this.documents.clear();
        super.dispose();
    }

    @Override
    public DocType docType() {
        return DocType.TEXT;
    }

    @Override
    public IDocument document(Role role) {
        return this.documents().get((Object)role);
    }

    @Override
    public Map<Role, IDocument> documents() {
        if (this.documents.isEmpty()) {
            Iterator<Role> iterator = Relation.roles(this.isThreeWay()).iterator();
            while (iterator.hasNext()) {
                Role role;
                ITextDoc iTextDoc = (ITextDoc)this.doc(0, role = iterator.next());
                this.documents.put(role, iTextDoc != null ? iTextDoc.document() : null);
            }
        }
        return this.documents;
    }

    @Override
    protected void fireThreeWayChanged(boolean bl, boolean bl2) {
        this.documents.clear();
        ((ITextDiffModel)this.diffModel(0)).computeDeltas();
        super.fireThreeWayChanged(bl, bl2);
    }

    @Override
    public Point lineRangeFromPosition(Role role, Position position) {
        IDocument iDocument = this.document(role);
        Point point = new Point(0, 0);
        if (position == null || iDocument == null) {
            point.x = 0;
            point.y = 0;
            return point;
        }
        int n = position.getOffset();
        int n2 = position.getLength();
        int n3 = 0;
        try {
            n3 = iDocument.getLineOfOffset(n);
        }
        catch (BadLocationException badLocationException) {}
        int n4 = 0;
        if (n2 > 0) {
            int n5 = 0;
            try {
                n5 = iDocument.getLineOfOffset(n + n2 - 1);
            }
            catch (BadLocationException badLocationException) {}
            n4 = n5 - n3 + 1;
        }
        point.x = n3;
        point.y = n4;
        return point;
    }
}

