/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.text;

import com.deltawalker.App;
import com.deltawalker.DocType;
import com.deltawalker.Pre;
import com.deltawalker.PrefKey;
import com.deltawalker.StateBoss;
import com.deltawalker.interfaces.Comparison;
import com.deltawalker.interfaces.IDiffDoc;
import com.deltawalker.interfaces.IDocBoss;
import com.deltawalker.interfaces.IFilter;
import com.deltawalker.interfaces.IFilters;
import com.deltawalker.interfaces.IFiltersListener;
import com.deltawalker.interfaces.IFolderFilter;
import com.deltawalker.script.AlignFilter;
import com.deltawalker.script.Filter;
import com.deltawalker.script.FolderFilter;
import com.deltawalker.script.Resource;
import com.deltawalker.script.SizeUnit;
import com.deltawalker.script.TimeFilter;
import com.deltawalker.structure.AttributeFilter;
import com.deltawalker.structure.FolderFilter;
import com.deltawalker.structure.PathFilter;
import com.deltawalker.structure.SizeFilter;
import com.deltawalker.structure.TimeFilter;
import com.deltawalker.text.TextFilter;
import com.deltopia.eclipse.util.TimeUnit;
import com.deltopia.interfaces.IJsonState;
import com.deltopia.io.IFile;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Filters
extends EventManager
implements IFilters,
IJsonState {
    private static final Logger LOG = LoggerFactory.getLogger(Filters.class);
    private UUID docId;
    private DocType docType;
    protected List<IFilter> filters = new CopyOnWriteArrayList<IFilter>();
    private final UUID id = UUID.randomUUID();
    private final List<IFilter> ifilters = Collections.unmodifiableList(this.filters);

    public static final boolean equals(Filters filters, Filters filters2) {
        return filters == null ? filters2 == null : filters.equals(filters2);
    }

    public static boolean matches(List<? extends IFilter> list, IFile iFile, boolean bl) {
        if (iFile == null) {
            return false;
        }
        if (list == null) {
            return true;
        }
        int n = list.size();
        int n2 = n - 1;
        while (n2 >= 0) {
            IFolderFilter iFolderFilter;
            IFilter iFilter = list.get(n2);
            if (iFilter instanceof IFolderFilter && iFilter.isEnabled() && (iFolderFilter = (IFolderFilter)iFilter).type() != FolderFilter.Type.ALIGN && iFolderFilter.matches(iFile)) {
                return iFolderFilter.action() == FolderFilter.Action.INCLUDE;
            }
            --n2;
        }
        return false;
    }

    public static int moveUpDown(IFilters iFilters, Filter filter, boolean bl) {
        int n = iFilters.getAllAsList().indexOf(filter);
        int n2 = iFilters.getAllAsList().size();
        iFilters.remove(n);
        --n2;
        int n3 = n = bl ? n - 1 : n;
        if (bl) {
            int n4 = n;
            while (n4 >= 0) {
                if (iFilters.get(n4).docType() == DocType.FOLDER) {
                    iFilters.add(filter, n4);
                    return n4;
                }
                --n4;
            }
        } else {
            int n5 = n;
            while (n5 < n2) {
                if (iFilters.get(n5).docType() == DocType.FOLDER) {
                    iFilters.add(filter, n5 + 1);
                    return n5 + 1;
                }
                ++n5;
            }
        }
        return -1;
    }

    public static boolean shouldCloneFilter(DocType docType, DocType docType2) {
        if (docType == null) {
            throw new NullPointerException("oldType");
        }
        if (docType2 == null) {
            throw new NullPointerException("newType");
        }
        boolean bl = docType.isStructure() || docType2 == DocType.XML || docType.isText() && docType2.isText();
        return bl;
    }

    public static final void updateFilter(IFilters iFilters, IPreferenceStore iPreferenceStore, String string, boolean bl) {
        boolean bl2 = string.equals(PrefKey.C_IGNORE_WHITESPACE.toString());
        boolean bl3 = string.equals(PrefKey.C_IGNORE_LINE_ENDINGS.toString());
        List<IFilter> list = iFilters.getAllAsList();
        for (IFilter iFilter : list) {
            String string2 = iFilter.getExpression();
            if ((!bl2 || !string2.equals("[ \\t]*")) && (!bl3 || !string2.equals("[\\n\\r\\f\\x0B]$"))) continue;
            iFilters.updateEnabled(iFilter, bl);
            break;
        }
    }

    public Filters() {
    }

    public Filters(Filters filters) {
        this(filters.getAllAsList(), filters.docType());
    }

    public Filters(JsonReader jsonReader, DocType docType) throws IOException {
        this.docType = docType;
        jsonReader.beginArray();
        while (jsonReader.hasNext()) {
            this.readFilter(jsonReader);
        }
        jsonReader.endArray();
        if (docType == DocType.UNKNOWN) {
            for (IFilter iFilter : this.filters) {
                if (iFilter.docType() != DocType.FOLDER) continue;
                this.docType = DocType.FOLDER;
                break;
            }
            if (this.docType == DocType.UNKNOWN) {
                this.docType = DocType.TEXT;
            }
        }
    }

    public Filters(List<? extends IFilter> list, DocType docType) {
        if (list == null) {
            throw new NullPointerException("filters");
        }
        if (docType == null) {
            throw new NullPointerException("type");
        }
        for (IFilter iFilter : list) {
            boolean bl = Filters.shouldCloneFilter(docType, iFilter.docType());
            if (bl) {
                this.add(iFilter.clone(iFilter.isEnabled()), false);
            }
            if (!LOG.isInfoEnabled()) continue;
            LOG.info(String.valueOf(bl ? "Filters# +added " : "-skipped ") + iFilter);
        }
        this.docType = docType;
    }

    @Override
    public void add(Filter filter) {
        this.add(filter, this.filters.size());
        this.waitTillDone();
    }

    @Override
    public void add(Filter filter, int n) {
        this.add((IFilter)filter, n, true);
    }

    public void add(IFilter iFilter, boolean bl) {
        this.add(iFilter, this.filters.size(), bl);
    }

    private void add(IFilter iFilter, int n, boolean bl) {
        if (!this.filters.contains(iFilter)) {
            this.filters.add(n, iFilter);
            if (bl) {
                HashSet<IFilter> hashSet = new HashSet<IFilter>(1);
                hashSet.add(iFilter);
                this.fireChanged(hashSet);
            }
        }
    }

    @Override
    public AlignFilter addAlignFilter(String string, String string2, boolean bl, boolean bl2, String string3, String string4) throws PatternSyntaxException {
        com.deltawalker.structure.AlignFilter alignFilter = new com.deltawalker.structure.AlignFilter(string, string2, bl, bl2, string3, true, string4);
        this.add(alignFilter);
        return alignFilter;
    }

    @Override
    public void addAll(List<? extends IFilter> list) {
        HashSet<IFilter> hashSet = new HashSet<IFilter>(list.size());
        for (IFilter iFilter : list) {
            if (this.filters.contains(iFilter)) {
                if (!this.updateEnabled(iFilter, true)) continue;
                hashSet.add(iFilter);
                continue;
            }
            this.filters.add(iFilter);
            hashSet.add(iFilter);
        }
        if (!hashSet.isEmpty()) {
            this.fireChanged(hashSet);
        }
    }

    @Override
    public com.deltawalker.script.AttributeFilter addAttributeFilter(boolean bl, Resource.Attribute attribute, FolderFilter.Target target, String string) {
        AttributeFilter attributeFilter = new AttributeFilter(FolderFilter.Action.fromBool(bl), AttributeFilter.Attribute.fromScript(attribute), FolderFilter.Target.fromScript(target), true, string);
        this.add(attributeFilter);
        return attributeFilter;
    }

    @Override
    public void addFilterListener(IFiltersListener iFiltersListener) {
        this.addListenerObject(iFiltersListener);
    }

    @Override
    public com.deltawalker.script.PathFilter addPathFilter(boolean bl, FolderFilter.Target target, String string, boolean bl2, boolean bl3, String string2) {
        PathFilter pathFilter = new PathFilter(FolderFilter.Action.fromBool(bl), FolderFilter.Target.fromScript(target), string, bl2, bl3, true, string2);
        this.add(pathFilter);
        return pathFilter;
    }

    @Override
    public com.deltawalker.script.SizeFilter addSizeFilter(boolean bl, boolean bl2, long l, SizeUnit sizeUnit, String string) {
        SizeFilter sizeFilter = new SizeFilter(FolderFilter.Action.fromBool(bl), SizeFilter.Relation.fromBool(bl2), l, SizeFilter.Unit.fromScript(sizeUnit), true, string);
        this.add(sizeFilter);
        return sizeFilter;
    }

    @Override
    public com.deltawalker.script.TextFilter addTextFilter(String string, boolean bl, String string2) {
        TextFilter textFilter = new TextFilter(string, bl ? TextFilter.Target.LINES : TextFilter.Target.CHARS, string2);
        this.add(textFilter);
        return textFilter;
    }

    @Override
    public TimeFilter addTimeFilter(boolean bl, FolderFilter.Target target, boolean bl2, long l, boolean bl3, String string) {
        com.deltawalker.structure.TimeFilter timeFilter = new com.deltawalker.structure.TimeFilter(FolderFilter.Action.fromBool(bl), FolderFilter.Target.fromScript(target), TimeFilter.Relation.fromBool(bl2), l, bl3, true, string);
        this.add(timeFilter);
        return timeFilter;
    }

    @Override
    public IFilters clone() {
        return new Filters(this);
    }

    @Override
    public DocType docType() {
        return this.docType;
    }

    public boolean equals(Object object) {
        return this.equals(object, false);
    }

    @Override
    public boolean equals(Object object, boolean bl) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Filters)) {
            return false;
        }
        Filters filters = (Filters)object;
        int n = this.filters.size();
        if (n == filters.filters.size()) {
            int n2 = 0;
            while (n2 < n) {
                if (!this.filters.get(n2).equals(filters.filters.get(n2), bl)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    @Override
    public int find(IFilter iFilter) {
        int n = this.filters.size();
        int n2 = 0;
        while (n2 < n) {
            IFilter iFilter2 = this.filters.get(n2);
            if (iFilter.equals(iFilter2, true)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public void fireChanged(Set<? extends IFilter> set) {
        Object[] objectArray;
        Object[] objectArray2 = objectArray = this.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray2[n2];
            ((IFiltersListener)object).filtersChanged(set);
            ++n2;
        }
    }

    public void fromJson(JsonReader jsonReader) throws IOException {
    }

    @Override
    public IFilter get(int n) {
        return this.filters.get(n);
    }

    @Override
    public IFilter get(String string) {
        for (IFilter iFilter : this.filters) {
            if (!string.equals(iFilter.jsonId())) continue;
            return iFilter;
        }
        return null;
    }

    @Override
    public Filter[] getAll() {
        List<IFilter> list = this.getAllAsList();
        return list.toArray(new Filter[list.size()]);
    }

    @Override
    public List<IFilter> getAllAsList() {
        return this.ifilters;
    }

    @Override
    public int getCount() {
        return this.filters.size();
    }

    @Override
    public UUID id() {
        return this.id;
    }

    @Override
    public boolean makeSame(IFilters iFilters) {
        if (this.equals(iFilters, true)) {
            return false;
        }
        if (this.docType != iFilters.docType()) {
            throw new IllegalArgumentException("Filters must be of the same DocType in order to be the same.");
        }
        HashSet<IFilter> hashSet = new HashSet<IFilter>();
        List<IFilter> list = iFilters.getAllAsList();
        for (IFilter iFilter : list) {
            for (IFilter iFilter2 : this.filters) {
                if (iFilter2.equals(iFilter, true)) continue;
                hashSet.add(iFilter2);
            }
        }
        if (hashSet.isEmpty()) {
            return false;
        }
        this.filters.clear();
        for (IFilter iFilter : list) {
            this.add(iFilter.clone(iFilter.isEnabled()), false);
        }
        this.fireChanged(hashSet);
        return true;
    }

    @Override
    public boolean matches(IFile iFile) {
        if (iFile == null) {
            return false;
        }
        int n = this.filters.size();
        int n2 = n - 1;
        while (n2 >= 0) {
            IFolderFilter iFolderFilter;
            IFilter iFilter = this.filters.get(n2);
            if (iFilter instanceof IFolderFilter && (iFolderFilter = (IFolderFilter)iFilter).type() != FolderFilter.Type.ALIGN && iFolderFilter.matches(iFile)) {
                return iFolderFilter.action() == FolderFilter.Action.INCLUDE;
            }
            --n2;
        }
        return false;
    }

    @Override
    public int moveUpDown(Filter filter, boolean bl) {
        return Filters.moveUpDown(this, filter, bl);
    }

    private void readFilter(JsonReader jsonReader) throws IOException {
        Object object;
        IFilters iFilters = App.instance().filterBoss().getFactoryDefaultFilters(DocType.TEXT);
        Builder builder = new Builder();
        jsonReader.beginObject();
        while (jsonReader.hasNext()) {
            object = jsonReader.nextName();
            if (((String)object).equals("jid".toString())) {
                String string = jsonReader.nextString();
                IFilter iFilter = iFilters.get(string);
                this.filters.add(iFilter.clone(iFilter.isEnabled()));
                jsonReader.endObject();
                return;
            }
            if (((String)object).equals("tp")) {
                builder.type(DocType.fromJson(jsonReader.nextString()));
                continue;
            }
            if (((String)object).equals("stp")) {
                builder.subType(FolderFilter.Type.fromString(jsonReader.nextString()));
                continue;
            }
            if (((String)object).equals("at")) {
                builder.attribute(AttributeFilter.Attribute.fromJson(jsonReader.nextString()));
                continue;
            }
            if (((String)object).equals("on")) {
                builder.enabled(jsonReader.nextBoolean());
                continue;
            }
            if (((String)object).equals("dsc")) {
                builder.description(jsonReader.nextString());
                continue;
            }
            if (((String)object).equals("sz")) {
                builder.size(jsonReader.nextLong());
                continue;
            }
            if (((String)object).equals("dt")) {
                builder.time(jsonReader.nextLong());
                continue;
            }
            if (((String)object).equals("cs")) {
                builder.caseSensitive(jsonReader.nextBoolean());
                continue;
            }
            if (((String)object).equals("act")) {
                builder.action(FolderFilter.Action.fromJson(jsonReader.nextString()));
                continue;
            }
            if (((String)object).equals("rel")) {
                builder.relation(jsonReader.nextString());
                continue;
            }
            if (((String)object).equals("tgt")) {
                builder.target(jsonReader.nextString());
                continue;
            }
            if (((String)object).equals("rex")) {
                builder.regexType(jsonReader.nextBoolean());
                continue;
            }
            if (((String)object).equals("af")) {
                builder.targetFolders(jsonReader.nextString());
                continue;
            }
            if (((String)object).equals("ex")) {
                builder.expression(jsonReader.nextString());
                continue;
            }
            if (((String)object).equals("sex")) {
                builder.expression2(jsonReader.nextString());
                continue;
            }
            if (((String)object).equals("unt")) {
                builder.unit(jsonReader.nextString());
                continue;
            }
            if (((String)object).equals("dag")) {
                boolean bl = false;
                if (StateBoss.is(Pre.V_1997)) {
                    long l = jsonReader.nextInt();
                    bl = l == 0L;
                    builder.daysAgo(l * TimeUnit.DAYS.toMillis());
                } else {
                    bl = StateBoss.is(Pre.V_20) ? !jsonReader.nextBoolean() : jsonReader.nextBoolean();
                }
                builder.absolute(bl);
                continue;
            }
            if (LOG.isWarnEnabled()) {
                LOG.warn("Unknown JSON key: " + (String)object);
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        object = builder.build();
        this.filters.add((IFilter)object);
    }

    @Override
    public void remove(Filter filter) {
        if (this.filters.remove(filter)) {
            HashSet<IFilter> hashSet = new HashSet<IFilter>(1);
            hashSet.add((IFilter)filter);
            this.fireChanged(hashSet);
            this.waitTillDone();
        }
    }

    @Override
    public void remove(int n) {
        IFilter iFilter = this.filters.remove(n);
        if (iFilter != null) {
            HashSet<IFilter> hashSet = new HashSet<IFilter>(1);
            hashSet.add(iFilter);
            this.fireChanged(hashSet);
            this.waitTillDone();
        }
    }

    @Override
    public void removeFilterListener(IFiltersListener iFiltersListener) {
        this.removeListenerObject(iFiltersListener);
    }

    @Override
    public boolean replace(IFilter iFilter, IFilter iFilter2, boolean bl) {
        boolean bl2 = false;
        int n = this.filters.indexOf(iFilter);
        if (n != -1) {
            this.filters.remove(iFilter);
            this.filters.add(n, iFilter2);
            bl2 = true;
        }
        if (bl2 && bl) {
            HashSet<IFilter> hashSet = new HashSet<IFilter>(1);
            hashSet.add(iFilter2);
            this.fireChanged(hashSet);
        }
        return bl2;
    }

    @Override
    public void setDocId(UUID uUID) {
        this.docId = uUID;
    }

    public void toJson(JsonWriter jsonWriter) throws IOException {
        IFilters iFilters = App.instance().filterBoss().getFactoryDefaultFilters(DocType.TEXT);
        jsonWriter.beginArray();
        for (IFilter iFilter : this.filters) {
            jsonWriter.beginObject();
            if (iFilters.find(iFilter) != -1) {
                jsonWriter.name("jid").value(iFilter.jsonId());
            } else {
                ((IJsonState)iFilter).toJson(jsonWriter);
            }
            jsonWriter.endObject();
        }
        jsonWriter.endArray();
    }

    public String toString() {
        return this.filters.toString();
    }

    @Override
    public void updateAllOfType(List<? extends IFilter> list, DocType docType) {
        int n = this.filters.size() - 1;
        while (n >= 0) {
            if (this.filters.get(n).docType() == docType) {
                this.filters.remove(n);
            }
            --n;
        }
        this.filters.addAll(list);
    }

    @Override
    public boolean updateEnabled(IFilter iFilter, boolean bl) {
        if (iFilter == null) {
            throw new NullPointerException("filter");
        }
        IFilter iFilter2 = iFilter.clone(bl);
        boolean bl2 = this.replace(iFilter, iFilter2, false);
        if (bl2) {
            HashSet<IFilter> hashSet = new HashSet<IFilter>(1);
            hashSet.add(iFilter2);
            this.fireChanged(hashSet);
        }
        return bl2;
    }

    private void waitTillDone() {
        IDocBoss iDocBoss;
        IDiffDoc iDiffDoc;
        Comparison comparison;
        if (this.docId != null && (comparison = (Comparison)(iDiffDoc = (iDocBoss = App.instance().docBoss()).get(this.docId)).getHistoryEntry()) != null) {
            comparison.waitTillDone();
        }
    }

    public static class Builder {
        private boolean absolute = false;
        private FolderFilter.Action action;
        private AttributeFilter.Attribute attrib;
        private boolean caseSensitive = false;
        private long daysAgo = 0L;
        private String description = "";
        private boolean enabled = true;
        private String exp = "";
        private String exp2 = "";
        private boolean regexType = false;
        private long size;
        private String strRelation;
        private String strTarget;
        private FolderFilter.Type subType;
        private String targetFolders = "";
        private long time;
        private DocType type;
        private SizeFilter.Unit unit;

        public Builder absolute(boolean bl) {
            this.absolute = bl;
            return this;
        }

        public Builder action(FolderFilter.Action action) {
            this.action = action;
            return this;
        }

        public Builder attribute(AttributeFilter.Attribute attribute) {
            this.attrib = attribute;
            return this;
        }

        public IFilter build() {
            IJsonState iJsonState;
            block15: {
                block14: {
                    iJsonState = null;
                    if (this.type != DocType.FOLDER) break block14;
                    FolderFilter.Target target = FolderFilter.Target.fromJson(this.strTarget);
                    switch (this.subType) {
                        case ALIGN: {
                            iJsonState = new com.deltawalker.structure.AlignFilter(this.exp, this.exp2, this.regexType, this.caseSensitive, this.targetFolders, this.enabled, this.description);
                            break block15;
                        }
                        case ATTRIBUTE: {
                            iJsonState = new AttributeFilter(this.action, this.attrib, target, this.enabled, this.description);
                            break block15;
                        }
                        case TIME: {
                            if (StateBoss.is(Pre.V_1997)) {
                                if (this.daysAgo > 0L) {
                                    this.time = this.daysAgo;
                                }
                            } else if (StateBoss.is(Pre.V_20)) {
                                this.time = TimeUnit.DAYS.toMillis();
                            }
                            TimeFilter.Relation relation = TimeFilter.Relation.fromJson(this.strRelation);
                            iJsonState = new com.deltawalker.structure.TimeFilter(this.action, target, relation, this.time, this.absolute, this.enabled, this.description);
                            break block15;
                        }
                        case PATH: {
                            iJsonState = new PathFilter(this.action, target, this.exp, this.regexType, this.caseSensitive, this.enabled, this.description);
                            break block15;
                        }
                        case SIZE: {
                            SizeFilter.Relation relation = SizeFilter.Relation.fromJson(this.strRelation);
                            iJsonState = new SizeFilter(this.action, relation, this.size, this.unit, this.enabled, this.description);
                            break block15;
                        }
                        default: {
                            assert (false);
                            break block15;
                        }
                    }
                }
                if (this.type == DocType.TEXT) {
                    TextFilter.Target target = TextFilter.Target.fromJson(this.strTarget);
                    iJsonState = new TextFilter(this.exp, target, this.enabled, this.description, null);
                } else {
                    LOG.error("Couldn't create filter: " + this.toString());
                }
            }
            return iJsonState;
        }

        public Builder caseSensitive(boolean bl) {
            this.caseSensitive = bl;
            return this;
        }

        public Builder daysAgo(long l) {
            this.daysAgo = l;
            return this;
        }

        public Builder description(String string) {
            this.description = string;
            return this;
        }

        public Builder enabled(boolean bl) {
            this.enabled = bl;
            return this;
        }

        public Builder expression(String string) {
            this.exp = string;
            return this;
        }

        public Builder expression2(String string) {
            this.exp2 = string;
            return this;
        }

        public Builder regexType(boolean bl) {
            this.regexType = bl;
            return this;
        }

        public Builder relation(String string) {
            this.strRelation = string;
            return this;
        }

        public Builder size(long l) {
            this.size = l;
            return this;
        }

        public FolderFilter.Type subType() {
            return this.subType;
        }

        public Builder subType(FolderFilter.Type type) {
            this.subType = type;
            return this;
        }

        public Builder target(String string) {
            this.strTarget = string;
            return this;
        }

        public Builder targetFolders(String string) {
            this.targetFolders = string;
            return this;
        }

        public Builder time(long l) {
            this.time = l;
            return this;
        }

        public Builder type(DocType docType) {
            this.type = docType;
            return this;
        }

        public Builder unit(String string) {
            this.unit = SizeFilter.Unit.fromJson(string);
            return this;
        }
    }
}

