/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.text;

import com.deltawalker.differencer.range.IRangeComparator;
import com.deltawalker.interfaces.ITextFilter;
import com.deltawalker.text.TextFilter;
import com.deltawalker.text.TokenComparator;
import com.deltopia.util.logging.ToString;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentLineComparator
extends TokenComparator {
    private static final int BUFFER_SIZE = 8192;
    private static final boolean CACHE_RANGES = false;
    private static final Logger LOG = LoggerFactory.getLogger(DocumentLineComparator.class);
    private static final String[] NO_LINES = new String[0];
    private int[] lineOffsets;
    private final String[] lines;
    private String[] ranges;
    private final SoftReference<String[]> rangesRef;

    private static Reader getContents(IDocument iDocument, IRegion iRegion) {
        String string;
        if (iRegion == null) {
            string = iDocument.get();
        } else {
            try {
                string = iDocument.get(iRegion.getOffset(), iRegion.getLength());
            }
            catch (BadLocationException badLocationException) {
                string = "";
            }
        }
        return new StringReader(string);
    }

    public DocumentLineComparator(IDocument iDocument, IRegion iRegion, List<ITextFilter> list, boolean bl) {
        this(DocumentLineComparator.getContents(iDocument, iRegion), list, bl);
    }

    public DocumentLineComparator(Reader reader, List<ITextFilter> list, boolean bl) {
        super(list, bl);
        try {
            String[] stringArray = this.lines = reader == null ? NO_LINES : this.collectLineInformation(reader);
            if (LOG.isDebugEnabled()) {
                LOG.debug(new ToString().append(">>>>> Lines", (Object[])this.lines, false, null).toString());
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.getMessage());
        }
        Object[] objectArray = this.cacheRanges();
        this.rangesRef = new SoftReference<String[]>((String[])objectArray);
        if (LOG.isDebugEnabled()) {
            LOG.debug(new ToString().append("<<<<< Ranges", objectArray, false, "\n").append("\n" + this).toString());
        }
    }

    private String[] cacheRanges() {
        String[] stringArray = null;
        return stringArray;
    }

    private String[] collectLineInformation(Reader reader) throws IOException {
        int n;
        char[] cArray = new char[8192];
        boolean bl = false;
        StringBuffer stringBuffer = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        block0: while ((n = reader.read(cArray)) != -1) {
            if (n == 0) continue;
            int n2 = 0;
            int n3 = n;
            if (n2 < n3 && bl) {
                if (cArray[n2] == '\n') {
                    String string = (String)arrayList.remove(arrayList.size() - 1);
                    arrayList.add(String.valueOf(string) + '\n');
                    ++n2;
                }
                bl = false;
            }
            while (n2 < n3) {
                String string;
                int n4 = -1;
                int n5 = n2;
                while (n5 < n3) {
                    char c = cArray[n5];
                    if (c == '\n') {
                        n4 = n5 + 1;
                        break;
                    }
                    if (c == '\r') {
                        n4 = n5 + 1;
                        int n6 = n5 + 1;
                        if (n6 < n3) {
                            if (cArray[n6] != '\n') break;
                            ++n4;
                            break;
                        }
                        bl = true;
                        break;
                    }
                    ++n5;
                }
                if (n4 == -1) {
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer();
                    }
                    stringBuffer.append(cArray, n2, n3 - n2);
                    continue block0;
                }
                if (stringBuffer == null) {
                    string = new String(cArray, n2, n4 - n2);
                } else {
                    stringBuffer.append(cArray, n2, n4 - n2);
                    string = stringBuffer.toString();
                    stringBuffer = null;
                }
                arrayList.add(string);
                n2 = n4;
            }
        }
        if (stringBuffer != null) {
            arrayList.add(stringBuffer.toString());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    @Override
    protected int filter() {
        ArrayList<Integer> arrayList = null;
        int n = 0;
        int n2 = this.lines.length;
        if (this.lineFilters.isEmpty()) {
            n = n2;
            if (LOG.isDebugEnabled()) {
                LOG.debug("No line filters. rangeCount=" + n);
            }
        } else {
            int n3 = 0 + n2;
            int n4 = 0;
            while (n4 < n3) {
                String string = this.getLine(n4);
                boolean bl = false;
                for (ITextFilter iTextFilter : this.lineFilters) {
                    Pattern pattern = iTextFilter.pattern();
                    if (!pattern.matcher(string).find()) continue;
                    bl = true;
                    if (!LOG.isDebugEnabled()) break;
                    String[] stringArray = DefaultLineTracker.DELIMITERS;
                    String string2 = string;
                    String[] stringArray2 = stringArray;
                    int n5 = stringArray.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        String string3 = stringArray2[n6];
                        if (string.equals(string3)) {
                            string2 = "an empty line";
                            break;
                        }
                        ++n6;
                    }
                    LOG.debug("Ignoring, at real index= " + n4 + " " + string2 + " with pattern: " + pattern);
                    break;
                }
                if (!bl) {
                    if (arrayList != null) {
                        arrayList.add(n, new Integer(n4));
                    }
                    ++n;
                } else if (arrayList == null) {
                    arrayList = new ArrayList<Integer>(n);
                    int n7 = 0;
                    while (n7 < n) {
                        arrayList.add(n7, new Integer(0 + n7));
                        ++n7;
                    }
                }
                ++n4;
            }
        }
        this.endFilter(arrayList, n);
        return n;
    }

    private String getLine(int n) {
        return this.lines[n];
    }

    private int getLineOffset(int n) {
        if (this.lineOffsets == null) {
            int n2 = this.lines.length;
            int[] nArray = new int[n2];
            int n3 = 0;
            int n4 = 0;
            while (n4 < n2) {
                nArray[n4] = n3;
                n3 += this.lines[n4].length();
                ++n4;
            }
            this.lineOffsets = nArray;
        }
        return this.lineOffsets[n];
    }

    @Override
    protected Object getRange(int n) {
        return this.getLine(this.getRealIndex(n));
    }

    @Override
    public int getTokenLength(int n) {
        int n2 = this.lines[this.getRealIndex(n)].length();
        if (LOG.isDebugEnabled()) {
            LOG.debug("getTokenLength " + n + "=" + n2);
        }
        return n2;
    }

    @Override
    public int getTokenStart(int n) {
        int n2;
        int n3 = this.getRealIndex(n);
        if (n3 == (n2 = this.lines.length)) {
            int n4;
            if (n2 == 0) {
                n4 = 0;
            } else {
                int n5 = n2 - 1;
                n4 = this.getLineOffset(n5) + this.lines[n5].length();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("getTokenStart " + n + "=" + n4 + " [DOC]");
            }
            return n4;
        }
        int n6 = this.getLineOffset(n3);
        if (LOG.isDebugEnabled()) {
            LOG.debug("getTokenStart " + n + "=" + n6);
        }
        return n6;
    }

    @Override
    public boolean rangesEqual(int n, IRangeComparator iRangeComparator, int n2) {
        this.ranges = this.rangesRef.get();
        if (this.ranges != null) {
            DocumentLineComparator documentLineComparator = (DocumentLineComparator)iRangeComparator;
            if (documentLineComparator.ranges != null || (documentLineComparator.ranges = documentLineComparator.rangesRef.get()) != null) {
                boolean bl;
                boolean bl2 = bl = this.ranges[n] == documentLineComparator.ranges[n2];
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.valueOf(bl ? "Equals" : "NOT Equals") + " " + n + "/" + n2 + ": '" + this.ranges[n] + "' / '" + documentLineComparator.ranges[n2] + "'");
                }
                return bl;
            }
        }
        return super.rangesEqual(n, iRangeComparator, n2);
    }

    @Override
    protected boolean rangesEqual(Object object, Object object2) {
        String string = (String)object;
        String string2 = (String)object2;
        if (this.charFilters.size() > 0) {
            string = TextFilter.filter(string, this.charFilters);
            string2 = TextFilter.filter(string2, this.charFilters);
        }
        if (this.getIgnoreCase()) {
            string = string.toLowerCase();
            string2 = string2.toLowerCase();
        }
        return string.equals(string2);
    }
}

