/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.text;

import com.deltawalker.differencer.range.IRangeComparator;
import com.deltawalker.interfaces.ITextFilter;
import com.deltawalker.text.TextFilter;
import com.deltawalker.text.TokenComparator;
import java.util.ArrayList;
import java.util.List;

public class CharSequenceCharComparator
extends TokenComparator {
    private final CharSequence chars;
    private char[] ranges;

    public CharSequenceCharComparator(CharSequence charSequence) {
        this(charSequence, null, false);
    }

    public CharSequenceCharComparator(CharSequence charSequence, List<ITextFilter> list, boolean bl) {
        super(list, bl);
        assert (charSequence != null);
        this.chars = charSequence;
        this.cacheRanges();
    }

    private void cacheRanges() {
        int n = this.filter();
        this.ranges = new char[n];
        boolean bl = this.getIgnoreCase();
        int n2 = 0;
        while (n2 < n) {
            char c = ((Character)this.getRange(n2)).charValue();
            if (bl) {
                c = Character.toLowerCase(c);
            }
            this.ranges[n2] = c;
            ++n2;
        }
    }

    @Override
    protected int filter() {
        ArrayList<Integer> arrayList = null;
        int n = 0;
        int n2 = this.chars.length();
        if (this.charFilters.size() < 1) {
            n = n2;
        } else {
            char[] cArray = TextFilter.getMatched(this.chars, this.charFilters);
            int n3 = cArray.length;
            if (n3 > 0) {
                int n4 = 0;
                while (n4 < n3) {
                    if (cArray[n4] != '\u0000') {
                        if (arrayList != null) {
                            arrayList.add(n, new Integer(n4));
                        }
                        ++n;
                    } else if (arrayList == null) {
                        arrayList = new ArrayList<Integer>(n);
                        int n5 = 0;
                        while (n5 < n) {
                            arrayList.add(n5, new Integer(n5));
                            ++n5;
                        }
                    }
                    ++n4;
                }
            } else {
                n = n2;
            }
        }
        this.endFilter(arrayList, n);
        return n;
    }

    @Override
    protected Object getRange(int n) {
        int n2 = this.getRealIndex(n);
        return new Character(-1 < n2 ? this.chars.charAt(n2) : (char)'\u0000');
    }

    @Override
    public int getTokenLength(int n) {
        return 1;
    }

    @Override
    public int getTokenStart(int n) {
        int n2 = this.chars.length();
        int n3 = this.getRealIndex(n);
        return n3 >= 0 && n3 < n2 ? n3 : n2;
    }

    @Override
    public boolean rangesEqual(int n, IRangeComparator iRangeComparator, int n2) {
        return this.ranges[n] == ((CharSequenceCharComparator)iRangeComparator).ranges[n2];
    }

    @Override
    protected boolean rangesEqual(Object object, Object object2) {
        char c = ((Character)object).charValue();
        char c2 = ((Character)object2).charValue();
        if (this.getIgnoreCase()) {
            c = Character.toLowerCase(c);
            c2 = Character.toLowerCase(c2);
        }
        return c == c2;
    }
}

