/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure;

import com.deltawalker.Msg;
import com.deltawalker.script.Role;
import com.deltawalker.ui.actions.ClearSearchAction;
import com.deltopia.StringUtil;
import com.deltopia.util.OS;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.progress.WorkbenchJob;

public class TreeFilter {
    private Font boldFont;
    private IAction clearAction;
    private boolean connected;
    private boolean hasSelection;
    private String initialText = "";
    private Font oldFont;
    private String oldText = "";
    private final AccessibleListener onAccessible = new AccessibleAdapter(){

        public void getName(AccessibleEvent accessibleEvent) {
            String string = TreeFilter.this.getFilterText();
            accessibleEvent.result = string.length() > 0 ? string : TreeFilter.this.initialText;
        }
    };
    private final FocusListener onFocus = new FocusListener(){

        public void focusGained(FocusEvent focusEvent) {
            TreeFilter.this.txtSearch.setForeground(TreeFilter.this.txtSearch.getDisplay().getSystemColor(2));
            if (TreeFilter.this.txtSearch.getEditable()) {
                TreeFilter.this.selectText();
                TreeFilter.this.hasSelection = TreeFilter.this.txtSearch.getSelectionText().trim().length() != 0;
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            TreeFilter.this.txtSearch.setForeground(TreeFilter.this.txtSearch.getDisplay().getSystemColor(15));
            TreeFilter.this.txtSearch.setSelection(0, 0);
        }
    };
    private final KeyListener onKey = new KeyAdapter(){

        public void keyPressed(KeyEvent keyEvent) {
            TreeFilter.this.onKey(keyEvent);
        }
    };
    private final ModifyListener onModify = new ModifyListener(){

        public void modifyText(ModifyEvent modifyEvent) {
            String string = TreeFilter.this.txtSearch.getText().trim();
            if (string.length() == 0) {
                TreeFilter.this.clearText();
            } else {
                if (!string.equals(TreeFilter.this.initialText)) {
                    TreeFilter.this.textChanged();
                }
                TreeFilter.this.oldText = string;
            }
        }
    };
    private final MouseAdapter onMouse = new MouseAdapter(){

        public void mouseDoubleClick(MouseEvent mouseEvent) {
            TreeFilter.this.selectText();
        }

        public void mouseDown(MouseEvent mouseEvent) {
            if (TreeFilter.this.hasSelection) {
                TreeFilter.this.selectText();
                TreeFilter.this.hasSelection = false;
            }
        }
    };
    private final TraverseListener onTraverse = new TraverseListener(){

        public void keyTraversed(TraverseEvent traverseEvent) {
            TreeFilter.this.onTraverse(traverseEvent);
        }
    };
    private Job refreshJob;
    protected String text = "";
    protected boolean textChanged;
    protected boolean textCleared;
    protected IToolBarManager toolBar;
    private final String toolTip;
    protected Composite tree;
    protected Text txtSearch;

    public TreeFilter(String string) {
        this.toolTip = string;
    }

    protected void clearText() {
        String string = this.txtSearch.getText().trim();
        if (string.length() > 0 && string.equals(this.initialText)) {
            return;
        }
        if (string.length() == 0 && this.oldText.equals(this.initialText)) {
            this.setFilterText(this.initialText);
            this.txtSearch.selectAll();
            return;
        }
        this.setFilterText(this.initialText);
        this.txtSearch.selectAll();
        this.textCleared = true;
        this.textChanged();
    }

    public void connectSearchControl(IToolBarManager iToolBarManager, Text text, boolean bl) {
        if (iToolBarManager == null || text == null) {
            return;
        }
        if (bl && !this.connected) {
            if (this.txtSearch == null) {
                this.toolBar = iToolBarManager;
                this.txtSearch = text;
                this.createClearTextAction();
                this.installTextListeners(true);
                if (!OS.OSX) {
                    this.setInitialText(Msg.SearchContributionItem_text);
                }
            } else {
                this.setFilterText(this.oldText);
                this.installTextListeners(true);
            }
            text.setToolTipText(this.toolTip);
            text.setEditable(true);
        } else if (!bl && this.connected) {
            this.installTextListeners(false);
            text.setToolTipText(Msg.SearchContributionItem_toolTip);
            text.setEditable(false);
        }
        this.connected = bl;
    }

    private void createClearTextAction() {
        this.clearAction = new ClearSearchAction(){

            public void run() {
                TreeFilter.this.clearText();
            }
        };
    }

    private Job createRefreshJob() {
        WorkbenchJob workbenchJob = new WorkbenchJob("Refresh Filter"){

            public IStatus runInUIThread(final IProgressMonitor iProgressMonitor) {
                final IStatus[] iStatusArray = new IStatus[1];
                BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        iStatusArray[0] = TreeFilter.this.runRefreshJob(iProgressMonitor);
                    }
                });
                return iStatusArray[0];
            }
        };
        workbenchJob.setSystem(true);
        DisposeListener disposeListener = new DisposeListener((Job)workbenchJob){
            private final /* synthetic */ Job val$refreshJob;
            {
                this.val$refreshJob = job;
            }

            public void widgetDisposed(DisposeEvent disposeEvent) {
                this.val$refreshJob.cancel();
            }
        };
        this.tree.addDisposeListener(disposeListener);
        return workbenchJob;
    }

    public void dispose() {
        this.clearAction = null;
        if (this.boldFont != null && !this.boldFont.isDisposed()) {
            this.boldFont.dispose();
            this.boldFont = null;
        }
        this.oldFont = null;
        if (this.txtSearch != null) {
            this.installTextListeners(false);
        }
    }

    public Font getBoldFont() {
        boolean bl = this.shouldUpdateFont();
        if (bl || this.boldFont == null || this.boldFont.isDisposed()) {
            if (this.boldFont != null) {
                this.boldFont.dispose();
            }
            if (bl) {
                this.oldFont = this.tree.getFont();
            }
            FontData[] fontDataArray = this.oldFont.getFontData();
            FontData[] fontDataArray2 = new FontData[fontDataArray.length];
            int n = 0;
            while (n < fontDataArray.length) {
                FontData fontData = fontDataArray[n];
                fontDataArray2[n] = new FontData(fontData.getName(), fontData.getHeight(), fontData.getStyle() | 1);
                ++n;
            }
            this.boldFont = new Font(this.oldFont.getDevice(), fontDataArray2);
        }
        return this.boldFont;
    }

    public Text getFilterControl() {
        return this.txtSearch;
    }

    protected String getFilterText() {
        return this.text;
    }

    protected TreeItem getFirstMatchingItem(TreeItem[] treeItemArray, Role role) {
        return null;
    }

    protected String getInitialText() {
        return this.initialText;
    }

    protected void initialize(Composite composite) {
        this.tree = composite;
        this.oldFont = composite.getFont();
        this.refreshJob = this.createRefreshJob();
    }

    protected void installTextListeners(boolean bl) {
        if (bl) {
            this.txtSearch.getAccessible().addAccessibleListener(this.onAccessible);
            this.txtSearch.addFocusListener(this.onFocus);
            this.txtSearch.addKeyListener(this.onKey);
            this.txtSearch.addTraverseListener(this.onTraverse);
            this.txtSearch.addModifyListener(this.onModify);
            this.txtSearch.addMouseListener((MouseListener)this.onMouse);
        } else {
            this.txtSearch.getAccessible().removeAccessibleListener(this.onAccessible);
            this.txtSearch.removeFocusListener(this.onFocus);
            this.txtSearch.removeKeyListener(this.onKey);
            this.txtSearch.removeTraverseListener(this.onTraverse);
            this.txtSearch.removeModifyListener(this.onModify);
            this.txtSearch.removeMouseListener((MouseListener)this.onMouse);
        }
    }

    protected boolean isDisposed() {
        return this.tree.isDisposed();
    }

    protected void onKey(KeyEvent keyEvent) {
    }

    protected void onTraverse(TraverseEvent traverseEvent) {
    }

    protected IStatus runRefreshJob(IProgressMonitor iProgressMonitor) {
        return Status.CANCEL_STATUS;
    }

    protected void scheduleRefreshJob(long l) {
        if (this.refreshJob != null) {
            this.refreshJob.cancel();
            this.refreshJob.schedule(l);
        }
    }

    private void selectText() {
        this.txtSearch.selectAll();
    }

    private void setFilterText(String string) {
        if (!this.txtSearch.getText().equals(string)) {
            this.txtSearch.setText(string);
            this.selectText();
        }
    }

    public void setInitialText(String string) {
        this.oldText = this.initialText = StringUtil.makeSafe((String)string);
        this.setFilterText(this.initialText);
        this.textChanged();
    }

    protected boolean shouldUpdateFont() {
        return this.oldFont != this.tree.getFont();
    }

    protected void showClearButton(boolean bl) {
        if (this.toolBar != null && !OS.OSX) {
            IContributionItem iContributionItem = this.toolBar.find(this.clearAction.getId());
            if (bl) {
                if (iContributionItem == null) {
                    this.toolBar.add(this.clearAction);
                    this.toolBar.update(true);
                }
            } else if (iContributionItem != null) {
                this.toolBar.remove(iContributionItem);
                this.toolBar.update(true);
                ToolBar toolBar = ((ToolBarManager)this.toolBar).getControl();
                toolBar.redraw();
                toolBar.update();
            }
        }
        this.textCleared = false;
    }

    protected void textChanged() {
        this.text = this.txtSearch != null ? this.txtSearch.getText().trim() : "";
        this.textChanged = !this.initialText.equals(this.text);
        this.scheduleRefreshJob(200L);
    }

    protected Composite tree() {
        return this.tree;
    }
}

