/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure;

import com.deltawalker.Msg;
import com.deltawalker.script.Filter;
import com.deltawalker.structure.FolderFilter;
import com.deltopia.eclipse.util.TimeFormatter;
import com.deltopia.io.IFile;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeFilter
extends FolderFilter
implements com.deltawalker.script.TimeFilter {
    private static final Logger LOG = LoggerFactory.getLogger(TimeFilter.class);
    private static final boolean TRACE = false;
    private final boolean absolute;
    private int hashCode;
    private final Relation relation;
    private final long time;

    public TimeFilter(FolderFilter.Action action, FolderFilter.Target target, Relation relation, long l, boolean bl, boolean bl2, String string) {
        super(action, target, bl2, string);
        if (relation == null) {
            throw new NullPointerException("relation");
        }
        this.absolute = bl;
        this.time = l;
        this.relation = relation;
    }

    public TimeFilter(TimeFilter timeFilter, boolean bl) {
        super(timeFilter, bl);
        this.absolute = timeFilter.absolute;
        this.relation = timeFilter.relation;
        this.time = timeFilter.time;
    }

    @Override
    public TimeFilter clone(boolean bl) {
        return new TimeFilter(this, bl);
    }

    @Override
    public boolean equals(Filter filter, boolean bl) {
        if (this == filter) {
            return true;
        }
        if (!(filter instanceof TimeFilter)) {
            return false;
        }
        TimeFilter timeFilter = (TimeFilter)filter;
        return this.absolute == timeFilter.absolute && this.time == timeFilter.time && super.equals(filter, bl);
    }

    @Override
    public void fromJson(JsonReader jsonReader) throws IOException {
    }

    @Override
    public String getExpression() {
        String string = this.absolute ? Msg.TimeFilter_dispExpression : Msg.TimeFilter_dispExpressionAgo;
        String string2 = this.absolute ? TimeFormatter.formatShort(this.time) : TimeFormatter.formatMilliDelta(this.time);
        return NLS.bind((String)string, (Object)this.relation.toString(), (Object)string2);
    }

    @Override
    public long getTime() {
        return this.time;
    }

    @Override
    public int hashCode() {
        int n = this.hashCode;
        if (n == 0) {
            n = this.absolute ? 31 * n + (this.absolute ? 1 : 0) : 31 * n + (int)(this.time ^ this.time >>> 32);
            this.hashCode = n = 31 * n + super.hashCode();
        }
        return n;
    }

    @Override
    public boolean isAbsolute() {
        return this.absolute;
    }

    @Override
    public boolean isExclude() {
        return this.action().toBool();
    }

    @Override
    public boolean isOlder() {
        return this.relation == Relation.OLDER;
    }

    @Override
    public boolean isRegexType() {
        return false;
    }

    @Override
    public boolean matches(IFile iFile) {
        long l;
        if (!super.matches(iFile)) {
            return false;
        }
        long l2 = iFile.getLastModifiedTime();
        if (this.relation == Relation.NEWER) {
            long l3;
            boolean bl = this.absolute ? l2 > this.time : l2 > (l3 = System.currentTimeMillis()) - this.time;
            return bl;
        }
        boolean bl = this.absolute ? l2 <= this.time : l2 <= (l = System.currentTimeMillis()) - this.time;
        return bl;
    }

    public Relation relation() {
        return this.relation;
    }

    @Override
    public void toJson(JsonWriter jsonWriter) throws IOException {
        super.toJson(jsonWriter);
        jsonWriter.name("dt").value(this.getTime());
        jsonWriter.name("dag").value(this.isAbsolute());
        jsonWriter.name("rel").value(this.relation().toJson());
    }

    @Override
    public String toString() {
        String string = String.valueOf(super.toString()) + "   absolute=" + this.absolute + "   relation=" + (Object)((Object)this.relation) + "   time=" + this.time + "ms";
        return string;
    }

    @Override
    public FolderFilter.Type type() {
        return FolderFilter.Type.TIME;
    }

    public static final class Relation
    extends Enum<Relation> {
        public static final /* enum */ Relation NEWER = new Relation(Msg.TimeFilter_Relation_newer, 1, "n");
        public static final /* enum */ Relation OLDER = new Relation(Msg.TimeFilter_Relation_older, 0, "o");
        private final int intVal;
        private final String jsonText;
        private final String text;
        private static final /* synthetic */ Relation[] ENUM$VALUES;

        static {
            ENUM$VALUES = new Relation[]{NEWER, OLDER};
        }

        public static Relation fromBool(boolean bl) {
            return bl ? OLDER : NEWER;
        }

        public static Relation fromInt(int n) {
            if (n == Relation.OLDER.intVal) {
                return OLDER;
            }
            assert (n == Relation.NEWER.intVal);
            return NEWER;
        }

        public static Relation fromJson(String string) {
            if (string.equals(Relation.OLDER.jsonText)) {
                return OLDER;
            }
            assert (string.equals(Relation.NEWER.jsonText));
            return NEWER;
        }

        private Relation(String string2, int n2, String string3) {
            this.text = string2;
            this.intVal = n2;
            this.jsonText = string3;
        }

        public boolean toBool() {
            return this == OLDER;
        }

        public int toInt() {
            return this.intVal;
        }

        public String toJson() {
            return this.jsonText;
        }

        public String toString() {
            return this.text;
        }

        public static Relation[] values() {
            Relation[] relationArray = ENUM$VALUES;
            int n = relationArray.length;
            Relation[] relationArray2 = new Relation[n];
            System.arraycopy(ENUM$VALUES, 0, relationArray2, 0, n);
            return relationArray2;
        }

        public static Relation valueOf(String string) {
            return Enum.valueOf(Relation.class, string);
        }
    }
}

