/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure;

import com.deltawalker.Msg;
import com.deltawalker.script.Filter;
import com.deltawalker.script.SizeUnit;
import com.deltawalker.structure.FolderFilter;
import com.deltopia.io.IFile;
import com.deltopia.util.OS;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.osgi.util.NLS;

public class SizeFilter
extends FolderFilter
implements com.deltawalker.script.SizeFilter {
    private static final long BASE = OS.OSX ? 1000 : 1024;
    private volatile int hashCode;
    private final Relation relation;
    private final long size;
    private final Unit unit;

    public SizeFilter(FolderFilter.Action action, Relation relation, long l, Unit unit, boolean bl, String string) {
        super(action, FolderFilter.Target.FILES, bl, string);
        if (relation == null) {
            throw new NullPointerException("relation");
        }
        if (unit == null) {
            throw new NullPointerException("unit");
        }
        this.relation = relation;
        this.size = l;
        this.unit = unit;
    }

    public SizeFilter(SizeFilter sizeFilter, boolean bl) {
        super(sizeFilter, bl);
        this.relation = sizeFilter.relation;
        this.size = sizeFilter.size;
        this.unit = sizeFilter.unit;
    }

    @Override
    public SizeFilter clone(boolean bl) {
        return new SizeFilter(this, bl);
    }

    @Override
    public boolean equals(Filter filter, boolean bl) {
        if (!(filter instanceof SizeFilter)) {
            return false;
        }
        if (this == filter) {
            return true;
        }
        SizeFilter sizeFilter = (SizeFilter)filter;
        return this.size == sizeFilter.size && this.unit == sizeFilter.unit && super.equals(filter, bl);
    }

    @Override
    public void fromJson(JsonReader jsonReader) throws IOException {
    }

    @Override
    public String getExpression() {
        return NLS.bind((String)Msg.SizeFilter_expression, (Object[])new Object[]{this.relation, this.size, this.unit});
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public int hashCode() {
        int n = this.hashCode;
        if (n == 0) {
            n = 31 * n + (int)this.size;
            n = 31 * n + this.unit.hashCode();
            this.hashCode = n = 31 * n + super.hashCode();
        }
        return n;
    }

    @Override
    public boolean isLarger() {
        return this.relation == Relation.LARGER;
    }

    @Override
    public boolean isRegexType() {
        return false;
    }

    @Override
    public boolean matches(IFile iFile) {
        if (!super.matches(iFile)) {
            return false;
        }
        long l = iFile.size();
        long l2 = this.size * this.unit.multiplier();
        return this.relation == Relation.LARGER ? l > l2 : l <= l2;
    }

    public Relation relation() {
        return this.relation;
    }

    @Override
    public void toJson(JsonWriter jsonWriter) throws IOException {
        super.toJson(jsonWriter);
        jsonWriter.name("sz").value(this.size);
        jsonWriter.name("unt").value(this.unit.toJson());
        jsonWriter.name("rel").value(this.relation.toJson());
    }

    @Override
    public FolderFilter.Type type() {
        return FolderFilter.Type.SIZE;
    }

    public Unit unit() {
        return this.unit;
    }

    static /* synthetic */ long access$1() {
        return BASE;
    }

    public static final class Relation
    extends Enum<Relation> {
        public static final /* enum */ Relation LARGER = new Relation(Msg.SizeFilter_Relation_larger, 0, "l");
        public static final /* enum */ Relation SMALLER = new Relation(Msg.SizeFilter_Relation_smaller, 1, "s");
        private final int intVal;
        private final String jsonText;
        private final String text;
        private static final /* synthetic */ Relation[] ENUM$VALUES;

        static {
            ENUM$VALUES = new Relation[]{LARGER, SMALLER};
        }

        public static Relation fromBool(Boolean bl) {
            return bl != false ? LARGER : SMALLER;
        }

        public static Relation fromInt(int n) {
            if (n == Relation.SMALLER.intVal) {
                return SMALLER;
            }
            assert (n == Relation.LARGER.intVal);
            return LARGER;
        }

        public static Relation fromJson(String string) {
            if (string.equals(Relation.SMALLER.jsonText)) {
                return SMALLER;
            }
            assert (string.equals(Relation.LARGER.jsonText));
            return LARGER;
        }

        private Relation(String string2, int n2, String string3) {
            this.text = string2;
            this.intVal = n2;
            this.jsonText = string3;
        }

        public int index() {
            return this.intVal;
        }

        public String toJson() {
            return this.jsonText;
        }

        public String toString() {
            return this.text;
        }

        public static Relation[] values() {
            Relation[] relationArray = ENUM$VALUES;
            int n = relationArray.length;
            Relation[] relationArray2 = new Relation[n];
            System.arraycopy(ENUM$VALUES, 0, relationArray2, 0, n);
            return relationArray2;
        }

        public static Relation valueOf(String string) {
            return Enum.valueOf(Relation.class, string);
        }
    }

    public static final class Unit
    extends Enum<Unit> {
        public static final /* enum */ Unit BYTES = new Unit(Msg.SizeFilter_Unit_bytes, 1L, 0, "b");
        public static final /* enum */ Unit GBYTES = new Unit(Msg.SizeFilter_Unit_gbytes, SizeFilter.access$1() * SizeFilter.access$1() * SizeFilter.access$1(), 3, "g");
        public static final /* enum */ Unit KBYTES = new Unit(Msg.SizeFilter_Unit_kbytes, SizeFilter.access$1(), 1, "k");
        public static final /* enum */ Unit MBYTES = new Unit(Msg.SizeFilter_Unit_mbytes, SizeFilter.access$1() * SizeFilter.access$1(), 2, "m");
        private static final Map<Integer, Unit> int2Enum;
        private static final Map<String, Unit> str2Enum;
        private final int intVal;
        private final String jsonText;
        private final long multiplier;
        private final String text;
        private static final /* synthetic */ Unit[] ENUM$VALUES;

        static {
            ENUM$VALUES = new Unit[]{BYTES, GBYTES, KBYTES, MBYTES};
            int2Enum = new HashMap<Integer, Unit>(4);
            str2Enum = new HashMap<String, Unit>(4);
            Unit[] unitArray = Unit.values();
            int n = unitArray.length;
            int n2 = 0;
            while (n2 < n) {
                Unit unit = unitArray[n2];
                int2Enum.put(unit.intVal, unit);
                str2Enum.put(unit.jsonText, unit);
                ++n2;
            }
        }

        public static Unit fromInt(int n) {
            return int2Enum.get(n);
        }

        public static Unit fromJson(String string) {
            assert (str2Enum.containsKey(string));
            return str2Enum.get(string);
        }

        public static Unit fromScript(SizeUnit sizeUnit) throws IllegalArgumentException {
            switch (sizeUnit) {
                case BYTES: {
                    return BYTES;
                }
                case GBYTES: {
                    return GBYTES;
                }
                case KBYTES: {
                    return KBYTES;
                }
                case MBYTES: {
                    return MBYTES;
                }
            }
            throw new IllegalArgumentException("Please specify a non-null unit.");
        }

        private Unit(String string2, long l, int n2, String string3) {
            this.text = string2;
            this.multiplier = l;
            this.intVal = n2;
            this.jsonText = string3;
        }

        public int index() {
            return this.intVal;
        }

        public long multiplier() {
            return this.multiplier;
        }

        public String toJson() {
            return this.jsonText;
        }

        public String toString() {
            return this.text;
        }

        public static Unit[] values() {
            Unit[] unitArray = ENUM$VALUES;
            int n = unitArray.length;
            Unit[] unitArray2 = new Unit[n];
            System.arraycopy(ENUM$VALUES, 0, unitArray2, 0, n);
            return unitArray2;
        }

        public static Unit valueOf(String string) {
            return Enum.valueOf(Unit.class, string);
        }
    }
}

