/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure;

import com.deltawalker.Pre;
import com.deltawalker.StateBoss;
import com.deltawalker.script.Filter;
import com.deltawalker.structure.FolderFilter;
import com.deltopia.io.IFile;
import com.deltopia.regex.RegexUtil;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class PathFilter
extends FolderFilter
implements com.deltawalker.script.PathFilter {
    private static final String ALL_REG_EX = ".*";
    public static final String[] EXCLUDE_FILES = new String[]{"*.cab", "*.dll", "*.exe", "*.idb", "*.map", "*.ncb", "*.obj", "*.o", "*.pch"};
    public static final String[] EXCLUDE_FOLDERS = new String[]{"CVS", ".git", ".hg", ".svn"};
    public static final String[] EXCLUDE_SYS_FILES_OSX = new String[]{"*.DS_Store"};
    public static final String[] INCLUDE_FILES = new String[]{"*.cpp", "*.cs", "*.c", "*.h", "*.java", "*.rc"};
    private static final Logger LOG = LoggerFactory.getLogger(PathFilter.class);
    private static final boolean TRACE = false;
    private final boolean caseSensitive;
    private String expression = "";
    private volatile int hashCode;
    private Pattern pattern;
    private final boolean regexType;

    public PathFilter(FolderFilter.Action action, FolderFilter.Target target, String string, boolean bl, boolean bl2, boolean bl3) {
        this(action, target, string, bl, bl2, bl3, "");
    }

    public PathFilter(FolderFilter.Action action, FolderFilter.Target target, String string, boolean bl, boolean bl2, boolean bl3, String string2) {
        super(action, target, bl3, string2);
        if (string == null) {
            throw new NullPointerException("expression");
        }
        if (string.isEmpty()) {
            throw new IllegalArgumentException("'expression' cannot be empty");
        }
        this.regexType = bl;
        this.caseSensitive = bl2;
        this.setExpression(string, StateBoss.is(Pre.V_1993));
    }

    public PathFilter(PathFilter pathFilter, boolean bl) {
        super(pathFilter, bl);
        this.expression = pathFilter.expression;
        this.regexType = pathFilter.regexType;
        this.caseSensitive = pathFilter.caseSensitive;
        this.pattern = pathFilter.pattern;
    }

    @Override
    public PathFilter clone(boolean bl) {
        return new PathFilter(this, bl);
    }

    @Override
    public boolean equals(Filter filter, boolean bl) {
        if (this == filter) {
            return true;
        }
        if (!(filter instanceof PathFilter)) {
            return false;
        }
        PathFilter pathFilter = (PathFilter)filter;
        return this.regexType == pathFilter.regexType && this.caseSensitive == pathFilter.caseSensitive && this.expression.equals(pathFilter.expression) && super.equals(filter, bl);
    }

    @Override
    public String getExpression() {
        return this.expression;
    }

    @Override
    public int hashCode() {
        int n = this.hashCode;
        if (n == 0) {
            n = 17;
            n = 31 * n + (this.caseSensitive ? 1 : 0);
            n = 31 * n + (this.regexType ? 1 : 0);
            n = 31 * n + this.expression.hashCode();
            this.hashCode = n = 31 * n + super.hashCode();
        }
        return n;
    }

    @Override
    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    @Override
    public boolean isExclude() {
        return this.action().toBool();
    }

    @Override
    public boolean isRegexType() {
        return this.regexType;
    }

    @Override
    public boolean matches(IFile iFile) {
        if (!super.matches(iFile)) {
            return false;
        }
        if (this.pattern == null) {
            return true;
        }
        return this.matches(iFile.rootlessPath());
    }

    boolean matches(String string) {
        Matcher matcher = this.pattern.matcher(string);
        boolean bl = matcher.matches();
        return bl;
    }

    @Override
    public Element report(Element element) {
        Element element2 = super.report(element);
        this.createElement(element.getOwnerDocument(), element2, "regex", Boolean.toString(this.isRegexType()), false);
        return element2;
    }

    @Override
    public boolean requiresRecompare() {
        return !this.isEnabled();
    }

    private void setExpression(String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException("exp");
        }
        if (this.regexType) {
            this.expression = string;
        } else {
            if (bl) {
                string = RegexUtil.upgradeShellex((String)string);
            }
            this.expression = string;
            string = RegexUtil.shell2regex((String)string, (int)4);
        }
        int n = this.caseSensitive ? 0 : 66;
        this.pattern = ALL_REG_EX.equals(string) ? null : Pattern.compile(string, n);
    }

    @Override
    public void toJson(JsonWriter jsonWriter) throws IOException {
        super.toJson(jsonWriter);
        jsonWriter.name("rex").value(this.isRegexType());
        jsonWriter.name("cs").value(this.isCaseSensitive());
        jsonWriter.name("ex").value(this.getExpression());
    }

    @Override
    public String toString() {
        return "PathFilter expression='" + this.expression + '\'' + ", pattern=" + this.pattern + ", " + (this.caseSensitive ? "caseSensitive" : "caseInsensitive") + ", " + (this.regexType ? "Regex" : "ShellExp");
    }

    @Override
    public FolderFilter.Type type() {
        return FolderFilter.Type.PATH;
    }
}

