/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure;

import com.deltawalker.DocType;
import com.deltawalker.Msg;
import com.deltawalker.interfaces.IFolderFilter;
import com.deltawalker.script.Filter;
import com.deltawalker.script.FolderFilter;
import com.deltopia.StringUtil;
import com.deltopia.interfaces.IJsonState;
import com.deltopia.io.IFile;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class FolderFilter
implements IFolderFilter,
IJsonState {
    public static final String FDFF_ID_01 = "f1";
    public static final String FDFF_ID_02 = "f2";
    public static final String FDFF_ID_03 = "f3";
    public static final String FDFF_ID_04 = "f4";
    public static final String FDFF_ID_05 = "f5";
    private final Action action;
    private final String description;
    private final boolean enabled;
    private volatile int hashCode;
    private final String jsonId;
    private final Target target;

    public FolderFilter(Action action, Target target, boolean bl, String string) {
        if (action == null) {
            throw new NullPointerException("action");
        }
        if (target == null) {
            throw new NullPointerException("target");
        }
        this.action = action;
        this.target = target;
        this.enabled = bl;
        this.jsonId = StringUtil.makeSafe((String)string);
        this.description = "";
    }

    public FolderFilter(FolderFilter folderFilter, boolean bl) {
        this.action = folderFilter.action;
        this.enabled = bl;
        this.target = folderFilter.target;
        this.jsonId = folderFilter.jsonId;
        this.description = folderFilter.description;
    }

    @Override
    public Action action() {
        return this.action;
    }

    protected Element createElement(Document document, Element element, String string, String string2, boolean bl) {
        Element element2 = document.createElement(string);
        if (!StringUtil.isEmpty((String)string2)) {
            if (bl) {
                element2.appendChild(document.createCDATASection(string2));
            } else {
                element2.setTextContent(string2);
            }
        }
        element.appendChild(element2);
        return element2;
    }

    @Override
    public DocType docType() {
        return DocType.FOLDER;
    }

    @Override
    public boolean equals(Filter filter, boolean bl) {
        FolderFilter folderFilter = (FolderFilter)filter;
        if (bl && this.isEnabled() != folderFilter.isEnabled()) {
            return false;
        }
        return this.action == folderFilter.action && this.target == folderFilter.target;
    }

    public boolean equals(Object object) {
        if (object instanceof Filter) {
            return this.equals((Filter)object, false);
        }
        return false;
    }

    public void fromJson(JsonReader jsonReader) throws IOException {
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDisplayExpression() {
        return this.getExpression();
    }

    @Override
    public FolderFilter.Target getTarget() {
        switch (this.target()) {
            case FILES: {
                return FolderFilter.Target.FILES;
            }
            case FOLDERS: {
                return FolderFilter.Target.FOLDERS;
            }
            case BOTH: {
                return FolderFilter.Target.FILES_AND_FOLDERS;
            }
        }
        throw new IllegalStateException("target=" + (Object)((Object)this.target()));
    }

    public int hashCode() {
        int n = this.hashCode;
        if (n == 0) {
            n = 17;
            n = 31 * n + this.type().hashCode();
            n = 31 * n + this.action.hashCode();
            n = 31 * n + this.target.hashCode();
            this.hashCode = n = 31 * n + this.getExpression().hashCode();
        }
        return n;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public String jsonId() {
        return this.jsonId;
    }

    @Override
    public boolean matches(IFile iFile) {
        if (iFile == null || !this.isEnabled()) {
            return false;
        }
        boolean bl = iFile.isDirectory(false);
        return (this.target == null || this.target != Target.FOLDERS || bl) && (this.target != Target.FILES || !bl);
    }

    @Override
    public boolean matches(String string, String string2) {
        throw new UnsupportedOperationException("matches(String name1, String name2)");
    }

    @Override
    public Element report(Element element) {
        Document document = element.getOwnerDocument();
        Element element2 = this.createElement(document, element, "filter", null, false);
        this.createElement(document, element2, "enabled", Boolean.toString(this.isEnabled()), false);
        this.createElement(document, element2, "action", this.action().toString(), false);
        this.createElement(document, element2, "target", this.target().toString(), false);
        this.createElement(document, element2, "expression", this.getDisplayExpression(), true);
        return element2;
    }

    @Override
    public boolean requiresRecompare() {
        return true;
    }

    @Override
    public Target target() {
        return this.target;
    }

    public void toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.name("tp").value(this.docType().toJson());
        jsonWriter.name("stp").value(this.type().toJson());
        jsonWriter.name("on").value(this.isEnabled());
        jsonWriter.name("act").value(this.action().toJson());
        jsonWriter.name("tgt").value(this.target().toJson());
        jsonWriter.name("dsc").value(this.getDescription());
    }

    public String toString() {
        String string = "docType=" + (Object)((Object)this.docType()) + "   type=" + (Object)((Object)this.type()) + "   enabled=" + this.isEnabled() + "   action=" + (Object)((Object)this.action()) + "   target=" + (Object)((Object)this.target());
        return string;
    }

    @Override
    public String[] toStringArray(boolean bl) {
        if (bl) {
            return new String[]{"Filter", "Type", "RegEx", "Target", "Action"};
        }
        String string = this.isRegexType() ? "Yes" : "No";
        return new String[]{this.getDisplayExpression(), this.type().toString(), string, this.target().toString(), this.action().toString()};
    }

    @Override
    public abstract Type type();

    public static final class Action
    extends Enum<Action> {
        public static final /* enum */ Action ALIGN = new Action(Msg.FolderFilter_Action_align, 2, "a");
        public static final /* enum */ Action EXCLUDE = new Action(Msg.FolderFilter_Action_exclude, 0, "e");
        public static final /* enum */ Action INCLUDE = new Action(Msg.FolderFilter_Action_include, 1, "i");
        private static final Map<String, Action> str2Enum;
        private final int intVal;
        private final String jsonText;
        private final String text;
        private static final /* synthetic */ Action[] ENUM$VALUES;

        static {
            ENUM$VALUES = new Action[]{ALIGN, EXCLUDE, INCLUDE};
            str2Enum = new HashMap<String, Action>(6);
            Action[] actionArray = Action.values();
            int n = actionArray.length;
            int n2 = 0;
            while (n2 < n) {
                Action action = actionArray[n2];
                str2Enum.put(action.text, action);
                str2Enum.put(action.jsonText, action);
                ++n2;
            }
        }

        public static Action fromBool(Boolean bl) {
            if (bl.booleanValue()) {
                return EXCLUDE;
            }
            if (!bl.booleanValue()) {
                return INCLUDE;
            }
            return ALIGN;
        }

        public static Action fromInt(int n) {
            if (n == Action.EXCLUDE.intVal) {
                return EXCLUDE;
            }
            assert (n == Action.INCLUDE.intVal);
            return INCLUDE;
        }

        public static Action fromJson(String string) {
            assert (str2Enum.containsKey(string));
            return str2Enum.get(string);
        }

        public static Action fromString(String string) {
            assert (str2Enum.containsKey(string));
            return str2Enum.get(string);
        }

        private Action(String string2, int n2, String string3) {
            this.text = string2;
            this.intVal = n2;
            this.jsonText = string3;
        }

        public boolean toBool() {
            if (this == EXCLUDE) {
                return true;
            }
            if (this == INCLUDE) {
                return false;
            }
            throw new IllegalArgumentException("toBool() can only be called with 'true' or 'false'.");
        }

        public int toInt() {
            return this.intVal;
        }

        public String toJson() {
            return this.jsonText;
        }

        public String toString() {
            return this.text;
        }

        public static Action[] values() {
            Action[] actionArray = ENUM$VALUES;
            int n = actionArray.length;
            Action[] actionArray2 = new Action[n];
            System.arraycopy(ENUM$VALUES, 0, actionArray2, 0, n);
            return actionArray2;
        }

        public static Action valueOf(String string) {
            return Enum.valueOf(Action.class, string);
        }
    }

    public static final class Tag {
        public static final String ACTION = "action";
        public static final String ENABLED = "enabled";
        public static final String EXPRESSION = "expression";
        public static final String FILTER = "filter";
        public static final String REGEX_TYPE = "regex";
        public static final String TARGET = "target";

        private Tag() {
        }
    }

    public static enum Target {
        BOTH(NLS.bind((String)Msg.FolderFilter_Target_both, (Object)Msg.FolderFilter_Target_files, (Object)Msg.FolderFilter_Target_folders), 0, "f&d"),
        FILES(Msg.FolderFilter_Target_files, 1, "f"),
        FOLDERS(Msg.FolderFilter_Target_folders, 2, "d");

        private static final Map<Integer, Target> int2Enum;
        private static final Map<String, Target> str2Enum;
        private final int intVal;
        private final String jsonText;
        private final String text;

        static {
            int2Enum = new HashMap<Integer, Target>(3);
            str2Enum = new HashMap<String, Target>(6);
            Target[] targetArray = Target.values();
            int n = targetArray.length;
            int n2 = 0;
            while (n2 < n) {
                Target target = targetArray[n2];
                int2Enum.put(target.intVal, target);
                str2Enum.put(target.text, target);
                str2Enum.put(target.jsonText, target);
                ++n2;
            }
        }

        public static Target fromInt(int n) {
            return int2Enum.get(n);
        }

        public static Target fromJson(String string) {
            return str2Enum.get(string);
        }

        public static Target fromScript(FolderFilter.Target target) {
            if (target == null) {
                throw new NullPointerException("'target' cannot be 'null'.");
            }
            switch (target) {
                case FILES: {
                    return FILES;
                }
                case FOLDERS: {
                    return FOLDERS;
                }
                case FILES_AND_FOLDERS: {
                    return BOTH;
                }
            }
            throw new IllegalArgumentException("Unknown 'target': " + (Object)((Object)target));
        }

        public static FolderFilter.Target fromScript(Target target) {
            if (target == null) {
                throw new NullPointerException("'target' cannot be 'null'.");
            }
            switch (target) {
                case FILES: {
                    return FolderFilter.Target.FILES;
                }
                case FOLDERS: {
                    return FolderFilter.Target.FOLDERS;
                }
                case BOTH: {
                    return FolderFilter.Target.FILES_AND_FOLDERS;
                }
            }
            throw new IllegalArgumentException("Unknown 'target': " + (Object)((Object)target));
        }

        public static Target fromString(String string) {
            return str2Enum.get(string);
        }

        private Target(String string2, int n2, String string3) {
            this.text = string2;
            this.intVal = n2;
            this.jsonText = string3;
        }

        public int toInt() {
            return this.intVal;
        }

        public String toJson() {
            return this.jsonText;
        }

        public String toString() {
            return this.text;
        }
    }

    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type ALIGN = new Type(Msg.FolderFilter_Type_align, "ao");
        public static final /* enum */ Type ATTRIBUTE = new Type(Msg.FolderFilter_Type_attribute, "at");
        public static final /* enum */ Type PATH = new Type(Msg.FolderFilter_Type_path, "nm");
        public static final /* enum */ Type SIZE = new Type(Msg.FolderFilter_Type_size, "sz");
        public static final /* enum */ Type TIME = new Type(Msg.FolderFilter_Type_time, "dt");
        private static final Map<String, Type> str2Enum;
        private final String jsonText;
        private final String text;
        private static final /* synthetic */ Type[] ENUM$VALUES;

        static {
            ENUM$VALUES = new Type[]{ALIGN, ATTRIBUTE, PATH, SIZE, TIME};
            str2Enum = new HashMap<String, Type>(6);
            Type[] typeArray = Type.values();
            int n = typeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Type type = typeArray[n2];
                str2Enum.put(type.text, type);
                str2Enum.put(type.jsonText, type);
                ++n2;
            }
        }

        public static Type fromJson(String string) {
            assert (str2Enum.containsKey(string));
            return str2Enum.get(string);
        }

        public static Type fromString(String string) {
            assert (str2Enum.containsKey(string));
            return str2Enum.get(string);
        }

        private Type(String string2, String string3) {
            this.text = string2;
            this.jsonText = string3;
        }

        public String toJson() {
            return this.jsonText;
        }

        public String toString() {
            return this.text;
        }

        public static Type[] values() {
            Type[] typeArray = ENUM$VALUES;
            int n = typeArray.length;
            Type[] typeArray2 = new Type[n];
            System.arraycopy(ENUM$VALUES, 0, typeArray2, 0, n);
            return typeArray2;
        }

        public static Type valueOf(String string) {
            return Enum.valueOf(Type.class, string);
        }
    }
}

